/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.abilities;

import java.util.ArrayList;
import java.util.Collection;
import net.foxyas.changedaddon.util.ParticlesUtil;
import net.ltxprogrammer.changed.ability.AbstractAbility;
import net.ltxprogrammer.changed.ability.IAbstractChangedEntity;
import net.ltxprogrammer.changed.ability.SimpleAbility;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class WindPassiveAbility
extends SimpleAbility {
    public boolean isActive = false;

    public static void spawnAirParticles(LivingEntity livingEntity) {
        if (livingEntity.m_21187_().nextFloat() >= 0.75f) {
            ParticlesUtil.sendParticlesWithMotion(livingEntity, (ParticleOptions)ParticleTypes.f_123759_, new Vec3(0.3, 0.1, 0.3), new Vec3(0.0, 0.25, 0.0), 2, 0.25f);
        }
    }

    public void saveData(CompoundTag tag, IAbstractChangedEntity entity) {
        super.saveData(tag, entity);
        tag.m_128379_("isActive", this.isActive);
    }

    public void readData(CompoundTag tag, IAbstractChangedEntity entity) {
        super.readData(tag, entity);
        if (tag.m_128441_("isActive")) {
            this.isActive = tag.m_128471_("isActive");
        }
    }

    public Component getAbilityName(IAbstractChangedEntity entity) {
        return new TranslatableComponent("changed_addon.ability.wind_control_passive");
    }

    public Collection<Component> getAbilityDescription(IAbstractChangedEntity entity) {
        ArrayList<Component> list = new ArrayList<Component>(super.getAbilityDescription(entity));
        list.add((Component)new TranslatableComponent("changed_addon.ability.wind_control_passive.desc"));
        return list;
    }

    public AbstractAbility.UseType getUseType(IAbstractChangedEntity entity) {
        return AbstractAbility.UseType.MENU;
    }

    public int getCoolDown(IAbstractChangedEntity entity) {
        return 5;
    }

    public boolean canUse(IAbstractChangedEntity entity) {
        return entity.getTransfurVariantInstance() != null;
    }

    public boolean canKeepUsing(IAbstractChangedEntity entity) {
        return entity.getTransfurVariantInstance() != null;
    }

    public void startUsing(IAbstractChangedEntity entity) {
        if (!entity.getLevel().m_5776_()) {
            this.TurnOnPassive(entity);
            this.setDirty(entity);
        }
    }

    public void TurnOnPassive(IAbstractChangedEntity entity) {
        this.isActive = !this.isActive;
        entity.displayClientMessage((Component)(this.isActive ? new TranslatableComponent("changed_addon.ability.passive.toggle.on") : new TranslatableComponent("changed_addon.ability.passive.toggle.off")), true);
    }
}

