/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.abilities;

import java.util.Optional;
import net.foxyas.changedaddon.abilities.interfaces.AbilityExtension;
import net.foxyas.changedaddon.configuration.ChangedAddonClientConfiguration;
import net.foxyas.changedaddon.variants.VariantExtraStats;
import net.ltxprogrammer.changed.ability.AbstractAbility;
import net.ltxprogrammer.changed.ability.AbstractAbilityInstance;
import net.ltxprogrammer.changed.ability.IAbstractChangedEntity;
import net.ltxprogrammer.changed.client.AbilityColors;
import net.ltxprogrammer.changed.client.gui.AbstractRadialScreen;
import net.ltxprogrammer.changed.entity.ChangedEntity;
import net.ltxprogrammer.changed.init.ChangedSounds;
import net.ltxprogrammer.changed.process.ProcessTransfur;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class WingFlapAbility
extends AbstractAbility<AbilityInstance> {
    public static final int MAX_TICK_HOLD = 30;
    public static final int TICK_HOLD_NEED = 10;

    public WingFlapAbility() {
        super(AbilityInstance::new);
    }

    public static Optional<Integer> getColor(AbstractAbilityInstance abilityInstance, int layer) {
        AbstractRadialScreen.ColorScheme scheme = AbilityColors.getAbilityColors((AbstractAbilityInstance)abilityInstance);
        if (abilityInstance instanceof AbilityInstance) {
            AbilityInstance Instance2 = (AbilityInstance)abilityInstance;
            if (Instance2.dashPower < 0.3f && layer == 0) {
                return Optional.of(scheme.foreground().toInt());
            }
            if (Instance2.dashPower >= 0.3f && Instance2.dashPower < 0.95f && layer == 1) {
                return Optional.of(scheme.foreground().toInt());
            }
            if (Instance2.dashPower >= 0.95f && layer == 2) {
                return Optional.of(scheme.foreground().toInt());
            }
        }
        return Optional.empty();
    }

    public ResourceLocation getTexture(IAbstractChangedEntity entity) {
        LivingEntity livingEntity = entity.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            AbilityInstance Instance2 = (AbilityInstance)ProcessTransfur.getPlayerTransfurVariant((Player)player).getAbilityInstance((AbstractAbility)this);
            if (Instance2.dashPower <= 0.1f) {
                return new ResourceLocation("changed_addon:textures/screens/wing_flap_ability_start.png");
            }
            if (Instance2.dashPower >= 0.3f && Instance2.dashPower < 0.95f) {
                return new ResourceLocation("changed_addon:textures/screens/wing_flap_ability_mid.png");
            }
            if (Instance2.dashPower >= 0.95f) {
                return new ResourceLocation("changed_addon:textures/screens/wing_flap_ability_final.png");
            }
        }
        return new ResourceLocation("changed_addon:textures/screens/wing_flap_ability_start.png");
    }

    public TranslatableComponent getAbilityName(IAbstractChangedEntity entity) {
        return new TranslatableComponent("changed_addon.ability.wing_flap");
    }

    public AbstractAbility.UseType getUseType(IAbstractChangedEntity entity) {
        LivingEntity livingEntity = entity.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (player.m_150110_().f_35935_) {
                return AbstractAbility.UseType.CHARGE_TIME;
            }
            if (player.m_21255_()) {
                return AbstractAbility.UseType.HOLD;
            }
            if (player.m_20096_()) {
                return AbstractAbility.UseType.HOLD;
            }
        }
        return AbstractAbility.UseType.INSTANT;
    }

    public int getChargeTime(IAbstractChangedEntity entity) {
        LivingEntity livingEntity = entity.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (player.m_150110_().f_35935_) {
                return 5;
            }
            if (player.m_21255_()) {
                return 45;
            }
            if (player.m_20096_()) {
                return 10;
            }
        }
        return 30;
    }

    public int getCoolDown(IAbstractChangedEntity entity) {
        LivingEntity livingEntity = entity.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (player.m_150110_().f_35935_) {
                return 10;
            }
            if (player.m_21255_()) {
                return 25;
            }
            if (player.m_20096_()) {
                return 20;
            }
        }
        return 15;
    }

    public static class AbilityInstance
    extends AbstractAbilityInstance
    implements AbilityExtension {
        public boolean readyToDash = false;
        public float dashPower;
        private float lastDashPower = this.dashPower = 0.0f;

        public AbilityInstance(AbstractAbility<?> ability, IAbstractChangedEntity entity) {
            super(ability, entity);
        }

        private static void playSound(Player player) {
            if (!player.f_19853_.m_5776_()) {
                player.f_19853_.m_5594_(null, player.m_142538_(), ChangedSounds.BOW2, player.m_5720_(), 2.5f, 1.0f);
            }
        }

        private static void playFlapSound(Player player) {
            if (!player.f_19853_.m_5776_()) {
                player.f_19853_.m_5594_(null, player.m_142538_(), SoundEvents.f_11893_, player.m_5720_(), 2.5f, 1.0f);
            }
        }

        private static void playFlapSound(Player player, float pitch) {
            if (!player.f_19853_.m_5776_()) {
                player.f_19853_.m_5594_(null, player.m_142538_(), SoundEvents.f_11893_, player.m_5720_(), 2.5f, pitch);
            }
        }

        private static void exhaustPlayer(Player player, float exhaustion) {
            if (!player.m_7500_()) {
                player.m_36399_(exhaustion);
            }
        }

        private static float capLevel(float value, float min, float max) {
            if (value < min) {
                return min;
            }
            if (value > max) {
                return max;
            }
            return value;
        }

        public void saveData(CompoundTag tag) {
            super.saveData(tag);
        }

        public void readData(CompoundTag tag) {
            super.readData(tag);
        }

        public boolean canUse() {
            Player player;
            VariantExtraStats extraStats;
            ChangedEntity changedEntity = this.entity.getChangedEntity();
            if (changedEntity instanceof VariantExtraStats && (extraStats = (VariantExtraStats)changedEntity).getFlyType() == VariantExtraStats.FlyType.NONE) {
                return false;
            }
            changedEntity = this.entity.getEntity();
            if (changedEntity instanceof Player && !(player = (Player)changedEntity).m_20096_() && !player.m_150110_().f_35935_ && !player.m_21255_()) {
                return false;
            }
            return this.entity.getSelfVariant() != null && this.entity.getSelfVariant().canGlide;
        }

        public boolean canKeepUsing() {
            Player player;
            VariantExtraStats extraStats;
            ChangedEntity changedEntity = this.entity.getChangedEntity();
            if (changedEntity instanceof VariantExtraStats && (extraStats = (VariantExtraStats)changedEntity).getFlyType() == VariantExtraStats.FlyType.NONE) {
                return false;
            }
            changedEntity = this.entity.getEntity();
            if (changedEntity instanceof Player && !(player = (Player)changedEntity).m_20096_() && !player.m_150110_().f_35935_ && !player.m_21255_()) {
                return false;
            }
            return this.entity.getSelfVariant() != null && this.entity.getSelfVariant().canGlide;
        }

        public void startUsing() {
            Player player;
            LivingEntity livingEntity = this.entity.getEntity();
            if (!(livingEntity instanceof Player) || (player = (Player)livingEntity).m_36324_().m_38702_() <= 6) {
                return;
            }
            if (player.m_20069_() || player.m_5833_()) {
                return;
            }
            if (player.m_150110_().f_35935_ && !player.m_21255_()) {
                double speed = 2.0;
                player.m_20256_(player.m_20184_().m_82549_(player.m_20252_(1.0f).m_82542_(speed, speed, speed)));
                AbilityInstance.playFlapSound(player);
                AbilityInstance.exhaustPlayer(player, 0.8f);
            }
        }

        public void tick() {
            Player player;
            LivingEntity livingEntity = this.entity.getEntity();
            if (!(livingEntity instanceof Player) || (player = (Player)livingEntity).m_36324_().m_38702_() <= 6) {
                return;
            }
            this.dashPower = AbilityInstance.capLevel((float)this.getController().getHoldTicks() / 30.0f, 0.0f, 1.0f);
            if (this.getController().getHoldTicks() >= 10) {
                this.readyToDash = true;
            }
            if (this.dashPower >= 1.0f && this.getController().getHoldTicks() == 30) {
                player.m_5496_(SoundEvents.f_11893_, 1.0f, 2.0f);
            }
            if (player.f_19853_.m_5776_() && ((Boolean)ChangedAddonClientConfiguration.WING_FLAP_INFO.get()).booleanValue()) {
                player.m_5661_((Component)new TextComponent("Ticks = " + this.getController().getHoldTicks()), true);
            }
        }

        @Override
        public boolean shouldApplyCooldown() {
            return this.lastDashPower > 0.0f;
        }

        public void stopUsing() {
            Player player;
            LivingEntity livingEntity = this.entity.getEntity();
            if (!(livingEntity instanceof Player) || (player = (Player)livingEntity).m_36324_().m_38702_() <= 6) {
                return;
            }
            if (player.m_20069_() || player.m_5833_()) {
                return;
            }
            if (player.m_21255_() && !player.m_150110_().f_35935_ && this.readyToDash) {
                this.readyToDash = false;
                double speed = 2.0f * this.dashPower;
                player.m_20256_(player.m_20184_().m_82549_(player.m_20252_(1.0f).m_82542_(speed, speed, speed)));
                AbilityInstance.playFlapSound(player);
                AbilityInstance.exhaustPlayer(player, 4.0f * this.dashPower);
                this.dashPower = 0.0f;
            } else if (player.m_20096_() && player.m_146909_() <= -45.0f && this.readyToDash) {
                this.readyToDash = false;
                double speed = 2.0f * this.dashPower;
                player.m_20256_(player.m_20184_().m_82549_(player.m_20252_(1.0f).m_82542_(0.0, speed, 0.0)));
                AbilityInstance.playFlapSound(player, 0.5f);
                AbilityInstance.exhaustPlayer(player, 4.0f * this.dashPower);
                this.dashPower = 0.0f;
            }
            this.dashPower = 0.0f;
        }

        public void tickIdle() {
            super.tickIdle();
            this.lastDashPower = this.dashPower;
        }
    }
}

