/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.block;

import java.util.Random;
import net.foxyas.changedaddon.block.entity.AbstractPlushyBlockEntity;
import net.foxyas.changedaddon.init.ChangedAddonSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractPlushyBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    protected AbstractPlushyBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return state.m_60819_().m_76178_();
    }

    public int m_7753_(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos) {
        return 0;
    }

    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @NotNull
    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    @NotNull
    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        return super.m_7417_(state, facing, facingState, world, currentPos, facingPos);
    }

    @NotNull
    public VoxelShape m_5909_(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return Shapes.m_83040_();
    }

    public BlockPathTypes getAiPathNodeType(BlockState state, BlockGetter world, BlockPos pos, Mob entity) {
        return BlockPathTypes.BLOCKED;
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.NORTH -> AbstractPlushyBlock.m_49796_((double)4.0, (double)0.0, (double)3.5, (double)12.0, (double)18.0, (double)12.0);
            case Direction.EAST -> AbstractPlushyBlock.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.5, (double)18.0, (double)12.0);
            case Direction.WEST -> AbstractPlushyBlock.m_49796_((double)3.5, (double)0.0, (double)4.0, (double)12.0, (double)18.0, (double)12.0);
            default -> AbstractPlushyBlock.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)18.0, (double)12.5);
        };
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        boolean flag = context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            return 0;
        }
        return 20;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{FACING, WATERLOGGED});
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState blockstate, @NotNull Level world, @NotNull BlockPos pos, @NotNull Player entity, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        AbstractPlushyBlockEntity plushBlockEntity;
        InteractionResult retValue = super.m_6227_(blockstate, world, pos, entity, hand, hit);
        double hitX = hit.m_82450_().f_82479_;
        double hitY = hit.m_82450_().f_82480_;
        double hitZ = hit.m_82450_().f_82481_;
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof AbstractPlushyBlockEntity && !(plushBlockEntity = (AbstractPlushyBlockEntity)blockEntity).isSqueezed()) {
            if (!world.m_5776_()) {
                world.m_6263_(null, hitX, hitY, hitZ, ChangedAddonSoundEvents.PLUSHY_SOUND, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            return InteractionResult.m_19078_((boolean)world.m_5776_());
        }
        return retValue;
    }

    @NotNull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public void m_6807_(@NotNull BlockState blockstate, @NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean moving) {
        super.m_6807_(blockstate, world, pos, oldState, moving);
        world.m_186460_(pos, (Block)this, 10);
    }

    public void m_7458_(@NotNull BlockState state, @NotNull ServerLevel serverLevel, @NotNull BlockPos pos, @NotNull Random p_60465_) {
        AbstractPlushyBlockEntity abstractPlushyBlockEntity;
        super.m_7458_(state, serverLevel, pos, p_60465_);
        BlockEntity blockEntity = serverLevel.m_7702_(pos);
        if (blockEntity instanceof AbstractPlushyBlockEntity && (abstractPlushyBlockEntity = (AbstractPlushyBlockEntity)blockEntity).isSqueezed()) {
            abstractPlushyBlockEntity.subSqueezedTicks(1);
        }
        serverLevel.m_186460_(pos, (Block)this, 10);
    }

    public boolean m_8133_(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, int eventID, int eventParam) {
        super.m_8133_(state, world, pos, eventID, eventParam);
        BlockEntity blockEntity = world.m_7702_(pos);
        return blockEntity != null && blockEntity.m_7531_(eventID, eventParam);
    }
}

