/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.block;

import java.util.Optional;
import java.util.Random;
import net.foxyas.changedaddon.block.entity.ContainmentContainerBlockEntity;
import net.foxyas.changedaddon.init.ChangedAddonBlockEntities;
import net.foxyas.changedaddon.init.ChangedAddonBlocks;
import net.foxyas.changedaddon.init.ChangedAddonTags;
import net.ltxprogrammer.changed.Changed;
import net.ltxprogrammer.changed.block.CustomFallable;
import net.ltxprogrammer.changed.block.NonLatexCoverableBlock;
import net.ltxprogrammer.changed.entity.ChangedEntity;
import net.ltxprogrammer.changed.entity.variant.TransfurVariant;
import net.ltxprogrammer.changed.init.ChangedBlocks;
import net.ltxprogrammer.changed.init.ChangedItems;
import net.ltxprogrammer.changed.init.ChangedParticles;
import net.ltxprogrammer.changed.init.ChangedSounds;
import net.ltxprogrammer.changed.init.ChangedTags;
import net.ltxprogrammer.changed.init.ChangedTransfurVariants;
import net.ltxprogrammer.changed.item.LatexFlask;
import net.ltxprogrammer.changed.item.LatexSyringe;
import net.ltxprogrammer.changed.item.Syringe;
import net.ltxprogrammer.changed.util.Color3;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class ContainmentContainerBlock
extends Block
implements SimpleWaterloggedBlock,
EntityBlock,
NonLatexCoverableBlock,
CustomFallable {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final VoxelShape SHAPE_WHOLE = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);

    public ContainmentContainerBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60918_(SoundType.f_56744_).m_60913_(3.0f, 5.0f).m_60955_().m_60924_((bs, br, bp) -> false).m_60999_());
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerRenderLayer() {
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ChangedAddonBlocks.CONTAINMENT_CONTAINER.get()), renderType -> renderType == RenderType.m_110463_());
    }

    public boolean m_7420_(BlockState state, @NotNull BlockGetter reader, @NotNull BlockPos pos) {
        return state.m_60819_().m_76178_();
    }

    public int m_7753_(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos) {
        ContainmentContainerBlockEntity blockEntity = this.getBlockEntity(state, worldIn, pos);
        if (blockEntity != null && blockEntity.getTransfurVariant() != null && blockEntity.getTransfurVariant().is(ChangedAddonTags.TransfurTypes.GLOWING_VARIANTS)) {
            return 8;
        }
        return 0;
    }

    @NotNull
    public VoxelShape m_5909_(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return SHAPE_WHOLE;
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return SHAPE_WHOLE;
    }

    @NotNull
    public VoxelShape m_6079_(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos) {
        return SHAPE_WHOLE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        boolean flag = context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_;
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    @NotNull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @NotNull
    public BlockState m_7417_(BlockState state, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor world, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        world.m_186460_(currentPos, (Block)this, this.getDelayAfterPlace());
        return super.m_7417_(state, facing, facingState, world, currentPos, facingPos);
    }

    public boolean m_7898_(@NotNull BlockState blockState, LevelReader level, BlockPos pos) {
        return level.m_8055_(pos.m_7495_()).m_60783_((BlockGetter)level, pos.m_7495_(), Direction.UP);
    }

    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new ContainmentContainerBlockEntity(pos, state);
    }

    public ContainmentContainerBlockEntity getBlockEntity(BlockState state, BlockGetter level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ContainmentContainerBlockEntity) {
            ContainmentContainerBlockEntity blockEntity2 = (ContainmentContainerBlockEntity)blockEntity;
            return blockEntity2;
        }
        return null;
    }

    public boolean m_8133_(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, int eventID, int eventParam) {
        super.m_8133_(state, world, pos, eventID, eventParam);
        BlockEntity blockEntity = world.m_7702_(pos);
        return blockEntity != null && blockEntity.m_7531_(eventID, eventParam);
    }

    protected int getDelayAfterPlace() {
        return 2;
    }

    public void m_6807_(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull BlockState p_53236_, boolean p_53237_) {
        level.m_186460_(pos, (Block)this, this.getDelayAfterPlace());
        super.m_6807_(state, level, pos, p_53236_, p_53237_);
    }

    public void m_7458_(@NotNull BlockState state, ServerLevel level, @NotNull BlockPos pos, @NotNull Random p_60465_) {
        level.m_186460_(pos, (Block)this, this.getDelayAfterPlace());
        if (pos.m_123342_() >= level.m_141937_() && !this.m_7898_(state, (LevelReader)level, pos)) {
            Optional blockEntity = level.m_141902_(pos, (BlockEntityType)ChangedAddonBlockEntities.CONTAINMENT_CONTAINER.get());
            CompoundTag blockData = blockEntity.map(BlockEntity::m_187480_).orElse(null);
            level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 67);
            FallingBlockEntity fallingBlockEntity = FallingBlockEntity.m_201971_((Level)level, (BlockPos)pos, (BlockState)state);
            fallingBlockEntity.f_31944_ = blockData;
            this.falling(fallingBlockEntity);
        }
        super.m_7458_(state, level, pos, p_60465_);
    }

    protected void falling(FallingBlockEntity blockEntity) {
        Changed.PACKET_HANDLER.send(PacketDistributor.TRACKING_ENTITY.with(() -> blockEntity), (Object)CustomFallable.updateBlockData((FallingBlockEntity)blockEntity));
    }

    public void m_6810_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos blockPos, @NotNull BlockState newState, boolean noSimulate) {
        super.m_6810_(state, level, blockPos, newState, noSimulate);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos blockPos, Player player, boolean willHarvest, FluidState fluid) {
        ContainmentContainerBlockEntity blockEntity = this.getBlockEntity(state, (BlockGetter)level, blockPos);
        if (blockEntity.getTransfurVariant() != null) {
            if (blockEntity.getTransfurVariant().getEntityType().m_204039_(ChangedTags.EntityTypes.LATEX)) {
                ChangedEntity changedEntity = (ChangedEntity)blockEntity.getTransfurVariant().getEntityType().m_20615_(level);
                assert (changedEntity != null);
                changedEntity.m_20035_(blockPos, changedEntity.m_146908_(), changedEntity.m_146909_());
                level.m_7967_((Entity)changedEntity);
            } else if ((blockEntity.getTransfurVariant().is((TransfurVariant)ChangedTransfurVariants.GAS_WOLF.get()) || blockEntity.getTransfurVariant().getRegistryName().toString().contains("gas")) && level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)ChangedParticles.gas((Color3)((Color3)blockEntity.getTransfurVariant().getColors().getFirst())), (double)((float)blockPos.m_123341_() + 0.5f), (double)((float)blockPos.m_123342_() + 0.5f), (double)((float)blockPos.m_123343_() + 0.5f), 5, 0.5, 0.5, 0.5, 0.0);
                serverLevel.m_8767_((ParticleOptions)ChangedParticles.gas((Color3)((Color3)blockEntity.getTransfurVariant().getColors().getSecond())), (double)((float)blockPos.m_123341_() + 0.5f), (double)((float)blockPos.m_123342_() + 0.5f), (double)((float)blockPos.m_123343_() + 0.5f), 5, 0.5, 0.5, 0.5, 0.0);
            }
        }
        return super.onDestroyedByPlayer(state, level, blockPos, player, willHarvest, fluid);
    }

    public void m_7592_(@NotNull Level level, @NotNull BlockPos blockPos, @NotNull Explosion explosion) {
        ContainmentContainerBlockEntity blockEntity = this.getBlockEntity(level.m_8055_(blockPos), (BlockGetter)level, blockPos);
        if (blockEntity != null && blockEntity.getTransfurVariant() != null) {
            if (blockEntity.getTransfurVariant().getEntityType().m_204039_(ChangedTags.EntityTypes.LATEX)) {
                ChangedEntity changedEntity = (ChangedEntity)blockEntity.getTransfurVariant().getEntityType().m_20615_(level);
                assert (changedEntity != null);
                changedEntity.m_20035_(blockPos, changedEntity.m_146908_(), changedEntity.m_146909_());
                level.m_7967_((Entity)changedEntity);
            } else if ((blockEntity.getTransfurVariant().is((TransfurVariant)ChangedTransfurVariants.GAS_WOLF.get()) || blockEntity.getTransfurVariant().getRegistryName().toString().contains("gas")) && level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)ChangedParticles.gas((Color3)((Color3)blockEntity.getTransfurVariant().getColors().getFirst())), (double)((float)blockPos.m_123341_() + 0.5f), (double)((float)blockPos.m_123342_() + 0.5f), (double)((float)blockPos.m_123343_() + 0.5f), 5, 0.5, 0.5, 0.5, 0.0);
                serverLevel.m_8767_((ParticleOptions)ChangedParticles.gas((Color3)((Color3)blockEntity.getTransfurVariant().getColors().getSecond())), (double)((float)blockPos.m_123341_() + 0.5f), (double)((float)blockPos.m_123342_() + 0.5f), (double)((float)blockPos.m_123343_() + 0.5f), 5, 0.5, 0.5, 0.5, 0.0);
            }
        }
        super.m_7592_(level, blockPos, explosion);
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, Player player, @NotNull InteractionHand interactionHand, @NotNull BlockHitResult blockHitResult) {
        ContainmentContainerBlockEntity blockEntity = this.getBlockEntity(state, (BlockGetter)level, pos);
        ItemStack selectedItem = player.m_21120_(interactionHand);
        TransfurVariant variant = Syringe.getVariant((ItemStack)selectedItem);
        if (variant != null && blockEntity.getTransfurVariant() == null) {
            if (selectedItem.m_41720_() instanceof LatexSyringe || selectedItem.m_41720_() instanceof LatexFlask && !variant.getEntityType().m_204039_(ChangedTags.EntityTypes.PARTIAL_LATEX)) {
                blockEntity.setTransfurVariant(variant);
                level.m_6289_(pos, (Block)this);
                level.m_46672_(pos, (Block)this);
                ItemStack normalSyringe = new ItemStack((ItemLike)ChangedItems.SYRINGE.get());
                ItemStack glassFlask = new ItemStack((ItemLike)ChangedItems.getBlockItem((Block)((Block)ChangedBlocks.ERLENMEYER_FLASK.get())));
                if (selectedItem.m_41720_() instanceof LatexSyringe) {
                    if (!player.m_7500_()) {
                        selectedItem.m_41774_(1);
                    }
                    if (!player.m_36356_(normalSyringe)) {
                        player.m_36176_(normalSyringe, false);
                    }
                } else if (selectedItem.m_41720_() instanceof LatexFlask) {
                    if (!player.m_7500_()) {
                        selectedItem.m_41774_(1);
                    }
                    if (!player.m_36356_(glassFlask)) {
                        player.m_36176_(glassFlask, false);
                    }
                }
                return InteractionResult.SUCCESS;
            }
        } else if (selectedItem.m_41720_() instanceof Syringe && blockEntity.getTransfurVariant() != null) {
            ItemStack latexSyringe = selectedItem.m_41720_() instanceof LatexSyringe ? new ItemStack((ItemLike)ChangedItems.LATEX_SYRINGE.get()) : (selectedItem.m_41720_() instanceof LatexFlask ? new ItemStack((ItemLike)ChangedItems.LATEX_FLASK.get()) : new ItemStack((ItemLike)ChangedItems.LATEX_SYRINGE.get()));
            Syringe.setVariant((ItemStack)latexSyringe, (ResourceLocation)blockEntity.getTransfurVariant().getFormId());
            blockEntity.setTransfurVariant(null);
            level.m_6289_(pos, (Block)this);
            level.m_46672_(pos, (Block)this);
            if (!player.m_7500_()) {
                selectedItem.m_41774_(1);
            }
            if (!player.m_36356_(latexSyringe)) {
                player.m_36176_(latexSyringe, false);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, level, pos, player, interactionHand, blockHitResult);
    }

    public double getFallDistance(FallingBlockEntity falling) {
        return (double)falling.m_31978_().m_123342_() - falling.m_20186_();
    }

    public void m_142216_(Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull BlockState fellOn, @NotNull FallingBlockEntity falling) {
        Optional blockEntity = level.m_141902_(pos, (BlockEntityType)ChangedAddonBlockEntities.CONTAINMENT_CONTAINER.get());
        blockEntity.ifPresent(container -> {
            if (falling.f_31944_ != null) {
                container.m_142466_(falling.f_31944_);
            }
        });
        if (this.getFallDistance(falling) >= 3.0 && level.m_6425_(pos).m_76178_()) {
            level.m_5594_(null, pos, ChangedSounds.CRASH, SoundSource.BLOCKS, 1.0f, 1.0f);
            blockEntity.ifPresent(containerBlock -> {
                if (containerBlock.getTransfurVariant() != null) {
                    if (!containerBlock.isTransfurNotLatex(containerBlock.getTransfurVariant())) {
                        ChangedEntity changedEntity = (ChangedEntity)containerBlock.getTransfurVariant().getEntityType().m_20615_(level);
                        assert (changedEntity != null);
                        changedEntity.m_20035_(containerBlock.m_58899_(), changedEntity.m_146908_(), changedEntity.m_146909_());
                        level.m_7967_((Entity)changedEntity);
                    } else if (containerBlock.isTransfurGasLike(containerBlock.getTransfurVariant()) && level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        serverLevel.m_8767_((ParticleOptions)ChangedParticles.gas((Color3)((Color3)containerBlock.getTransfurVariant().getColors().getFirst())), (double)((float)containerBlock.m_58899_().m_123341_() + 0.5f), (double)((float)containerBlock.m_58899_().m_123342_() + 0.5f), (double)((float)containerBlock.m_58899_().m_123343_() + 0.5f), 5, 0.5, 0.5, 0.5, 0.0);
                        serverLevel.m_8767_((ParticleOptions)ChangedParticles.gas((Color3)((Color3)containerBlock.getTransfurVariant().getColors().getSecond())), (double)((float)containerBlock.m_58899_().m_123341_() + 0.5f), (double)((float)containerBlock.m_58899_().m_123342_() + 0.5f), (double)((float)containerBlock.m_58899_().m_123343_() + 0.5f), 5, 0.5, 0.5, 0.5, 0.0);
                    }
                }
            });
            level.m_46597_(pos, Blocks.f_50016_.m_49966_());
        }
    }

    public ResourceLocation getModelName() {
        return new ModelResourceLocation(new ResourceLocation("changed_addon:containment_container"), "inventory");
    }
}

