/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.block;

import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.foxyas.changedaddon.block.entity.DarkLatexPuddleBlockEntity;
import net.foxyas.changedaddon.init.ChangedAddonBlocks;
import net.foxyas.changedaddon.init.ChangedAddonSoundEvents;
import net.foxyas.changedaddon.network.PacketUtil;
import net.ltxprogrammer.changed.block.NonLatexCoverableBlock;
import net.ltxprogrammer.changed.entity.ChangedEntity;
import net.ltxprogrammer.changed.entity.LatexType;
import net.ltxprogrammer.changed.process.ProcessTransfur;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class DarkLatexPuddleBlock
extends HorizontalDirectionalBlock
implements EntityBlock,
NonLatexCoverableBlock {
    public DarkLatexPuddleBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60918_(SoundType.f_56750_).m_60913_(1.0f, 10.0f).m_60956_(0.8f).m_60955_().m_60924_((bs, br, bp) -> false));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerRenderLayer() {
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ChangedAddonBlocks.DARK_LATEX_PUDDLE.get()), renderType -> renderType == RenderType.m_110463_());
    }

    private static boolean isPlayerDLOrPuro(Player player) {
        return ProcessTransfur.getPlayerTransfurVariantSafe((Player)player).map(tf -> tf.getLatexType() == LatexType.DARK_LATEX || tf.getFormId().toString().contains("puro_kind")).orElse(false);
    }

    private static void alertNearbyDL(Level level, double x, double y, double z, Entity entity) {
        BlockPos pos;
        BlockEntity be;
        ChangedEntity chEntity;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel sLevel = (ServerLevel)level;
        if (entity instanceof ChangedEntity && (chEntity = (ChangedEntity)entity).getLatexType() == LatexType.DARK_LATEX) {
            return;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (DarkLatexPuddleBlock.isPlayerDLOrPuro(player)) {
                return;
            }
            if (player.m_20161_()) {
                return;
            }
            if (player.m_5833_()) {
                return;
            }
        }
        if ((be = level.m_7702_(pos = new BlockPos(x, y, z))) == null) {
            return;
        }
        if (!(be instanceof DarkLatexPuddleBlockEntity)) {
            return;
        }
        DarkLatexPuddleBlockEntity darkLatexPuddleBlockEntity = (DarkLatexPuddleBlockEntity)be;
        byte cooldown = darkLatexPuddleBlockEntity.cooldown;
        Vec3 center = new Vec3(x, y, z);
        if (cooldown > 0) {
            return;
        }
        PacketUtil.playSound(sLevel, DarkLatexPuddleBlock::isPlayerDLOrPuro, x, y, z, ChangedAddonSoundEvents.WARN, SoundSource.BLOCKS, 1.0f, 1.0f);
        darkLatexPuddleBlockEntity.cooldown = (byte)30;
        darkLatexPuddleBlockEntity.m_6596_();
        AABB area = AABB.m_165882_((Vec3)center, (double)20.0, (double)20.0, (double)20.0);
        level.m_6443_(ChangedEntity.class, area, e -> e != entity && e.getTransfurVariant().getLatexType() == LatexType.DARK_LATEX && !e.getTransfurVariant().getFormId().toString().contains("puro_kind")).forEach(nearby -> nearby.m_21573_().m_26519_(x, y, z, 0.3));
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public int m_7753_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    @NotNull
    public VoxelShape m_5909_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)f_54117_)) {
            case Direction.NORTH -> Shapes.m_83124_((VoxelShape)DarkLatexPuddleBlock.m_49796_((double)6.0, (double)0.25, (double)1.5, (double)14.5, (double)1.5, (double)10.0), (VoxelShape[])new VoxelShape[]{DarkLatexPuddleBlock.m_49796_((double)5.5, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)10.5), DarkLatexPuddleBlock.m_49796_((double)0.75, (double)0.0, (double)10.0, (double)5.75, (double)1.0, (double)15.0), DarkLatexPuddleBlock.m_49796_((double)1.25, (double)0.25, (double)10.5, (double)5.25, (double)1.5, (double)14.5)});
            case Direction.EAST -> Shapes.m_83124_((VoxelShape)DarkLatexPuddleBlock.m_49796_((double)6.0, (double)0.25, (double)6.0, (double)14.5, (double)1.5, (double)14.5), (VoxelShape[])new VoxelShape[]{DarkLatexPuddleBlock.m_49796_((double)5.5, (double)0.0, (double)5.5, (double)15.0, (double)1.0, (double)15.0), DarkLatexPuddleBlock.m_49796_((double)1.0, (double)0.0, (double)0.75, (double)6.0, (double)1.0, (double)5.75), DarkLatexPuddleBlock.m_49796_((double)1.5, (double)0.25, (double)1.25, (double)5.5, (double)1.5, (double)5.25)});
            case Direction.WEST -> Shapes.m_83124_((VoxelShape)DarkLatexPuddleBlock.m_49796_((double)1.5, (double)0.25, (double)1.5, (double)10.0, (double)1.5, (double)10.0), (VoxelShape[])new VoxelShape[]{DarkLatexPuddleBlock.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)10.5, (double)1.0, (double)10.5), DarkLatexPuddleBlock.m_49796_((double)10.0, (double)0.0, (double)10.25, (double)15.0, (double)1.0, (double)15.25), DarkLatexPuddleBlock.m_49796_((double)10.5, (double)0.25, (double)10.75, (double)14.5, (double)1.5, (double)14.75)});
            default -> Shapes.m_83124_((VoxelShape)DarkLatexPuddleBlock.m_49796_((double)1.5, (double)0.25, (double)6.0, (double)10.0, (double)1.5, (double)14.5), (VoxelShape[])new VoxelShape[]{DarkLatexPuddleBlock.m_49796_((double)1.0, (double)0.0, (double)5.5, (double)10.5, (double)1.0, (double)15.0), DarkLatexPuddleBlock.m_49796_((double)10.25, (double)0.0, (double)1.0, (double)15.25, (double)1.0, (double)6.0), DarkLatexPuddleBlock.m_49796_((double)10.75, (double)0.25, (double)1.5, (double)14.75, (double)1.5, (double)5.5)});
        };
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)context.m_8125_().m_122424_());
    }

    @NotNull
    public PushReaction m_5537_(BlockState state) {
        return PushReaction.DESTROY;
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean moving) {
        if (level.m_5776_()) {
            return;
        }
        level.m_186460_(pos, (Block)this, 1);
    }

    public void m_7458_(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity == null) {
            return;
        }
        if (!(blockEntity instanceof DarkLatexPuddleBlockEntity)) {
            return;
        }
        DarkLatexPuddleBlockEntity darkLatexPuddleBlockEntity = (DarkLatexPuddleBlockEntity)blockEntity;
        byte cooldown = darkLatexPuddleBlockEntity.cooldown;
        if (cooldown > 0) {
            darkLatexPuddleBlockEntity.cooldown = (byte)Math.max(0, cooldown - 1);
            darkLatexPuddleBlockEntity.m_6596_();
        }
        level.m_186460_(pos, (Block)this, 1);
    }

    public void m_6256_(BlockState blockstate, Level world, BlockPos pos, Player entity) {
        DarkLatexPuddleBlock.alertNearbyDL(world, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), (Entity)entity);
    }

    public void m_7892_(BlockState blockstate, Level world, BlockPos pos, Entity entity) {
        DarkLatexPuddleBlock.alertNearbyDL(world, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), entity);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new DarkLatexPuddleBlockEntity(pos, state);
    }
}

