/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.block;

import java.util.Arrays;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.foxyas.changedaddon.block.entity.SignalBlockBlockEntity;
import net.foxyas.changedaddon.init.ChangedAddonBlocks;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class SignalBlockBlock
extends Block
implements EntityBlock {
    public static final EnumProperty<SignalVariant> VARIANT = EnumProperty.m_61587_((String)"variant", SignalVariant.class);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;

    public SignalBlockBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60918_(SoundType.f_56742_).m_60913_(1.5f, 20.0f).m_60953_(s -> 8).m_60982_((bs, br, bp) -> true).m_60991_((bs, br, bp) -> true).m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(VARIANT, (Comparable)((Object)SignalVariant.VARIANT_1))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerRenderLayer() {
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ChangedAddonBlocks.SIGNAL_BLOCK.get()), renderType -> renderType == RenderType.m_110457_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{VARIANT});
        builder.m_61104_(new Property[]{FACING});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_(VARIANT, (Comparable)((Object)SignalVariant.VARIANT_1))).m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean moving) {
        super.m_6807_(state, world, pos, oldState, moving);
        if (!world.f_46443_ && world.f_46441_.nextInt(100) < 25) {
            List<SignalVariant> variants = Arrays.stream(SignalVariant.values()).toList();
            SignalVariant randomVariant = variants.get(world.f_46441_.nextInt(variants.size()));
            BlockState updated = (BlockState)state.m_61124_(VARIANT, (Comparable)((Object)randomVariant));
            world.m_7731_(pos, updated, 3);
        }
        world.m_186460_(pos, (Block)this, 10);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos belowPos = pos.m_7495_();
        BlockState below = level.m_8055_(belowPos);
        return below.m_60783_((BlockGetter)level, belowPos, Direction.UP);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean moving) {
        if (!this.m_7898_(state, (LevelReader)level, pos)) {
            level.m_46961_(pos, true);
        }
        super.m_6861_(state, level, pos, block, fromPos, moving);
    }

    @NotNull
    public VoxelShape m_5909_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.NORTH -> SignalBlockBlock.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)3.5, (double)13.0);
            case Direction.EAST -> SignalBlockBlock.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)3.5, (double)13.0);
            case Direction.WEST -> SignalBlockBlock.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)3.5, (double)13.0);
            default -> SignalBlockBlock.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)3.5, (double)13.0);
        };
    }

    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @NotNull
    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public int m_7753_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new SignalBlockBlockEntity(pos, state);
    }

    public boolean m_8133_(BlockState state, Level world, BlockPos pos, int eventID, int eventParam) {
        super.m_8133_(state, world, pos, eventID, eventParam);
        BlockEntity blockEntity = world.m_7702_(pos);
        return blockEntity != null && blockEntity.m_7531_(eventID, eventParam);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof SignalBlockBlockEntity) {
                SignalBlockBlockEntity be = (SignalBlockBlockEntity)blockEntity;
                world.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, world, pos, newState, isMoving);
        }
    }

    public static enum SignalVariant implements StringRepresentable
    {
        DEFAULT("default"),
        VARIANT_1("variant_1"),
        VARIANT_2("variant_2"),
        VARIANT_3("variant_3"),
        VARIANT_4("variant_4"),
        VARIANT_5("variant_5");

        private final String name;

        private SignalVariant(String name) {
            this.name = name;
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }
    }
}

