/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.block;

import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.foxyas.changedaddon.block.AbstractPlushyBlock;
import net.foxyas.changedaddon.block.entity.SnepPlushyBlockEntity;
import net.foxyas.changedaddon.init.ChangedAddonBlocks;
import net.foxyas.changedaddon.init.ChangedAddonSoundEvents;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class SnepPlushyBlock
extends AbstractPlushyBlock {
    public static final EnumProperty<CansEnum> CANS = EnumProperty.m_61587_((String)"cans", CansEnum.class);

    public SnepPlushyBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76272_).m_60918_(SoundType.f_56745_).m_60913_(0.5f, 5.0f).m_60955_().m_60924_((bs, br, bp) -> false));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_(CANS, (Comparable)((Object)CansEnum.NONE)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerRenderLayer() {
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ChangedAddonBlocks.SNEP_PLUSH.get()), renderType -> renderType == RenderType.m_110457_());
    }

    @Override
    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return state.m_60819_().m_76178_();
    }

    @Override
    public int m_7753_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    @Override
    @NotNull
    public VoxelShape m_5909_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    @Override
    public BlockPathTypes getAiPathNodeType(BlockState state, BlockGetter world, BlockPos pos, Mob entity) {
        return BlockPathTypes.BLOCKED;
    }

    @Override
    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)f_54117_)) {
            case Direction.NORTH -> SnepPlushyBlock.m_49796_((double)4.0, (double)0.0, (double)3.5, (double)12.0, (double)16.0, (double)12.0);
            case Direction.EAST -> SnepPlushyBlock.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.5, (double)16.0, (double)12.0);
            case Direction.WEST -> SnepPlushyBlock.m_49796_((double)3.5, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
            default -> SnepPlushyBlock.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.5);
        };
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, WATERLOGGED, CANS});
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        boolean flag = context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag))).m_61124_(CANS, (Comparable)((Object)CansEnum.NONE));
    }

    @Override
    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)f_54117_, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)f_54117_)));
    }

    @Override
    @NotNull
    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)f_54117_)));
    }

    @Override
    @NotNull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @Override
    @NotNull
    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        return super.m_7417_(state, facing, facingState, world, currentPos, facingPos);
    }

    @Override
    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            return 0;
        }
        return 20;
    }

    @Override
    @NotNull
    public InteractionResult m_6227_(BlockState blockstate, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        SnepPlushyBlockEntity plushBlockEntity;
        InteractionResult retValue = super.m_6227_(blockstate, world, pos, player, hand, hit);
        ItemStack itemInHand = player.m_21120_(hand);
        BlockEntity blockEntity = world.m_7702_(pos);
        if (!world.m_5776_() && blockEntity instanceof SnepPlushyBlockEntity) {
            SnepPlushyBlockEntity snepPlushyBlockEntity = (SnepPlushyBlockEntity)blockEntity;
            if (itemInHand.m_150930_(Items.f_151056_) && !snepPlushyBlockEntity.glowingEyes) {
                if (!player.m_7500_()) {
                    itemInHand.m_41774_(1);
                }
                snepPlushyBlockEntity.glowingEyes = true;
                world.m_7260_(pos, blockstate, blockstate, 1);
                snepPlushyBlockEntity.m_6596_();
                world.m_5594_(null, hit.m_82425_(), SoundEvents.f_144153_, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    CriteriaTriggers.f_10562_.m_45482_(serverPlayer, pos, itemInHand);
                }
                return InteractionResult.SUCCESS;
            }
        }
        double hitX = hit.m_82450_().f_82479_;
        double hitY = hit.m_82450_().f_82480_;
        double hitZ = hit.m_82450_().f_82481_;
        if (blockEntity instanceof SnepPlushyBlockEntity && !(plushBlockEntity = (SnepPlushyBlockEntity)blockEntity).isSqueezed()) {
            if (!world.m_5776_()) {
                world.m_6263_(null, hitX, hitY, hitZ, ChangedAddonSoundEvents.PLUSHY_SOUND, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            return InteractionResult.m_19078_((boolean)world.m_5776_());
        }
        return retValue;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new SnepPlushyBlockEntity(pos, state);
    }

    @Override
    public void m_6807_(BlockState blockstate, Level world, BlockPos pos, BlockState oldState, boolean moving) {
        super.m_6807_(blockstate, world, pos, oldState, moving);
        Random random = new Random();
        if (random.nextInt(100) <= 25) {
            CansEnum[] possibleValues = new CansEnum[]{CansEnum.RIGHT, CansEnum.LEFT, CansEnum.HUG, CansEnum.BOTH};
            CansEnum randomCans = possibleValues[random.nextInt(possibleValues.length)];
            BlockState newBlockState = (BlockState)blockstate.m_61124_(CANS, (Comparable)((Object)randomCans));
            world.m_7731_(pos, newBlockState, 3);
        }
        world.m_186460_(pos, (Block)this, 10);
    }

    @Override
    public void m_7458_(BlockState state, ServerLevel serverLevel, BlockPos pos, Random p_60465_) {
        SnepPlushyBlockEntity snepPlushyBlockEntity;
        super.m_7458_(state, serverLevel, pos, p_60465_);
        BlockEntity blockEntity = serverLevel.m_7702_(pos);
        if (blockEntity instanceof SnepPlushyBlockEntity && (snepPlushyBlockEntity = (SnepPlushyBlockEntity)blockEntity).isSqueezed()) {
            snepPlushyBlockEntity.subSqueezedTicks(1);
        }
        serverLevel.m_186460_(pos, (Block)this, 10);
    }

    @Override
    public boolean m_8133_(BlockState state, Level world, BlockPos pos, int eventID, int eventParam) {
        super.m_8133_(state, world, pos, eventID, eventParam);
        BlockEntity blockEntity = world.m_7702_(pos);
        return blockEntity != null && blockEntity.m_7531_(eventID, eventParam);
    }

    public static enum CansEnum implements StringRepresentable
    {
        NONE("none"),
        RIGHT("right"),
        LEFT("left"),
        HUG("hug"),
        BOTH("both");

        private final String name;

        private CansEnum(String name) {
            this.name = name;
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }
    }
}

