/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.block.advanced;

import com.google.common.collect.ImmutableMap;
import java.util.Objects;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Supplier;
import net.foxyas.changedaddon.init.ChangedAddonBlocks;
import net.ltxprogrammer.changed.entity.variant.TransfurVariantInstance;
import net.ltxprogrammer.changed.init.ChangedSounds;
import net.ltxprogrammer.changed.init.ChangedTransfurVariants;
import net.ltxprogrammer.changed.process.ProcessTransfur;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HandScanner
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty POWERED = LeverBlock.f_54622_;
    public static final EnumProperty<LockType> LOCK_TYPE = EnumProperty.m_61587_((String)"lock_type", LockType.class);
    protected static final VoxelShape SHAPE_NORTH = Block.m_49796_((double)5.0, (double)3.5, (double)14.0, (double)11.0, (double)12.5, (double)16.0);
    protected static final VoxelShape SHAPE_SOUTH = Block.m_49796_((double)5.0, (double)3.5, (double)0.0, (double)11.0, (double)12.5, (double)2.0);
    protected static final VoxelShape SHAPE_WEST = Block.m_49796_((double)14.0, (double)3.5, (double)5.0, (double)16.0, (double)12.5, (double)11.0);
    protected static final VoxelShape SHAPE_EAST = Block.m_49796_((double)0.0, (double)3.5, (double)5.0, (double)2.0, (double)12.5, (double)11.0);

    public HandScanner() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76365_).m_60924_((state, blockGetter, blockPos) -> (Boolean)state.m_61143_((Property)POWERED)).m_60918_(SoundType.f_56743_).m_60913_(3.0f, 3.0f).m_60988_());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)POWERED, (Comparable)Boolean.FALSE)).m_61124_(LOCK_TYPE, (Comparable)((Object)LockType.TRANSFURRED)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerRenderLayer() {
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ChangedAddonBlocks.HAND_SCANNER.get()), renderType -> renderType == RenderType.m_110463_());
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction direction) {
        return super.canConnectRedstone(state, level, pos, direction);
    }

    @NotNull
    public BlockState m_7417_(@NotNull BlockState state, @NotNull Direction direction, @NotNull BlockState neighborState, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        if (!this.m_7898_(state, (LevelReader)level, pos)) {
            level.m_46961_(pos, true);
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    @NotNull
    protected ImmutableMap<BlockState, VoxelShape> m_152458_(@NotNull Function<BlockState, VoxelShape> p_152459_) {
        return super.m_152458_(p_152459_);
    }

    protected void m_7926_(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{POWERED, FACING, LOCK_TYPE});
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, @NotNull BlockGetter blockGetter, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.WEST -> SHAPE_WEST;
            case Direction.EAST -> SHAPE_EAST;
            default -> SHAPE_NORTH;
        };
    }

    @NotNull
    public VoxelShape m_5909_(BlockState state, @NotNull BlockGetter blockGetter, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.WEST -> SHAPE_WEST;
            case Direction.EAST -> SHAPE_EAST;
            default -> SHAPE_NORTH;
        };
    }

    @NotNull
    public VoxelShape m_5939_(BlockState state, @NotNull BlockGetter blockGetter, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.WEST -> SHAPE_WEST;
            case Direction.EAST -> SHAPE_EAST;
            default -> SHAPE_NORTH;
        };
    }

    public void m_6807_(@NotNull BlockState blockstate, @NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean moving) {
        super.m_6807_(blockstate, world, pos, oldState, moving);
        world.m_186460_(pos, (Block)this, 5);
    }

    public boolean m_7899_(@NotNull BlockState state) {
        return true;
    }

    public int m_6378_(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull Direction direction) {
        return (Boolean)state.m_61143_((Property)POWERED) != false ? 15 : 0;
    }

    public int m_6376_(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull Direction direction) {
        return (Boolean)state.m_61143_((Property)POWERED) != false ? 15 : 0;
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        boolean allow;
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        TransfurVariantInstance playerTransfur = ProcessTransfur.getPlayerTransfurVariant((Player)player);
        boolean isTransfurred = playerTransfur != null;
        LockType lockType = (LockType)((Object)state.m_61143_(LOCK_TYPE));
        boolean bl = allow = lockType == LockType.HUMAN && (!isTransfurred || playerTransfur.is((Supplier)ChangedTransfurVariants.LATEX_HUMAN)) || lockType == LockType.TRANSFURRED && isTransfurred && !playerTransfur.is((Supplier)ChangedTransfurVariants.LATEX_HUMAN);
        if (player.m_6144_()) {
            boolean canChange = false;
            for (Direction direction : Direction.values()) {
                if (!level.m_8055_(pos.m_142300_(direction)).m_204336_(BlockTags.f_13093_) && !level.m_8055_(pos.m_142300_(direction)).m_60713_(Blocks.f_50164_) || level.m_46681_(pos, direction) <= 0 || !((Boolean)level.m_8055_(pos.m_142300_(direction)).m_61143_((Property)POWERED)).booleanValue() && !((Boolean)level.m_8055_(pos.m_142300_(direction)).m_61143_((Property)BlockStateProperties.f_61448_)).booleanValue()) continue;
                canChange = true;
                break;
            }
            if (canChange) {
                ChangedSounds.broadcastSound((MinecraftServer)Objects.requireNonNull(level.m_142572_()), (SoundEvent)ChangedSounds.BLOW1, (BlockPos)pos, (float)0.25f, (float)2.0f);
                ChangedSounds.broadcastSound((MinecraftServer)Objects.requireNonNull(level.m_142572_()), (SoundEvent)ChangedSounds.KEY, (BlockPos)pos, (float)0.5f, (float)1.0f);
                if (state.m_61143_(LOCK_TYPE) == LockType.HUMAN) {
                    level.m_7731_(pos, (BlockState)state.m_61124_(LOCK_TYPE, (Comparable)((Object)LockType.TRANSFURRED)), 3);
                } else if (state.m_61143_(LOCK_TYPE) == LockType.TRANSFURRED) {
                    level.m_7731_(pos, (BlockState)state.m_61124_(LOCK_TYPE, (Comparable)((Object)LockType.HUMAN)), 3);
                }
                level.m_186460_(pos, (Block)this, 5);
                return InteractionResult.SUCCESS;
            }
        }
        if (!allow) {
            ChangedSounds.broadcastSound((MinecraftServer)Objects.requireNonNull(level.m_142572_()), (SoundEvent)ChangedSounds.BUZZER1, (BlockPos)pos, (float)1.0f, (float)1.0f);
            player.m_5661_((Component)new TextComponent("You cannot use this lock in your current form!"), true);
            return InteractionResult.CONSUME;
        }
        if (!((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
            ChangedSounds.broadcastSound((MinecraftServer)Objects.requireNonNull(level.m_142572_()), (SoundEvent)ChangedSounds.BLOW1, (BlockPos)pos, (float)0.25f, (float)2.0f);
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(true)), 3);
        } else {
            ChangedSounds.broadcastSound((MinecraftServer)Objects.requireNonNull(level.m_142572_()), (SoundEvent)ChangedSounds.BLOW1, (BlockPos)pos, (float)0.25f, (float)2.0f);
            ChangedSounds.broadcastSound((MinecraftServer)Objects.requireNonNull(level.m_142572_()), (SoundEvent)ChangedSounds.KEY, (BlockPos)pos, (float)0.5f, (float)1.0f);
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)), 3);
        }
        this.updateRedstoneSignal(level, pos, state.m_60734_());
        level.m_186460_(pos, (Block)this, 5);
        return InteractionResult.SUCCESS;
    }

    public void updateRedstoneSignal(Level level, BlockPos pos, Block block) {
        level.m_46672_(pos, (Block)this);
        for (Direction direction : Direction.values()) {
            level.m_46672_(pos.m_142300_(direction), block);
        }
    }

    public void m_6861_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Block blockIn, @NotNull BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, level, pos, blockIn, fromPos, isMoving);
    }

    public void m_7458_(@NotNull BlockState state, @NotNull ServerLevel world, @NotNull BlockPos pos, @NotNull Random random) {
        super.m_7458_(state, world, pos, random);
        if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
            ChangedSounds.broadcastSound((MinecraftServer)world.m_142572_(), (SoundEvent)ChangedSounds.CHIME2, (BlockPos)pos, (float)1.0f, (float)1.0f);
        }
    }

    public boolean m_7898_(BlockState blockState, LevelReader level, BlockPos blockPos) {
        return level.m_8055_(blockPos.m_142300_(((Direction)blockState.m_61143_((Property)FACING)).m_122424_())).m_60783_((BlockGetter)level, blockPos.m_142300_(((Direction)blockState.m_61143_((Property)FACING)).m_122424_()), (Direction)blockState.m_61143_((Property)FACING));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        if (context.m_43723_() != null) {
            return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_(LOCK_TYPE, (Comparable)((Object)LockType.getValueByPlayer(context.m_43723_())));
        }
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public static enum LockType implements StringRepresentable
    {
        HUMAN,
        TRANSFURRED;


        public static LockType getValueByPlayer(@NotNull Player player) {
            return ProcessTransfur.isPlayerTransfurred((Player)player) ? TRANSFURRED : HUMAN;
        }

        @NotNull
        public String m_7912_() {
            return this.name().toLowerCase();
        }
    }
}

