/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.foxyas.changedaddon.ChangedAddonMod;
import net.foxyas.changedaddon.block.entity.InformantBlockEntity;
import net.foxyas.changedaddon.client.renderer.blockEntitys.InformantBlockEntityRenderer;
import net.foxyas.changedaddon.network.InformantBlockGuiKeyMessage;
import net.foxyas.changedaddon.util.TransfurVariantUtils;
import net.foxyas.changedaddon.world.inventory.InformantGuiMenu;
import net.ltxprogrammer.changed.entity.ChangedEntity;
import net.ltxprogrammer.changed.entity.variant.TransfurVariant;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.NotNull;

public class InformantGuiScreen
extends AbstractContainerScreen<InformantGuiMenu> {
    private static final ResourceLocation texture = ChangedAddonMod.textureLoc("textures/screens/informant_gui");
    private final Player player;
    private final List<String> allSuggestions = TransfurVariant.getPublicTransfurVariants().map(v -> v.getEntityType().m_20676_().getString()).toList();
    private final Map<String, List<TransfurVariant<?>>> nameToVariants = TransfurVariant.getPublicTransfurVariants().collect(Collectors.groupingBy(v -> v.getEntityType().m_20676_().getString()));
    private final List<String> filteredSuggestions = new ArrayList<String>();
    public EditBox form;
    private int suggestionIndex = -1;

    public InformantGuiScreen(InformantGuiMenu container, Inventory inventory, Component title) {
        super((AbstractContainerMenu)container, inventory, title);
        this.player = container.player;
        this.f_97726_ = 176;
        this.f_97727_ = 195;
        this.form = new EditBox(Minecraft.m_91087_().f_91062_, this.f_97735_ + 44, this.f_97736_ + 13, 90, 10, (Component)new TranslatableComponent("gui.changed_addon.informant_gui.form"));
        this.form.m_94202_(new Color(0, 205, 255).getRGB());
        this.form.m_94199_(128);
        this.form.m_94151_(text -> {
            InformantBlockEntity blockEntity = ((InformantGuiMenu)this.f_97732_).blockEntity;
            if (blockEntity.getText().equals(this.form.m_94155_())) {
                return;
            }
            this.updateSuggestions((String)text);
            List<TransfurVariant<?>> variants = this.nameToVariants.get(text);
            TransfurVariant<?> variant = null;
            if (variants != null && !variants.isEmpty()) {
                variant = variants.get(0);
            }
            ChangedAddonMod.PACKET_HANDLER.sendToServer((Object)new InformantBlockGuiKeyMessage((String)text, variant, ((InformantGuiMenu)this.f_97732_).blockEntity.m_58899_()));
            blockEntity.updateInternal((String)text, variant);
        });
        this.form.m_94144_(((InformantGuiMenu)this.f_97732_).blockEntity.getText());
        this.updateSuggestions(this.form.m_94155_());
    }

    public void m_6305_(@NotNull PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(stack);
        super.m_6305_(stack, mouseX, mouseY, partialTicks);
        this.form.m_6305_(stack, mouseX, mouseY, partialTicks);
        this.m_7025_(stack, mouseX, mouseY);
        if (mouseX > this.f_97735_ + 25 && mouseX < this.f_97735_ + 34 && mouseY > this.f_97736_ + 4 && mouseY < this.f_97736_ + 13) {
            this.m_96602_(stack, (Component)new TranslatableComponent("gui.changed_addon.informant_gui.tooltip_type_the_form"), mouseX, mouseY);
        }
        if (((InformantGuiMenu)this.f_97732_).getStackInSlot().m_41619_() && mouseX > this.f_97735_ + 151 && mouseX < this.f_97735_ + 168 && mouseY > this.f_97736_ + 88 && mouseY < this.f_97736_ + 105) {
            this.m_96602_(stack, (Component)new TranslatableComponent("gui.changed_addon.informant_gui.tooltip_put_a_syringe_with_a_form"), mouseX, mouseY);
        }
        if (!this.filteredSuggestions.isEmpty() && this.form.m_93696_()) {
            int x = this.form.f_93620_;
            int y = this.form.f_93621_ + this.form.m_93694_() + 2;
            int width = this.form.m_5711_();
            int height = 12;
            for (int i = 0; i < this.filteredSuggestions.size(); ++i) {
                String suggestion = this.filteredSuggestions.get(i);
                Color color = new Color(-2009022721, true);
                Color Bgcolor = new Color(-2011321620, true);
                int bgColor = i == this.suggestionIndex ? Bgcolor.getRGB() : color.getRGB();
                RenderSystem.m_69478_();
                RenderSystem.m_69453_();
                InformantGuiScreen.m_93172_((PoseStack)stack, (int)x, (int)(y + i * height), (int)(x + width), (int)(y + (i + 1) * height), (int)bgColor);
                this.f_96547_.m_92883_(stack, suggestion, (float)(x + 2), (float)(y + i * height + 2), 0xFFFFFF);
                RenderSystem.m_69461_();
            }
        }
        int iconX = this.f_97735_ + 9;
        int iconSize = 16;
        int iconYHealth = this.f_97736_ + 18;
        int iconYLandSpeed = this.f_97736_ + 40;
        int iconYSwimSpeed = this.f_97736_ + 62;
        int iconYJump = this.f_97736_ + 84;
        InformantBlockEntity blockEntity = ((InformantGuiMenu)this.f_97732_).blockEntity;
        TransfurVariant<?> tf = blockEntity.getDisplayTf();
        ChangedEntity entity = InformantBlockEntityRenderer.getDisplayEntity(tf);
        if (entity != null) {
            assert (Minecraft.m_91087_().f_91074_ != null);
            entity.f_19797_ = Minecraft.m_91087_().f_91074_.f_19797_;
            int centerX = this.f_97735_ + this.f_97726_ / 2;
            int centerY = this.f_97736_ + this.f_97727_ / 2;
            InventoryScreen.m_98850_((int)centerX, (int)centerY, (int)30, (float)(centerX - mouseX), (float)(centerY - 52 - mouseY), (LivingEntity)entity);
        }
        float hp = TransfurVariantUtils.GetExtraHp(tf, this.player);
        float swimSpeed = TransfurVariantUtils.GetSwimSpeed(tf, this.player);
        float landSpeed = TransfurVariantUtils.GetLandSpeed(tf, this.player);
        float jumpStrength = TransfurVariantUtils.GetJumpStrength(tf);
        boolean canFlyOrGlide = TransfurVariantUtils.CanGlideAndFly(tf);
        String miningStrength = TransfurVariantUtils.getMiningStrength(tf);
        float extraHp = hp / 2.0f;
        float landSpeedPct = landSpeed == 0.0f ? 0.0f : (landSpeed - 1.0f) * 100.0f;
        float swimSpeedPct = swimSpeed == 0.0f ? 0.0f : (swimSpeed - 1.0f) * 100.0f;
        float jumpStrengthPct = jumpStrength == 0.0f ? 0.0f : (jumpStrength - 1.0f) * 100.0f;
        MutableComponent landSpeedInfo = new TranslatableComponent("text.changed_addon.land_speed").m_130946_("").m_7220_((Component)(landSpeedPct == 0.0f ? new TextComponent("\u00a77None\u00a7r") : new TextComponent((landSpeedPct > 0.0f ? "\u00a7a+" : "\u00a7c") + (int)landSpeedPct + "%")));
        MutableComponent swimSpeedInfo = new TranslatableComponent("text.changed_addon.swim_speed").m_130946_("").m_7220_((Component)(swimSpeedPct == 0.0f ? new TextComponent("\u00a77None\u00a7r") : new TextComponent((swimSpeedPct > 0.0f ? "\u00a7a+" : "\u00a7c") + (int)swimSpeedPct + "%")));
        MutableComponent additionalHealthInfo = new TranslatableComponent("text.changed_addon.additionalHealth").m_130946_("").m_7220_((Component)(extraHp == 0.0f ? new TextComponent("\u00a77None\u00a7r") : new TextComponent((extraHp > 0.0f ? "\u00a7a+" : "\u00a7c") + extraHp + "\u00a7r"))).m_7220_((Component)new TranslatableComponent("text.changed_addon.additionalHealth.Hearts"));
        TranslatableComponent miningStrengthInfo = new TranslatableComponent("text.changed_addon.miningStrength", new Object[]{miningStrength});
        MutableComponent jumpStrengthInfo = new TranslatableComponent("text.changed_addon.jumpStrength").m_130946_("").m_7220_((Component)(jumpStrengthPct == 0.0f ? new TextComponent("\u00a77None\u00a7r") : new TextComponent((jumpStrengthPct > 0.0f ? "\u00a7a+" : "\u00a7c") + (int)jumpStrengthPct + "%")));
        MutableComponent canGlideInfo = new TranslatableComponent("text.changed_addon.canGlide/Fly").m_130946_("").m_7220_((Component)(canFlyOrGlide ? new TextComponent("\u00a7aTrue\u00a7r") : new TextComponent("\u00a7cFalse\u00a7r")));
        if (mouseX > iconX && mouseX < iconX + iconSize) {
            if (mouseY > iconYHealth && mouseY < iconYHealth + iconSize) {
                this.m_96602_(stack, (Component)additionalHealthInfo, mouseX, mouseY);
            } else if (mouseY > iconYLandSpeed && mouseY < iconYLandSpeed + iconSize) {
                this.m_96602_(stack, (Component)landSpeedInfo, mouseX, mouseY);
            } else if (mouseY > iconYSwimSpeed && mouseY < iconYSwimSpeed + iconSize) {
                this.m_169388_(stack, List.of(swimSpeedInfo), Optional.empty(), mouseX, mouseY);
            } else if (mouseY > iconYJump && mouseY < iconYJump + iconSize) {
                this.m_96602_(stack, (Component)jumpStrengthInfo, mouseX, mouseY);
            }
        }
    }

    protected void m_7286_(@NotNull PoseStack ms, float partialTicks, int gx, int gy) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
        InformantGuiScreen.m_93133_((PoseStack)ms, (int)this.f_97735_, (int)this.f_97736_, (float)0.0f, (float)0.0f, (int)this.f_97726_, (int)this.f_97727_, (int)this.f_97726_, (int)this.f_97727_);
        RenderSystem.m_69461_();
    }

    public boolean m_6375_(double mouseX, double mouseY, int keyCode) {
        assert (this.f_96541_ != null);
        if (this.f_96541_.f_91074_ != null) {
            int iconX = this.f_97735_ + 9;
            int iconSize = 16;
            int iconYHealth = this.f_97736_ + 18;
            int iconYLandSpeed = this.f_97736_ + 40;
            int iconYSwimSpeed = this.f_97736_ + 62;
            int iconYJump = this.f_97736_ + 84;
            if (mouseX > (double)iconX && mouseX < (double)(iconX + iconSize)) {
                if (mouseY > (double)iconYHealth && mouseY < (double)(iconYHealth + iconSize)) {
                    this.f_96541_.f_91074_.m_5496_(SoundEvents.f_12490_, 1.0f, 1.0f);
                } else if (mouseY > (double)iconYLandSpeed && mouseY < (double)(iconYLandSpeed + iconSize)) {
                    this.f_96541_.f_91074_.m_5496_(SoundEvents.f_12490_, 1.0f, 1.0f);
                } else if (mouseY > (double)iconYSwimSpeed && mouseY < (double)(iconYSwimSpeed + iconSize)) {
                    this.f_96541_.f_91074_.m_5496_(SoundEvents.f_12490_, 1.0f, 1.0f);
                } else if (mouseY > (double)iconYJump && mouseY < (double)(iconYJump + iconSize)) {
                    this.f_96541_.f_91074_.m_5496_(SoundEvents.f_12490_, 1.0f, 1.0f);
                }
            } else if (mouseX > (double)(this.f_97735_ + 25) && mouseX < (double)(this.f_97735_ + 34) && mouseY > (double)(this.f_97736_ + 4) && mouseY < (double)(this.f_97736_ + 13)) {
                this.f_96541_.f_91074_.m_5496_(SoundEvents.f_12490_, 1.0f, 1.0f);
            }
        }
        return super.m_6375_(mouseX, mouseY, keyCode);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (!this.filteredSuggestions.isEmpty()) {
            if (keyCode == 265) {
                this.suggestionIndex = Math.max(0, this.suggestionIndex - 1);
                return true;
            }
            if (keyCode == 264) {
                this.suggestionIndex = Math.min(this.filteredSuggestions.size() - 1, this.suggestionIndex + 1);
                return true;
            }
            if ((keyCode == 257 || keyCode == 335) && this.suggestionIndex >= 0 && this.suggestionIndex < this.filteredSuggestions.size()) {
                this.form.m_94144_(this.filteredSuggestions.get(this.suggestionIndex));
                if (this.form.m_93696_()) {
                    this.form.m_94178_(false);
                }
                return true;
            }
        }
        if (keyCode == 256) {
            assert (this.f_96541_ != null);
            assert (this.f_96541_.f_91074_ != null);
            if (!this.form.m_93696_()) {
                this.f_96541_.f_91074_.m_6915_();
            } else {
                this.form.m_94178_(false);
            }
            return true;
        }
        return this.form.m_93696_() ? this.form.m_7933_(keyCode, scanCode, modifiers) : super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_181908_() {
        super.m_181908_();
        this.form.m_94120_();
        InformantBlockEntity blockEntity = ((InformantGuiMenu)this.f_97732_).blockEntity;
        if (!blockEntity.getText().equals(this.form.m_94155_())) {
            this.form.m_94144_(blockEntity.getText());
        }
    }

    protected void m_7027_(@NotNull PoseStack poseStack, int mouseX, int mouseY) {
        this.f_96547_.m_92889_(poseStack, (Component)new TranslatableComponent("gui.changed_addon.informant_gui.label_empty"), 27.5f, 5.5f, -12829636);
    }

    public void m_7379_() {
        super.m_7379_();
        Minecraft.m_91087_().f_91068_.m_90926_(false);
    }

    public void m_7856_() {
        super.m_7856_();
        this.form.f_93620_ = this.f_97735_ + 44;
        this.form.f_93621_ = this.f_97736_ + 13;
        assert (this.f_96541_ != null);
        this.f_96541_.f_91068_.m_90926_(true);
        this.m_7787_((GuiEventListener)this.form);
    }

    public void updateSuggestions(String input) {
        this.filteredSuggestions.clear();
        if (input.isEmpty()) {
            this.suggestionIndex = -1;
            this.form.m_94167_(new TranslatableComponent("gui.changed_addon.informant_gui.form").getString());
            return;
        }
        this.allSuggestions.stream().filter(s -> s.toLowerCase().startsWith(input.toLowerCase())).distinct().limit(6L).forEach(this.filteredSuggestions::add);
        if (this.filteredSuggestions.isEmpty()) {
            this.suggestionIndex = -1;
            this.form.m_94167_(null);
            return;
        }
        this.suggestionIndex = Mth.m_14045_((int)this.suggestionIndex, (int)0, (int)(this.filteredSuggestions.size() - 1));
        String suggestion = this.filteredSuggestions.get(this.suggestionIndex);
        this.form.m_94167_(input.equalsIgnoreCase(suggestion) ? null : suggestion.substring(input.length()));
    }
}

