/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.foxyas.changedaddon.entity.advanced.LatexSnepEntity;
import net.ltxprogrammer.changed.client.renderer.animate.AnimatorPresets;
import net.ltxprogrammer.changed.client.renderer.animate.HumanoidAnimator;
import net.ltxprogrammer.changed.client.renderer.model.AdvancedHumanoidModel;
import net.ltxprogrammer.changed.client.renderer.model.AdvancedHumanoidModelInterface;
import net.ltxprogrammer.changed.entity.ChangedEntity;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.Pose;
import org.jetbrains.annotations.NotNull;

public class LatexSnepModel
extends AdvancedHumanoidModel<LatexSnepEntity>
implements AdvancedHumanoidModelInterface<LatexSnepEntity, LatexSnepModel> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("changed_addon", "latex_snep"), "main");
    private final ModelPart Animal;
    private final ModelPart Head;
    private final ModelPart Torso;
    private final ModelPart Tail;
    private final ModelPart TailPrimary;
    private final ModelPart TailSecondary;
    private final ModelPart TailTertiary;
    private final ModelPart TailQuaternary;
    private final ModelPart TailQuinternary;
    private final ModelPart LegFrontRight;
    private final ModelPart LegBackRight;
    private final ModelPart LegFrontLeft;
    private final ModelPart LegBackLeft;
    private final HumanoidAnimator<LatexSnepEntity, LatexSnepModel> animator;

    public LatexSnepModel(ModelPart root) {
        super(root);
        this.Animal = root.m_171324_("Animal");
        this.Head = this.Animal.m_171324_("Head");
        this.Torso = this.Animal.m_171324_("Torso");
        this.Tail = this.Torso.m_171324_("Tail");
        this.TailPrimary = this.Tail.m_171324_("TailPrimary");
        this.TailSecondary = this.TailPrimary.m_171324_("TailSecondary");
        this.TailTertiary = this.TailSecondary.m_171324_("TailTertiary");
        this.TailQuaternary = this.TailTertiary.m_171324_("TailQuaternary");
        this.TailQuinternary = this.TailQuaternary.m_171324_("TailQuinternary");
        this.animator = HumanoidAnimator.of((AdvancedHumanoidModel)this).addPreset(AnimatorPresets.wolfTail((ModelPart)this.Tail, List.of(this.TailPrimary, this.TailSecondary, this.TailTertiary, this.TailQuaternary, this.TailQuinternary)));
        this.LegFrontRight = this.Animal.m_171324_("LegFrontRight").m_171324_("RightArm");
        this.LegBackRight = this.Animal.m_171324_("LegBackRight");
        ModelPart rightLowerLeg = this.LegBackRight.m_171324_("RightLowerLeg");
        ModelPart rightFoot = rightLowerLeg.m_171324_("RightFoot");
        ModelPart rightPad = rightFoot.m_171324_("RightPad");
        this.LegFrontLeft = this.Animal.m_171324_("LegFrontLeft").m_171324_("LeftArm");
        this.LegBackLeft = this.Animal.m_171324_("LegBackLeft");
        ModelPart leftLowerLeg = this.LegBackLeft.m_171324_("LeftLowerLeg");
        ModelPart leftFoot = leftLowerLeg.m_171324_("LeftFoot");
        ModelPart leftPad = leftFoot.m_171324_("LeftPad");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition Animal = partdefinition.m_171599_("Animal", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.5f));
        PartDefinition Head = Animal.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.5f, -2.0f, -3.0f, 5.0f, 4.0f, 5.0f, new CubeDeformation(0.5f)).m_171514_(0, 24).m_171488_(-1.5f, -0.02f, -4.75f, 3.0f, 2.0f, 2.0f, new CubeDeformation(0.05f)).m_171514_(14, 23).m_171488_(-2.75f, -4.5f, -0.75f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(25, 24).m_171488_(0.75f, -4.5f, -0.75f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-10.0f, (float)-8.25f));
        PartDefinition Torso = Animal.m_171599_("Torso", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-9.0f, (float)-0.5f));
        PartDefinition Torso_r1 = Torso.m_171599_("Torso_r1", CubeListBuilder.m_171558_().m_171514_(50, 12).m_171488_(-3.0f, 3.0f, -2.0f, 6.0f, 11.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.5f, (float)-4.75f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition Torso_r2 = Torso.m_171599_("Torso_r2", CubeListBuilder.m_171558_().m_171514_(48, 1).m_171488_(-3.5f, -2.0f, -2.5f, 7.0f, 5.0f, 6.0f, new CubeDeformation(-0.2f)), PartPose.m_171423_((float)0.0f, (float)0.5f, (float)-4.5f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition Tail = Torso.m_171599_("Tail", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)-0.5f, (float)7.75f, (float)0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition TailPrimary = Tail.m_171599_("TailPrimary", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)-0.0173f, (float)-1.0306f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition Base_r1 = TailPrimary.m_171599_("Base_r1", CubeListBuilder.m_171558_().m_171514_(0, 57).m_171488_(-2.0f, 0.75f, -1.5f, 4.0f, 5.0f, 4.0f, new CubeDeformation(-0.2f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0908f, (float)0.0f, (float)0.0f));
        PartDefinition TailSecondary = TailPrimary.m_171599_("TailSecondary", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)1.25f, (float)4.5f));
        PartDefinition Base_r2 = TailSecondary.m_171599_("Base_r2", CubeListBuilder.m_171558_().m_171514_(0, 46).m_171488_(-2.5f, -0.45f, -2.5f, 5.0f, 6.0f, 5.0f, new CubeDeformation(-0.3f)), PartPose.m_171423_((float)0.0f, (float)0.5f, (float)0.0f, (float)1.3526f, (float)0.0f, (float)0.0f));
        PartDefinition TailTertiary = TailSecondary.m_171599_("TailTertiary", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.75f, (float)4.5f));
        PartDefinition Base_r3 = TailTertiary.m_171599_("Base_r3", CubeListBuilder.m_171558_().m_171514_(27, 32).m_171488_(-2.5f, 4.55f, -3.3f, 5.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-0.25f, (float)-4.5f, (float)1.5272f, (float)0.0f, (float)0.0f));
        PartDefinition TailQuaternary = TailTertiary.m_171599_("TailQuaternary", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)8.0f));
        PartDefinition Base_r4 = TailQuaternary.m_171599_("Base_r4", CubeListBuilder.m_171558_().m_171514_(73, 53).m_171488_(-2.5f, 4.55f, -3.3f, 5.0f, 8.0f, 5.0f, new CubeDeformation(-0.01f)), PartPose.m_171423_((float)0.0f, (float)-0.75f, (float)-4.75f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition TailQuinternary = TailQuaternary.m_171599_("TailQuinternary", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)7.5f));
        PartDefinition Base_r5 = TailQuinternary.m_171599_("Base_r5", CubeListBuilder.m_171558_().m_171514_(60, 63).m_171488_(-2.0f, 5.5f, -3.8f, 4.0f, 3.0f, 4.0f, new CubeDeformation(0.15f)), PartPose.m_171423_((float)0.0f, (float)-1.0f, (float)-5.5f, (float)1.7017f, (float)0.0f, (float)0.0f));
        PartDefinition LegFrontRight = Animal.m_171599_("LegFrontRight", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-1.0f, (float)-6.0f, (float)-4.5f));
        PartDefinition RightArm = LegFrontRight.m_171599_("RightArm", CubeListBuilder.m_171558_().m_171514_(16, 35).m_171480_().m_171488_(-1.5f, -2.0f, -1.75f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition RightThigh_r1 = RightArm.m_171599_("RightThigh_r1", CubeListBuilder.m_171558_().m_171514_(0, 34).m_171488_(0.0f, 2.075f, -2.1f, 2.0f, 4.0f, 3.0f, new CubeDeformation(0.001f)), PartPose.m_171423_((float)-1.5f, (float)-4.5f, (float)1.0f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition NewRightPawBeans = RightArm.m_171599_("NewRightPawBeans", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-0.5f, (float)6.025f, (float)-1.1f));
        PartDefinition MiddlePawBeans2 = NewRightPawBeans.m_171599_("MiddlePawBeans2", CubeListBuilder.m_171558_().m_171514_(8, 83).m_171480_().m_171488_(-0.9f, -0.6169f, -0.4895f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.4f)).m_171555_(false).m_171514_(8, 83).m_171480_().m_171488_(-0.8f, -0.617f, -0.615f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.4f)).m_171555_(false).m_171514_(8, 83).m_171480_().m_171488_(-0.7f, -0.6167f, -0.6145f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.4f)).m_171555_(false).m_171514_(8, 83).m_171480_().m_171488_(-0.5f, -0.6167f, -0.6145f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.4f)).m_171555_(false).m_171514_(8, 83).m_171480_().m_171488_(-0.3f, -0.6167f, -0.6145f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.4f)).m_171555_(false).m_171514_(8, 83).m_171480_().m_171488_(-0.2f, -0.617f, -0.615f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.4f)).m_171555_(false).m_171514_(8, 83).m_171480_().m_171488_(-0.1f, -0.6169f, -0.4895f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.4f)).m_171555_(false).m_171514_(9, 88).m_171480_().m_171488_(-1.0f, -0.6168f, -0.3645f, 2.0f, 1.0f, 1.0f, new CubeDeformation(-0.4f)).m_171555_(false).m_171514_(9, 88).m_171480_().m_171488_(-1.0f, -0.7157f, -0.1145f, 2.0f, 1.0f, 1.0f, new CubeDeformation(-0.3f)).m_171555_(false).m_171514_(8, 83).m_171480_().m_171488_(-0.3f, -0.6169f, -0.4895f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.4f)).m_171555_(false).m_171514_(8, 83).m_171480_().m_171488_(-0.5f, -0.6169f, -0.4895f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.4f)).m_171555_(false).m_171514_(8, 83).m_171480_().m_171488_(-0.7f, -0.6169f, -0.4895f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.4f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)0.0417f, (float)0.4645f));
        PartDefinition PawBeans2 = NewRightPawBeans.m_171599_("PawBeans2", CubeListBuilder.m_171558_().m_171514_(8, 83).m_171480_().m_171488_(-1.96f, -0.624f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.325f)).m_171555_(false).m_171514_(8, 79).m_171480_().m_171488_(-1.53f, -0.624f, -0.925f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.3f)).m_171555_(false).m_171514_(8, 81).m_171480_().m_171488_(-0.93f, -0.624f, -0.925f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.3f)).m_171555_(false).m_171514_(8, 85).m_171488_(-0.5f, -0.624f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.325f)), PartPose.m_171419_((float)0.73f, (float)-0.05f, (float)0.225f));
        PartDefinition LegFrontLeft = Animal.m_171599_("LegFrontLeft", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)1.0f, (float)-5.75f, (float)-4.75f));
        PartDefinition LeftArm = LegFrontLeft.m_171599_("LeftArm", CubeListBuilder.m_171558_().m_171514_(16, 35).m_171488_(-0.5f, -2.25f, -1.5f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition LeftThigh_r1 = LeftArm.m_171599_("LeftThigh_r1", CubeListBuilder.m_171558_().m_171514_(0, 34).m_171480_().m_171488_(-2.0f, 2.075f, -2.1f, 2.0f, 4.0f, 3.0f, new CubeDeformation(0.001f)).m_171555_(false), PartPose.m_171423_((float)1.5f, (float)-4.75f, (float)1.25f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition NewLeftPawBeans = LeftArm.m_171599_("NewLeftPawBeans", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.5f, (float)5.775f, (float)-0.85f));
        PartDefinition MiddlePawBeans = NewLeftPawBeans.m_171599_("MiddlePawBeans", CubeListBuilder.m_171558_().m_171514_(8, 83).m_171488_(-0.1f, -0.6169f, -0.4895f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.4f)).m_171514_(8, 83).m_171488_(-0.2f, -0.617f, -0.615f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.4f)).m_171514_(8, 83).m_171488_(-0.3f, -0.6167f, -0.6145f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.4f)).m_171514_(8, 83).m_171488_(-0.5f, -0.6167f, -0.6145f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.4f)).m_171514_(8, 83).m_171488_(-0.7f, -0.6167f, -0.6145f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.4f)).m_171514_(8, 83).m_171488_(-0.8f, -0.617f, -0.615f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.4f)).m_171514_(8, 83).m_171488_(-0.9f, -0.6169f, -0.4895f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.4f)).m_171514_(9, 88).m_171488_(-1.0f, -0.6168f, -0.3645f, 2.0f, 1.0f, 1.0f, new CubeDeformation(-0.4f)).m_171514_(9, 88).m_171488_(-1.0f, -0.7157f, -0.1145f, 2.0f, 1.0f, 1.0f, new CubeDeformation(-0.3f)).m_171514_(8, 83).m_171488_(-0.7f, -0.6169f, -0.4895f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.4f)).m_171514_(8, 83).m_171488_(-0.5f, -0.6169f, -0.4895f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.4f)).m_171514_(8, 83).m_171488_(-0.3f, -0.6169f, -0.4895f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.4f)), PartPose.m_171419_((float)0.0f, (float)0.0417f, (float)0.4645f));
        PartDefinition PawBeans = NewLeftPawBeans.m_171599_("PawBeans", CubeListBuilder.m_171558_().m_171514_(8, 85).m_171488_(0.96f, -0.624f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.325f)).m_171514_(8, 79).m_171488_(0.53f, -0.624f, -0.925f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.3f)).m_171514_(8, 81).m_171488_(-0.07f, -0.624f, -0.925f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.3f)).m_171514_(8, 83).m_171480_().m_171488_(-0.5f, -0.624f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.325f)).m_171555_(false), PartPose.m_171419_((float)-0.73f, (float)-0.05f, (float)0.225f));
        PartDefinition LegBackRight = Animal.m_171599_("LegBackRight", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-2.0f, (float)-6.0f, (float)6.5f));
        PartDefinition RightThigh_r2 = LegBackRight.m_171599_("RightThigh_r2", CubeListBuilder.m_171558_().m_171514_(0, 34).m_171488_(0.25f, 2.075f, -2.1f, 2.0f, 4.0f, 3.0f, new CubeDeformation(0.001f)), PartPose.m_171423_((float)-1.5f, (float)-4.5f, (float)1.0f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition RightLowerLeg = LegBackRight.m_171599_("RightLowerLeg", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-0.5f, (float)2.875f, (float)-2.45f));
        PartDefinition RightCalf_r1 = RightLowerLeg.m_171599_("RightCalf_r1", CubeListBuilder.m_171558_().m_171514_(0, 28).m_171488_(-0.74f, -0.625f, -2.15f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-3.125f, (float)1.95f, (float)0.8727f, (float)0.0f, (float)0.0f));
        PartDefinition RightFoot = RightLowerLeg.m_171599_("RightFoot", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.3f, (float)4.675f));
        PartDefinition RightArch_r1 = RightFoot.m_171599_("RightArch_r1", CubeListBuilder.m_171558_().m_171514_(8, 28).m_171488_(0.25f, -5.45f, -0.725f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.005f)), PartPose.m_171423_((float)-1.0f, (float)3.575f, (float)-3.225f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition RightPad = RightFoot.m_171599_("RightPad", CubeListBuilder.m_171558_().m_171514_(7, 34).m_171488_(-0.75f, -1.0f, -0.85f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)2.825f, (float)-2.675f));
        PartDefinition NewBackRightPawBeans = LegBackRight.m_171599_("NewBackRightPawBeans", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-0.25f, (float)6.025f, (float)-0.6f));
        PartDefinition MiddlePawBeans3 = NewBackRightPawBeans.m_171599_("MiddlePawBeans3", CubeListBuilder.m_171558_().m_171514_(8, 83).m_171480_().m_171488_(-0.9f, -0.6169f, -0.4895f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.4f)).m_171555_(false).m_171514_(8, 83).m_171480_().m_171488_(-0.8f, -0.617f, -0.615f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.4f)).m_171555_(false).m_171514_(8, 83).m_171480_().m_171488_(-0.7f, -0.6167f, -0.6145f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.4f)).m_171555_(false).m_171514_(8, 83).m_171480_().m_171488_(-0.5f, -0.6167f, -0.6145f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.4f)).m_171555_(false).m_171514_(8, 83).m_171480_().m_171488_(-0.3f, -0.6167f, -0.6145f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.4f)).m_171555_(false).m_171514_(8, 83).m_171480_().m_171488_(-0.2f, -0.617f, -0.615f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.4f)).m_171555_(false).m_171514_(8, 83).m_171480_().m_171488_(-0.1f, -0.6169f, -0.4895f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.4f)).m_171555_(false).m_171514_(9, 88).m_171480_().m_171488_(-1.0f, -0.6168f, -0.3645f, 2.0f, 1.0f, 1.0f, new CubeDeformation(-0.4f)).m_171555_(false).m_171514_(9, 88).m_171480_().m_171488_(-1.0f, -0.7157f, -0.1145f, 2.0f, 1.0f, 1.0f, new CubeDeformation(-0.3f)).m_171555_(false).m_171514_(8, 83).m_171480_().m_171488_(-0.3f, -0.6169f, -0.4895f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.4f)).m_171555_(false).m_171514_(8, 83).m_171480_().m_171488_(-0.5f, -0.6169f, -0.4895f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.4f)).m_171555_(false).m_171514_(8, 83).m_171480_().m_171488_(-0.7f, -0.6169f, -0.4895f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.4f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)0.0417f, (float)0.4645f));
        PartDefinition PawBeans3 = NewBackRightPawBeans.m_171599_("PawBeans3", CubeListBuilder.m_171558_().m_171514_(8, 83).m_171480_().m_171488_(-1.96f, -0.624f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.325f)).m_171555_(false).m_171514_(8, 79).m_171480_().m_171488_(-1.53f, -0.624f, -0.925f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.3f)).m_171555_(false).m_171514_(8, 81).m_171480_().m_171488_(-0.93f, -0.624f, -0.925f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.3f)).m_171555_(false).m_171514_(8, 85).m_171488_(-0.5f, -0.624f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.325f)), PartPose.m_171419_((float)0.73f, (float)-0.05f, (float)0.225f));
        PartDefinition LegBackLeft = Animal.m_171599_("LegBackLeft", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)1.75f, (float)-6.0f, (float)6.5f));
        PartDefinition LeftThigh_r2 = LegBackLeft.m_171599_("LeftThigh_r2", CubeListBuilder.m_171558_().m_171514_(0, 34).m_171480_().m_171488_(-2.0f, 2.075f, -2.1f, 2.0f, 4.0f, 3.0f, new CubeDeformation(0.001f)).m_171555_(false), PartPose.m_171423_((float)1.5f, (float)-4.5f, (float)1.0f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition LeftLowerLeg = LegBackLeft.m_171599_("LeftLowerLeg", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.5f, (float)2.875f, (float)-2.45f));
        PartDefinition LeftCalf_r1 = LeftLowerLeg.m_171599_("LeftCalf_r1", CubeListBuilder.m_171558_().m_171514_(0, 28).m_171480_().m_171488_(-1.01f, -0.625f, -2.15f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)-3.125f, (float)1.95f, (float)0.8727f, (float)0.0f, (float)0.0f));
        PartDefinition LeftFoot = LeftLowerLeg.m_171599_("LeftFoot", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.3f, (float)4.675f));
        PartDefinition LeftArch_r1 = LeftFoot.m_171599_("LeftArch_r1", CubeListBuilder.m_171558_().m_171514_(8, 28).m_171480_().m_171488_(-2.0f, -5.45f, -0.725f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.005f)).m_171555_(false), PartPose.m_171423_((float)1.0f, (float)3.575f, (float)-3.225f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition LeftPad = LeftFoot.m_171599_("LeftPad", CubeListBuilder.m_171558_().m_171514_(7, 34).m_171480_().m_171488_(-1.0f, -1.0f, -0.85f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)2.825f, (float)-2.675f));
        PartDefinition NewBackLeftPawBeans = LegBackLeft.m_171599_("NewBackLeftPawBeans", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.5f, (float)6.025f, (float)-0.6f));
        PartDefinition MiddlePawBeans4 = NewBackLeftPawBeans.m_171599_("MiddlePawBeans4", CubeListBuilder.m_171558_().m_171514_(8, 83).m_171488_(-0.1f, -0.6169f, -0.4895f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.4f)).m_171514_(8, 83).m_171488_(-0.2f, -0.617f, -0.615f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.4f)).m_171514_(8, 83).m_171488_(-0.3f, -0.6167f, -0.6145f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.4f)).m_171514_(8, 83).m_171488_(-0.5f, -0.6167f, -0.6145f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.4f)).m_171514_(8, 83).m_171488_(-0.7f, -0.6167f, -0.6145f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.4f)).m_171514_(8, 83).m_171488_(-0.8f, -0.617f, -0.615f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.4f)).m_171514_(8, 83).m_171488_(-0.9f, -0.6169f, -0.4895f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.4f)).m_171514_(9, 88).m_171488_(-1.0f, -0.6168f, -0.3645f, 2.0f, 1.0f, 1.0f, new CubeDeformation(-0.4f)).m_171514_(9, 88).m_171488_(-1.0f, -0.7157f, -0.1145f, 2.0f, 1.0f, 1.0f, new CubeDeformation(-0.3f)).m_171514_(8, 83).m_171488_(-0.7f, -0.6169f, -0.4895f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.4f)).m_171514_(8, 83).m_171488_(-0.5f, -0.6169f, -0.4895f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.4f)).m_171514_(8, 83).m_171488_(-0.3f, -0.6169f, -0.4895f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.4f)), PartPose.m_171419_((float)0.0f, (float)0.0417f, (float)0.4645f));
        PartDefinition PawBeans4 = NewBackLeftPawBeans.m_171599_("PawBeans4", CubeListBuilder.m_171558_().m_171514_(8, 85).m_171488_(0.96f, -0.624f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.325f)).m_171514_(8, 79).m_171488_(0.53f, -0.624f, -0.925f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.3f)).m_171514_(8, 81).m_171488_(-0.07f, -0.624f, -0.925f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.3f)).m_171514_(8, 83).m_171480_().m_171488_(-0.5f, -0.624f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.325f)).m_171555_(false), PartPose.m_171419_((float)-0.73f, (float)-0.05f, (float)0.225f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)96, (int)96);
    }

    public void prepareMobModel(@NotNull LatexSnepEntity entity, float limbSwing, float limbSwingAmount, float partialTicks) {
        this.prepareMobModel(this.animator, (ChangedEntity)entity, limbSwing, limbSwingAmount, partialTicks);
        this.Torso.f_104203_ = 0.0f;
        this.Torso.f_104204_ = 0.0f;
        this.Torso.f_104205_ = 0.0f;
        this.Tail.f_104203_ = -0.05235988f;
        if (entity.m_20142_() && entity.m_20096_()) {
            this.LegFrontRight.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.LegFrontLeft.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.LegBackRight.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.LegBackLeft.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.LegBackRight.f_104204_ = 0.0f;
            this.LegBackRight.f_104205_ = 0.0f;
            this.LegBackLeft.f_104204_ = 0.0f;
            this.LegBackLeft.f_104205_ = 0.0f;
            this.LegFrontRight.f_104204_ = 0.0f;
            this.LegFrontRight.f_104205_ = 0.0f;
            this.LegFrontLeft.f_104204_ = 0.0f;
            this.LegFrontLeft.f_104205_ = 0.0f;
        } else {
            this.LegBackRight.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.LegBackRight.f_104204_ = 0.0f;
            this.LegBackRight.f_104205_ = 0.0f;
            this.LegBackLeft.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.LegBackLeft.f_104204_ = 0.0f;
            this.LegBackLeft.f_104205_ = 0.0f;
            this.LegFrontRight.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.LegFrontRight.f_104204_ = 0.0f;
            this.LegFrontRight.f_104205_ = 0.0f;
            this.LegFrontLeft.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.LegFrontLeft.f_104204_ = 0.0f;
            this.LegFrontLeft.f_104205_ = 0.0f;
        }
        this.Head.m_104227_(0.0f, 14.0f, -7.2f);
        this.Head.f_104204_ = 0.0f;
        this.LegBackRight.f_104207_ = true;
        this.LegBackLeft.f_104207_ = true;
        this.LegFrontRight.f_104207_ = true;
        this.LegFrontLeft.f_104207_ = true;
        this.Torso.f_104205_ = 0.0f;
        this.LegBackRight.m_104227_(-2.0f, 18.0f, 7.0f);
        this.LegBackLeft.m_104227_(1.75f, 18.0f, 7.0f);
        this.LegFrontRight.m_104227_(-1.75f, 18.0f, -3.0f);
        this.LegFrontLeft.m_104227_(1.75f, 18.0f, -3.0f);
        if (entity.m_6047_()) {
            float f = entity.getCrouchAmount(partialTicks);
            this.Torso.m_104227_(0.0f, 15.0f + entity.getCrouchAmount(partialTicks) - (entity.WantToLoaf() ? 0.0f : 2.0f), 0.0f);
            this.Head.m_104227_(0.0f, 14.0f + f - (entity.WantToLoaf() ? 0.0f : 2.0f), -7.2f);
        } else if (entity.m_5803_()) {
            this.LegBackRight.f_104207_ = false;
            this.LegBackLeft.f_104207_ = false;
            this.LegFrontRight.f_104207_ = false;
            this.LegFrontLeft.f_104207_ = false;
            this.Torso.f_104203_ = -1.5707964f;
            this.Torso.f_104204_ = (float)Math.PI;
            this.Torso.m_104227_(0.0f, 22.5f, -2.5f);
            this.Head.m_104227_(0.0f, 14.0f, -1.75f);
            this.Head.f_104203_ = -1.5707964f;
            this.Head.f_104204_ = (float)Math.PI;
        } else if (!entity.m_6144_()) {
            this.Torso.m_104227_(0.0f, 15.0f, 0.0f);
        }
        if (!entity.m_5803_()) {
            breathingOffset = Mth.m_14031_((float)((float)entity.f_19797_ * 0.1f)) * 0.15f;
            this.Torso.f_104201_ += breathingOffset;
            this.Head.f_104201_ += breathingOffset;
        } else {
            breathingOffset = Mth.m_14031_((float)((float)entity.f_19797_ * 0.1f)) * 0.15f;
            this.Torso.f_104202_ += breathingOffset;
            this.Head.f_104202_ += breathingOffset;
        }
    }

    public void setupHand(LatexSnepEntity entity) {
        this.animator.setupHand();
    }

    public void setupAnim(@NotNull LatexSnepEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!entity.m_5803_()) {
            this.Head.f_104203_ = headPitch * ((float)Math.PI / 180);
            this.Head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
            this.Head.f_104205_ = 0.0f;
            this.Torso.f_104204_ = 0.0f;
        }
        if (entity.m_5803_()) {
            // empty if block
        }
        if (entity.m_6047_() && entity.WantToLoaf()) {
            float f;
            this.Torso.f_104204_ = f = Mth.m_14089_((float)ageInTicks) * 0.01f;
            this.LegBackRight.f_104205_ = f;
            this.LegBackLeft.f_104205_ = f;
            this.LegFrontRight.f_104205_ = f / 2.0f;
            this.LegFrontLeft.f_104205_ = f / 2.0f;
        }
        this.animator.setupAnim((ChangedEntity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        if (entity.m_6047_()) {
            this.Tail.f_104203_ = 0.34906584f;
        }
        if (entity.m_5803_()) {
            this.Tail.f_104203_ = 0.0f;
        }
        if (entity.m_20089_() == Pose.SWIMMING || entity.m_20089_() == Pose.FALL_FLYING) {
            this.Tail.f_104203_ = 0.0f;
        }
        super.setupAnim((ChangedEntity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
    }

    @NotNull
    public ModelPart m_102851_(HumanoidArm p_102852) {
        return p_102852 == HumanoidArm.LEFT ? this.LegFrontLeft : this.LegFrontRight;
    }

    public ModelPart getLeg(HumanoidArm humanoidArm) {
        return humanoidArm == HumanoidArm.LEFT ? this.LegBackLeft : this.LegBackRight;
    }

    @NotNull
    public ModelPart m_5585_() {
        return this.Head;
    }

    public ModelPart getTorso() {
        return this.Torso;
    }

    public HumanoidAnimator<LatexSnepEntity, LatexSnepModel> getAnimator(LatexSnepEntity entity) {
        return this.animator;
    }

    public void m_7695_(@NotNull PoseStack poseStack, @NotNull VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.Head.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.Torso.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.LegFrontRight.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.LegBackRight.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.LegBackLeft.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.LegFrontLeft.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

