/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.foxyas.changedaddon.ChangedAddonMod;
import net.foxyas.changedaddon.entity.partials.SnowLeopardPartialEntity;
import net.ltxprogrammer.changed.client.CubeListBuilderExtender;
import net.ltxprogrammer.changed.client.renderer.animate.AnimatorPresets;
import net.ltxprogrammer.changed.client.renderer.animate.HumanoidAnimator;
import net.ltxprogrammer.changed.client.renderer.animate.arm.ArmBobAnimator;
import net.ltxprogrammer.changed.client.renderer.animate.arm.ArmRideAnimator;
import net.ltxprogrammer.changed.client.renderer.animate.arm.ArmSwimAnimator;
import net.ltxprogrammer.changed.client.renderer.animate.upperbody.WolfHeadInitAnimator;
import net.ltxprogrammer.changed.client.renderer.model.AdvancedHumanoidModel;
import net.ltxprogrammer.changed.client.renderer.model.AdvancedHumanoidModelInterface;
import net.ltxprogrammer.changed.entity.ChangedEntity;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.PlayerModelPart;
import org.jetbrains.annotations.NotNull;

public class SnowLeopardPartialModel
extends AdvancedHumanoidModel<SnowLeopardPartialEntity>
implements AdvancedHumanoidModelInterface<SnowLeopardPartialEntity, SnowLeopardPartialModel> {
    public static final ModelLayerLocation LAYER_LOCATION_HUMAN = new ModelLayerLocation(ChangedAddonMod.resourceLoc("snow_leopard_partial"), "main");
    public static final ModelLayerLocation LAYER_LOCATION_HUMAN_SLIM = new ModelLayerLocation(ChangedAddonMod.resourceLoc("snow_leopard_partial"), "main_slim");
    public static final ModelLayerLocation LAYER_LOCATION_LATEX = new ModelLayerLocation(ChangedAddonMod.resourceLoc("snow_leopard_partial"), "latex");
    public static final ModelLayerLocation LAYER_LOCATION_LATEX_SLIM = new ModelLayerLocation(ChangedAddonMod.resourceLoc("snow_leopard_partial"), "latex_slim");
    private static final ModelPart NULL_PART = new ModelPart(List.of(), Map.of());
    private final ModelPart RightLeg;
    private final ModelPart LeftLeg;
    private final ModelPart RightArm;
    private final ModelPart LeftArm;
    private final ModelPart Head;
    private final ModelPart Torso;
    private final ModelPart Tail;
    private final ModelPart RightPants;
    private final ModelPart LeftPants;
    private final ModelPart RightSleeve;
    private final ModelPart LeftSleeve;
    private final ModelPart Hat;
    private final ModelPart Jacket;
    private final ModelPart RightLowerLeg;
    private final ModelPart LeftLowerLeg;
    private final ModelPart RightEar;
    private final ModelPart LeftEar;
    private final boolean latexLayer;
    private final HumanoidAnimator<SnowLeopardPartialEntity, SnowLeopardPartialModel> animator;

    public SnowLeopardPartialModel(ModelPart root, boolean latexLayer) {
        super(root);
        this.RightLeg = root.m_171324_("RightLeg");
        this.LeftLeg = root.m_171324_("LeftLeg");
        this.Head = root.m_171324_("Head");
        this.Torso = root.m_171324_("Torso");
        this.Tail = this.Torso.m_171324_("Tail");
        this.RightArm = root.m_171324_("RightArm");
        this.LeftArm = root.m_171324_("LeftArm");
        this.LeftEar = this.Head.m_171324_("LeftEar");
        this.RightEar = this.Head.m_171324_("RightEar");
        ModelPart tailPrimary = this.Tail.m_171324_("TailPrimary");
        ModelPart tailSecondary = tailPrimary.m_171324_("TailSecondary");
        ModelPart tailTertiary = tailSecondary.m_171324_("TailTertiary");
        ModelPart tailQuaternary = tailTertiary.m_171324_("TailQuaternary");
        ModelPart leftEar = this.Head.m_171324_("LeftEar");
        ModelPart rightEar = this.Head.m_171324_("RightEar");
        this.LeftLowerLeg = this.LeftLeg.m_171324_("LeftLowerLeg");
        ModelPart leftFoot = this.LeftLowerLeg.m_171324_("LeftFoot");
        ModelPart leftPad = leftFoot.m_171324_("LeftPad");
        this.RightLowerLeg = this.RightLeg.m_171324_("RightLowerLeg");
        ModelPart rightFoot = this.RightLowerLeg.m_171324_("RightFoot");
        ModelPart rightPad = rightFoot.m_171324_("RightPad");
        if (latexLayer) {
            this.RightPants = NULL_PART;
            this.LeftPants = NULL_PART;
            this.RightSleeve = NULL_PART;
            this.LeftSleeve = NULL_PART;
            this.Hat = NULL_PART;
            this.Jacket = NULL_PART;
        } else {
            this.RightPants = this.RightLeg.m_171324_("RightPants");
            this.LeftPants = this.LeftLeg.m_171324_("LeftPants");
            this.RightSleeve = this.RightArm.m_171324_("RightSleeve");
            this.LeftSleeve = this.LeftArm.m_171324_("LeftSleeve");
            this.Hat = this.Head.m_171324_("Hat");
            this.Jacket = this.Torso.m_171324_("Jacket");
        }
        this.latexLayer = latexLayer;
        this.animator = HumanoidAnimator.of((AdvancedHumanoidModel)this).hipOffset(-1.5f).addPreset(AnimatorPresets.catLike((ModelPart)this.Head, (ModelPart)leftEar, (ModelPart)rightEar, (ModelPart)this.Torso, (ModelPart)this.LeftArm, (ModelPart)this.RightArm, (ModelPart)this.Tail, List.of(tailPrimary, tailSecondary, tailTertiary, tailQuaternary), (ModelPart)this.LeftLeg, (ModelPart)this.LeftLowerLeg, (ModelPart)leftFoot, (ModelPart)leftPad, (ModelPart)this.RightLeg, (ModelPart)this.RightLowerLeg, (ModelPart)rightFoot, (ModelPart)rightPad));
    }

    public static SnowLeopardPartialModel human(ModelPart root) {
        return new SnowLeopardPartialModel(root, false);
    }

    public static SnowLeopardPartialModel latex(ModelPart root) {
        return new SnowLeopardPartialModel(root, true);
    }

    public static LayerDefinition createHumanLayer(boolean slim) {
        float armWidth = slim ? 3.0f : 4.0f;
        float rightArmOffset = slim ? 1.0f : 0.0f;
        CubeDeformation hatDeformation = new CubeDeformation(0.5f);
        CubeDeformation clothingDeformation = new CubeDeformation(0.25f);
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition RightLeg = partdefinition.m_171599_("RightLeg", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-2.5f, (float)10.5f, (float)0.0f));
        PartDefinition RightThigh_r1 = RightLeg.m_171599_("RightThigh_r1", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 7.0f, 4.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition RightPants = RightLeg.m_171599_("RightPants", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        CubeListBuilderExtender rightPantCubes = ((CubeListBuilderExtender)CubeListBuilder.m_171558_().m_171514_(0, 32).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 7.0f, 4.0f, clothingDeformation)).removeLastFaces(new Direction[]{Direction.DOWN});
        PartDefinition RightThighLayer_r1 = RightPants.m_171599_("RightThighLayer_r1", rightPantCubes.finish(), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition RightLowerLeg = RightLeg.m_171599_("RightLowerLeg", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)6.375f, (float)-3.45f));
        PartDefinition RightCalf_r1 = RightLowerLeg.m_171599_("RightCalf_r1", CubeListBuilder.m_171558_().m_171514_(28, 20).m_171488_(-1.99f, -0.125f, -2.9f, 4.0f, 6.0f, 4.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)0.0f, (float)-2.125f, (float)1.95f, (float)0.8727f, (float)0.0f, (float)0.0f));
        PartDefinition RightFoot = RightLowerLeg.m_171599_("RightFoot", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.8f, (float)7.175f));
        PartDefinition RightArch_r1 = RightFoot.m_171599_("RightArch_r1", CubeListBuilder.m_171558_().m_171514_(30, 40).m_171488_(-2.0f, -8.45f, -0.725f, 4.0f, 6.0f, 3.0f, new CubeDeformation(0.005f)), PartPose.m_171423_((float)0.0f, (float)7.075f, (float)-4.975f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition RightPad = RightFoot.m_171599_("RightPad", CubeListBuilder.m_171558_().m_171514_(32, 11).m_171488_(-2.0f, 0.0f, -2.5f, 4.0f, 2.0f, 5.0f, CubeDeformation.f_171458_), PartPose.m_171419_((float)0.0f, (float)4.325f, (float)-4.425f));
        PartDefinition LeftLeg = partdefinition.m_171599_("LeftLeg", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)2.5f, (float)10.5f, (float)0.0f));
        PartDefinition LeftThigh_r1 = LeftLeg.m_171599_("LeftThigh_r1", CubeListBuilder.m_171558_().m_171514_(16, 48).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 7.0f, 4.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition LeftPants = LeftLeg.m_171599_("LeftPants", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        CubeListBuilderExtender leftPantCubes = ((CubeListBuilderExtender)CubeListBuilder.m_171558_().m_171514_(0, 48).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 7.0f, 4.0f, clothingDeformation)).removeLastFaces(new Direction[]{Direction.DOWN});
        PartDefinition LeftThighLayer_r1 = LeftPants.m_171599_("LeftThighLayer_r1", leftPantCubes.finish(), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition LeftLowerLeg = LeftLeg.m_171599_("LeftLowerLeg", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)6.375f, (float)-3.45f));
        PartDefinition LeftCalf_r1 = LeftLowerLeg.m_171599_("LeftCalf_r1", CubeListBuilder.m_171558_().m_171514_(28, 30).m_171488_(-2.01f, -0.125f, -2.9f, 4.0f, 6.0f, 4.0f, CubeDeformation.f_171458_), PartPose.m_171423_((float)0.0f, (float)-2.125f, (float)1.95f, (float)0.8727f, (float)0.0f, (float)0.0f));
        PartDefinition LeftFoot = LeftLowerLeg.m_171599_("LeftFoot", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.8f, (float)7.175f));
        PartDefinition LeftArch_r1 = LeftFoot.m_171599_("LeftArch_r1", CubeListBuilder.m_171558_().m_171514_(0, 42).m_171488_(-2.0f, -8.45f, -0.725f, 4.0f, 6.0f, 3.0f, new CubeDeformation(0.005f)), PartPose.m_171423_((float)0.0f, (float)7.075f, (float)-4.975f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition LeftPad = LeftFoot.m_171599_("LeftPad", CubeListBuilder.m_171558_().m_171514_(0, 35).m_171488_(-2.0f, 0.0f, -2.5f, 4.0f, 2.0f, 5.0f, CubeDeformation.f_171458_), PartPose.m_171419_((float)0.0f, (float)4.325f, (float)-4.425f));
        PartDefinition Head = partdefinition.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, CubeDeformation.f_171458_), PartPose.m_171419_((float)0.0f, (float)-0.5f, (float)0.0f));
        PartDefinition Hat = Head.m_171599_("Hat", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, hatDeformation), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition RightEar = Head.m_171599_("RightEar", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-3.0f, (float)-7.5f, (float)0.0f));
        PartDefinition RightEarPivot = RightEar.m_171599_("RightEarPivot", CubeListBuilder.m_171558_().m_171514_(20, 4).m_171488_(-1.9f, -1.2f, -1.0f, 3.0f, 3.0f, 1.0f, new CubeDeformation(0.05f)).m_171514_(23, 0).m_171488_(-0.9f, -1.6f, -0.4f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.04f)).m_171514_(6, 28).m_171488_(-0.9f, -2.3f, -1.0f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.05f)).m_171514_(0, 0).m_171488_(0.1f, -3.1f, -1.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.05f)), PartPose.m_171423_((float)0.5f, (float)-1.25f, (float)0.0f, (float)-0.1309f, (float)0.5236f, (float)-0.3491f));
        PartDefinition LeftEar = Head.m_171599_("LeftEar", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)3.0f, (float)-7.5f, (float)0.0f));
        PartDefinition LeftEarPivot = LeftEar.m_171599_("LeftEarPivot", CubeListBuilder.m_171558_().m_171514_(15, 0).m_171488_(-1.1f, -1.2f, -1.0f, 3.0f, 3.0f, 1.0f, new CubeDeformation(0.05f)).m_171514_(0, 28).m_171488_(-1.1f, -1.6f, -0.4f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.04f)).m_171514_(6, 30).m_171488_(-1.1f, -2.3f, -1.0f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.05f)).m_171514_(0, 2).m_171488_(-1.1f, -3.1f, -1.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.05f)), PartPose.m_171423_((float)-0.5f, (float)-1.25f, (float)0.0f, (float)-0.1309f, (float)-0.5236f, (float)0.3491f));
        PartDefinition Torso = partdefinition.m_171599_("Torso", CubeListBuilder.m_171558_().m_171514_(16, 16).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, CubeDeformation.f_171458_), PartPose.m_171419_((float)0.0f, (float)-0.5f, (float)0.0f));
        PartDefinition Jacket = Torso.m_171599_("Jacket", CubeListBuilder.m_171558_().m_171514_(16, 32).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, clothingDeformation), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition Tail = Torso.m_171599_("Tail", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)10.5f, (float)0.0f));
        PartDefinition TailPrimary = Tail.m_171599_("TailPrimary", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition Base_r1 = TailPrimary.m_171599_("Base_r1", CubeListBuilder.m_171558_().m_171514_(14, 38).m_171488_(-2.0f, 0.75f, -1.5f, 4.0f, 5.0f, 4.0f, new CubeDeformation(-0.2f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)1.1781f, (float)0.0f, (float)0.0f));
        PartDefinition TailSecondary = TailPrimary.m_171599_("TailSecondary", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)1.25f, (float)4.5f));
        PartDefinition Base_r2 = TailSecondary.m_171599_("Base_r2", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.5f, -0.45f, -2.1f, 5.0f, 7.0f, 5.0f, new CubeDeformation(-0.1f)), PartPose.m_171423_((float)0.0f, (float)0.5f, (float)0.0f, (float)1.4835f, (float)0.0f, (float)0.0f));
        PartDefinition TailTertiary = TailSecondary.m_171599_("TailTertiary", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.75f, (float)2.5f));
        PartDefinition Base_r3 = TailTertiary.m_171599_("Base_r3", CubeListBuilder.m_171558_().m_171514_(40, 26).m_171488_(-2.0f, -1.2f, -1.95f, 4.0f, 4.0f, 4.0f, new CubeDeformation(-0.15f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)4.0f, (float)1.8326f, (float)0.0f, (float)0.0f));
        PartDefinition TailQuaternary = TailTertiary.m_171599_("TailQuaternary", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)7.5f));
        PartDefinition Base_r4 = TailQuaternary.m_171599_("Base_r4", CubeListBuilder.m_171558_().m_171514_(43, 28).m_171488_(-2.0f, 5.5f, -3.8f, 4.0f, 3.0f, 4.0f, new CubeDeformation(0.15f)), PartPose.m_171423_((float)0.0f, (float)-1.0f, (float)-5.5f, (float)1.7017f, (float)0.0f, (float)0.0f));
        PartDefinition RightArm = partdefinition.m_171599_("RightArm", CubeListBuilder.m_171558_().m_171514_(40, 16).m_171488_(-3.0f + rightArmOffset, -2.0f, -2.0f, armWidth, 12.0f, 4.0f, CubeDeformation.f_171458_), PartPose.m_171419_((float)-5.0f, (float)1.5f, (float)0.0f));
        CubeListBuilderExtender rightSleeveCube = ((CubeListBuilderExtender)CubeListBuilder.m_171558_().m_171514_(40, 32).m_171488_(-3.0f + rightArmOffset, -2.0f, -2.0f, armWidth, 9.0f, 4.0f, clothingDeformation)).removeLastFaces(new Direction[]{Direction.DOWN});
        PartDefinition RightSleeve = RightArm.m_171599_("RightSleeve", rightSleeveCube.finish(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition LeftArm = partdefinition.m_171599_("LeftArm", CubeListBuilder.m_171558_().m_171514_(32, 48).m_171488_(-1.0f, -2.0f, -2.0f, armWidth, 12.0f, 4.0f, CubeDeformation.f_171458_), PartPose.m_171419_((float)5.0f, (float)1.5f, (float)0.0f));
        CubeListBuilderExtender leftSleeveCube = ((CubeListBuilderExtender)CubeListBuilder.m_171558_().m_171514_(48, 48).m_171488_(-1.0f, -2.0f, -2.0f, armWidth, 9.0f, 4.0f, clothingDeformation)).removeLastFaces(new Direction[]{Direction.DOWN});
        PartDefinition LeftSleeve = LeftArm.m_171599_("LeftSleeve", leftSleeveCube.finish(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public static LayerDefinition createLatexLayer(boolean slim) {
        float armWidth = slim ? 3.0f : 4.0f;
        float rightArmOffset = slim ? 1.0f : 0.0f;
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition RightLeg = partdefinition.m_171599_("RightLeg", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-2.5f, (float)10.5f, (float)0.0f));
        PartDefinition RightThigh_r1 = RightLeg.m_171599_("RightThigh_r1", CubeListBuilder.m_171558_().m_171514_(28, 0).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.0025f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition RightLowerLeg = RightLeg.m_171599_("RightLowerLeg", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)6.375f, (float)-3.45f));
        PartDefinition RightCalf_r1 = RightLowerLeg.m_171599_("RightCalf_r1", CubeListBuilder.m_171558_().m_171514_(32, 11).m_171488_(-1.99f, -0.125f, -2.9f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0025f)), PartPose.m_171423_((float)0.0f, (float)-2.125f, (float)1.95f, (float)0.8727f, (float)0.0f, (float)0.0f));
        PartDefinition RightFoot = RightLowerLeg.m_171599_("RightFoot", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.8f, (float)7.175f));
        PartDefinition RightArch_r1 = RightFoot.m_171599_("RightArch_r1", CubeListBuilder.m_171558_().m_171514_(44, 0).m_171488_(-2.0f, -8.45f, -0.725f, 4.0f, 6.0f, 3.0f, new CubeDeformation(0.005f)), PartPose.m_171423_((float)0.0f, (float)7.075f, (float)-4.975f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition RightPad = RightFoot.m_171599_("RightPad", CubeListBuilder.m_171558_().m_171514_(38, 37).m_171488_(-2.0f, 0.0f, -2.5f, 4.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)4.325f, (float)-4.425f));
        PartDefinition LeftLeg = partdefinition.m_171599_("LeftLeg", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)2.5f, (float)10.5f, (float)0.0f));
        PartDefinition LeftThigh_r1 = LeftLeg.m_171599_("LeftThigh_r1", CubeListBuilder.m_171558_().m_171514_(31, 21).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.0025f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition LeftLowerLeg = LeftLeg.m_171599_("LeftLowerLeg", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)6.375f, (float)-3.45f));
        PartDefinition LeftCalf_r1 = LeftLowerLeg.m_171599_("LeftCalf_r1", CubeListBuilder.m_171558_().m_171514_(27, 32).m_171488_(-2.01f, -0.125f, -2.9f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0025f)), PartPose.m_171423_((float)0.0f, (float)-2.125f, (float)1.95f, (float)0.8727f, (float)0.0f, (float)0.0f));
        PartDefinition LeftFoot = LeftLowerLeg.m_171599_("LeftFoot", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.8f, (float)7.175f));
        PartDefinition LeftArch_r1 = LeftFoot.m_171599_("LeftArch_r1", CubeListBuilder.m_171558_().m_171514_(26, 44).m_171488_(-2.0f, -8.45f, -0.725f, 4.0f, 6.0f, 3.0f, new CubeDeformation(0.005f)), PartPose.m_171423_((float)0.0f, (float)7.075f, (float)-4.975f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition LeftPad = LeftFoot.m_171599_("LeftPad", CubeListBuilder.m_171558_().m_171514_(11, 40).m_171488_(-2.0f, 0.0f, -2.5f, 4.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)4.325f, (float)-4.425f));
        PartDefinition Head = partdefinition.m_171599_("Head", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-0.5f, (float)0.0f));
        PartDefinition LeftEar = Head.m_171599_("LeftEar", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)2.5f, (float)-5.0f, (float)0.0f));
        PartDefinition leftear_r1 = LeftEar.m_171599_("leftear_r1", CubeListBuilder.m_171558_().m_171514_(40, 44).m_171488_(-7.75f, -34.75f, -1.0f, 2.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.5f, (float)30.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3054f));
        PartDefinition RightEar = Head.m_171599_("RightEar", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-2.5f, (float)-5.0f, (float)0.0f));
        PartDefinition rightear_r1 = RightEar.m_171599_("rightear_r1", CubeListBuilder.m_171558_().m_171514_(0, 29).m_171488_(5.75f, -34.75f, -1.0f, 2.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.5f, (float)30.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3054f));
        PartDefinition Torso = partdefinition.m_171599_("Torso", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-0.5f, (float)0.0f));
        PartDefinition Tail = Torso.m_171599_("Tail", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)10.5f, (float)0.0f));
        PartDefinition TailPrimary = Tail.m_171599_("TailPrimary", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition Base_r1 = TailPrimary.m_171599_("Base_r1", CubeListBuilder.m_171558_().m_171514_(0, 36).m_171488_(-2.0f, 0.75f, -1.5f, 4.0f, 5.0f, 4.0f, new CubeDeformation(-0.2f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0908f, (float)0.0f, (float)0.0f));
        PartDefinition TailSecondary = TailPrimary.m_171599_("TailSecondary", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)1.25f, (float)4.5f));
        PartDefinition Base_r2 = TailSecondary.m_171599_("Base_r2", CubeListBuilder.m_171558_().m_171514_(11, 25).m_171488_(-2.5f, -0.45f, -2.5f, 5.0f, 6.0f, 5.0f, new CubeDeformation(-0.3f)), PartPose.m_171423_((float)0.0f, (float)0.5f, (float)0.0f, (float)1.3526f, (float)0.0f, (float)0.0f));
        PartDefinition TailTertiary = TailSecondary.m_171599_("TailTertiary", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.75f, (float)4.5f));
        PartDefinition Base_r3 = TailTertiary.m_171599_("Base_r3", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.5f, 4.55f, -3.3f, 5.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-0.25f, (float)-4.5f, (float)1.5272f, (float)0.0f, (float)0.0f));
        PartDefinition TailQuaternary = TailTertiary.m_171599_("TailQuaternary", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)7.5f));
        PartDefinition Base_r4 = TailQuaternary.m_171599_("Base_r4", CubeListBuilder.m_171558_().m_171514_(43, 28).m_171488_(-2.0f, 5.5f, -3.8f, 4.0f, 3.0f, 4.0f, new CubeDeformation(0.15f)), PartPose.m_171423_((float)0.0f, (float)-1.0f, (float)-5.5f, (float)1.7017f, (float)0.0f, (float)0.0f));
        PartDefinition RightArm = slim ? partdefinition.m_171599_("RightArm", CubeListBuilder.m_171558_().m_171514_(17, 9).m_171488_(-2.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, new CubeDeformation(0.001f)), PartPose.m_171419_((float)-5.0f, (float)1.5f, (float)0.0f)) : partdefinition.m_171599_("RightArm", CubeListBuilder.m_171558_().m_171514_(16, 9).m_171488_(-3.0f + rightArmOffset, -2.0f, -2.0f, armWidth, 12.0f, 4.0f, new CubeDeformation(0.001f)), PartPose.m_171419_((float)-5.0f, (float)1.5f, (float)0.0f));
        PartDefinition LeftArm = slim ? partdefinition.m_171599_("LeftArm", CubeListBuilder.m_171558_().m_171514_(0, 13).m_171488_(-1.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, new CubeDeformation(0.001f)), PartPose.m_171419_((float)5.0f, (float)1.5f, (float)0.0f)) : partdefinition.m_171599_("LeftArm", CubeListBuilder.m_171558_().m_171514_(0, 13).m_171488_(-1.0f, -2.0f, -2.0f, armWidth, 12.0f, 4.0f, new CubeDeformation(0.001f)), PartPose.m_171419_((float)5.0f, (float)1.5f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void defaultModelProperties() {
        this.Hat.f_104207_ = true;
        this.Jacket.f_104207_ = true;
        this.LeftPants.f_104207_ = true;
        this.RightPants.f_104207_ = true;
        this.LeftSleeve.f_104207_ = true;
        this.RightSleeve.f_104207_ = true;
    }

    public void setModelProperties(AbstractClientPlayer player) {
        this.Hat.f_104207_ = player.m_36170_(PlayerModelPart.HAT);
        this.Jacket.f_104207_ = player.m_36170_(PlayerModelPart.JACKET);
        this.LeftPants.f_104207_ = player.m_36170_(PlayerModelPart.LEFT_PANTS_LEG);
        this.RightPants.f_104207_ = player.m_36170_(PlayerModelPart.RIGHT_PANTS_LEG);
        this.LeftSleeve.f_104207_ = player.m_36170_(PlayerModelPart.LEFT_SLEEVE);
        this.RightSleeve.f_104207_ = player.m_36170_(PlayerModelPart.RIGHT_SLEEVE);
    }

    public void prepareMobModel(@NotNull SnowLeopardPartialEntity p_102861_, float p_102862_, float p_102863_, float p_102864_) {
        this.prepareMobModel(this.animator, (ChangedEntity)p_102861_, p_102862_, p_102863_, p_102864_);
        if (!this.latexLayer) {
            this.Tail.f_104207_ = false;
            this.LeftLowerLeg.f_104207_ = false;
            this.RightLowerLeg.f_104207_ = false;
            this.LeftEar.f_104207_ = false;
            this.RightEar.f_104207_ = false;
        }
    }

    public void setupHand(SnowLeopardPartialEntity entity) {
        this.animator.setupHand();
    }

    public void setupAnim(@NotNull SnowLeopardPartialEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.animator.setupAnim((ChangedEntity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        super.setupAnim((ChangedEntity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
    }

    @NotNull
    public ModelPart m_102851_(HumanoidArm arm) {
        return arm == HumanoidArm.LEFT ? this.LeftArm : this.RightArm;
    }

    @NotNull
    public ModelPart m_5585_() {
        return this.Head;
    }

    public ModelPart getTorso() {
        return this.Torso;
    }

    public ModelPart getLeg(HumanoidArm humanoidArm) {
        return humanoidArm == HumanoidArm.LEFT ? this.LeftLeg : this.RightLeg;
    }

    public void m_7695_(@NotNull PoseStack poseStack, @NotNull VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.RightLeg.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.LeftLeg.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.Head.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.Torso.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.RightArm.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.LeftArm.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public HumanoidAnimator<SnowLeopardPartialEntity, SnowLeopardPartialModel> getAnimator(SnowLeopardPartialEntity entity) {
        return this.animator;
    }

    public static class PartialModelAnimation {
        public static <T extends ChangedEntity, M extends AdvancedHumanoidModel<T>> Consumer<HumanoidAnimator<T, M>> Partial(ModelPart head, ModelPart leftEar, ModelPart rightEar, ModelPart torso, ModelPart leftArm, ModelPart rightArm, ModelPart tail, List<ModelPart> tailJoints, ModelPart leftLeg, ModelPart leftLegLower, ModelPart leftFoot, ModelPart leftPad, ModelPart rightLeg, ModelPart rightLegLower, ModelPart rightFoot, ModelPart rightPad) {
            return animator -> animator.addPreset(AnimatorPresets.wolfBipedal((ModelPart)leftLeg, (ModelPart)leftLegLower, (ModelPart)leftFoot, (ModelPart)leftPad, (ModelPart)rightLeg, (ModelPart)rightLegLower, (ModelPart)rightFoot, (ModelPart)rightPad)).addPreset(AnimatorPresets.wolfUpperBody((ModelPart)head, (ModelPart)torso, (ModelPart)leftArm, (ModelPart)rightArm)).addPreset(AnimatorPresets.catTail((ModelPart)tail, (List)tailJoints)).addPreset(AnimatorPresets.wolfEars((ModelPart)leftEar, (ModelPart)rightEar)).addAnimator((HumanoidAnimator.Animator)new WolfHeadInitAnimator(head)).addAnimator((HumanoidAnimator.Animator)new ArmSwimAnimator(leftArm, rightArm)).addAnimator((HumanoidAnimator.Animator)new ArmBobAnimator(leftArm, rightArm)).addAnimator((HumanoidAnimator.Animator)new ArmRideAnimator(leftArm, rightArm));
        }
    }
}

