/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.client.model.armors;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.foxyas.changedaddon.ChangedAddonMod;
import net.ltxprogrammer.changed.client.renderer.animate.AnimatorPresets;
import net.ltxprogrammer.changed.client.renderer.animate.HumanoidAnimator;
import net.ltxprogrammer.changed.client.renderer.model.AdvancedHumanoidModel;
import net.ltxprogrammer.changed.client.renderer.model.armor.ArmorModel;
import net.ltxprogrammer.changed.client.renderer.model.armor.ArmorModelSet;
import net.ltxprogrammer.changed.client.renderer.model.armor.LatexHumanoidArmorModel;
import net.ltxprogrammer.changed.entity.ChangedEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ArmorLatexDazedModel<T extends ChangedEntity>
extends LatexHumanoidArmorModel<T, ArmorLatexDazedModel<T>> {
    public static final ArmorModelSet<ChangedEntity, ArmorLatexDazedModel<ChangedEntity>> MODEL_SET = ArmorModelSet.of((ResourceLocation)ChangedAddonMod.resourceLoc("armor_latex_wolf_male_unified"), ArmorLatexDazedModel::createArmorLayer, ArmorLatexDazedModel::new);
    private final ModelPart Head;
    private final ModelPart Torso;
    private final ModelPart LeftLeg;
    private final ModelPart RightLeg;
    private final ModelPart LeftArm;
    private final ModelPart RightArm;
    private final HumanoidAnimator<T, ArmorLatexDazedModel<T>> animator;

    public ArmorLatexDazedModel(ModelPart modelPart, ArmorModel model) {
        super(modelPart, model);
        this.Head = modelPart.m_171324_("Head");
        this.Torso = modelPart.m_171324_("Torso");
        this.LeftLeg = modelPart.m_171324_("LeftLeg");
        this.RightLeg = modelPart.m_171324_("RightLeg");
        this.LeftArm = modelPart.m_171324_("LeftArm");
        this.RightArm = modelPart.m_171324_("RightArm");
        ModelPart leftLowerLeg = this.LeftLeg.m_171324_("LeftLowerLeg");
        ModelPart leftFoot = leftLowerLeg.m_171324_("LeftFoot");
        ModelPart rightLowerLeg = this.RightLeg.m_171324_("RightLowerLeg");
        ModelPart rightFoot = rightLowerLeg.m_171324_("RightFoot");
        this.animator = HumanoidAnimator.of((AdvancedHumanoidModel)this).hipOffset(-1.5f).addPreset(AnimatorPresets.wolfLikeArmor((ModelPart)this.Head, (ModelPart)this.Torso, (ModelPart)this.LeftArm, (ModelPart)this.RightArm, (ModelPart)this.LeftLeg, (ModelPart)leftLowerLeg, (ModelPart)leftFoot, (ModelPart)leftFoot.m_171324_("LeftPad"), (ModelPart)this.RightLeg, (ModelPart)rightLowerLeg, (ModelPart)rightFoot, (ModelPart)rightFoot.m_171324_("RightPad")));
    }

    public static LayerDefinition createArmorLayer(ArmorModel layer) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        ArmorLatexDazedModel.addUnifiedLegs((PartDefinition)partdefinition, (ArmorModel)layer);
        partdefinition.m_171599_("Torso", CubeListBuilder.m_171558_().m_171514_(16, 16).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, layer.dualDeformation), PartPose.m_171419_((float)0.0f, (float)-0.5f, (float)0.0f));
        partdefinition.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, layer.dualDeformation), PartPose.m_171419_((float)0.0f, (float)-0.5f, (float)0.0f));
        partdefinition.m_171599_("RightArm", CubeListBuilder.m_171558_().m_171514_(40, 16).m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, layer.dualDeformation), PartPose.m_171419_((float)-5.0f, (float)1.5f, (float)0.0f));
        partdefinition.m_171599_("LeftArm", CubeListBuilder.m_171558_().m_171514_(40, 16).m_171480_().m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, layer.dualDeformation).m_171555_(false), PartPose.m_171419_((float)5.0f, (float)1.5f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void prepareVisibility(EquipmentSlot armorSlot, ItemStack item) {
        super.prepareVisibility(armorSlot, item);
        if (armorSlot == EquipmentSlot.LEGS) {
            ArmorLatexDazedModel.prepareUnifiedLegsForArmor((ItemStack)item, (ModelPart)this.LeftLeg, (ModelPart)this.RightLeg);
        }
    }

    public void unprepareVisibility(EquipmentSlot armorSlot, ItemStack item) {
        super.unprepareVisibility(armorSlot, item);
        if (armorSlot == EquipmentSlot.LEGS) {
            ArmorLatexDazedModel.prepareUnifiedLegsForArmor((ItemStack)item, (ModelPart)this.LeftLeg, (ModelPart)this.RightLeg);
        }
    }

    public void prepareMobModel(HumanoidAnimator<T, ? extends EntityModel<T>> animator, T entity, float p_102862_, float p_102863_, float partialTicks) {
        super.prepareMobModel(animator, entity, p_102862_, p_102863_, partialTicks);
    }

    public void setAllLimbsVisible(T entity, boolean visible) {
        super.setAllLimbsVisible(entity, visible);
    }

    public void setupAnim(@NotNull T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
    }

    public void renderForSlot(T entity, RenderLayerParent<? super T, ?> parent, ItemStack stack, EquipmentSlot slot, PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        poseStack.m_85836_();
        this.scaleForSlot(parent, slot, poseStack);
        switch (slot) {
            case HEAD: {
                this.Head.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
                break;
            }
            case CHEST: {
                this.Torso.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
                this.LeftArm.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
                this.RightArm.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
                break;
            }
            case LEGS: {
                this.Torso.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
                this.LeftLeg.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
                this.RightLeg.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
                break;
            }
            case FEET: {
                this.LeftLeg.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
                this.RightLeg.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
            }
        }
        poseStack.m_85849_();
    }

    public HumanoidAnimator<T, ArmorLatexDazedModel<T>> getAnimator(T entity) {
        return this.animator;
    }

    public ModelPart m_102851_(HumanoidArm arm) {
        return arm == HumanoidArm.LEFT ? this.LeftArm : this.RightArm;
    }

    public ModelPart getLeg(HumanoidArm leg) {
        return leg == HumanoidArm.LEFT ? this.LeftLeg : this.RightLeg;
    }

    public ModelPart m_5585_() {
        return this.Head;
    }

    public ModelPart getTorso() {
        return this.Torso;
    }
}

