/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.client.renderer.advanced;

import com.mojang.blaze3d.vertex.PoseStack;
import net.foxyas.changedaddon.ChangedAddonMod;
import net.foxyas.changedaddon.client.model.LatexDazedModel;
import net.foxyas.changedaddon.client.model.armors.ArmorLatexDazedModel;
import net.foxyas.changedaddon.entity.advanced.DazedLatexEntity;
import net.ltxprogrammer.changed.client.renderer.AdvancedHumanoidRenderer;
import net.ltxprogrammer.changed.client.renderer.layers.CustomEyesLayer;
import net.ltxprogrammer.changed.client.renderer.layers.GasMaskLayer;
import net.ltxprogrammer.changed.client.renderer.layers.LatexParticlesLayer;
import net.ltxprogrammer.changed.client.renderer.layers.TransfurCapeLayer;
import net.ltxprogrammer.changed.client.renderer.model.AdvancedHumanoidModel;
import net.ltxprogrammer.changed.client.renderer.model.armor.ArmorLatexMaleWolfModel;
import net.ltxprogrammer.changed.entity.ChangedEntity;
import net.ltxprogrammer.changed.util.Color3;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class LatexDazedRenderer
extends AdvancedHumanoidRenderer<DazedLatexEntity, LatexDazedModel, ArmorLatexDazedModel<DazedLatexEntity>> {
    public LatexDazedRenderer(EntityRendererProvider.Context context) {
        super(context, (AdvancedHumanoidModel)new LatexDazedModel(context.m_174023_(LatexDazedModel.LAYER_LOCATION)), ArmorLatexMaleWolfModel.MODEL_SET, 0.5f);
        this.m_115326_((RenderLayer)new LatexParticlesLayer((RenderLayerParent)this, (AdvancedHumanoidModel)((LatexDazedModel)this.m_7200_()), ((LatexDazedModel)this.f_115290_)::isPartNotPuddle));
        this.m_115326_(new ConditionalCustomEyesLayer(this, new CustomEyesLayer((RenderLayerParent)this, context.m_174027_(), CustomEyesLayer.fixedColor((Color3)Color3.DARK), CustomEyesLayer::glowingIrisColorLeft, CustomEyesLayer::glowingIrisColorRight, CustomEyesLayer::noRender, CustomEyesLayer::noRender)));
        this.m_115326_(new ConditionalCustomLayers(this, TransfurCapeLayer.normalCape((RenderLayerParent)this, (EntityModelSet)context.m_174027_()), GasMaskLayer.forSnouted((RenderLayerParent)this, (EntityModelSet)context.m_174027_()), new LatexParticlesLayer((RenderLayerParent)this, (AdvancedHumanoidModel)((LatexDazedModel)this.m_7200_()), ((LatexDazedModel)this.f_115290_)::isPartNotPuddle)));
    }

    public void render(@NotNull DazedLatexEntity entity, float yRot, float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight) {
        super.render((ChangedEntity)entity, yRot, partialTicks, poseStack, bufferSource, packedLight);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull DazedLatexEntity entity) {
        if (entity.isMorphed()) {
            return ChangedAddonMod.textureLoc("textures/entities/dazed_creature_puddle");
        }
        return ChangedAddonMod.textureLoc("textures/entities/dazed_creature");
    }

    public boolean shouldRenderArmor(DazedLatexEntity entity) {
        return !entity.isMorphed();
    }

    public static class ConditionalCustomEyesLayer<M extends AdvancedHumanoidModel<T>, T extends ChangedEntity>
    extends RenderLayer<T, M> {
        private final CustomEyesLayer<M, T> customEyesLayer;

        public ConditionalCustomEyesLayer(RenderLayerParent<T, M> parent, CustomEyesLayer<M, T> customEyesLayer) {
            super(parent);
            this.customEyesLayer = customEyesLayer;
        }

        public void render(@NotNull PoseStack pose, @NotNull MultiBufferSource bufferSource, int packedLight, @NotNull T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            DazedLatexEntity dazedLatexEntity;
            if (entity instanceof DazedLatexEntity && !(dazedLatexEntity = (DazedLatexEntity)((Object)entity)).isMorphed()) {
                this.customEyesLayer.render(pose, bufferSource, packedLight, entity, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
            }
        }
    }

    public static class ConditionalCustomLayers<M extends AdvancedHumanoidModel<T>, T extends ChangedEntity>
    extends RenderLayer<T, M> {
        private final TransfurCapeLayer<T, M> transfurCapeLayer;
        private final GasMaskLayer<T, M> gasMaskLayer;
        private final LatexParticlesLayer<T, M> latexParticlesLayer;

        public ConditionalCustomLayers(RenderLayerParent<T, M> parent, TransfurCapeLayer<T, M> transfurCapeLayer, GasMaskLayer<T, M> gasMaskLayer, LatexParticlesLayer<T, M> latexParticlesLayer) {
            super(parent);
            this.transfurCapeLayer = transfurCapeLayer;
            this.gasMaskLayer = gasMaskLayer;
            this.latexParticlesLayer = latexParticlesLayer;
        }

        public void render(@NotNull PoseStack pose, @NotNull MultiBufferSource bufferSource, int packedLight, @NotNull T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            DazedLatexEntity dazedLatexEntity;
            if (entity instanceof DazedLatexEntity && !(dazedLatexEntity = (DazedLatexEntity)((Object)entity)).isMorphed()) {
                this.transfurCapeLayer.render(pose, bufferSource, packedLight, entity, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
                this.gasMaskLayer.render(pose, bufferSource, packedLight, entity, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
                this.latexParticlesLayer.render(pose, bufferSource, packedLight, entity, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
            }
        }
    }
}

