/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.client.renderer.items;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.ltxprogrammer.changed.client.FormRenderHandler;
import net.ltxprogrammer.changed.client.renderer.AdvancedHumanoidRenderer;
import net.ltxprogrammer.changed.client.renderer.accessory.AccessoryRenderer;
import net.ltxprogrammer.changed.client.renderer.accessory.TransitionalAccessory;
import net.ltxprogrammer.changed.client.renderer.layers.LatexHumanoidArmorLayer;
import net.ltxprogrammer.changed.client.renderer.model.AdvancedHumanoidModel;
import net.ltxprogrammer.changed.client.renderer.model.AdvancedHumanoidModelInterface;
import net.ltxprogrammer.changed.client.renderer.model.armor.ArmorHumanModel;
import net.ltxprogrammer.changed.client.renderer.model.armor.ArmorModel;
import net.ltxprogrammer.changed.client.renderer.model.armor.LatexHumanoidArmorModel;
import net.ltxprogrammer.changed.data.AccessorySlotContext;
import net.ltxprogrammer.changed.entity.ChangedEntity;
import net.ltxprogrammer.changed.item.Clothing;
import net.ltxprogrammer.changed.util.EntityUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class SimpleColorfulClothingRenderer
implements AccessoryRenderer,
TransitionalAccessory {
    protected final HumanoidModel clothingModel;
    protected final Set<ModelComponent> components;

    public SimpleColorfulClothingRenderer(ArmorModel humanoid, Set<ModelComponent> components) {
        this.components = components;
        this.clothingModel = new HumanoidModel(Minecraft.m_91087_().m_167973_().m_171103_(ArmorHumanModel.MODEL_SET.getModelName(humanoid)));
    }

    public static Supplier<AccessoryRenderer> of(ArmorModel armorModel, EquipmentSlot renderAs) {
        return () -> new SimpleColorfulClothingRenderer(armorModel, Set.of(new ModelComponent(armorModel, renderAs)));
    }

    public static Supplier<AccessoryRenderer> of(ArmorModel humanoidModel, Set<ModelComponent> components) {
        return () -> new SimpleColorfulClothingRenderer(humanoidModel, components);
    }

    public Optional<HumanoidModel<?>> getBeforeModel(AccessorySlotContext<?> slotContext, RenderLayerParent<?, ?> renderLayerParent) {
        return Optional.of(this.clothingModel);
    }

    public Stream<AdvancedHumanoidModel<?>> getAfterModels(AccessorySlotContext<?> slotContext, RenderLayerParent<?, ?> renderLayerParent) {
        if (renderLayerParent instanceof AdvancedHumanoidRenderer) {
            AdvancedHumanoidRenderer advancedHumanoidRenderer = (AdvancedHumanoidRenderer)renderLayerParent;
            LivingEntity var5 = EntityUtil.maybeGetOverlaying((LivingEntity)slotContext.wearer());
            if (var5 instanceof ChangedEntity) {
                ChangedEntity wearer = (ChangedEntity)var5;
                LatexHumanoidArmorLayer layer = advancedHumanoidRenderer.getArmorLayer();
                return this.components.stream().map(component -> Optional.of((LatexHumanoidArmorModel)layer.modelPicker.getModelSetForSlot(wearer, component.renderAs).get(component.armorModel))).filter(Optional::isPresent).map(Optional::get);
            }
        }
        return Stream.empty();
    }

    public Optional<ResourceLocation> getModelTexture(AccessorySlotContext<?> slotContext) {
        Item var3 = slotContext.stack().m_41720_();
        if (var3 instanceof Clothing) {
            Clothing clothing = (Clothing)var3;
            return Optional.ofNullable(clothing.getTexture(slotContext.stack(), (Entity)slotContext.wearer()));
        }
        return Optional.empty();
    }

    public <T extends LivingEntity, M extends EntityModel<T>> void render(AccessorySlotContext<T> slotContext, PoseStack matrixStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource renderTypeBuffer, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack stack = slotContext.stack();
        Item var14 = stack.m_41720_();
        if (var14 instanceof Clothing) {
            EntityModel layer;
            LivingEntity entity;
            ResourceLocation texture;
            Clothing clothing = (Clothing)var14;
            Color color = Color.WHITE;
            if (clothing instanceof DyeableLeatherItem) {
                DyeableLeatherItem dyeableLeatherItem = (DyeableLeatherItem)clothing;
                color = new Color(dyeableLeatherItem.m_41121_(stack));
            }
            if ((texture = clothing.getTexture(stack, (Entity)(entity = slotContext.wearer()))) == null) {
                return;
            }
            if (entity instanceof ChangedEntity) {
                ChangedEntity changedEntity = (ChangedEntity)entity;
                if (renderLayerParent instanceof AdvancedHumanoidRenderer) {
                    AdvancedHumanoidRenderer advancedHumanoidRenderer = (AdvancedHumanoidRenderer)renderLayerParent;
                    LatexHumanoidArmorLayer layer2 = advancedHumanoidRenderer.getArmorLayer();
                    for (ModelComponent component : this.components) {
                        LatexHumanoidArmorModel model = (LatexHumanoidArmorModel)layer2.modelPicker.getModelSetForSlot(changedEntity, component.renderAs).get(component.armorModel);
                        AdvancedHumanoidModel var24 = advancedHumanoidRenderer.getModel(changedEntity);
                        if (var24 instanceof AdvancedHumanoidModelInterface) {
                            AdvancedHumanoidModelInterface advancedModel = (AdvancedHumanoidModelInterface)var24;
                            model.getAnimator(changedEntity).copyProperties(advancedModel.getAnimator(changedEntity));
                        }
                        model.prepareMobModel(changedEntity, limbSwing, limbSwingAmount, partialTicks);
                        model.setupAnim(changedEntity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
                        model.prepareVisibility(component.renderAs, stack);
                        model.renderForSlot(changedEntity, (RenderLayerParent)advancedHumanoidRenderer, stack, component.renderAs, matrixStack, ItemRenderer.m_115184_((MultiBufferSource)renderTypeBuffer, (RenderType)RenderType.m_110431_((ResourceLocation)texture), (boolean)false, (boolean)stack.m_41790_()), light, OverlayTexture.f_118083_, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f);
                        model.unprepareVisibility(component.renderAs, stack);
                    }
                    return;
                }
            }
            if ((layer = renderLayerParent.m_7200_()) instanceof HumanoidModel) {
                HumanoidModel baseModel = (HumanoidModel)layer;
                baseModel.m_102872_(this.clothingModel);
                this.clothingModel.m_7695_(matrixStack, ItemRenderer.m_115184_((MultiBufferSource)renderTypeBuffer, (RenderType)RenderType.m_110431_((ResourceLocation)texture), (boolean)false, (boolean)stack.m_41790_()), light, OverlayTexture.f_118083_, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f);
            }
        }
    }

    public <T extends LivingEntity, M extends EntityModel<T>> void renderFirstPersonOnArms(AccessorySlotContext<T> slotContext, PoseStack poseStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource renderTypeBuffer, int light, HumanoidArm arm, PartPose armPose, PoseStack stackCorrector, float partialTicks) {
        ItemStack stack = slotContext.stack();
        Item var11 = stack.m_41720_();
        if (var11 instanceof Clothing) {
            EntityModel layer;
            LivingEntity entity;
            ResourceLocation texture;
            Clothing clothing = (Clothing)var11;
            Color color = Color.WHITE;
            if (clothing instanceof DyeableLeatherItem) {
                DyeableLeatherItem dyeableLeatherItem = (DyeableLeatherItem)clothing;
                color = new Color(dyeableLeatherItem.m_41121_(stack));
            }
            if ((texture = clothing.getTexture(stack, (Entity)(entity = slotContext.wearer()))) == null) {
                return;
            }
            if (entity instanceof ChangedEntity) {
                ChangedEntity changedEntity = (ChangedEntity)entity;
                if (renderLayerParent instanceof AdvancedHumanoidRenderer) {
                    AdvancedHumanoidRenderer advancedHumanoidRenderer = (AdvancedHumanoidRenderer)renderLayerParent;
                    LatexHumanoidArmorLayer layer2 = advancedHumanoidRenderer.getArmorLayer();
                    for (ModelComponent component : this.components) {
                        if (component.renderAs != EquipmentSlot.CHEST) continue;
                        LatexHumanoidArmorModel model = (LatexHumanoidArmorModel)layer2.modelPicker.getModelSetForSlot(changedEntity, component.renderAs).get(component.armorModel);
                        model.prepareMobModel(changedEntity, 0.0f, 0.0f, partialTicks);
                        model.prepareVisibility(component.renderAs, stack);
                        ModelPart armPart = model.m_102851_(arm);
                        armPart.m_171322_(armPose);
                        FormRenderHandler.renderModelPartWithTexture((ModelPart)model.m_102851_(arm), (PoseStack)stackCorrector, (PoseStack)poseStack, (VertexConsumer)ItemRenderer.m_115184_((MultiBufferSource)renderTypeBuffer, (RenderType)RenderType.m_110431_((ResourceLocation)texture), (boolean)false, (boolean)stack.m_41790_()), (int)light, (float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)1.0f);
                        model.unprepareVisibility(component.renderAs, stack);
                    }
                    return;
                }
            }
            if ((layer = renderLayerParent.m_7200_()) instanceof HumanoidModel) {
                HumanoidModel baseModel = (HumanoidModel)layer;
                baseModel.m_102872_(this.clothingModel);
                ModelPart armPart = arm == HumanoidArm.RIGHT ? this.clothingModel.f_102811_ : this.clothingModel.f_102812_;
                armPart.m_171322_(armPose);
                FormRenderHandler.renderVanillaModelPartWithTexture((ModelPart)armPart, (PoseStack)stackCorrector, (PoseStack)poseStack, (VertexConsumer)ItemRenderer.m_115184_((MultiBufferSource)renderTypeBuffer, (RenderType)RenderType.m_110431_((ResourceLocation)texture), (boolean)false, (boolean)stack.m_41790_()), (int)light, (float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)1.0f);
            }
        }
    }

    public record ModelComponent(ArmorModel armorModel, EquipmentSlot renderAs) {
    }
}

