/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.client.renderer.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.foxyas.changedaddon.entity.advanced.AvaliEntity;
import net.ltxprogrammer.changed.client.FormRenderHandler;
import net.ltxprogrammer.changed.client.renderer.layers.FirstPersonLayer;
import net.ltxprogrammer.changed.client.renderer.model.AdvancedHumanoidModel;
import net.ltxprogrammer.changed.entity.ChangedEntity;
import net.ltxprogrammer.changed.util.Color3;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import org.jetbrains.annotations.NotNull;

public class AvaliColorsLayer<M extends AdvancedHumanoidModel<T>, T extends ChangedEntity>
extends RenderLayer<T, M>
implements FirstPersonLayer<T> {
    private final M model;
    private final ResourceLocation layerTexture;
    private final int layer;

    public AvaliColorsLayer(RenderLayerParent<T, M> parent, M model, ResourceLocation layerTexture, int layer) {
        super(parent);
        this.model = model;
        this.layerTexture = layerTexture;
        this.layer = layer;
    }

    public void render(@NotNull PoseStack pose, @NotNull MultiBufferSource bufferSource, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!entity.m_20145_() && entity instanceof AvaliEntity) {
            AvaliEntity avaliEntity = (AvaliEntity)entity;
            ResourceLocation texture = this.getTextureStyle(avaliEntity);
            Color3 bodyColor = avaliEntity.getColor(this.layer);
            int overlay = LivingEntityRenderer.m_115338_(entity, (float)0.0f);
            this.model.m_7695_(pose, bufferSource.m_6299_(RenderType.m_110458_((ResourceLocation)texture)), packedLight, overlay, bodyColor.red(), bodyColor.green(), bodyColor.blue(), 1.0f);
        }
    }

    private ResourceLocation getTextureStyle(AvaliEntity avaliEntity) {
        if (this.layerTexture.toString().contains("gender")) {
            return new ResourceLocation(this.layerTexture.toString().replace("gender", avaliEntity.getStyleOfColor()));
        }
        return this.layerTexture;
    }

    public void renderFirstPersonOnArms(PoseStack stack, MultiBufferSource bufferSource, int packedLight, T entity, HumanoidArm arm, PartPose armPose, PoseStack stackCorrector, float partialTick) {
        super.renderFirstPersonOnArms(stack, bufferSource, packedLight, entity, arm, armPose, stackCorrector, partialTick);
        if (entity instanceof AvaliEntity) {
            AvaliEntity avaliEntity = (AvaliEntity)entity;
            ResourceLocation texture = this.getTextureStyle(avaliEntity);
            Color3 bodyColor = avaliEntity.getColor(this.layer);
            stack.m_85836_();
            stack.m_85841_(1.0002f, 1.0002f, 1.0002f);
            FormRenderHandler.renderModelPartWithTexture((ModelPart)this.model.m_102851_(arm), (PoseStack)stackCorrector, (PoseStack)stack, (VertexConsumer)bufferSource.m_6299_(RenderType.m_110458_((ResourceLocation)texture)), (int)packedLight, (float)bodyColor.red(), (float)bodyColor.green(), (float)bodyColor.blue(), (float)1.0f);
            stack.m_85849_();
        }
    }
}

