/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.client.renderer.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.ltxprogrammer.changed.client.FormRenderHandler;
import net.ltxprogrammer.changed.client.renderer.layers.CustomEyesLayer;
import net.ltxprogrammer.changed.client.renderer.layers.FirstPersonLayer;
import net.ltxprogrammer.changed.client.renderer.model.AdvancedHumanoidModel;
import net.ltxprogrammer.changed.entity.ChangedEntity;
import net.ltxprogrammer.changed.util.Color3;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import org.jetbrains.annotations.NotNull;

public class CustomClothesLayer<E extends ChangedEntity, M extends AdvancedHumanoidModel<E>>
extends RenderLayer<E, M>
implements FirstPersonLayer<E> {
    private final M model;
    private final ResourceLocation clothesTexture;
    private final boolean poseStackStyle;
    private final float scale;

    public CustomClothesLayer(RenderLayerParent<E, M> p_117346_, M model, ResourceLocation clothesTexture) {
        super(p_117346_);
        this.model = model;
        this.clothesTexture = clothesTexture;
        this.poseStackStyle = false;
        this.scale = 1.0f;
    }

    public CustomClothesLayer(RenderLayerParent<E, M> p_117346_, M model, ResourceLocation clothesTexture, boolean poseStackStyle, float poseStackScale) {
        super(p_117346_);
        this.model = model;
        this.clothesTexture = clothesTexture;
        this.poseStackStyle = poseStackStyle;
        this.scale = poseStackScale;
    }

    public void render(@NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight, @NotNull E entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        this.model.m_6839_(entity, limbSwing, limbSwingAmount, partialTicks);
        this.model.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        ResourceLocation accessoryTexture = this.getClothTexture();
        if (accessoryTexture == null) {
            return;
        }
        VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderType.m_110452_((ResourceLocation)accessoryTexture));
        Color3 color = this.getClothColor(entity);
        float alpha = this.getClothAlpha(entity);
        float zFightOffset = CustomEyesLayer.getZFightingOffset(entity);
        poseStack.m_85836_();
        this.model.m_6839_(entity, limbSwing, limbSwingAmount, partialTicks);
        this.model.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        if (this.poseStackStyle) {
            poseStack.m_85841_(this.scale + zFightOffset, this.scale + zFightOffset, this.scale + zFightOffset);
        }
        if (color != null) {
            this.model.m_7695_(poseStack, vertexConsumer, packedLight, LivingEntityRenderer.m_115338_(entity, (float)0.0f), color.red(), color.green(), color.blue(), alpha);
        } else {
            this.model.m_7695_(poseStack, vertexConsumer, packedLight, LivingEntityRenderer.m_115338_(entity, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
        }
        poseStack.m_85849_();
    }

    public void renderFirstPersonOnArms(PoseStack stack, MultiBufferSource bufferSource, int packedLight, E entity, HumanoidArm arm, PartPose armPose, PoseStack stackCorrector, float partialTick) {
        super.renderFirstPersonOnArms(stack, bufferSource, packedLight, entity, arm, armPose, stackCorrector, partialTick);
        stack.m_85836_();
        stack.m_85841_(1.0002f, 1.0002f, 1.0002f);
        ResourceLocation accessoryTexture = this.getClothTexture();
        if (accessoryTexture == null) {
            return;
        }
        VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderType.m_110452_((ResourceLocation)accessoryTexture));
        Color3 color = this.getClothColor(entity);
        if (color == null) {
            color = Color3.WHITE;
        }
        float alpha = this.getClothAlpha(entity);
        FormRenderHandler.renderModelPartWithTexture((ModelPart)this.model.m_102851_(arm), (PoseStack)stackCorrector, (PoseStack)stack, (VertexConsumer)vertexConsumer, (int)packedLight, (float)color.red(), (float)color.green(), (float)color.blue(), (float)alpha);
        stack.m_85849_();
    }

    private float getClothAlpha(@NotNull E entity) {
        return 1.0f;
    }

    private Color3 getClothColor(E entity) {
        return Color3.WHITE;
    }

    private ResourceLocation getClothTexture() {
        return this.clothesTexture;
    }
}

