/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.client.renderer.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import net.foxyas.changedaddon.entity.simple.ReynEntity;
import net.ltxprogrammer.changed.client.renderer.layers.FirstPersonLayer;
import net.ltxprogrammer.changed.client.renderer.model.AdvancedHumanoidModel;
import net.ltxprogrammer.changed.entity.BasicPlayerInfo;
import net.ltxprogrammer.changed.entity.ChangedEntity;
import net.ltxprogrammer.changed.util.Color3;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class CustomDisplay<M extends AdvancedHumanoidModel<T>, T extends ChangedEntity>
extends RenderLayer<T, M>
implements FirstPersonLayer<T> {
    private final M model;
    private final RenderType GlowEyeRender;
    private final RenderType NormalEyeRender;
    private final RenderType GlowDisplayRender;
    private final RenderType NormalDisplayRender;
    private final boolean isOnlyHead;

    public CustomDisplay(RenderLayerParent<T, M> parent, M model, ResourceLocation eyePart, ResourceLocation displayPart) {
        super(parent);
        this.model = model;
        this.GlowEyeRender = RenderType.m_110488_((ResourceLocation)eyePart);
        this.GlowDisplayRender = RenderType.m_110488_((ResourceLocation)displayPart);
        this.NormalEyeRender = RenderType.m_110458_((ResourceLocation)eyePart);
        this.NormalDisplayRender = RenderType.m_110458_((ResourceLocation)displayPart);
        this.isOnlyHead = false;
    }

    public CustomDisplay(RenderLayerParent<T, M> parent, M model, ResourceLocation eyePart, ResourceLocation displayPart, boolean OnlyHead) {
        super(parent);
        this.model = model;
        this.GlowEyeRender = RenderType.m_110488_((ResourceLocation)eyePart);
        this.GlowDisplayRender = RenderType.m_110488_((ResourceLocation)displayPart);
        this.NormalEyeRender = RenderType.m_110458_((ResourceLocation)eyePart);
        this.NormalDisplayRender = RenderType.m_110458_((ResourceLocation)displayPart);
        this.isOnlyHead = OnlyHead;
    }

    public void render(@NotNull PoseStack pose, @NotNull MultiBufferSource bufferSource, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!entity.m_20145_()) {
            RenderType renderType2;
            RenderType renderType;
            if (entity instanceof ReynEntity) {
                ReynEntity reynEntity = (ReynEntity)((Object)entity);
                renderType = this.GlowEyeRender;
                renderType2 = this.GlowDisplayRender;
            } else if (packedLight > 5) {
                renderType = this.GlowEyeRender;
                renderType2 = this.GlowDisplayRender;
            } else {
                renderType = this.NormalEyeRender;
                renderType2 = this.NormalDisplayRender;
            }
            BasicPlayerInfo info = entity.getBasicPlayerInfo();
            Color3 displayColor = info.getHairColor();
            Color3 eyeColor = info.getScleraColor();
            int overlay = LivingEntityRenderer.m_115338_(entity, (float)0.0f);
            if (this.isOnlyHead) {
                this.model.m_5585_().m_104306_(pose, bufferSource.m_6299_(renderType), packedLight, overlay, eyeColor.red(), eyeColor.green(), eyeColor.blue(), 1.0f);
                this.model.m_5585_().m_104306_(pose, bufferSource.m_6299_(renderType2), packedLight, overlay, displayColor.red(), displayColor.green(), displayColor.blue(), 1.0f);
            } else {
                this.model.m_7695_(pose, bufferSource.m_6299_(renderType), packedLight, overlay, eyeColor.red(), eyeColor.green(), eyeColor.blue(), 1.0f);
                this.model.m_7695_(pose, bufferSource.m_6299_(renderType2), packedLight, overlay, displayColor.red(), displayColor.green(), displayColor.blue(), 1.0f);
            }
        }
    }
}

