/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.client.renderer.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.foxyas.changedaddon.configuration.ChangedAddonClientConfiguration;
import net.ltxprogrammer.changed.client.FormRenderHandler;
import net.ltxprogrammer.changed.client.renderer.layers.FirstPersonLayer;
import net.ltxprogrammer.changed.client.renderer.model.AdvancedHumanoidModel;
import net.ltxprogrammer.changed.entity.BasicPlayerInfo;
import net.ltxprogrammer.changed.entity.ChangedEntity;
import net.ltxprogrammer.changed.util.Color3;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import org.jetbrains.annotations.NotNull;

public class CustomHairColorLayer<M extends AdvancedHumanoidModel<T>, T extends ChangedEntity>
extends RenderLayer<T, M>
implements FirstPersonLayer<T> {
    private final M model;
    private final RenderType renderTypeDark;
    private final RenderType renderTypeLight;
    private final boolean IsFemaleOrNot;

    public CustomHairColorLayer(RenderLayerParent<T, M> parent, M model, ResourceLocation textureBase) {
        super(parent);
        this.model = model;
        this.renderTypeDark = RenderType.m_110452_((ResourceLocation)new ResourceLocation(textureBase.m_135827_(), textureBase.m_135815_() + "_dark.png"));
        this.renderTypeLight = RenderType.m_110452_((ResourceLocation)new ResourceLocation(textureBase.m_135827_(), textureBase.m_135815_() + "_light.png"));
        this.IsFemaleOrNot = textureBase.m_135815_().contains("female");
    }

    public CustomHairColorLayer(RenderLayerParent<T, M> parent, M model, ResourceLocation textureBase, boolean Female) {
        super(parent);
        this.model = model;
        this.renderTypeDark = RenderType.m_110452_((ResourceLocation)new ResourceLocation(textureBase.m_135827_(), textureBase.m_135815_() + "_dark.png"));
        this.renderTypeLight = RenderType.m_110452_((ResourceLocation)new ResourceLocation(textureBase.m_135827_(), textureBase.m_135815_() + "_light.png"));
        this.IsFemaleOrNot = Female;
    }

    public void render(@NotNull PoseStack pose, @NotNull MultiBufferSource bufferSource, int packedLight, @NotNull T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!((Boolean)ChangedAddonClientConfiguration.FEMALE_SNEPS_HAIR.get()).booleanValue() && this.IsFemaleOrNot) {
            return;
        }
        if (!((Boolean)ChangedAddonClientConfiguration.MALE_SNEPS_HAIR.get()).booleanValue() && !this.IsFemaleOrNot) {
            return;
        }
        if (!entity.m_20145_()) {
            BasicPlayerInfo info = entity.getBasicPlayerInfo();
            Color3 coatColor = info.getHairColor();
            int overlay = LivingEntityRenderer.m_115338_(entity, (float)0.0f);
            this.model.m_7695_(pose, bufferSource.m_6299_(this.getRenderTypeForColor(coatColor)), packedLight, overlay, coatColor.red(), coatColor.green(), coatColor.blue(), 1.0f);
        }
    }

    public RenderType getRenderTypeForColor(Color3 color) {
        return color.brightness() < 0.5f ? this.renderTypeDark : this.renderTypeLight;
    }

    public void renderFirstPersonOnArms(PoseStack stack, MultiBufferSource bufferSource, int packedLight, T entity, HumanoidArm arm, PartPose armPose, PoseStack stackCorrector, float partialTick) {
        super.renderFirstPersonOnArms(stack, bufferSource, packedLight, entity, arm, armPose, stackCorrector, partialTick);
        if (!((Boolean)ChangedAddonClientConfiguration.FEMALE_SNEPS_HAIR.get()).booleanValue() && this.IsFemaleOrNot) {
            return;
        }
        if (!((Boolean)ChangedAddonClientConfiguration.MALE_SNEPS_HAIR.get()).booleanValue() && !this.IsFemaleOrNot) {
            return;
        }
        BasicPlayerInfo info = entity.getBasicPlayerInfo();
        Color3 coatColor = info.getHairColor();
        stack.m_85836_();
        stack.m_85841_(1.0002f, 1.0002f, 1.0002f);
        FormRenderHandler.renderModelPartWithTexture((ModelPart)this.model.m_102851_(arm), (PoseStack)stackCorrector, (PoseStack)stack, (VertexConsumer)bufferSource.m_6299_(this.getRenderTypeForColor(coatColor)), (int)packedLight, (float)coatColor.red(), (float)coatColor.green(), (float)coatColor.blue(), (float)1.0f);
        stack.m_85849_();
    }
}

