/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.client.renderer.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import net.foxyas.changedaddon.entity.bosses.LuminarcticLeopardMaleEntity;
import net.foxyas.changedaddon.entity.defaults.AbstractLuminarcticLeopard;
import net.ltxprogrammer.changed.ability.AbstractAbilityInstance;
import net.ltxprogrammer.changed.ability.HypnosisAbility;
import net.ltxprogrammer.changed.client.renderer.layers.CustomEyesLayer;
import net.ltxprogrammer.changed.client.renderer.layers.EmissiveBodyLayer;
import net.ltxprogrammer.changed.client.renderer.layers.FirstPersonLayer;
import net.ltxprogrammer.changed.client.renderer.model.AdvancedHumanoidModel;
import net.ltxprogrammer.changed.entity.ChangedEntity;
import net.ltxprogrammer.changed.process.ProcessTransfur;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class LuminarcticLeopardsConditionalLayers {

    public static class LuminarcticCustomEyesLayer<M extends AdvancedHumanoidModel<T>, T extends ChangedEntity>
    extends RenderLayer<T, M> {
        private final CustomEyesLayer<M, T> customEyesLayer;
        private final CustomEyesLayer<M, T> customGlowEyesLayer;

        public LuminarcticCustomEyesLayer(RenderLayerParent<T, M> parent, CustomEyesLayer<M, T> customEyesLayer, CustomEyesLayer<M, T> customGlowEyesLayer) {
            super(parent);
            this.customEyesLayer = customEyesLayer;
            this.customGlowEyesLayer = customGlowEyesLayer;
        }

        public void render(@NotNull PoseStack pose, @NotNull MultiBufferSource bufferSource, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (entity.getUnderlyingPlayer() != null) {
                LuminarcticLeopardMaleEntity LUMI;
                Player player = entity.getUnderlyingPlayer();
                AbstractAbilityInstance instance = ProcessTransfur.getPlayerTransfurVariant((Player)player).getSelectedAbility();
                if (instance != null && instance.ability instanceof HypnosisAbility) {
                    if (instance.getController().getHoldTicks() > 0) {
                        this.customGlowEyesLayer.render(pose, bufferSource, packedLight, entity, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
                    } else {
                        this.customEyesLayer.render(pose, bufferSource, packedLight, entity, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
                    }
                } else if (entity instanceof LuminarcticLeopardMaleEntity && (LUMI = (LuminarcticLeopardMaleEntity)entity).isActivatedAbility()) {
                    this.customGlowEyesLayer.render(pose, bufferSource, packedLight, entity, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
                } else {
                    this.customEyesLayer.render(pose, bufferSource, packedLight, entity, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
                }
            }
        }
    }

    public static class GlowFelineEyesLayer<M extends AdvancedHumanoidModel<T>, T extends ChangedEntity>
    extends EmissiveBodyLayer<M, T> {
        public GlowFelineEyesLayer(RenderLayerParent<T, M> p_116964_, ResourceLocation emissiveTexture) {
            super(p_116964_, emissiveTexture);
        }

        public void render(@NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            LuminarcticLeopardMaleEntity WILD_LUMI;
            if (entity.getUnderlyingPlayer() != null) {
                return;
            }
            if (entity instanceof LuminarcticLeopardMaleEntity && (WILD_LUMI = (LuminarcticLeopardMaleEntity)entity).m_5448_() != null) {
                super.m_6494_(poseStack, bufferSource, packedLight, entity, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
            }
        }
    }

    public static class GlowLayer<M extends AdvancedHumanoidModel<T>, T extends ChangedEntity>
    extends EmissiveBodyLayer<M, T>
    implements FirstPersonLayer<T> {
        public GlowLayer(RenderLayerParent<T, M> p_116964_, ResourceLocation emissiveTexture) {
            super(p_116964_, emissiveTexture);
        }

        public void render(@NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            AbstractLuminarcticLeopard WILD_LUMI;
            float blue;
            float green;
            float red;
            if (entity.getUnderlyingPlayer() != null) {
                AbstractLuminarcticLeopard LUMI;
                Player player = entity.getUnderlyingPlayer();
                AbstractAbilityInstance instance = ProcessTransfur.getPlayerTransfurVariant((Player)player).getSelectedAbility();
                if (instance != null && instance.ability instanceof HypnosisAbility) {
                    if (instance.getController().getHoldTicks() > 0) {
                        super.m_6494_(poseStack, bufferSource, packedLight, entity, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
                    }
                } else if (entity instanceof AbstractLuminarcticLeopard && (LUMI = (AbstractLuminarcticLeopard)entity).isActivatedAbility()) {
                    if (LUMI.getGlowStage() == 1) {
                        vertexConsumer = bufferSource.m_6299_(this.m_5708_());
                        float pulseFactor = (float)(Math.sin(ageInTicks * 0.1f) + 1.0) / 2.0f;
                        float intensity = 1.0f;
                        float red2 = 1.0f - pulseFactor * intensity;
                        float green2 = 1.0f - pulseFactor * intensity;
                        float blue2 = 1.0f - pulseFactor * intensity;
                        ((AdvancedHumanoidModel)this.m_117386_()).m_7695_(poseStack, vertexConsumer, packedLight, OverlayTexture.f_118083_, red2, green2, blue2, 1.0f);
                    } else if (LUMI.getGlowStage() == 2) {
                        vertexConsumer = bufferSource.m_6299_(this.m_5708_());
                        red = 1.0f;
                        green = 1.0f;
                        blue = 1.0f;
                        ((AdvancedHumanoidModel)this.m_117386_()).m_7695_(poseStack, vertexConsumer, packedLight, OverlayTexture.f_118083_, red, green, blue, 1.0f);
                    } else {
                        super.m_6494_(poseStack, bufferSource, packedLight, entity, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
                    }
                }
            }
            if (entity instanceof AbstractLuminarcticLeopard && (WILD_LUMI = (AbstractLuminarcticLeopard)entity).m_5448_() != null) {
                if (WILD_LUMI.getGlowStage() == 1) {
                    vertexConsumer = bufferSource.m_6299_(this.m_5708_());
                    float pulseFactor = (float)(Math.sin(ageInTicks * 0.1f) + 1.0) / 2.0f;
                    float intensity = 1.0f;
                    red = 1.0f - pulseFactor * intensity;
                    green = 1.0f - pulseFactor * intensity;
                    blue = 1.0f - pulseFactor * intensity;
                    ((AdvancedHumanoidModel)this.m_117386_()).m_7695_(poseStack, vertexConsumer, packedLight, OverlayTexture.f_118083_, red, green, blue, 1.0f);
                } else if (WILD_LUMI.getGlowStage() == 2) {
                    vertexConsumer = bufferSource.m_6299_(this.m_5708_());
                    float red3 = 1.0f;
                    float green3 = 1.0f;
                    float blue3 = 1.0f;
                    ((AdvancedHumanoidModel)this.m_117386_()).m_7695_(poseStack, vertexConsumer, packedLight, OverlayTexture.f_118083_, red3, green3, blue3, 1.0f);
                } else {
                    super.m_6494_(poseStack, bufferSource, packedLight, entity, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
                }
            }
        }

        public void renderFirstPersonOnArms(PoseStack stack, MultiBufferSource bufferSource, int packedLight, T entity, HumanoidArm arm, PartPose armPose, PoseStack stackCorrector, float partialTick) {
            AbstractLuminarcticLeopard WILD_LUMI;
            if (entity.getUnderlyingPlayer() != null) {
                AbstractLuminarcticLeopard LUMI;
                Player player = entity.getUnderlyingPlayer();
                AbstractAbilityInstance instance = ProcessTransfur.getPlayerTransfurVariant((Player)player).getSelectedAbility();
                if (entity instanceof AbstractLuminarcticLeopard && (LUMI = (AbstractLuminarcticLeopard)entity).isActivatedAbility()) {
                    super.renderFirstPersonOnArms(stack, bufferSource, packedLight, entity, arm, armPose, stackCorrector, partialTick);
                } else if (instance != null && instance.ability instanceof HypnosisAbility && instance.getController().getHoldTicks() > 0) {
                    super.renderFirstPersonOnArms(stack, bufferSource, packedLight, entity, arm, armPose, stackCorrector, partialTick);
                }
            } else if (entity instanceof AbstractLuminarcticLeopard && (WILD_LUMI = (AbstractLuminarcticLeopard)entity).m_5448_() != null) {
                super.renderFirstPersonOnArms(stack, bufferSource, packedLight, entity, arm, armPose, stackCorrector, partialTick);
            }
        }
    }
}

