/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.client.renderer.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.ltxprogrammer.changed.client.renderer.model.AdvancedHumanoidModel;
import net.ltxprogrammer.changed.entity.ChangedEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class ModelFlickerLayer<M extends AdvancedHumanoidModel<T>, T extends ChangedEntity>
extends RenderLayer<T, M> {
    public ModelFlickerLayer(RenderLayerParent<T, M> parent) {
        super(parent);
    }

    public void render(@NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight, @NotNull T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        float healthRatio = entity.computeHealthRatio();
        if (healthRatio >= 0.5f) {
            return;
        }
        float intensity = 1.0f - healthRatio;
        float flickerSpeed = 40.0f + 90.0f * (intensity * 2.0f);
        float flicker = (float)Math.sin(((float)((ChangedEntity)entity).f_19797_ + partialTicks) * flickerSpeed) * intensity * 0.05f;
        poseStack.m_85836_();
        poseStack.m_85837_((double)flicker, (double)(flicker * 1.25f), (double)flicker);
        AdvancedHumanoidModel model = (AdvancedHumanoidModel)this.m_117386_();
        ResourceLocation texture = this.m_117347_((Entity)entity);
        VertexConsumer buffer = bufferSource.m_6299_(RenderType.m_110436_((ResourceLocation)texture, (float)0.0f, (float)0.0f));
        float alpha = 0.3f;
        model.m_6839_(entity, limbSwing, limbSwingAmount, partialTicks);
        model.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        model.m_7695_(poseStack, buffer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, alpha);
        poseStack.m_85849_();
    }
}

