/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.client.renderer.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import net.ltxprogrammer.changed.client.renderer.layers.FirstPersonLayer;
import net.ltxprogrammer.changed.client.renderer.model.AdvancedHumanoidModel;
import net.ltxprogrammer.changed.entity.BasicPlayerInfo;
import net.ltxprogrammer.changed.entity.ChangedEntity;
import net.ltxprogrammer.changed.util.Color3;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import org.jetbrains.annotations.NotNull;

public class ProtogenDisplay<M extends AdvancedHumanoidModel<T>, T extends ChangedEntity>
extends RenderLayer<T, M>
implements FirstPersonLayer<T> {
    private final M model;
    private final RenderType GlowEyeRender;
    private final RenderType NormalEyeRender;
    private final RenderType GlowDisplayRender;
    private final RenderType NormalDisplayRender;
    private final boolean isOnlyHead;

    public ProtogenDisplay(RenderLayerParent<T, M> parent, M model, ResourceLocation eyePart, ResourceLocation displayPart) {
        super(parent);
        this.model = model;
        this.GlowEyeRender = RenderType.m_110488_((ResourceLocation)eyePart);
        this.GlowDisplayRender = RenderType.m_110488_((ResourceLocation)displayPart);
        this.NormalEyeRender = RenderType.m_110458_((ResourceLocation)eyePart);
        this.NormalDisplayRender = RenderType.m_110458_((ResourceLocation)displayPart);
        this.isOnlyHead = false;
    }

    public ProtogenDisplay(RenderLayerParent<T, M> parent, M model, ResourceLocation eyePart, ResourceLocation displayPart, boolean OnlyHead) {
        super(parent);
        this.model = model;
        this.GlowEyeRender = RenderType.m_110488_((ResourceLocation)eyePart);
        this.GlowDisplayRender = RenderType.m_110488_((ResourceLocation)displayPart);
        this.NormalEyeRender = RenderType.m_110458_((ResourceLocation)eyePart);
        this.NormalDisplayRender = RenderType.m_110458_((ResourceLocation)displayPart);
        this.isOnlyHead = OnlyHead;
    }

    public void render(@NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!entity.m_20145_()) {
            BasicPlayerInfo info = entity.getBasicPlayerInfo();
            Color3 displayColor = info.getScleraColor();
            Color3 eyeColor = info.getRightIrisColor();
            int overlay = LivingEntityRenderer.m_115338_(entity, (float)0.0f);
            if (this.isOnlyHead) {
                this.model.m_5585_().m_104306_(poseStack, bufferSource.m_6299_(this.NormalDisplayRender), packedLight, overlay, displayColor.red(), displayColor.green(), displayColor.blue(), 1.0f);
                this.model.m_5585_().m_104306_(poseStack, bufferSource.m_6299_(this.GlowEyeRender), packedLight, overlay, eyeColor.red(), eyeColor.green(), eyeColor.blue(), 1.0f);
            } else {
                this.model.m_7695_(poseStack, bufferSource.m_6299_(this.NormalDisplayRender), packedLight, overlay, displayColor.red(), displayColor.green(), displayColor.blue(), 1.0f);
                this.model.m_7695_(poseStack, bufferSource.m_6299_(this.GlowEyeRender), packedLight, overlay, eyeColor.red(), eyeColor.green(), eyeColor.blue(), 1.0f);
            }
        }
    }

    public boolean isOnlyHead() {
        return this.isOnlyHead;
    }

    public RenderType getGlowDisplayRender() {
        return this.GlowDisplayRender;
    }

    public RenderType getGlowEyeRender() {
        return this.GlowEyeRender;
    }

    public RenderType getNormalDisplayRender() {
        return this.NormalDisplayRender;
    }

    public RenderType getNormalEyeRender() {
        return this.NormalEyeRender;
    }

    public void renderFirstPersonOnArms(PoseStack stack, MultiBufferSource bufferSource, int packedLight, T entity, HumanoidArm arm, PartPose armPose, PoseStack stackCorrector, float partialTick) {
        super.renderFirstPersonOnArms(stack, bufferSource, packedLight, entity, arm, armPose, stackCorrector, partialTick);
    }
}

