/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.datagen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import net.foxyas.changedaddon.init.ChangedAddonTags;
import net.ltxprogrammer.changed.data.AccessorySlotType;
import net.ltxprogrammer.changed.init.ChangedAccessorySlots;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class AccessoryEntityProvider
implements DataProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static AccessorySlotType[] humanoidSlots;
    protected final String modId;
    private final DataGenerator generator;
    private final Map<String, Appender> appenders = new HashMap<String, Appender>();

    public AccessoryEntityProvider(DataGenerator generator) {
        this(generator, "changed_addon");
    }

    public AccessoryEntityProvider(DataGenerator generator, String modId) {
        this.generator = generator;
        this.modId = modId;
    }

    public static AccessorySlotType[] getHumanoidSlots() {
        if (humanoidSlots == null) {
            humanoidSlots = new AccessorySlotType[]{(AccessorySlotType)ChangedAccessorySlots.BODY.get(), (AccessorySlotType)ChangedAccessorySlots.FULL_BODY.get(), (AccessorySlotType)ChangedAccessorySlots.LEGS.get()};
        }
        return humanoidSlots;
    }

    public void m_6865_(@NotNull HashCache cache) {
        this.registerEntityAccessories();
        Path basePath = this.generator.m_123916_();
        for (Map.Entry<String, Appender> entry : this.appenders.entrySet()) {
            Appender appender = entry.getValue();
            if (appender.isInvalid()) {
                LOGGER.error("{} Provider: Appender for file {} is missing entities or slots!", (Object)this.m_6055_(), (Object)entry.getKey());
                continue;
            }
            Path path = this.createPath(basePath, entry.getKey());
            try {
                DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)appender.toJson(), (Path)path);
            }
            catch (IOException e) {
                LOGGER.error("Couldn't save accessory entities to file {}", (Object)path, (Object)e);
            }
        }
    }

    public Appender add(@NotNull String fileName) {
        return this.appenders.computeIfAbsent(fileName, f -> new Appender());
    }

    protected void registerEntityAccessories() {
        this.add("humanoids").entityTypesTag(ChangedAddonTags.EntityTypes.CAN_USE_ACCESSORIES).slots(AccessoryEntityProvider.getHumanoidSlots());
    }

    private Path createPath(Path base, String fileName) {
        return base.resolve("data/" + this.modId + "/accessories/entities/" + fileName + ".json");
    }

    @NotNull
    public String m_6055_() {
        return "Accessory Entities";
    }

    @ParametersAreNonnullByDefault
    public static class Appender {
        private final Set<EntityType<?>> entities = new HashSet();
        private final Set<TagKey<EntityType<?>>> entityTypesTags = new HashSet();
        private final Set<AccessorySlotType> slots = new ObjectArraySet();

        private Appender() {
        }

        public Appender entity(EntityType<?> entity) {
            this.entities.add(entity);
            return this;
        }

        public Appender entities(EntityType<?> ... entities) {
            Collections.addAll(this.entities, entities);
            return this;
        }

        public Appender entityTypesTag(TagKey<EntityType<?>> entityTypeTagKey) {
            this.entityTypesTags.add(entityTypeTagKey);
            return this;
        }

        public Appender entityTypesTags(TagKey<EntityType<?>> ... entityTypeTagKey) {
            Collections.addAll(this.entityTypesTags, entityTypeTagKey);
            return this;
        }

        public Appender slot(AccessorySlotType slot) {
            this.slots.add(slot);
            return this;
        }

        public Appender slots(AccessorySlotType ... slots) {
            Collections.addAll(this.slots, slots);
            return this;
        }

        private boolean isInvalid() {
            return this.entities.isEmpty() && this.entityTypesTags.isEmpty() || this.slots.isEmpty();
        }

        private JsonObject toJson() {
            JsonObject root = new JsonObject();
            JsonArray entityAr = new JsonArray();
            JsonArray slotAr = new JsonArray();
            root.add("entities", (JsonElement)entityAr);
            root.add("slots", (JsonElement)slotAr);
            for (EntityType<?> entityType : this.entities) {
                entityAr.add(entityType.getRegistryName().toString());
            }
            for (TagKey tagKey : this.entityTypesTags) {
                entityAr.add("#" + tagKey.f_203868_());
            }
            for (AccessorySlotType accessorySlotType : this.slots) {
                slotAr.add(accessorySlotType.getRegistryName().toString());
            }
            return root;
        }
    }
}

