/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.effect.particles;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.foxyas.changedaddon.configuration.ChangedAddonClientConfiguration;
import net.foxyas.changedaddon.init.ChangedAddonParticleTypes;
import net.foxyas.changedaddon.init.ChangedAddonTags;
import net.foxyas.changedaddon.item.LaserPointer;
import net.foxyas.changedaddon.util.DynamicClipContext;
import net.foxyas.changedaddon.util.FoxyasUtils;
import net.foxyas.changedaddon.util.PlayerUtil;
import net.ltxprogrammer.changed.process.ProcessTransfur;
import net.ltxprogrammer.changed.util.Color3;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LaserPointParticle
extends TextureSheetParticle {
    public final SpriteSet spriteSet;
    private final Entity entity;

    public LaserPointParticle(ClientLevel level, double x, double y, double z, double dx, double dy, double dz, Option data, SpriteSet sprites) {
        super(level, x, y, z, dx, dy, dz);
        this.spriteSet = sprites;
        this.m_107250_(0.1f, 0.1f);
        this.f_107663_ = 0.1f;
        this.m_107271_(data.getColorAlpha());
        this.f_107225_ = 100;
        this.entity = level.m_6815_(data.getEntityId());
        this.f_107227_ = data.getColorAsColor3().red();
        this.f_107229_ = data.getColorAsColor3().blue();
        this.f_107228_ = data.getColorAsColor3().green();
        this.m_108335_(sprites);
    }

    public int m_6355_(float p_105562_) {
        return 0xF000F0;
    }

    public void m_5744_(@NotNull VertexConsumer pBuffer, @NotNull Camera pRenderInfo, float pPartialTicks) {
        if (this.f_107208_.m_5776_() && Minecraft.m_91087_().f_91074_ != null && ProcessTransfur.getPlayerTransfurVariantSafe((Player)Minecraft.m_91087_().f_91074_).map(transfurVariantInstance -> transfurVariantInstance.getParent().is(ChangedAddonTags.TransfurTypes.CAT_LIKE) || transfurVariantInstance.getParent().is(ChangedAddonTags.TransfurTypes.LEOPARD_LIKE)).orElse(false).booleanValue() && (double)this.f_107221_ != 0.35) {
            this.m_107250_(0.35f, 0.35f);
            this.f_107663_ = 0.35f;
        } else if ((double)this.f_107221_ == 0.35) {
            this.m_107250_(0.1f, 0.1f);
            this.f_107663_ = 0.1f;
        }
        super.m_5744_(pBuffer, pRenderInfo, pPartialTicks);
    }

    public void m_5989_() {
        LivingEntity owner;
        super.m_5989_();
        Entity entity = this.entity;
        if (!(entity instanceof LivingEntity) || !(owner = (LivingEntity)entity).m_6084_()) {
            this.m_107274_();
            return;
        }
        ItemStack heldItem = owner.m_21211_();
        if (heldItem.m_41619_() || !(heldItem.m_41720_() instanceof LaserPointer) || !owner.m_6117_()) {
            this.m_107274_();
            return;
        }
        Vec3 eyePos = owner.m_146892_();
        BlockHitResult result = this.f_107208_.m_45547_((ClipContext)new DynamicClipContext(eyePos, eyePos.m_82549_(owner.m_20252_(1.0f).m_82490_(32.0)), LaserPointer.IGNORE_TRANSLUCENT, arg_0 -> ((ClipContext.Fluid)ClipContext.Fluid.NONE).m_45731_(arg_0), CollisionContext.m_82750_((Entity)owner)));
        EntityHitResult entityHitResult = PlayerUtil.getEntityHitLookingAt((Entity)owner, result.m_6662_() != HitResult.Type.MISS ? (float)result.m_82448_((Entity)owner) : 32.0f, false);
        Vec3 hitPos = result.m_82450_();
        Direction face = null;
        boolean Subtract = false;
        if (entityHitResult != null) {
            hitPos = entityHitResult.m_82450_();
            face = entityHitResult.m_82443_().m_6350_();
        } else if (result instanceof BlockHitResult) {
            BlockHitResult blockResult = result;
            hitPos = blockResult.m_82450_();
            face = blockResult.m_82434_();
            hitPos = FoxyasUtils.applyOffset(hitPos, face, !Subtract ? (double)-0.01f : (double)0.05f);
        }
        double offset = !Subtract ? -0.05 : 0.05;
        hitPos = hitPos.m_82492_((double)face.m_122429_() * offset, (double)face.m_122430_() * offset, (double)face.m_122431_() * offset);
        if (((Boolean)ChangedAddonClientConfiguration.SMOOTH_LASER_MOVEMENT.get()).booleanValue()) {
            this.moveToward(hitPos);
        } else {
            this.SetToward(hitPos);
        }
    }

    private void moveToward(Vec3 target) {
        double dx = target.f_82479_ - this.f_107212_;
        double dy = target.f_82480_ - this.f_107213_;
        double dz = target.f_82481_ - this.f_107214_;
        double distanceSquared = dx * dx + dy * dy + dz * dz;
        if (distanceSquared >= 0.001) {
            double speed = 0.5;
            this.f_107215_ = dx * speed;
            this.f_107216_ = dy * speed;
            this.f_107217_ = dz * speed;
            this.f_107212_ += this.f_107215_;
            this.f_107213_ += this.f_107216_;
            this.f_107214_ += this.f_107217_;
            this.m_107259_(this.m_107277_().m_82386_(this.f_107215_, this.f_107216_, this.f_107217_));
        }
        this.f_107224_ = 0;
    }

    private void SetToward(Vec3 target) {
        this.m_107259_(this.m_107277_().m_82386_(target.f_82479_ - this.f_107212_, target.f_82480_ - this.f_107213_, target.f_82481_ - this.f_107214_));
        this.f_107212_ = target.f_82479_;
        this.f_107213_ = target.f_82480_;
        this.f_107214_ = target.f_82481_;
        this.f_107224_ = 0;
    }

    @NotNull
    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107432_;
    }

    public static class Option
    implements ParticleOptions {
        public static final ParticleOptions.Deserializer<Option> DESERIALIZER = new ParticleOptions.Deserializer<Option>(){

            @NotNull
            public Option fromNetwork(@NotNull ParticleType<Option> type, FriendlyByteBuf buffer) {
                int entityId = buffer.readInt();
                int color = buffer.readInt();
                float alpha = buffer.readFloat();
                return new Option(entityId, color, alpha);
            }

            @NotNull
            public Option fromCommand(@NotNull ParticleType<Option> type, StringReader reader) throws CommandSyntaxException {
                float alpha;
                int color;
                int entityId;
                reader.expect(' ');
                if (!reader.canRead()) {
                    throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.readerExpectedInt().create();
                }
                try {
                    entityId = reader.readInt();
                }
                catch (Exception e) {
                    throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.readerInvalidInt().create((Object)reader);
                }
                reader.expect(' ');
                if (!reader.canRead()) {
                    throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.readerExpectedInt().create();
                }
                try {
                    color = reader.readInt();
                }
                catch (Exception e) {
                    throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.readerInvalidInt().create((Object)reader);
                }
                reader.expect(' ');
                if (!reader.canRead()) {
                    throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.readerExpectedInt().create();
                }
                try {
                    alpha = reader.readFloat();
                }
                catch (Exception e) {
                    throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.readerInvalidInt().create((Object)reader);
                }
                return new Option(entityId, color, alpha);
            }
        };
        private final int entityId;
        private final int color;
        private final Entity entity;
        private float alpha;

        public Option(int entityId, int color, float alpha) {
            this.entityId = entityId;
            this.entity = null;
            this.color = color;
            this.alpha = alpha;
        }

        public Option(Entity entity, int color, float alpha) {
            this.entity = entity;
            this.entityId = entity.m_142049_();
            this.color = color;
            this.alpha = alpha;
        }

        public static Codec<Option> codec(ParticleType<Option> type) {
            return RecordCodecBuilder.create(builder -> builder.group((App)Codec.INT.fieldOf("entity").forGetter(Option::getEntityId), (App)Codec.INT.fieldOf("color").forGetter(Option::getColorAsInt), (App)Codec.FLOAT.fieldOf("alpha").forGetter(Option::getColorAlpha)).apply((Applicative)builder, Option::new));
        }

        public int getEntityId() {
            return this.entityId;
        }

        public int getColorAsInt() {
            return this.color;
        }

        public Color3 getColorAsColor3() {
            return Color3.fromInt((int)this.color);
        }

        @NotNull
        public ParticleType<?> m_6012_() {
            return (ParticleType)ChangedAddonParticleTypes.LASER_POINT.get();
        }

        public void m_7711_(FriendlyByteBuf buffer) {
            buffer.writeInt(this.entityId);
            buffer.writeInt(this.getColorAsInt());
            buffer.writeFloat(this.getColorAlpha());
        }

        @NotNull
        public String m_5942_() {
            return "EntityId:" + this.entityId + " ,Color:" + this.color;
        }

        public float getColorAlpha() {
            return this.alpha;
        }

        public void setColorAlpha(float alpha) {
            this.alpha = alpha;
        }
    }

    public static class Provider
    implements ParticleProvider<Option> {
        protected final SpriteSet sprite;

        public Provider(SpriteSet p_106394_) {
            this.sprite = p_106394_;
        }

        @Nullable
        public Particle createParticle(@NotNull Option type, @NotNull ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new LaserPointParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, type, this.sprite);
        }
    }
}

