/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.effect.particles;

import javax.annotation.Nullable;
import net.foxyas.changedaddon.effect.particles.ThunderSparkOption;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import org.jetbrains.annotations.NotNull;

public class ThunderSparkParticle
extends TextureSheetParticle {
    private final SpriteSet spriteSet;
    private final int delay;

    public ThunderSparkParticle(ClientLevel level, double x, double y, double z, double dx, double dy, double dz, ThunderSparkOption sparkData, SpriteSet sprites) {
        super(level, x, y, z, dx, dy, dz);
        this.spriteSet = sprites;
        this.f_107224_ = 0;
        this.m_107250_(0.3f, 0.3f);
        this.f_107225_ = Math.max(1, 15 * sparkData.getEnergyCharge() + (this.f_107223_.nextInt(6) - 3));
        this.f_107226_ = 0.0f;
        this.f_107219_ = true;
        this.f_107215_ = dx * 1.0;
        this.f_107216_ = dy * 1.0;
        this.f_107217_ = dz * 1.0;
        this.delay = 2 * sparkData.getEnergyCharge();
        this.m_108339_(this.spriteSet);
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        this.f_107212_ += (this.f_107223_.nextDouble() - 0.5) * 0.02 * this.f_107215_;
        this.f_107213_ += (this.f_107223_.nextDouble() - 0.5) * 0.02 * this.f_107216_;
        this.f_107214_ += (this.f_107223_.nextDouble() - 0.5) * 0.02 * this.f_107217_;
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        } else {
            int delay = this.delay;
            int spriteIndex = this.f_107224_ / delay % 9;
            this.m_108337_(this.spriteSet.m_5819_(spriteIndex, 9));
            this.f_107230_ = 1.0f - (float)this.f_107224_ / (float)this.f_107225_;
        }
    }

    public int m_6355_(float p_105562_) {
        return 0xF000F0;
    }

    @NotNull
    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public static class Provider
    implements ParticleProvider<ThunderSparkOption> {
        protected final SpriteSet sprite;

        public Provider(SpriteSet p_106394_) {
            this.sprite = p_106394_;
        }

        @Nullable
        public Particle createParticle(@NotNull ThunderSparkOption type, @NotNull ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new ThunderSparkParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, type, this.sprite);
        }
    }
}

