/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.enchantment;

import java.util.List;
import net.foxyas.changedaddon.init.ChangedAddonEnchantments;
import net.ltxprogrammer.changed.ability.IAbstractChangedEntity;
import net.ltxprogrammer.changed.entity.ChangedEntity;
import net.ltxprogrammer.changed.entity.TransfurCause;
import net.ltxprogrammer.changed.entity.TransfurContext;
import net.ltxprogrammer.changed.entity.variant.TransfurVariant;
import net.ltxprogrammer.changed.entity.variant.TransfurVariantInstance;
import net.ltxprogrammer.changed.init.ChangedAttributes;
import net.ltxprogrammer.changed.init.ChangedTags;
import net.ltxprogrammer.changed.process.ProcessTransfur;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TransfurAspectEnchantment
extends Enchantment {
    public TransfurAspectEnchantment(EquipmentSlot ... pApplicableSlots) {
        super(Enchantment.Rarity.RARE, EnchantmentCategory.WEAPON, pApplicableSlots);
    }

    public void m_7675_(@NotNull LivingEntity pTarget, @NotNull Entity pAttacker, int pLevel) {
        super.m_7675_(pTarget, pAttacker, pLevel);
    }

    public int m_6586_() {
        return 5;
    }

    public int m_7205_(int pLevel, @NotNull DamageSource pSource) {
        return super.m_7205_(pLevel, pSource);
    }

    public boolean canApplyAtEnchantingTable(@NotNull ItemStack itemstack) {
        return super.canApplyAtEnchantingTable(itemstack) || itemstack.m_41720_() instanceof SwordItem || itemstack.m_41720_() instanceof AxeItem;
    }

    public boolean m_6081_(@NotNull ItemStack itemstack) {
        return super.m_6081_(itemstack) || itemstack.m_41720_() instanceof SwordItem || itemstack.m_41720_() instanceof AxeItem;
    }

    public void m_7677_(@NotNull LivingEntity pAttacker, @NotNull Entity pTarget, int pLevel) {
        super.m_7677_(pAttacker, pTarget, pLevel);
        if (pAttacker.m_183503_().m_5776_()) {
            return;
        }
        if (!(pAttacker instanceof Player)) {
            if (pAttacker instanceof ChangedEntity) {
                ChangedEntity changedEntity = (ChangedEntity)pAttacker;
                if (!(pTarget instanceof LivingEntity)) {
                    return;
                }
                LivingEntity livingEntity = (LivingEntity)pTarget;
                TransfurVariant variant = changedEntity.getSelfVariant();
                if (variant == null) {
                    return;
                }
                boolean isLatex = changedEntity.m_6095_().m_204039_(ChangedTags.EntityTypes.LATEX);
                if (!isLatex) {
                    return;
                }
                IAbstractChangedEntity iAbstractChangedEntity = IAbstractChangedEntity.forEntity((ChangedEntity)changedEntity);
                TransfurCause[] causes = TransfurCause.values();
                TransfurCause randomCause = causes[changedEntity.m_21187_().nextInt(causes.length)];
                TransfurContext context = new TransfurContext(randomCause, iAbstractChangedEntity);
                float transfurDamage = TransfurAspectEnchantment.getTransfurDamage((LivingEntity)changedEntity, (Entity)livingEntity, pLevel);
                if (transfurDamage <= 0.0f) {
                    return;
                }
                ProcessTransfur.progressTransfur((LivingEntity)livingEntity, (float)transfurDamage, (TransfurVariant)variant, (TransfurContext)context);
                return;
            }
            return;
        }
        Player player = (Player)pAttacker;
        if (!(pTarget instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)pTarget;
        TransfurVariantInstance variant = ProcessTransfur.getPlayerTransfurVariant((Player)player);
        if (variant == null) {
            return;
        }
        boolean isLatex = variant.getChangedEntity().m_6095_().m_204039_(ChangedTags.EntityTypes.LATEX);
        if (!isLatex) {
            return;
        }
        IAbstractChangedEntity changedEntity = IAbstractChangedEntity.forPlayer((Player)player);
        TransfurCause[] causes = TransfurCause.values();
        TransfurCause randomCause = causes[player.m_21187_().nextInt(causes.length)];
        TransfurContext context = new TransfurContext(randomCause, changedEntity);
        float transfurDamage = TransfurAspectEnchantment.getTransfurDamage((LivingEntity)player, (Entity)livingEntity, pLevel);
        if (transfurDamage <= 0.0f) {
            return;
        }
        ProcessTransfur.progressTransfur((LivingEntity)livingEntity, (float)transfurDamage, (TransfurVariant)variant.getParent(), (TransfurContext)context);
    }

    public static float getTransfurDamage(@NotNull LivingEntity attacker, @Nullable Entity target, int enchantLevel) {
        AttributeInstance instance = attacker.m_21051_((Attribute)ChangedAttributes.TRANSFUR_DAMAGE.get());
        if (instance == null) {
            return 0.0f;
        }
        double baseValue = instance.m_22135_();
        return (float)(baseValue * 0.75 * (double)enchantLevel / 4.0);
    }

    @Mod.EventBusSubscriber
    public static class ShowTransfurDmg {
        @SubscribeEvent
        public static void onItemTooltip(ItemTooltipEvent event) {
            ItemStack stack = event.getItemStack();
            List tooltip = event.getToolTip();
            int enchantLevel = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ChangedAddonEnchantments.TRANSFUR_ASPECT.get()), (ItemStack)stack);
            if (enchantLevel <= 0) {
                return;
            }
            if (Screen.m_96638_()) {
                double baseValue = TransfurAspectEnchantment.getTransfurDamage(event.getEntityLiving(), null, enchantLevel);
                double damage = baseValue * 0.75 * (double)enchantLevel / 4.0;
                tooltip.add(new TextComponent("\u00a7r\u00a7e+" + String.format("%.2f", damage) + "\u00a7r Transfur Damage to Humanoids"));
            } else {
                tooltip.add(new TextComponent("Press \u00a7e<Shift>\u00a7r for show tooltip"));
            }
        }
    }
}

