/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.entity.advanced;

import java.awt.Color;
import java.util.List;
import java.util.Objects;
import net.foxyas.changedaddon.entity.defaults.AbstractCanTameSnepChangedEntity;
import net.foxyas.changedaddon.entity.goals.simple.SleepingWithOwnerGoal;
import net.foxyas.changedaddon.entity.interfaces.IDynamicPawColor;
import net.foxyas.changedaddon.init.ChangedAddonEntities;
import net.foxyas.changedaddon.variants.ChangedAddonTransfurVariants;
import net.ltxprogrammer.changed.entity.Gender;
import net.ltxprogrammer.changed.entity.LatexType;
import net.ltxprogrammer.changed.entity.TransfurMode;
import net.ltxprogrammer.changed.entity.variant.TransfurVariant;
import net.ltxprogrammer.changed.init.ChangedAttributes;
import net.ltxprogrammer.changed.process.ProcessTransfur;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import org.jetbrains.annotations.NotNull;

public class LatexSnepEntity
extends AbstractCanTameSnepChangedEntity
implements IDynamicPawColor {
    public boolean WantLoaf = false;
    public Gender gender = Gender.MALE;

    public LatexSnepEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<LatexSnepEntity>)((EntityType)ChangedAddonEntities.LATEX_SNEP.get()), world);
    }

    public LatexSnepEntity(EntityType<LatexSnepEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 0;
        this.setAttributes(this.m_21204_());
        this.m_21557_(false);
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder.m_22268_((Attribute)ChangedAttributes.TRANSFUR_DAMAGE.get(), 3.0);
        builder = builder.m_22268_(Attributes.f_22279_, 0.3);
        builder = builder.m_22268_(Attributes.f_22276_, 10.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 3.0);
        builder = builder.m_22268_(Attributes.f_22277_, 16.0);
        return builder;
    }

    protected void setAttributes(AttributeMap attributes) {
        Objects.requireNonNull(attributes.m_22146_((Attribute)ChangedAttributes.TRANSFUR_DAMAGE.get())).m_22100_(3.0);
        attributes.m_22146_(Attributes.f_22276_).m_22100_(10.0);
        attributes.m_22146_(Attributes.f_22277_).m_22100_(16.0);
        attributes.m_22146_(Attributes.f_22279_).m_22100_((double)1.15f);
        attributes.m_22146_((Attribute)ForgeMod.SWIM_SPEED.get()).m_22100_(1.0);
        attributes.m_22146_(Attributes.f_22281_).m_22100_(3.0);
        attributes.m_22146_(Attributes.f_22284_).m_22100_(0.0);
        attributes.m_22146_(Attributes.f_22285_).m_22100_(0.0);
        attributes.m_22146_(Attributes.f_22278_).m_22100_(0.0);
    }

    public TransfurVariant<?> getSelfVariant() {
        return (TransfurVariant)ChangedAddonTransfurVariants.LATEX_SNEP.get();
    }

    public boolean WantToLoaf() {
        return this.WantLoaf;
    }

    @Override
    protected boolean targetSelectorTest(LivingEntity livingEntity) {
        return false;
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("wantLoaf")) {
            this.WantLoaf = tag.m_128471_("wantLoaf");
        }
    }

    @Override
    public boolean isBiped() {
        return false;
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("wantLoaf", this.WantLoaf);
    }

    public LatexType getLatexType() {
        return LatexType.NEUTRAL;
    }

    public TransfurMode getTransfurMode() {
        return TransfurMode.NONE;
    }

    public Gender getGender() {
        return this.gender;
    }

    @NotNull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(5, (Goal)new SleepingWithOwnerGoal((LivingEntity)this));
    }

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public double m_6049_() {
        return super.m_6049_();
    }

    @NotNull
    public SoundEvent m_7975_(@NotNull DamageSource ds) {
        return SoundEvents.f_12172_;
    }

    @NotNull
    public SoundEvent m_5592_() {
        return SoundEvents.f_12174_;
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        if (source == DamageSource.f_19315_) {
            return false;
        }
        if (source == DamageSource.f_146701_) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public boolean isItemAllowedInSlot(ItemStack stack, EquipmentSlot slot) {
        if (slot.m_20743_() == EquipmentSlot.Type.ARMOR) {
            return false;
        }
        return super.isItemAllowedInSlot(stack, slot);
    }

    public InteractionResult LatexSnepInteraction(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (this.f_19853_.f_46443_) {
            boolean flag = this.isOwnedBy((LivingEntity)player) || this.isTame() || this.isTameItem(itemstack) && !this.isTame();
            return flag ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (!this.isTame() && this.isTameItem(itemstack)) {
            boolean isTransfur;
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            if (!(isTransfur = ProcessTransfur.isPlayerTransfurred((Player)player)) && this.f_19796_.nextInt(3) == 0) {
                this.tame(player);
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                this.f_19853_.m_7605_((Entity)this, (byte)7);
            } else if (isTransfur && this.f_19796_.nextInt(6) == 0) {
                this.tame(player);
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                this.f_19853_.m_7605_((Entity)this, (byte)7);
            } else {
                this.f_19853_.m_7605_((Entity)this, (byte)6);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    @Override
    @NotNull
    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        return this.LatexSnepInteraction(player, hand);
    }

    public void m_5802_(BlockPos pos) {
        List entities = this.f_19853_.m_45976_(Entity.class, new AABB(pos).m_82400_(1.0));
        boolean isEntityOnBed = entities.stream().anyMatch(e -> e instanceof Player && this.getOwner() == e && e.m_142538_().equals((Object)pos));
        if (isEntityOnBed) {
            this.m_5496_(SoundEvents.f_11792_, 1.0f, 1.0f);
        }
        super.m_5802_(pos);
    }

    public boolean m_6573_(@NotNull Player p_21418_) {
        return !this.m_21523_();
    }

    @Override
    public Color getPawBeansColor() {
        return Color.decode("#fdfdfd");
    }

    @Override
    public Color getPawColor() {
        return Color.decode("#969696");
    }
}

