/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.entity.advanced;

import java.util.List;
import net.foxyas.changedaddon.entity.advanced.handle.VoidTransformationHandler;
import net.foxyas.changedaddon.entity.defaults.AbstractBasicOrganicChangedEntity;
import net.foxyas.changedaddon.entity.interfaces.CustomPatReaction;
import net.foxyas.changedaddon.init.ChangedAddonEntities;
import net.foxyas.changedaddon.init.ChangedAddonMobEffects;
import net.foxyas.changedaddon.init.ChangedAddonTags;
import net.foxyas.changedaddon.procedures.CreatureDietsHandleProcedure;
import net.foxyas.changedaddon.util.ColorUtil;
import net.foxyas.changedaddon.util.FoxyasUtils;
import net.foxyas.changedaddon.util.ParticlesUtil;
import net.foxyas.changedaddon.variants.VariantExtraStats;
import net.ltxprogrammer.changed.ability.IAbstractChangedEntity;
import net.ltxprogrammer.changed.entity.ChangedEntity;
import net.ltxprogrammer.changed.entity.PowderSnowWalkable;
import net.ltxprogrammer.changed.entity.TransfurCause;
import net.ltxprogrammer.changed.entity.variant.TransfurVariantInstance;
import net.ltxprogrammer.changed.init.ChangedAttributes;
import net.ltxprogrammer.changed.init.ChangedItems;
import net.ltxprogrammer.changed.init.ChangedTags;
import net.ltxprogrammer.changed.process.ProcessTransfur;
import net.ltxprogrammer.changed.util.Color3;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PlayMessages;

public class LuminaraFlowerBeastEntity
extends AbstractBasicOrganicChangedEntity
implements VariantExtraStats,
CustomPatReaction,
PowderSnowWalkable {
    private static final EntityDataAccessor<Boolean> AWAKENED = SynchedEntityData.m_135353_(LuminaraFlowerBeastEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> HYPER_AWAKENED = SynchedEntityData.m_135353_(LuminaraFlowerBeastEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private boolean attributesApplied;
    private boolean attributesAppliedEntity;
    public boolean spawnParticles = true;
    public static final CreatureDietsHandleProcedure.DietType LUMINARA_DIET = CreatureDietsHandleProcedure.DietType.create("LUMINARA", ChangedAddonTags.TransfurTypes.DRAGON_LIKE, ChangedAddonTags.Items.DRAGON_DIET, List.of(Items.f_42730_, (Item)ChangedItems.ORANGE.get()));

    public LuminaraFlowerBeastEntity(PlayMessages.SpawnEntity ignoredPacket, Level world) {
        this((EntityType<? extends ChangedEntity>)((EntityType)ChangedAddonEntities.LUMINARA_FLOWER_BEAST.get()), world);
    }

    public LuminaraFlowerBeastEntity(EntityType<? extends ChangedEntity> type, Level level) {
        super(type, level);
    }

    public Vec3 getMouthPosition() {
        return this.m_146892_().m_82492_(0.0, 0.25, 0.0);
    }

    @Override
    protected void setAttributes(AttributeMap attributes) {
        this.safeSetBaseValue(attributes.m_22146_((Attribute)ChangedAttributes.TRANSFUR_DAMAGE.get()), 1.0);
        this.safeSetBaseValue(attributes.m_22146_(Attributes.f_22276_), 22.0);
        this.safeSetBaseValue(attributes.m_22146_(Attributes.f_22277_), 40.0);
        this.safeSetBaseValue(attributes.m_22146_(Attributes.f_22279_), 1.0);
        this.safeSetBaseValue(attributes.m_22146_((Attribute)ForgeMod.SWIM_SPEED.get()), 1.0);
        this.safeSetBaseValue(attributes.m_22146_(Attributes.f_22281_), 2.0);
        this.safeSetBaseValue(attributes.m_22146_(Attributes.f_22284_), 0.0);
        this.safeSetBaseValue(attributes.m_22146_(Attributes.f_22285_), 0.0);
        this.safeSetBaseValue(attributes.m_22146_(Attributes.f_22278_), 0.0);
        this.safeSetBaseValue(attributes.m_22146_((Attribute)ForgeMod.REACH_DISTANCE.get()), 4.5);
        this.safeSetBaseValue(attributes.m_22146_((Attribute)ForgeMod.ATTACK_RANGE.get()), 3.0);
        this.safeSetBaseValue(attributes.m_22146_(Attributes.f_22282_), 0.0);
    }

    public void setAttributesAwakened(AttributeMap attributes) {
        this.safeSetBaseValue(attributes.m_22146_((Attribute)ChangedAttributes.TRANSFUR_DAMAGE.get()), 5.0);
        this.safeSetBaseValue(attributes.m_22146_(Attributes.f_22276_), 40.0);
        this.safeSetBaseValue(attributes.m_22146_(Attributes.f_22277_), 126.0);
        this.safeSetBaseValue(attributes.m_22146_(Attributes.f_22279_), 1.25);
        this.safeSetBaseValue(attributes.m_22146_((Attribute)ForgeMod.SWIM_SPEED.get()), 1.25);
        this.safeSetBaseValue(attributes.m_22146_(Attributes.f_22281_), 4.0);
        this.safeSetBaseValue(attributes.m_22146_(Attributes.f_22284_), 0.0);
        this.safeSetBaseValue(attributes.m_22146_(Attributes.f_22285_), 0.0);
        this.safeSetBaseValue(attributes.m_22146_(Attributes.f_22278_), 0.0);
    }

    public void setAttributesHyperAwakened(AttributeMap attributes) {
        this.safeSetBaseValue(attributes.m_22146_((Attribute)ChangedAttributes.TRANSFUR_DAMAGE.get()), 7.0);
        this.safeSetBaseValue(attributes.m_22146_(Attributes.f_22281_), 6.0);
        this.safeSetBaseValue(attributes.m_22146_(Attributes.f_22284_), 10.0);
        this.safeSetBaseValue(attributes.m_22146_(Attributes.f_22285_), 6.0);
        this.safeSetBaseValue(attributes.m_22146_((Attribute)ForgeMod.REACH_DISTANCE.get()), 6.0);
        this.safeSetBaseValue(attributes.m_22146_((Attribute)ForgeMod.ATTACK_RANGE.get()), 4.0);
        this.safeSetBaseValue(attributes.m_22146_(Attributes.f_22282_), 2.0);
    }

    @Override
    public List<CreatureDietsHandleProcedure.DietType> getExtraDietTypes() {
        return List.of(LUMINARA_DIET);
    }

    @Override
    public void WhenPatEvent(LivingEntity patter, InteractionHand hand, LivingEntity patTarget) {
        if (patter.m_183503_().m_5776_()) {
            return;
        }
        MobEffectInstance effect = this.getPatEffect(patter);
        if (patTarget instanceof Player) {
            Player player = (Player)patTarget;
            patTarget.m_147207_(effect, (Entity)patter);
        } else if (patTarget instanceof ChangedEntity) {
            ChangedEntity changedEntity = (ChangedEntity)patTarget;
            changedEntity.m_147207_(effect, (Entity)patter);
        }
    }

    @Override
    public void WhenPattedReaction(Player patter, InteractionHand hand) {
        if (patter.m_183503_().m_5776_()) {
            return;
        }
        MobEffectInstance effect = this.getPatEffect((LivingEntity)this);
        patter.m_147207_(effect, (Entity)this);
    }

    @Override
    public float getFlySpeed() {
        return 0.075f;
    }

    private MobEffectInstance getPatEffect(LivingEntity patter) {
        if (!this.isAwakened()) {
            return new MobEffectInstance((MobEffect)ChangedAddonMobEffects.PACIFIED.get(), 600);
        }
        if (!patter.m_6144_()) {
            return new MobEffectInstance((MobEffect)ChangedAddonMobEffects.PACIFIED.get(), 600);
        }
        return new MobEffectInstance((MobEffect)ChangedAddonMobEffects.UNTRANSFUR.get(), 600);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(AWAKENED, (Object)false);
        this.f_19804_.m_135372_(HYPER_AWAKENED, (Object)false);
    }

    public boolean isAwakened() {
        return (Boolean)this.f_19804_.m_135370_(AWAKENED);
    }

    public void setAwakened(boolean value) {
        this.f_19804_.m_135381_(AWAKENED, (Object)value);
    }

    public boolean isHyperAwakened() {
        return (Boolean)this.f_19804_.m_135370_(HYPER_AWAKENED);
    }

    public void setHyperAwakened(boolean value) {
        this.f_19804_.m_135381_(HYPER_AWAKENED, (Object)value);
    }

    public void applyAwakenedBuffs() {
        this.setAttributesAwakened(this.m_21204_());
        if (this.isHyperAwakened()) {
            this.setAttributesHyperAwakened(this.m_21204_());
        }
        this.attributesApplied = true;
        IAbstractChangedEntity.forEitherSafe((Entity)this.maybeGetUnderlying()).map(IAbstractChangedEntity::getTransfurVariantInstance).ifPresent(TransfurVariantInstance::refreshAttributes);
    }

    public void removeAwakenedBuffs() {
        this.setAttributes(this.m_21204_());
        this.attributesApplied = false;
        IAbstractChangedEntity.forEitherSafe((Entity)this.maybeGetUnderlying()).map(IAbstractChangedEntity::getTransfurVariantInstance).ifPresent(TransfurVariantInstance::refreshAttributes);
    }

    public void variantTick(Level level) {
        super.variantTick(level);
        Player player = this.getUnderlyingPlayer();
        if (player != null) {
            if (this.isAwakened()) {
                if (this.isHyperAwakened() && this.spawnParticles) {
                    this.spawnHyperAwakenedParticles();
                }
                this.tryToPacifyNearbyEntities(128.0);
            }
            if (this.isAwakened() && !this.attributesApplied) {
                this.applyAwakenedBuffs();
            } else if (!this.isAwakened() && this.attributesApplied) {
                this.removeAwakenedBuffs();
            }
        } else {
            AttributeInstance attributeInstance = this.m_21051_(Attributes.f_22277_);
            double range = 32.0;
            if (attributeInstance != null) {
                range = attributeInstance.m_22135_();
            }
            this.tryToPacifyNearbyEntities(range);
        }
    }

    private void spawnHyperAwakenedParticles() {
        double offsetX = 0.25;
        double offsetY = 0.25;
        double offsetZ = 0.25;
        Vec3 offset = new Vec3(offsetX, offsetY, offsetZ);
        double x = this.f_19796_.nextGaussian() * offset.f_82479_;
        double y = this.f_19796_.nextGaussian() * offset.f_82480_;
        double z = this.f_19796_.nextGaussian() * offset.f_82481_;
        Vec3 pos = this.m_20182_().m_82520_(0.0, 0.5, 0.0).m_82520_(x, y, z);
        Vec3 motion = this.m_146892_().m_82546_(pos);
        if (this.f_19796_.nextInt(10) == 0) {
            ParticlesUtil.sendParticles(this.m_183503_(), (ParticleOptions)ParticleTypes.f_123760_, this.m_20182_().m_82520_(0.0, (double)(this.m_20206_() / 2.0f), 0.0), (float)offsetX, (float)offsetY, (float)offsetZ, 6, 1.0f);
        }
        if (this.f_19796_.nextInt(20) == 0) {
            ParticlesUtil.sendParticlesWithMotion((LivingEntity)this, (ParticleOptions)ParticleTypes.f_123810_, this.m_146892_(), new Vec3(offsetX, offsetY, offsetZ), new Vec3(0.0, 0.08 + this.f_19796_.nextDouble() * 0.05, 0.0), 2, 0.05f);
        }
    }

    public void m_6075_() {
        super.m_6075_();
        if (this.isHyperAwakened() && this.spawnParticles) {
            this.spawnHyperAwakenedParticles();
        }
        AttributeInstance attributeInstance = this.m_21051_(Attributes.f_22277_);
        double range = 32.0;
        if (attributeInstance != null) {
            range = attributeInstance.m_22135_();
        }
        this.tryToPacifyNearbyEntities(range);
        if (this.isAwakened() && !this.attributesAppliedEntity) {
            this.setAttributesAwakened(this.m_21204_());
            if (this.isHyperAwakened()) {
                this.setAttributesHyperAwakened(this.m_21204_());
            }
            this.attributesAppliedEntity = true;
        } else if (!this.isAwakened() && this.attributesAppliedEntity) {
            this.setAttributes(this.m_21204_());
            this.attributesAppliedEntity = false;
        }
    }

    public void tryToPacifyNearbyEntities(double range) {
        List nearChangedBeasts = this.m_183503_().m_6443_(LivingEntity.class, this.m_142469_().m_82400_(range), entity -> FoxyasUtils.canEntitySeeOtherIgnoreGlass(entity, (LivingEntity)this, 90.0));
        for (LivingEntity livingEntity : nearChangedBeasts) {
            Player player;
            TransfurVariantInstance instance;
            if (livingEntity instanceof ChangedEntity) {
                ChangedEntity changedEntity = (ChangedEntity)livingEntity;
                if (changedEntity.m_6095_().m_204039_(ChangedAddonTags.EntityTypes.PACIFY_IMMUNE) || changedEntity instanceof LuminaraFlowerBeastEntity || !changedEntity.m_6095_().m_204039_(ChangedTags.EntityTypes.LATEX) || changedEntity.m_21023_((MobEffect)ChangedAddonMobEffects.PACIFIED.get())) continue;
                changedEntity.m_7292_(new MobEffectInstance((MobEffect)ChangedAddonMobEffects.PACIFIED.get(), 1200, 0, true, false, true));
                continue;
            }
            if (!(livingEntity instanceof Player) || (instance = ProcessTransfur.getPlayerTransfurVariant((Player)(player = (Player)livingEntity))) == null || instance.getChangedEntity().m_6095_().m_204039_(ChangedAddonTags.EntityTypes.PACIFY_IMMUNE) || instance.getChangedEntity() instanceof LuminaraFlowerBeastEntity || !instance.getParent().getEntityType().m_204039_(ChangedTags.EntityTypes.LATEX) || player.m_21023_((MobEffect)ChangedAddonMobEffects.PACIFIED.get())) continue;
            player.m_7292_(new MobEffectInstance((MobEffect)ChangedAddonMobEffects.PACIFIED.get(), 1200, 0, true, false, true));
        }
    }

    public CompoundTag savePlayerVariantData() {
        CompoundTag tag = super.savePlayerVariantData();
        this.saveExtraData(tag);
        return tag;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        this.saveExtraData(tag);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.readExtraData(tag);
    }

    public void readPlayerVariantData(CompoundTag tag) {
        super.readPlayerVariantData(tag);
        this.readExtraData(tag);
    }

    @Override
    public void saveExtraData(CompoundTag tag) {
        tag.m_128379_("Awakened", this.isAwakened());
        tag.m_128379_("HyperAwakened", this.isHyperAwakened());
    }

    @Override
    public void readExtraData(CompoundTag tag) {
        if (tag.m_128441_("Awakened")) {
            this.setAwakened(tag.m_128471_("Awakened"));
        }
        if (tag.m_128441_("HyperAwakened")) {
            this.setHyperAwakened(tag.m_128471_("HyperAwakened"));
        }
    }

    @Override
    public VariantExtraStats.FlyType getFlyType() {
        return this.isAwakened() ? VariantExtraStats.FlyType.BOTH : VariantExtraStats.FlyType.NONE;
    }

    public Color3 getTransfurColor(TransfurCause cause) {
        Color3 firstColor = Color3.getColor((String)"#f5d4ef");
        Color3 secondColor = Color3.getColor((String)"#241942");
        return ColorUtil.lerpTFColor(firstColor, secondColor, this.getUnderlyingPlayer());
    }

    @Mod.EventBusSubscriber
    public static class TransfurEvolveEventsHandle {
        @SubscribeEvent
        public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
            if (event.phase == TickEvent.Phase.END) {
                VoidTransformationHandler.handlePlayerVoid(event.player);
            }
        }

        @SubscribeEvent
        public static void onLivingDamage(LivingDamageEvent event) {
            VoidTransformationHandler.handleVoidDamage(event);
        }
    }
}

