/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.entity.advanced;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Predicate;
import net.foxyas.changedaddon.entity.defaults.AbstractCanTameChangedEntity;
import net.foxyas.changedaddon.entity.goals.prototype.ApplyBonemealGoal;
import net.foxyas.changedaddon.entity.goals.prototype.FindAndHarvestCropsGoal;
import net.foxyas.changedaddon.entity.goals.prototype.FindChestGoal;
import net.foxyas.changedaddon.entity.goals.prototype.GotoTargetChestGoal;
import net.foxyas.changedaddon.entity.goals.prototype.PlantSeedsGoal;
import net.foxyas.changedaddon.entity.goals.prototype.PruningOrangeLeavesGoal;
import net.foxyas.changedaddon.entity.goals.prototype.TryGrabItemsGoal;
import net.foxyas.changedaddon.entity.interfaces.CustomPatReaction;
import net.foxyas.changedaddon.entity.interfaces.IDynamicPawColor;
import net.foxyas.changedaddon.init.ChangedAddonEntities;
import net.foxyas.changedaddon.menu.PrototypeMenu;
import net.foxyas.changedaddon.util.ColorUtil;
import net.foxyas.changedaddon.util.DynamicClipContext;
import net.foxyas.changedaddon.util.FoxyasUtils;
import net.foxyas.changedaddon.variants.ChangedAddonTransfurVariants;
import net.ltxprogrammer.changed.ability.IAbstractChangedEntity;
import net.ltxprogrammer.changed.entity.ChangedEntity;
import net.ltxprogrammer.changed.entity.EyeStyle;
import net.ltxprogrammer.changed.entity.TransfurCause;
import net.ltxprogrammer.changed.entity.TransfurMode;
import net.ltxprogrammer.changed.entity.variant.TransfurVariant;
import net.ltxprogrammer.changed.entity.variant.TransfurVariantInstance;
import net.ltxprogrammer.changed.init.ChangedAttributes;
import net.ltxprogrammer.changed.init.ChangedBlocks;
import net.ltxprogrammer.changed.process.ProcessTransfur;
import net.ltxprogrammer.changed.util.Color3;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.EntityArmorInvWrapper;
import net.minecraftforge.items.wrapper.EntityHandsInvWrapper;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrototypeEntity
extends AbstractCanTameChangedEntity
implements InventoryCarrier,
MenuProvider,
CustomPatReaction,
IDynamicPawColor {
    public static final int MAX_HARVEST_TIMES = 32;
    private final SimpleContainer inventory = new SimpleContainer(9);
    private final MenuProvider menuProvider = new MenuProvider(){

        @NotNull
        public Component m_5446_() {
            return PrototypeEntity.this.m_5446_();
        }

        @Nullable
        public AbstractContainerMenu m_7208_(int i, @NotNull Inventory inventory, @NotNull Player player) {
            return PrototypeEntity.this.m_7208_(i, inventory, player);
        }
    };
    private int harvestsTimes = 0;
    private DepositeType depositeType = DepositeType.BOTH;
    @Nullable
    private BlockPos targetChestPos = null;
    private final IItemHandlerModifiable combinedInv;

    public PrototypeEntity(PlayMessages.SpawnEntity ignoredPacket, Level world) {
        this((EntityType<PrototypeEntity>)((EntityType)ChangedAddonEntities.PROTOTYPE.get()), world);
    }

    public PrototypeEntity(EntityType<PrototypeEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 0;
        this.m_21530_();
        this.combinedInv = new CombinedInvWrapper(new IItemHandlerModifiable[]{new EntityArmorInvWrapper((LivingEntity)this), new EntityHandsInvWrapper((LivingEntity)this), new InvWrapper((Container)this.inventory)});
    }

    public IItemHandlerModifiable getCombinedInv() {
        return this.combinedInv;
    }

    protected float m_21519_(@NotNull EquipmentSlot pSlot) {
        return 2.0f;
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = ChangedEntity.createLatexAttributes();
        builder = builder.m_22268_((Attribute)ChangedAttributes.TRANSFUR_DAMAGE.get(), 0.0);
        builder = builder.m_22268_(Attributes.f_22279_, 0.3);
        builder = builder.m_22268_(Attributes.f_22276_, 24.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 3.0);
        builder = builder.m_22268_(Attributes.f_22277_, 16.0);
        return builder;
    }

    @Override
    protected void setAttributes(AttributeMap attributes) {
        Objects.requireNonNull(attributes.m_22146_((Attribute)ChangedAttributes.TRANSFUR_DAMAGE.get())).m_22100_(0.0);
        attributes.m_22146_(Attributes.f_22276_).m_22100_(24.0);
        attributes.m_22146_(Attributes.f_22277_).m_22100_(40.0);
        attributes.m_22146_(Attributes.f_22279_).m_22100_((double)1.05f);
        attributes.m_22146_((Attribute)ForgeMod.SWIM_SPEED.get()).m_22100_((double)0.95f);
        attributes.m_22146_(Attributes.f_22281_).m_22100_(3.0);
        attributes.m_22146_(Attributes.f_22284_).m_22100_(0.0);
        attributes.m_22146_(Attributes.f_22285_).m_22100_(0.0);
        attributes.m_22146_(Attributes.f_22278_).m_22100_(0.0);
    }

    @Override
    public void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(50, (Goal)new FindAndHarvestCropsGoal(this));
        this.f_21345_.m_25352_(15, (Goal)new TryGrabItemsGoal(this));
        this.f_21345_.m_25352_(10, (Goal)new FindChestGoal(this));
        this.f_21345_.m_25352_(30, (Goal)new GotoTargetChestGoal(this));
        this.f_21345_.m_25352_(30, (Goal)new PlantSeedsGoal(this));
        this.f_21345_.m_25352_(30, (Goal)new ApplyBonemealGoal(this));
        this.f_21345_.m_25352_(50, (Goal)new PruningOrangeLeavesGoal(this));
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128365_("Inventory", (Tag)this.inventory.m_7927_());
        tag.m_128405_("harvestDone", this.harvestsTimes);
        tag.m_128359_("DepositeType", this.depositeType.toString().toLowerCase(Locale.ROOT));
        if (this.targetChestPos != null) {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128405_("targetX", this.targetChestPos.m_123341_());
            nbt.m_128405_("targetY", this.targetChestPos.m_123342_());
            nbt.m_128405_("targetZ", this.targetChestPos.m_123343_());
            tag.m_128365_("TargetChestPos", (Tag)nbt);
        }
    }

    @Override
    public void WhenPattedReaction(Player patter, InteractionHand hand) {
        CustomPatReaction.super.WhenPattedReaction(patter, hand);
        if (!patter.f_19853_.m_5776_()) {
            if (!this.isTame()) {
                this.tame(patter);
            } else {
                InteractionResult interactionresult = super.m_6071_(patter, hand);
                if ((!interactionresult.m_19077_() || this.m_6162_()) && this.isOwnedBy((LivingEntity)patter)) {
                    boolean shouldFollow = !this.isFollowingOwner();
                    this.setFollowOwner(shouldFollow);
                    patter.m_5661_((Component)new TranslatableComponent(shouldFollow ? "text.changed.tamed.follow" : "text.changed.tamed.wander", new Object[]{this.m_5446_()}), false);
                    this.f_20899_ = false;
                    this.f_21344_.m_26573_();
                    this.m_6710_(null);
                }
            }
        }
    }

    protected boolean m_8028_() {
        return false;
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.inventory.m_7797_(tag.m_128437_("Inventory", 10));
        if (tag.m_128441_("harvestDone")) {
            this.harvestsTimes = tag.m_128451_("harvestsTimes");
        }
        if (tag.m_128441_("DepositeType")) {
            this.depositeType = DepositeType.valueOf(tag.m_128461_("DepositeType").toUpperCase());
        }
        if (tag.m_128441_("TargetChestPos")) {
            CompoundTag nbt = tag.m_128469_("TargetChestPos");
            int x = nbt.m_128451_("targetX");
            int y = nbt.m_128451_("targetY");
            int z = nbt.m_128451_("targetZ");
            this.targetChestPos = new BlockPos(x, y, z);
        }
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    @Override
    protected boolean targetSelectorTest(LivingEntity livingEntity) {
        return false;
    }

    public boolean tryTransfurTarget(Entity entity) {
        return false;
    }

    public boolean tryAbsorbTarget(LivingEntity target, IAbstractChangedEntity source, float amount, @Nullable List<TransfurVariant<?>> possibleMobFusions) {
        return false;
    }

    public TransfurMode getTransfurMode() {
        return TransfurMode.NONE;
    }

    public Color3 getTransfurColor(TransfurCause cause) {
        Color3 firstColor = Color3.getColor((String)"#AEBBF7");
        Color3 secondColor = Color3.getColor((String)"#71FFFF");
        return ColorUtil.lerpTFColor(firstColor, secondColor, this.getUnderlyingPlayer());
    }

    @Nullable
    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor pLevel, @NotNull DifficultyInstance pDifficulty, @NotNull MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        SpawnGroupData ret = super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        this.getBasicPlayerInfo().setEyeStyle(EyeStyle.TALL);
        this.getBasicPlayerInfo().setRightIrisColor(Color3.getColor((String)"#59c5ff"));
        this.getBasicPlayerInfo().setLeftIrisColor(Color3.getColor((String)"#59c5ff"));
        return ret;
    }

    @NotNull
    public InteractionResult m_7111_(@NotNull Player player, @NotNull Vec3 vec, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (!player.m_6144_()) {
            if (!this.m_183503_().f_46443_) {
                this.depositeType = this.depositeType.switchDepositeType();
            }
            player.m_5661_((Component)new TranslatableComponent("entity.changed_addon.prototype.deposite_type.switch", new Object[]{this.depositeType.getFormatedName()}), true);
        } else if (!this.m_183503_().f_46443_) {
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)this.getMenuProvider(), buf -> buf.m_130130_(this.m_142049_()));
        }
        if (this.isTame() && this.isTame() && this.isTameItem(itemstack) && this.m_21223_() < this.m_21233_()) {
            itemstack.m_41774_(1);
            this.m_5634_(2.0f);
            Level level = this.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel _level = (ServerLevel)level;
                _level.m_8767_((ParticleOptions)ParticleTypes.f_123750_, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), 7, 0.3, 0.3, 0.3, 1.0);
            }
            this.m_146859_(GameEvent.f_157771_, this.m_146901_());
            return InteractionResult.SUCCESS;
        }
        player.m_6674_(hand);
        if (!this.m_183503_().f_46443_) {
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6075_() {
        Level level;
        super.m_6075_();
        if (this.isInventoryFull(itemStacks -> itemStacks.stream().filter(this::m_7066_).count() >= 4L) && this.targetChestPos != null && this.m_142538_().m_123314_((Vec3i)this.targetChestPos, 2.0) && (level = this.m_183503_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.depositToChest(serverLevel, this.targetChestPos);
        }
        if (this.f_19797_ % 120 == 0 && this.harvestsTimes >= 32) {
            this.harvestsTimes = 0;
        }
    }

    @Override
    public boolean isTameItem(ItemStack stack) {
        return stack.m_204117_(Tags.Items.INGOTS_IRON);
    }

    protected void m_6668_(@NotNull DamageSource pDamageSource) {
        super.m_6668_(pDamageSource);
        if (!this.inventory.m_7983_()) {
            for (int i = 0; i < this.inventory.m_6643_(); ++i) {
                this.dropInventoryItems();
            }
        }
    }

    protected void m_5907_() {
        super.m_5907_();
        for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
            ItemStack stack;
            if (equipmentSlot.m_20743_() != EquipmentSlot.Type.HAND || (stack = this.m_6844_(equipmentSlot)).m_41619_()) continue;
            ItemEntity itemEntity = new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), stack.m_41777_());
            itemEntity.m_20334_((this.f_19853_.f_46441_.nextDouble() - 0.5) * 0.2, 0.2, (this.f_19853_.f_46441_.nextDouble() - 0.5) * 0.2);
            this.f_19853_.m_7967_((Entity)itemEntity);
            this.m_8061_(equipmentSlot, ItemStack.f_41583_);
        }
    }

    public boolean m_7066_(@NotNull ItemStack pItemstack) {
        if (pItemstack.m_41619_()) {
            return false;
        }
        if (this.pickAbleItems().contains(pItemstack.m_41720_()) || pItemstack.m_204117_(Tags.Items.CROPS) || pItemstack.m_204117_(PrototypeEntity.tag("fruits")) || pItemstack.m_204117_(Tags.Items.SHEARS) || pItemstack.m_204117_(Tags.Items.SEEDS)) {
            return true;
        }
        return super.m_7066_(pItemstack);
    }

    public boolean m_21531_() {
        return true;
    }

    public boolean m_7243_(@NotNull ItemStack pStack) {
        if (!this.isInventoryAndHandsFull() && (pStack.m_204117_(Tags.Items.CROPS) || pStack.m_204117_(PrototypeEntity.tag("fruits")) || pStack.m_204117_(Tags.Items.SEEDS) || pStack.m_204117_(Tags.Items.SHEARS) || this.pickAbleItems().contains(pStack.m_41720_()))) {
            return true;
        }
        return super.m_7243_(pStack);
    }

    public boolean m_7252_(@NotNull ItemStack pStack) {
        return !this.isInventoryAndHandsFull() && (pStack.m_204117_(Tags.Items.CROPS) || pStack.m_204117_(PrototypeEntity.tag("fruits")) || pStack.m_204117_(Tags.Items.SEEDS) || pStack.m_204117_(Tags.Items.SHEARS) || this.pickAbleItems().contains(pStack.m_41720_()));
    }

    protected void m_7581_(@NotNull ItemEntity pItemEntity) {
        ItemStack pStack = pItemEntity.m_32055_();
        if (pStack.m_204117_(Tags.Items.CROPS) || pStack.m_204117_(PrototypeEntity.tag("fruits")) || pStack.m_204117_(Tags.Items.SEEDS) || pStack.m_204117_(Tags.Items.SHEARS) || this.pickAbleItems().contains(pStack.m_41720_())) {
            this.addToInventory(pStack);
            return;
        }
        super.m_7581_(pItemEntity);
    }

    @NotNull
    public SimpleContainer getInventory() {
        return this.inventory;
    }

    @NotNull
    public Component m_5446_() {
        return this.m_7755_();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, @NotNull Inventory playerInventory, @NotNull Player player) {
        return new PrototypeMenu(id, playerInventory, this);
    }

    public MenuProvider getMenuProvider() {
        return this.menuProvider;
    }

    public boolean isInventoryFull() {
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            if (!this.inventory.m_8020_(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public boolean isInventoryAndHandsFull() {
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            if (!this.inventory.m_8020_(i).m_41619_()) continue;
            return false;
        }
        if (this.m_21205_().m_41619_()) {
            return false;
        }
        return !this.m_21206_().m_41619_();
    }

    public boolean isInventoryFull(Predicate<NonNullList<ItemStack>> listPredicate) {
        NonNullList<ItemStack> itemStacks = this.getInventoryItems();
        return listPredicate.test(itemStacks);
    }

    public NonNullList<ItemStack> getInventoryItems() {
        NonNullList itemStacks = NonNullList.m_122779_();
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            itemStacks.add((Object)this.inventory.m_8020_(i));
        }
        return itemStacks;
    }

    public boolean isInventoryEmpty() {
        return this.inventory.m_7983_();
    }

    public void addToInventory(ItemStack stack) {
        for (int i = 0; i < this.getInventory().m_6643_(); ++i) {
            ItemStack slot = this.getInventory().m_8020_(i);
            if (slot.m_41619_()) {
                this.getInventory().m_6836_(i, stack.m_41777_());
                stack.m_41764_(0);
                return;
            }
            if (!ItemStack.m_150942_((ItemStack)slot, (ItemStack)stack)) continue;
            int canAdd = Math.min(slot.m_41741_() - slot.m_41613_(), stack.m_41613_());
            slot.m_41769_(canAdd);
            stack.m_41774_(canAdd);
            if (!stack.m_41619_()) continue;
            return;
        }
        if (this.isInventoryFull()) {
            for (EquipmentSlot equipmentSlot2 : Arrays.stream(EquipmentSlot.values()).filter(equipmentSlot -> equipmentSlot.m_20743_() == EquipmentSlot.Type.HAND).toList()) {
                ItemStack itemStack = this.m_6844_(equipmentSlot2);
                if (itemStack.m_41619_()) {
                    this.m_8061_(equipmentSlot2, stack);
                    continue;
                }
                if (!ItemStack.m_150942_((ItemStack)itemStack, (ItemStack)stack)) continue;
                itemStack.m_41769_(1);
                stack.m_41774_(1);
            }
        }
    }

    private void dropInventoryItems() {
        Level level = this.f_19853_;
        if (level.f_46443_) {
            return;
        }
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            ItemStack stack = this.inventory.m_8020_(i);
            if (stack.m_41619_()) continue;
            ItemEntity itemEntity = new ItemEntity(level, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), stack.m_41777_());
            itemEntity.m_20334_((level.f_46441_.nextDouble() - 0.5) * 0.2, 0.2, (level.f_46441_.nextDouble() - 0.5) * 0.2);
            level.m_7967_((Entity)itemEntity);
            this.inventory.m_6836_(i, ItemStack.f_41583_);
        }
        this.inventory.m_6596_();
    }

    public BlockPos tryFindNearbyChest(Level level, BlockPos center, int range) {
        ChestBlockEntity chest;
        BlockEntity be;
        ArrayList<ItemStack> carriedItems = new ArrayList<ItemStack>();
        for (int i = 0; i < this.getInventory().m_6643_(); ++i) {
            ItemStack stack = this.getInventory().m_8020_(i);
            if (stack.m_41619_()) continue;
            carriedItems.add(stack);
        }
        BlockPos closestChest = null;
        double closestDist = Double.MAX_VALUE;
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)center.m_142082_(-range, -range, -range), (BlockPos)center.m_142082_(range, range, range))) {
            be = level.m_7702_(pos);
            if (!(be instanceof ChestBlockEntity) || this.isChestFull(chest = (ChestBlockEntity)be)) continue;
            for (int slot = 0; slot < chest.m_6643_(); ++slot) {
                ItemStack chestItem = chest.m_8020_(slot);
                if (chestItem.m_41619_()) continue;
                for (ItemStack carried : carriedItems) {
                    double dist;
                    if (!ItemStack.m_150942_((ItemStack)carried, (ItemStack)chestItem) || !((dist = pos.m_123331_((Vec3i)center)) < closestDist)) continue;
                    closestDist = dist;
                    closestChest = pos.m_7949_();
                }
            }
        }
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)center.m_142082_(-range, -range, -range), (BlockPos)center.m_142082_(range, range, range))) {
            double dist;
            be = level.m_7702_(pos);
            if (!(be instanceof ChestBlockEntity) || this.isChestFull(chest = (ChestBlockEntity)be) || !((dist = pos.m_123331_((Vec3i)center)) < closestDist)) continue;
            closestDist = dist;
            closestChest = pos.m_7949_();
        }
        return closestChest;
    }

    public BlockPos findNearbyCrop(Level level, BlockPos center, int range) {
        BlockPos closestCrop = null;
        double closestDist = Double.MAX_VALUE;
        for (BlockPos pos : FoxyasUtils.betweenClosedStreamSphere(center, range, range).toList()) {
            double dist;
            CropBlock crop;
            BlockState state = level.m_8055_(pos);
            Block block = state.m_60734_();
            if (!(block instanceof CropBlock) || !(crop = (CropBlock)block).m_52307_(state) || !((dist = pos.m_123331_((Vec3i)center)) < closestDist)) continue;
            closestDist = dist;
            closestCrop = pos.m_7949_();
        }
        return closestCrop;
    }

    @Nullable
    public BlockPos findNearbyOrangeLeaves(BlockPos center, int range, Vec3 eyePos, @Nullable Entity viewer) {
        BlockPos best = null;
        double bestDist = Double.MAX_VALUE;
        for (BlockPos pos : FoxyasUtils.betweenClosedStreamSphere(center, range, range)::iterator) {
            BlockHitResult hit;
            double dist;
            BlockState state = this.f_19853_.m_8055_(pos);
            if (!state.m_60713_((Block)ChangedBlocks.ORANGE_TREE_LEAVES.get()) || (dist = eyePos.m_82557_(Vec3.m_82512_((Vec3i)pos))) >= bestDist || (hit = this.f_19853_.m_45547_(this.eyeContext(pos))).m_6662_() != HitResult.Type.BLOCK || !hit.m_82425_().equals((Object)pos)) continue;
            bestDist = dist;
            best = pos.m_7949_();
        }
        return best;
    }

    @NotNull
    private ClipContext eyeContext(BlockPos pos) {
        return new DynamicClipContext(this.m_146892_(), Vec3.m_82512_((Vec3i)pos), DynamicClipContext.IGNORE_TRANSLUCENT, arg_0 -> ((ClipContext.Fluid)ClipContext.Fluid.ANY).m_45731_(arg_0), CollisionContext.m_82750_((Entity)this));
    }

    public void harvestCrop(ServerLevel level, BlockPos pos) {
        CropBlock crop;
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof CropBlock && (crop = (CropBlock)block).m_52307_(state)) {
            ItemStack tool = this.m_21205_();
            Block.m_49881_((BlockState)state, (Level)level, (BlockPos)pos, (BlockEntity)level.m_7702_(pos), (Entity)this, (ItemStack)tool);
            level.m_7731_(pos, crop.m_52289_(0), 3);
            level.m_5594_(null, pos, state.m_60827_().m_56777_(), SoundSource.BLOCKS, 1.0f, 1.0f);
            this.addHarvestsTime();
        }
    }

    private void depositToChest(ServerLevel level, BlockPos chestPos) {
        BlockState state = level.m_8055_(chestPos);
        BlockEntity be = level.m_7702_(chestPos);
        if (!(be instanceof ChestBlockEntity)) {
            this.setTargetChestPos(null);
            return;
        }
        ChestBlockEntity chest = (ChestBlockEntity)be;
        chest.m_5856_((Player)FakePlayerFactory.getMinecraft((ServerLevel)level));
        for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
            if (equipmentSlot.m_20743_() != EquipmentSlot.Type.HAND) continue;
            ItemStack stack = this.m_6844_(equipmentSlot);
            if (!this.isChestFull(chest)) {
                if (stack.m_41619_() || !this.depositeType.isRightType(stack)) continue;
                this.m_7618_(EntityAnchorArgument.Anchor.FEET, new Vec3((double)chestPos.m_123341_(), (double)(chestPos.m_123342_() - 1), (double)chestPos.m_123343_()));
                this.m_6674_(this.m_21526_() ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND);
                ItemStack remaining = HopperBlockEntity.m_59326_(null, (Container)chest, (ItemStack)stack, null);
                chest.m_6596_();
                this.m_8061_(equipmentSlot, remaining);
                this.getInventory().m_6596_();
                chest.m_7531_(1, 1);
                if (!(state.m_60734_() instanceof ChestBlock)) continue;
                level.m_5594_(null, chestPos, SoundEvents.f_11749_, SoundSource.BLOCKS, 0.25f, 1.0f);
                this.setHarvestsTimes(0);
                continue;
            }
            this.targetChestPos = this.tryFindNearbyChest(this.m_183503_(), this.m_142538_(), 8);
        }
        for (int i = 0; i < this.getInventory().m_6643_(); ++i) {
            ItemStack stack = this.getInventory().m_8020_(i);
            if (!this.isChestFull(chest)) {
                if (stack.m_41619_() || !this.depositeType.isRightType(stack)) continue;
                this.m_21563_().m_24950_((double)chestPos.m_123341_(), (double)chestPos.m_123342_(), (double)chestPos.m_123343_(), 30.0f, 30.0f);
                this.m_6674_(this.m_21526_() ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND);
                ItemStack remaining = HopperBlockEntity.m_59326_(null, (Container)chest, (ItemStack)stack, null);
                chest.m_6596_();
                this.getInventory().m_6836_(i, remaining);
                this.getInventory().m_6596_();
                if ((i == 0 || i == this.inventory.m_6643_()) && state.m_60734_() instanceof ChestBlock) {
                    level.m_5594_(null, chestPos, SoundEvents.f_11749_, SoundSource.BLOCKS, 0.25f, 1.0f);
                    this.setHarvestsTimes(0);
                }
                this.setTargetChestPos(null);
                continue;
            }
            this.targetChestPos = this.tryFindNearbyChest(this.m_183503_(), this.m_142538_(), 8);
        }
    }

    private boolean isChestFull(ChestBlockEntity chest) {
        for (int i = 0; i < chest.m_6643_(); ++i) {
            ItemStack stack = chest.m_8020_(i);
            if (!stack.m_41619_() && stack.m_41613_() >= stack.m_41741_()) continue;
            return false;
        }
        return true;
    }

    public List<Item> pickAbleItems() {
        return List.of(Items.f_42499_, Items.f_42574_);
    }

    public DepositeType getDepositeType() {
        return this.depositeType;
    }

    public void setDepositeType(DepositeType depositeType) {
        this.depositeType = depositeType;
    }

    public int getHarvestsTimes() {
        return this.harvestsTimes;
    }

    public void setHarvestsTimes(int harvestsTimes) {
        this.harvestsTimes = harvestsTimes;
    }

    public void addHarvestsTime() {
        ++this.harvestsTimes;
    }

    @Nullable
    public BlockPos getTargetChestPos() {
        return this.targetChestPos;
    }

    public void setTargetChestPos(@Nullable BlockPos targetChestPos) {
        this.targetChestPos = targetChestPos;
    }

    public boolean willDepositSeeds() {
        return this.depositeType == DepositeType.SEEDS || this.depositeType == DepositeType.BOTH;
    }

    @Override
    public Color getPawBeansColor() {
        return Color.CYAN;
    }

    public static TagKey<Item> tag(String name) {
        return ItemTags.create((ResourceLocation)new ResourceLocation("forge", name));
    }

    public static enum DepositeType {
        SEEDS((TagKey<Item>)Tags.Items.SEEDS),
        CROPS(PrototypeEntity.tag("fruits"), (TagKey<Item>)Tags.Items.CROPS),
        BOTH(PrototypeEntity.tag("fruits"), (TagKey<Item>)Tags.Items.CROPS, (TagKey<Item>)Tags.Items.SEEDS);

        final List<TagKey<Item>> tagKeys;

        private DepositeType(TagKey<Item> crops, TagKey<Item> seeds) {
            this.tagKeys = List.of(crops, seeds);
        }

        private DepositeType(TagKey<Item> typeTag) {
            this.tagKeys = List.of(typeTag);
        }

        private DepositeType(TagKey<Item> fruits, TagKey<Item> crops, TagKey<Item> seeds) {
            this.tagKeys = List.of(fruits, crops, seeds);
        }

        public List<TagKey<Item>> getTagKeys() {
            return this.tagKeys;
        }

        public String getFormatedName() {
            String normalName = this.name();
            String lowerCaseName = this.name().substring(1).toLowerCase();
            return normalName.toUpperCase().charAt(0) + lowerCaseName;
        }

        public boolean isRightType(ItemStack stack) {
            return this.tagKeys.stream().anyMatch(arg_0 -> ((ItemStack)stack).m_204117_(arg_0));
        }

        public DepositeType switchDepositeType() {
            int next = (this.ordinal() + 1) % DepositeType.values().length;
            return DepositeType.values()[next];
        }
    }

    @Mod.EventBusSubscriber
    public static class EventHandle {
        @SubscribeEvent
        public static void onFarmlandTrample(BlockEvent.FarmlandTrampleEvent event) {
            if (event.getEntity() instanceof PrototypeEntity) {
                event.setCanceled(true);
            } else {
                Player player;
                TransfurVariantInstance transfurVariant;
                Entity entity = event.getEntity();
                if (entity instanceof Player && (transfurVariant = ProcessTransfur.getPlayerTransfurVariant((Player)(player = (Player)entity))) != null && transfurVariant.is(ChangedAddonTransfurVariants.PROTOTYPE)) {
                    event.setCanceled(true);
                }
            }
        }
    }
}

