/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.entity.advanced.handle;

import net.foxyas.changedaddon.entity.advanced.LuminaraFlowerBeastEntity;
import net.foxyas.changedaddon.util.DelayedTask;
import net.foxyas.changedaddon.util.ParticlesUtil;
import net.foxyas.changedaddon.variants.ChangedAddonTransfurVariants;
import net.ltxprogrammer.changed.entity.ChangedEntity;
import net.ltxprogrammer.changed.entity.variant.TransfurVariant;
import net.ltxprogrammer.changed.entity.variant.TransfurVariantInstance;
import net.ltxprogrammer.changed.process.ProcessTransfur;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingDamageEvent;

public class VoidTransformationHandler {
    public static void handlePlayerVoid(Player player) {
        if (player.m_183503_().f_46443_) {
            return;
        }
        if (player.m_5833_()) {
            return;
        }
        if (player.m_20186_() < (double)((float)player.m_183503_().m_141937_() - 6.0f) && VoidTransformationHandler.isVoidForm(player)) {
            VoidTransformationHandler.triggerVoidTransformation(player);
        }
    }

    public static void handleVoidDamage(LivingDamageEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (player.m_5833_()) {
            return;
        }
        if (event.getSource() == DamageSource.f_19317_ && VoidTransformationHandler.isVoidForm(player)) {
            event.setCanceled(true);
            VoidTransformationHandler.triggerVoidTransformation(player);
        }
    }

    public static void triggerVoidTransformation(Player player) {
        LuminaraFlowerBeastEntity luminaraFlowerBeastEntity;
        ChangedEntity changedEntity;
        TransfurVariantInstance instance = ProcessTransfur.getPlayerTransfurVariant((Player)player);
        if (instance != null && (changedEntity = instance.getChangedEntity()) instanceof LuminaraFlowerBeastEntity && !(luminaraFlowerBeastEntity = (LuminaraFlowerBeastEntity)changedEntity).isAwakened()) {
            luminaraFlowerBeastEntity.setAwakened(true);
            if (player.m_150109_().m_36063_(new ItemStack((ItemLike)Items.f_42735_))) {
                luminaraFlowerBeastEntity.setHyperAwakened(true);
            }
            player.m_20334_(0.0, 8.0, 0.0);
            player.f_19864_ = true;
            DelayedTask.schedule(20, () -> {
                player.m_150110_().f_35936_ = true;
                player.m_150110_().f_35935_ = true;
                player.m_6885_();
            });
            player.m_7292_(new MobEffectInstance(MobEffects.f_19618_, 200, 1));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 200, 2));
            Level level = player.m_183503_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                double radius = 1.0;
                double angle = 25.0;
                for (double theta = 0.0; theta < 360.0; theta += angle) {
                    double angleTheta = Math.toRadians(theta);
                    for (double phi = 0.0; phi <= 180.0; phi += angle) {
                        double anglePhi = Math.toRadians(phi);
                        double x = player.m_20185_() + Math.sin(anglePhi) * Math.cos(angleTheta) * radius;
                        double y = player.m_20186_() + Math.cos(anglePhi) * radius;
                        double z = player.m_20189_() + Math.sin(anglePhi) * Math.sin(angleTheta) * radius;
                        Vec3 pos = new Vec3(x, y, z);
                        ParticlesUtil.sendParticlesWithMotion(player.m_183503_(), (ParticleOptions)ParticleTypes.f_123789_, pos, Vec3.f_82478_, pos.m_82546_(player.m_20182_()), 1, 1.0f);
                    }
                }
                serverLevel.m_5594_(null, player.m_142538_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 2.0f, 0.8f);
            }
        }
    }

    public static boolean isVoidForm(Player player) {
        LuminaraFlowerBeastEntity luminaraFlowerBeastEntity;
        ChangedEntity changedEntity;
        TransfurVariantInstance instance = ProcessTransfur.getPlayerTransfurVariant((Player)player);
        return instance != null && instance.is((TransfurVariant)ChangedAddonTransfurVariants.LUMINARA_FLOWER_BEAST.get()) && (changedEntity = instance.getChangedEntity()) instanceof LuminaraFlowerBeastEntity && !(luminaraFlowerBeastEntity = (LuminaraFlowerBeastEntity)changedEntity).isAwakened();
    }
}

