/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.entity.bosses;

import java.awt.Color;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.foxyas.changedaddon.entity.customHandle.AttributesHandle;
import net.foxyas.changedaddon.entity.customHandle.BossAbilitiesHandle;
import net.foxyas.changedaddon.entity.interfaces.IDynamicPawColor;
import net.foxyas.changedaddon.init.ChangedAddonEntities;
import net.foxyas.changedaddon.util.ColorUtil;
import net.ltxprogrammer.changed.entity.ChangedEntity;
import net.ltxprogrammer.changed.entity.EyeStyle;
import net.ltxprogrammer.changed.entity.Gender;
import net.ltxprogrammer.changed.entity.GenderedEntity;
import net.ltxprogrammer.changed.entity.HairStyle;
import net.ltxprogrammer.changed.entity.LatexType;
import net.ltxprogrammer.changed.entity.PowderSnowWalkable;
import net.ltxprogrammer.changed.entity.TransfurCause;
import net.ltxprogrammer.changed.entity.TransfurMode;
import net.ltxprogrammer.changed.init.ChangedAttributes;
import net.ltxprogrammer.changed.init.ChangedSounds;
import net.ltxprogrammer.changed.util.Color3;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import org.jetbrains.annotations.NotNull;

public class Experiment10Entity
extends ChangedEntity
implements GenderedEntity,
IDynamicPawColor,
PowderSnowWalkable {
    private float TpCooldown;
    private boolean Phase2;

    public Experiment10Entity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<Experiment10Entity>)((EntityType)ChangedAddonEntities.EXPERIMENT_10.get()), world);
    }

    public Experiment10Entity(EntityType<Experiment10Entity> type, Level world) {
        super(type, world);
        this.setAttributes(this.m_21204_());
        this.f_21364_ = 160;
        this.m_21557_(false);
        this.m_21530_();
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder.m_22268_((Attribute)ChangedAttributes.TRANSFUR_DAMAGE.get(), 0.0);
        builder = builder.m_22268_(Attributes.f_22279_, 0.3);
        builder = builder.m_22268_(Attributes.f_22276_, 300.0);
        builder = builder.m_22268_(Attributes.f_22284_, 20.0);
        builder = builder.m_22268_(Attributes.f_22281_, 12.0);
        builder = builder.m_22268_(Attributes.f_22277_, 32.0);
        builder = builder.m_22268_(Attributes.f_22278_, 0.25);
        builder = builder.m_22268_(Attributes.f_22282_, 1.0);
        return builder;
    }

    protected void setAttributes(AttributeMap attributes) {
        Objects.requireNonNull(attributes.m_22146_((Attribute)ChangedAttributes.TRANSFUR_DAMAGE.get())).m_22100_(3.0);
        attributes.m_22146_(Attributes.f_22276_).m_22100_(AttributesHandle.DefaultPlayerAttributes().m_22185_(Attributes.f_22276_) + 16.0);
        attributes.m_22146_(Attributes.f_22277_).m_22100_(64.0);
        attributes.m_22146_(Attributes.f_22279_).m_22100_(1.17);
        attributes.m_22146_((Attribute)ForgeMod.SWIM_SPEED.get()).m_22100_(1.1);
        attributes.m_22146_(Attributes.f_22281_).m_22100_(AttributesHandle.DefaultPlayerAttributes().m_22185_(Attributes.f_22281_) + 6.5);
        attributes.m_22146_(Attributes.f_22284_).m_22100_(AttributesHandle.DefaultPlayerAttributes().m_22185_(Attributes.f_22284_));
        attributes.m_22146_(Attributes.f_22285_).m_22100_(AttributesHandle.DefaultPlayerAttributes().m_22185_(Attributes.f_22285_));
        attributes.m_22146_(Attributes.f_22278_).m_22100_(AttributesHandle.DefaultPlayerAttributes().m_22185_(Attributes.f_22278_));
        attributes.m_22146_(Attributes.f_22282_).m_22100_(AttributesHandle.DefaultPlayerAttributes().m_22185_(Attributes.f_22282_));
    }

    public boolean m_7998_(@NotNull Entity EntityIn, boolean force) {
        if (EntityIn instanceof Boat || EntityIn instanceof Minecart) {
            return false;
        }
        return super.m_7998_(EntityIn, force);
    }

    public double m_142593_(LivingEntity target) {
        if (target.m_20188_() > this.m_20188_() + 1.0) {
            return super.m_142593_(target) * 1.5;
        }
        return super.m_142593_(target);
    }

    public Color3 getHairColor(int i) {
        return Color3.getColor((String)"#1f1f1f");
    }

    public int m_146891_() {
        return 1000;
    }

    protected boolean targetSelectorTest(LivingEntity livingEntity) {
        return livingEntity instanceof Player || livingEntity instanceof ServerPlayer || livingEntity.m_6095_().m_204039_(TagKey.m_203882_((ResourceKey)Registry.f_122903_, (ResourceLocation)new ResourceLocation("changed:humanoids")));
    }

    public void m_6043_() {
    }

    public boolean m_7301_(@NotNull MobEffectInstance mobEffectInstance) {
        if (mobEffectInstance.m_19544_() == MobEffects.f_19615_) {
            return false;
        }
        return super.m_7301_(mobEffectInstance);
    }

    public LatexType getLatexType() {
        return LatexType.NEUTRAL;
    }

    public TransfurMode getTransfurMode() {
        return TransfurMode.NONE;
    }

    public HairStyle getDefaultHairStyle() {
        return (HairStyle)HairStyle.BALD.get();
    }

    @Nullable
    public List<HairStyle> getValidHairStyles() {
        return HairStyle.Collection.FEMALE.getStyles();
    }

    public Color3 getDripColor() {
        return Color3.getColor((String)"#181818");
    }

    public Color3 getTransfurColor(TransfurCause cause) {
        Color3 firstColor = Color3.getColor((String)"#181818");
        Color3 secondColor = Color3.getColor((String)"#ed1c24");
        return ColorUtil.lerpTFColor(firstColor, secondColor, this.getUnderlyingPlayer());
    }

    @NotNull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
    }

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public double m_6049_() {
        return super.m_6049_();
    }

    @NotNull
    public SoundEvent m_7975_(@NotNull DamageSource ds) {
        return SoundEvents.f_11915_;
    }

    @NotNull
    public SoundEvent m_5592_() {
        return SoundEvents.f_11910_;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_7640_() instanceof ThrownPotion || source.m_7640_() instanceof AreaEffectCloud) {
            return false;
        }
        if (source == DamageSource.f_19315_) {
            return false;
        }
        if (source == DamageSource.f_19314_) {
            return false;
        }
        if (source == DamageSource.f_19312_) {
            return false;
        }
        if (source == DamageSource.f_19306_) {
            return false;
        }
        if (source.m_19385_().equals("trident")) {
            Entity entity;
            if (this.m_183503_().f_46441_.nextFloat() <= 0.25f && (entity = source.m_7639_()) instanceof Player) {
                Player player = (Player)entity;
                player.m_5661_((Component)new TextComponent("\u00a7l\u00a7o\u00a73YOU'RE COWARD! Is distance all you can rely on? How PATHETIC!!!"), true);
            }
            return super.m_6469_(source, amount * 0.5f);
        }
        if (source == DamageSource.f_19321_) {
            return false;
        }
        if (source == DamageSource.f_19323_) {
            return false;
        }
        if (source == DamageSource.f_19320_) {
            return false;
        }
        if (source.m_19385_().equals("witherSkull")) {
            return false;
        }
        if (source.m_19360_()) {
            Entity entity;
            if (this.m_183503_().f_46441_.nextFloat() <= 0.25f && (entity = source.m_7639_()) instanceof Player) {
                Player player = (Player)entity;
                player.m_5661_((Component)new TextComponent("\u00a7l\u00a7o\u00a74Coward! Is distance all you can rely on? How PATHETIC!!!"), true);
            }
            return super.m_6469_(source, amount * 0.5f);
        }
        return super.m_6469_(source, amount);
    }

    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor world, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType reason, @Nullable SpawnGroupData livingdata, @Nullable CompoundTag tag) {
        SpawnGroupData retval = super.m_6518_(world, difficulty, reason, livingdata, tag);
        this.getBasicPlayerInfo().setSize(1.0f);
        this.getBasicPlayerInfo().setEyeStyle(EyeStyle.TALL);
        this.getBasicPlayerInfo().setRightIrisColor(Color3.getColor((String)"#edbd25"));
        this.getBasicPlayerInfo().setLeftIrisColor(Color3.getColor((String)"#edbd25"));
        this.getBasicPlayerInfo().setScleraColor(Color3.getColor((String)"#edd725"));
        return retval;
    }

    public boolean m_6072_() {
        return false;
    }

    public void m_6457_(@NotNull ServerPlayer player) {
        super.m_6457_(player);
    }

    public void m_6452_(@NotNull ServerPlayer player) {
        super.m_6452_(player);
    }

    public void m_8024_() {
        super.m_8024_();
    }

    public Gender getGender() {
        return Gender.FEMALE;
    }

    public boolean isPhase2() {
        return this.Phase2;
    }

    public void setPhase2(boolean set) {
        this.Phase2 = set;
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("Tp_Cooldown")) {
            this.TpCooldown = tag.m_128457_("Tp_Cooldown");
        }
        if (tag.m_128441_("Phase2")) {
            this.Phase2 = tag.m_128471_("Phase2");
        }
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128350_("Tp_Cooldown", this.TpCooldown);
        tag.m_128379_("Phase2", this.Phase2);
    }

    public void m_6075_() {
        super.m_6075_();
    }

    private void thisBurstAttack() {
        if (this.TpCooldown <= 0.0f) {
            BossAbilitiesHandle.BurstAttack((LivingEntity)this);
            this.TpCooldown = 50.0f;
        }
    }

    public void CrawSystem(LivingEntity target) {
        if (target != null) {
            this.setCrawlingPoseIfNeeded(target);
            this.crawlToTarget(target);
        } else if (!this.m_6069_() && !this.f_19853_.m_8055_(new BlockPos(this.m_20185_(), this.m_20188_(), this.m_20189_())).m_60795_()) {
            this.m_20124_(Pose.SWIMMING);
        }
    }

    public void setCrawlingPoseIfNeeded(LivingEntity target) {
        double targetEyeY = target.m_20188_();
        double entityEyeY = this.m_20188_();
        if (target.m_20089_() == Pose.SWIMMING && this.m_20089_() != Pose.SWIMMING) {
            if (target.m_20186_() < entityEyeY && !target.f_19853_.m_8055_(new BlockPos(target.m_20185_(), target.m_20188_(), target.m_20189_()).m_7494_()).m_60795_()) {
                this.m_20124_(Pose.SWIMMING);
            }
        } else if (!this.m_6069_() && this.f_19853_.m_8055_(new BlockPos(this.m_20185_(), this.m_20188_(), this.m_20189_()).m_7494_()).m_60795_()) {
            this.m_20124_(Pose.STANDING);
        }
    }

    public void crawlToTarget(LivingEntity target) {
        double deltaZ;
        double deltaY;
        double deltaX;
        double distance;
        double targetEyeY = target.m_20188_();
        double entityEyeY = this.m_20188_();
        if (target.m_20089_() == Pose.SWIMMING && this.m_20089_() == Pose.SWIMMING && (distance = Math.sqrt((deltaX = target.m_20185_() - this.m_20185_()) * deltaX + (deltaY = target.m_20186_() - this.m_20186_()) * deltaY + (deltaZ = target.m_20189_() - this.m_20189_()) * deltaZ)) > 1.0) {
            double speed = 1.5E-4;
            double motionX = deltaX / distance * speed;
            double motionY = deltaY / distance * speed;
            double motionZ = deltaZ / distance * speed;
            this.m_20256_(this.m_20184_().m_82520_(motionX, motionY, motionZ));
        }
    }

    public void updateSwimmingMovement() {
        if (this.m_20069_()) {
            double deltaZ;
            double deltaY;
            LivingEntity target;
            double deltaX;
            double distance;
            if (this.m_5448_() != null && (distance = Math.sqrt((deltaX = (target = this.m_5448_()).m_20185_() - this.m_20185_()) * deltaX + (deltaY = target.m_20186_() - this.m_20186_()) * deltaY + (deltaZ = target.m_20189_() - this.m_20189_()) * deltaZ)) > 0.0) {
                double speed = 0.07;
                double motionX = deltaX / distance * speed;
                double motionY = deltaY / distance * speed;
                double motionZ = deltaZ / distance * speed;
                this.m_20256_(this.m_20184_().m_82520_(motionX, motionY, motionZ));
            }
            if (this.m_204029_(FluidTags.f_13131_)) {
                this.m_20124_(Pose.SWIMMING);
                this.m_20282_(true);
            } else if (this.m_20089_() == Pose.SWIMMING && !this.m_204029_(FluidTags.f_13131_)) {
                this.m_20124_(Pose.STANDING);
                this.m_20282_(false);
            }
        } else if (this.m_20089_() == Pose.SWIMMING && !this.m_20069_() && this.f_19853_.m_8055_(new BlockPos(this.m_20185_(), this.m_20188_(), this.m_20189_()).m_7494_()).m_60795_()) {
            this.m_20124_(Pose.STANDING);
        }
    }

    public void SetDefense(Experiment10Entity entity) {
        AttributeModifier AttibuteChange = new AttributeModifier(UUID.fromString("10-0-0-0-0"), "ArmorChange", 20.0, AttributeModifier.Operation.ADDITION);
        AttributeModifier AttibuteDefenseChange = new AttributeModifier(UUID.fromString("10-10-0-0-0"), "ArmorChange", 0.7, AttributeModifier.Operation.MULTIPLY_BASE);
        if (entity.isPhase2()) {
            if (!entity.m_21051_(Attributes.f_22284_).m_22109_(AttibuteChange)) {
                entity.m_21051_(Attributes.f_22284_).m_22118_(AttibuteChange);
            }
            if (!entity.m_21051_(Attributes.f_22285_).m_22109_(AttibuteDefenseChange)) {
                entity.m_21051_(Attributes.f_22285_).m_22118_(AttibuteDefenseChange);
            }
        } else {
            entity.m_21051_(Attributes.f_22284_).m_22130_(AttibuteChange);
            entity.m_21051_(Attributes.f_22285_).m_22130_(AttibuteDefenseChange);
        }
    }

    public void SetAttack(Experiment10Entity entity) {
        AttributeModifier AttibuteChange = new AttributeModifier(UUID.fromString("10-0-0-0-0"), "Attack", 0.6667, AttributeModifier.Operation.MULTIPLY_BASE);
        if (entity.isPhase2()) {
            if (!entity.m_21051_(Attributes.f_22281_).m_22109_(AttibuteChange)) {
                entity.m_21051_(Attributes.f_22281_).m_22118_(AttibuteChange);
            }
        } else {
            entity.m_21051_(Attributes.f_22281_).m_22130_(AttibuteChange);
        }
    }

    public void SetSpeed(Experiment10Entity entity) {
        AttributeModifier AttibuteChange = new AttributeModifier(UUID.fromString("10-0-0-0-0"), "Speed", -0.4, AttributeModifier.Operation.MULTIPLY_BASE);
        if (entity.m_20089_() == Pose.SWIMMING) {
            if (!entity.m_21051_(Attributes.f_22279_).m_22109_(AttibuteChange)) {
                entity.m_21051_(Attributes.f_22279_).m_22118_(AttibuteChange);
            }
        } else {
            entity.m_21051_(Attributes.f_22279_).m_22130_(AttibuteChange);
        }
    }

    public void TpEntity(Experiment10Entity entity) {
        if (entity.m_5448_() == null) {
            return;
        }
        LivingEntity Target2 = entity.m_5448_();
        LivingEntity Targets = entity.m_142581_();
        double deltaX = Target2.m_20185_() - entity.m_20185_();
        double deltaY = Target2.m_20186_() - entity.m_20186_();
        double deltaZ = Target2.m_20189_() - entity.m_20189_();
        double distance = Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
        if (this.TpCooldown <= 0.0f) {
            if (distance > 3.0) {
                if (entity.m_142581_() == Target2) {
                    entity.m_6021_(Target2.m_20185_(), Target2.m_20186_(), Target2.m_20189_());
                    this.f_19853_.m_7785_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), ChangedSounds.BOW2, SoundSource.HOSTILE, 10.0f, 1.0f, true);
                    this.TpCooldown = 40.0f;
                } else {
                    if (Targets != null && !(Targets instanceof ServerPlayer)) {
                        entity.m_6710_(Targets);
                    } else if (Targets != null && Targets instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)Targets;
                        if (serverPlayer.f_8941_.m_9290_() != GameType.CREATIVE && serverPlayer.f_8941_.m_9290_() != GameType.SPECTATOR) {
                            entity.m_6710_(Targets);
                        }
                    }
                    entity.m_6021_(Target2.m_20185_(), Target2.m_20186_(), Target2.m_20189_());
                    this.f_19853_.m_7785_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), ChangedSounds.BOW2, SoundSource.HOSTILE, 10.0f, 1.0f, true);
                    this.TpCooldown = 40.0f;
                }
            }
        } else {
            this.TpCooldown -= 0.5f;
        }
    }

    @Override
    public Color getPawBeansColor() {
        return Color.decode("#070607");
    }
}

