/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.entity.customHandle;

import java.util.List;
import java.util.Random;
import net.foxyas.changedaddon.block.LuminarCrystalBlock;
import net.foxyas.changedaddon.entity.defaults.AbstractLuminarcticLeopard;
import net.foxyas.changedaddon.init.ChangedAddonBlocks;
import net.foxyas.changedaddon.init.ChangedAddonEntities;
import net.foxyas.changedaddon.util.ParticlesUtil;
import net.ltxprogrammer.changed.Changed;
import net.ltxprogrammer.changed.init.ChangedSounds;
import net.ltxprogrammer.changed.process.ProcessTransfur;
import net.ltxprogrammer.changed.util.CameraUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public record BossAbilitiesHandle(AbstractLuminarcticLeopard boss) {
    public static void BurstAttack(LivingEntity livingEntity) {
        Mob boss;
        if (livingEntity instanceof Mob && (boss = (Mob)livingEntity).m_5448_() != null && boss.m_20270_((Entity)boss.m_5448_()) <= 2.0f) {
            BossAbilitiesHandle.ExplosionBurst((Entity)boss);
        }
    }

    public static void ExplosionBurst(Entity boss) {
        if (boss.m_183503_().m_5776_()) {
            return;
        }
        int radius = 3;
        int radiusY = 3;
        BlockPos center = boss.m_142538_();
        Level world = boss.m_183503_();
        world.m_46511_(boss, boss.m_20185_(), boss.m_20186_(), boss.m_20189_(), 1.0f, Explosion.BlockInteraction.DESTROY);
        for (LivingEntity entity : boss.f_19853_.m_45976_(LivingEntity.class, boss.m_142469_().m_82400_(1.5))) {
            if (entity == boss) continue;
            entity.m_147240_(1.5, boss.m_20185_() - entity.m_20185_(), boss.m_20189_() - entity.m_20189_());
        }
    }

    private static List<EntityType<?>> ImmuneEntities() {
        return List.of((EntityType)ChangedAddonEntities.LUMINARCTIC_LEOPARD_MALE.get(), (EntityType)ChangedAddonEntities.LUMINARCTIC_LEOPARD_FEMALE.get());
    }

    public void tick() {
        Random random = this.boss.m_183503_().f_46441_;
        LivingEntity bossTarget = this.boss.m_5448_();
        if (bossTarget != null) {
            if (bossTarget.m_20270_((Entity)this.boss) >= 4.0f) {
                this.arcticDash();
                int abilityIndex = random.nextInt(5);
                switch (abilityIndex) {
                    case 0: {
                        this.arcticDash();
                        break;
                    }
                    case 1: {
                        this.irradiatedPulse();
                        break;
                    }
                    case 2: {
                        this.radiantField();
                        break;
                    }
                    case 3: {
                        this.meltdown();
                        break;
                    }
                    case 4: {
                        this.RadioActiveIceExplosion();
                    }
                }
            } else if (bossTarget.m_20270_((Entity)this.boss) <= 4.0f) {
                int abilityIndex = random.nextInt(9);
                switch (abilityIndex) {
                    case 0: {
                        this.glacialSpikes();
                        break;
                    }
                    case 1: {
                        this.frostNova();
                        break;
                    }
                    case 2: {
                        this.crystallineShield();
                        break;
                    }
                    case 3: {
                        this.radioactiveBurst();
                        break;
                    }
                    case 4: {
                        this.irradiatedPulse();
                        break;
                    }
                    case 5: {
                        this.radiantField();
                        break;
                    }
                    case 6: {
                        this.meltdown();
                        break;
                    }
                    case 7: {
                        this.arcticDash();
                        break;
                    }
                    case 8: {
                        this.RadioActiveIceExplosion();
                    }
                }
            }
        }
    }

    public void RadioActiveIceExplosion() {
        if (this.boss.isActivatedAbility() && this.boss.AbilitiesTicksCooldown <= 0.0f) {
            for (int theta = 0; theta < 360; theta += 15) {
                double angleTheta = Math.toRadians(theta);
                for (int phi = 0; phi <= 180; phi += 15) {
                    double anglePhi = Math.toRadians(phi);
                    double x = this.boss.m_20185_() + Math.sin(anglePhi) * Math.cos(angleTheta) * 4.0;
                    double y = this.boss.m_20186_() + Math.cos(anglePhi) * 4.0;
                    double z = this.boss.m_20189_() + Math.sin(anglePhi) * Math.sin(angleTheta) * 4.0;
                    Vec3 pos = new Vec3(x, y, z);
                    ParticlesUtil.sendParticles(this.boss.m_183503_(), (ParticleOptions)ParticleTypes.f_123745_, pos, 0.3f, 0.2f, 0.3f, 15, 0.0f);
                }
            }
            this.createIceExplosion();
        }
    }

    public void createIceExplosion() {
        if (this.boss.m_183503_().f_46443_) {
            return;
        }
        int radius = 3;
        int radiusY = 3;
        BlockPos center = this.boss.m_142538_();
        Level world = this.boss.m_183503_();
        world.m_46511_((Entity)this.boss, this.boss.m_20185_(), this.boss.m_20186_(), this.boss.m_20189_(), 1.0f, Explosion.BlockInteraction.BREAK);
        Explosion explosionReference = new Explosion(world, (Entity)this.boss, this.boss.m_20185_(), this.boss.m_20186_(), this.boss.m_20189_(), 4.0f, false, Explosion.BlockInteraction.NONE);
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)center.m_142082_(-radius, -radiusY, -radius), (BlockPos)center.m_142082_(radius, radiusY, radius))) {
            double dz;
            double dy;
            double dx = (double)(pos.m_123341_() - center.m_123341_()) / (double)radius;
            double distanceSq = dx * dx + (dy = (double)(pos.m_123342_() - center.m_123342_()) / (double)radiusY) * dy + (dz = (double)(pos.m_123343_() - center.m_123343_()) / (double)radius) * dz;
            if (!(distanceSq <= 1.0)) continue;
            BlockState state = world.m_8055_(pos);
            float blastResistance = state.m_60734_().m_7325_();
            if (state.m_60795_() || !(blastResistance <= 2.0f)) continue;
            BlockState newState = (BlockState)((BlockState)((Block)ChangedAddonBlocks.LUMINAR_CRYSTAL_BLOCK.get()).m_49966_().m_61124_((Property)LuminarCrystalBlock.AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)LuminarCrystalBlock.DEFROST, (Comparable)Boolean.valueOf(true));
            world.m_46597_(pos, newState);
            world.m_5594_(null, pos, SoundEvents.f_11986_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        this.boss.m_5496_(SoundEvents.f_11913_, 4.5f, 1.0f);
        this.boss.AbilitiesTicksCooldown = 125.0f;
    }

    public void arcticDash() {
        if (this.boss.isActivatedAbility() && this.boss.AbilitiesTicksCooldown <= 0.0f && this.boss.m_20096_()) {
            Vec3 lookDirection = this.boss.m_20154_().m_82541_();
            this.boss.m_20256_(lookDirection.m_82490_(2.5));
            LivingEntity target = this.boss.m_5448_();
            if (target != null) {
                this.boss.DashingTicks = 40;
                Vec3 targetDirection = target.m_20182_().m_82546_(this.boss.m_20182_()).m_82541_();
                this.boss.m_20256_(targetDirection.m_82490_(2.5));
                for (LivingEntity entity : this.boss.f_19853_.m_45976_(LivingEntity.class, this.boss.m_142469_().m_82400_(3.0))) {
                    if (entity.m_20147_() || BossAbilitiesHandle.ImmuneEntities().contains(entity.m_6095_()) || entity == this.boss) continue;
                    entity.m_6469_(DamageSource.m_19370_((LivingEntity)this.boss), 4.0f);
                    entity.m_147240_(1.5, this.boss.m_20185_() - entity.m_20185_(), this.boss.m_20189_() - entity.m_20189_());
                    Vec3 pos = new Vec3(entity.m_20182_().f_82479_, entity.m_20182_().f_82480_ + 0.5, entity.m_20182_().f_82481_);
                    ParticlesUtil.sendParticles(entity.f_19853_, (ParticleOptions)ParticleTypes.f_175827_, pos, 0.3f, 0.2f, 0.3f, 25, 1.0f);
                    entity.m_5496_(SoundEvents.f_11737_, 4.5f, 0.0f);
                }
                this.boss.m_5496_(ChangedSounds.BOW2, 4.5f, 1.0f);
                this.boss.AbilitiesTicksCooldown = 60.0f;
                this.boss.DashingTicks = 0;
            }
        }
    }

    public void glacialSpikes() {
        if (this.boss.isActivatedAbility() && this.boss.AbilitiesTicksCooldown <= 0.0f) {
            for (int i = 0; i < 16; ++i) {
                double angle = Math.toRadians(i * 45);
                double x = this.boss.m_20185_() + (double)Mth.m_14089_((float)((float)angle)) * 3.0;
                double z = this.boss.m_20189_() + (double)Mth.m_14031_((float)((float)angle)) * 3.0;
                Vec3 pos = new Vec3(x, this.boss.m_20186_(), z);
                ParticlesUtil.sendParticles(this.boss.m_183503_(), (ParticleOptions)ParticleTypes.f_175821_, pos, 0.3f, 0.2f, 0.3f, 15, 0.0f);
                for (LivingEntity entity : this.boss.f_19853_.m_45976_(LivingEntity.class, this.boss.m_142469_().m_82400_(3.0))) {
                    if (entity.m_20147_() || BossAbilitiesHandle.ImmuneEntities().contains(entity.m_6095_()) || entity == this.boss) continue;
                    entity.m_6469_(DamageSource.m_19370_((LivingEntity)this.boss), 4.0f);
                    entity.m_147240_(1.0, this.boss.m_20185_() - entity.m_20185_(), this.boss.m_20189_() - entity.m_20189_());
                }
            }
            this.boss.m_5496_(SoundEvents.f_11913_, 4.5f, 1.0f);
            this.boss.AbilitiesTicksCooldown = 100.0f;
        }
    }

    public void frostNova() {
        if (this.boss.isActivatedAbility() && this.boss.AbilitiesTicksCooldown <= 0.0f) {
            ParticlesUtil.sendParticles(this.boss.m_183503_(), (ParticleOptions)ParticleTypes.f_123796_, this.boss.m_20182_(), 0.3f, 0.2f, 0.3f, 15, 0.0f);
            for (LivingEntity entity : this.boss.f_19853_.m_45976_(LivingEntity.class, this.boss.m_142469_().m_82400_(6.0))) {
                if (entity.m_20147_() || BossAbilitiesHandle.ImmuneEntities().contains(entity.m_6095_()) || entity == this.boss) continue;
                entity.m_6469_(DamageSource.m_19370_((LivingEntity)this.boss), 4.0f);
                if (entity.m_183503_().m_5776_()) continue;
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 80, 2));
            }
            this.boss.m_5496_(SoundEvents.f_11913_, 4.5f, 1.0f);
            this.boss.AbilitiesTicksCooldown = 150.0f;
        }
    }

    public void crystallineShield() {
        if (this.boss.isActivatedAbility() && this.boss.AbilitiesTicksCooldown <= 0.0f) {
            for (int i = 0; i < 16; ++i) {
                double angle = Math.toRadians(i * 45);
                double x = this.boss.m_20185_() + (double)Mth.m_14089_((float)((float)angle)) * 3.0;
                double z = this.boss.m_20189_() + (double)Mth.m_14031_((float)((float)angle)) * 3.0;
                Vec3 pos = new Vec3(x, this.boss.m_20186_(), z);
                ParticlesUtil.sendParticles(this.boss.m_183503_(), (ParticleOptions)ParticleTypes.f_123810_, pos, 0.3f, 0.2f, 0.3f, 15, 0.0f);
            }
            this.boss.m_5496_(SoundEvents.f_11737_, 4.5f, 0.0f);
            this.boss.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 100, 4));
            this.boss.AbilitiesTicksCooldown = 80.0f;
        }
    }

    public void radioactiveBurst() {
        if (this.boss.isActivatedAbility() && this.boss.AbilitiesTicksCooldown <= 0.0f) {
            for (LivingEntity entity : this.boss.f_19853_.m_45976_(LivingEntity.class, this.boss.m_142469_().m_82400_(5.0))) {
                if (entity.m_20147_() || BossAbilitiesHandle.ImmuneEntities().contains(entity.m_6095_()) || entity == this.boss) continue;
                entity.m_6469_(DamageSource.m_19370_((LivingEntity)this.boss), 4.0f);
                if (entity.m_183503_().m_5776_()) continue;
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 20, 1));
            }
            this.boss.m_5496_(SoundEvents.f_11913_, 4.5f, 2.0f);
            ParticlesUtil.sendParticles(this.boss.m_183503_(), (ParticleOptions)ParticleTypes.f_123762_, this.boss.m_20182_(), 0.1f, 0.2f, 0.1f, 15, 0.0f);
            this.boss.AbilitiesTicksCooldown = 80.0f;
        }
    }

    public void toxicGlare(LivingEntity entity) {
        Vec3 directionToBoss;
        Player player;
        Vec3 lookVec;
        double dotProduct;
        if (entity == null || this.boss == null) {
            return;
        }
        if (entity instanceof Player && (dotProduct = (lookVec = (player = (Player)entity).m_20154_().m_82541_()).m_82526_(directionToBoss = this.boss.m_20182_().m_82546_(player.m_20182_()).m_82541_())) > 0.95) {
            Level world = player.m_183503_();
            Vec3 playerEyePos = player.m_20299_(1.0f);
            Vec3 bossPos = this.boss.m_20182_().m_82520_(0.0, (double)this.boss.m_20206_() / 2.0, 0.0);
            BlockHitResult blockHitResult = world.m_45547_(new ClipContext(playerEyePos, bossPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
            EntityHitResult entityHitResult = ProjectileUtil.m_37304_((Level)world, (Entity)player, (Vec3)playerEyePos, (Vec3)bossPos, (AABB)player.m_142469_().m_82369_(lookVec.m_82490_(64.0)), e -> e == this.boss);
            if ((blockHitResult.m_6662_() == HitResult.Type.MISS || blockHitResult.m_82425_().equals((Object)this.boss.m_142538_())) && entityHitResult != null && entityHitResult.m_82443_() == this.boss && !player.m_183503_().m_5776_()) {
                if (ProcessTransfur.isPlayerNotLatex((Player)player)) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 30, 2));
                } else {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 30, 2));
                }
            }
        }
    }

    public void tugPlayerLook(Player player, Vec3 target, double strength) {
        Vec3 eyePosition = player.m_20299_(1.0f);
        Vec3 direction = target.m_82546_(eyePosition);
        double distanceXZ = Math.sqrt(direction.f_82479_ * direction.f_82479_ + direction.f_82481_ * direction.f_82481_);
        float targetYaw = (float)(Math.toDegrees(Math.atan2(direction.f_82481_, direction.f_82479_)) - 90.0);
        float targetPitch = (float)(-Math.toDegrees(Math.atan2(direction.f_82480_, distanceXZ)));
        float newYaw = (float)((double)player.m_146908_() + (double)(targetYaw - player.m_146908_()) * strength);
        float newPitch = (float)((double)player.m_146909_() + (double)(targetPitch - player.m_146909_()) * strength);
        player.m_146922_(newYaw);
        player.m_146926_(newPitch);
        player.f_19859_ = newYaw;
        player.f_19860_ = newPitch;
    }

    public void hypnoticGaze(LivingEntity entity) {
        AbstractLuminarcticLeopard self = this.boss;
        Level level = this.boss.m_183503_();
        level.m_45971_(Mob.class, TargetingConditions.f_26872_, (LivingEntity)self, AABB.m_165882_((Vec3)self.m_20182_(), (double)3.0, (double)3.0, (double)3.0)).forEach(arg_0 -> BossAbilitiesHandle.lambda$hypnoticGaze$1((LivingEntity)self, arg_0));
        level.m_45971_(LivingEntity.class, TargetingConditions.f_26872_, (LivingEntity)self, AABB.m_165882_((Vec3)self.m_20182_(), (double)10.0, (double)10.0, (double)10.0)).forEach(arg_0 -> BossAbilitiesHandle.lambda$hypnoticGaze$2((LivingEntity)self, arg_0));
    }

    public void Passives() {
        if (this.boss.isActivatedAbility()) {
            for (LivingEntity entity : this.boss.f_19853_.m_45976_(LivingEntity.class, this.boss.m_142469_().m_82400_(10.0))) {
                double healthPercentage = entity.m_21223_() / entity.m_21233_() * 100.0f;
                boolean isToUseToxicGlare = healthPercentage > 15.0;
                if (!isToUseToxicGlare) continue;
                this.toxicGlare(entity);
                ++this.boss.PassivesTicksCooldown;
            }
        }
    }

    public void irradiatedPulse() {
        if (this.boss.isActivatedAbility() && this.boss.AbilitiesTicksCooldown <= 0.0f) {
            for (int i = 0; i < 5; ++i) {
                ParticlesUtil.sendParticles(this.boss.m_183503_(), (ParticleOptions)ParticleTypes.f_123799_, this.boss.m_20182_(), 0.3f, 0.2f, 0.3f, 15, 0.0f);
            }
            for (LivingEntity entity : this.boss.f_19853_.m_45976_(LivingEntity.class, this.boss.m_142469_().m_82400_(6.0))) {
                if (entity.m_20147_() || BossAbilitiesHandle.ImmuneEntities().contains(entity.m_6095_()) || entity == this.boss) continue;
                if (!entity.m_183503_().m_5776_()) {
                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 120, 1));
                }
                entity.m_6469_(DamageSource.m_19370_((LivingEntity)this.boss), 6.0f);
            }
            this.boss.m_5496_(SoundEvents.f_11736_, 4.5f, 0.0f);
            this.boss.AbilitiesTicksCooldown = 100.0f;
        }
    }

    public void radiantField() {
        if (this.boss.isActivatedAbility() && this.boss.AbilitiesTicksCooldown <= 0.0f) {
            for (int theta = 0; theta < 360; theta += 45) {
                double angleTheta = Math.toRadians(theta);
                for (int phi = 0; phi <= 180; phi += 45) {
                    double anglePhi = Math.toRadians(phi);
                    double x = this.boss.m_20185_() + Math.sin(anglePhi) * Math.cos(angleTheta) * 4.0;
                    double y = this.boss.m_20186_() + Math.cos(anglePhi) * 4.0;
                    double z = this.boss.m_20189_() + Math.sin(anglePhi) * Math.sin(angleTheta) * 4.0;
                    Vec3 pos = new Vec3(x, y, z);
                    ParticlesUtil.sendParticles(this.boss.m_183503_(), (ParticleOptions)ParticleTypes.f_175827_, pos, 0.3f, 0.2f, 0.3f, 15, 0.0f);
                }
            }
            for (LivingEntity entity : this.boss.f_19853_.m_45976_(LivingEntity.class, this.boss.m_142469_().m_82400_(4.0))) {
                if (entity.m_20147_() || BossAbilitiesHandle.ImmuneEntities().contains(entity.m_6095_()) || entity == this.boss) continue;
                entity.m_6469_(DamageSource.m_19370_((LivingEntity)this.boss), 2.0f);
                if (entity.m_183503_().m_5776_()) continue;
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 100, 0));
            }
            this.boss.m_5496_(SoundEvents.f_11738_, 4.5f, 1.0f);
            this.boss.AbilitiesTicksCooldown = 100.0f;
        }
    }

    public void meltdown() {
        if (this.boss.isActivatedAbility() && this.boss.AbilitiesTicksCooldown <= 0.0f) {
            ParticlesUtil.sendParticles(this.boss.m_183503_(), (ParticleOptions)ParticleTypes.f_123813_, this.boss.m_20182_(), 0.3f, 0.2f, 0.3f, 15, 0.0f);
            for (LivingEntity entity : this.boss.f_19853_.m_45976_(LivingEntity.class, this.boss.m_142469_().m_82400_(5.0))) {
                if (entity.m_20147_() || BossAbilitiesHandle.ImmuneEntities().contains(entity.m_6095_()) || entity == this.boss) continue;
                entity.m_6469_(DamageSource.m_19370_((LivingEntity)this.boss), 14.0f);
                if (!entity.m_183503_().m_5776_()) {
                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 100, 0));
                }
                for (int theta = 0; theta < 360; theta += 45) {
                    double angleTheta = Math.toRadians(theta);
                    for (int phi = 0; phi <= 180; phi += 45) {
                        double anglePhi = Math.toRadians(phi);
                        double x = this.boss.m_20185_() + Math.sin(anglePhi) * Math.cos(angleTheta) * 4.0;
                        double y = this.boss.m_20186_() + Math.cos(anglePhi) * 4.0;
                        double z = this.boss.m_20189_() + Math.sin(anglePhi) * Math.sin(angleTheta) * 4.0;
                        Vec3 pos = new Vec3(x, y, z);
                        ParticlesUtil.sendParticles(this.boss.m_183503_(), (ParticleOptions)ParticleTypes.f_123762_, pos, 0.3f, 0.2f, 0.3f, 15, 0.0f);
                    }
                }
            }
            this.boss.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60, 1));
            this.boss.m_5496_(SoundEvents.f_11738_, 4.5f, 0.0f);
            this.boss.AbilitiesTicksCooldown = 30.0f;
            this.boss.PassivesTicksCooldown = 150;
        }
    }

    private static /* synthetic */ void lambda$hypnoticGaze$2(LivingEntity self, LivingEntity livingEntity) {
        if (!(livingEntity.m_20154_().m_82526_(self.m_146892_().m_82546_(livingEntity.m_146892_()).m_82541_()) < (double)0.85f || livingEntity instanceof Player && !((Boolean)Changed.config.server.playerControllingAbilities.get()).booleanValue())) {
            CameraUtil.tugEntityLookDirection((LivingEntity)livingEntity, (LivingEntity)self, (double)0.125);
            if (!livingEntity.m_183503_().m_5776_()) {
                livingEntity.m_147207_(new MobEffectInstance(MobEffects.f_19604_, 120, 2, false, false), (Entity)self);
                livingEntity.m_147207_(new MobEffectInstance(MobEffects.f_19597_, 5, 2, false, false), (Entity)self);
            }
        }
    }

    private static /* synthetic */ void lambda$hypnoticGaze$1(LivingEntity self, Mob mob) {
        if (mob.m_5448_() != null && mob.m_5448_().m_7306_((Entity)self)) {
            mob.m_6710_(null);
        }
    }
}

