/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.entity.defaults;

import java.util.Objects;
import java.util.Random;
import net.foxyas.changedaddon.abilities.DodgeAbilityInstance;
import net.foxyas.changedaddon.block.AbstractLuminarCrystal;
import net.foxyas.changedaddon.entity.customHandle.BossAbilitiesHandle;
import net.foxyas.changedaddon.entity.interfaces.CrawlFeature;
import net.foxyas.changedaddon.init.ChangedAddonAbilities;
import net.foxyas.changedaddon.init.ChangedAddonBlocks;
import net.foxyas.changedaddon.init.ChangedAddonDamageSources;
import net.foxyas.changedaddon.init.ChangedAddonEnchantments;
import net.foxyas.changedaddon.init.ChangedAddonItems;
import net.foxyas.changedaddon.init.ChangedAddonTags;
import net.foxyas.changedaddon.util.ParticlesUtil;
import net.ltxprogrammer.changed.ability.AbstractAbility;
import net.ltxprogrammer.changed.ability.IAbstractChangedEntity;
import net.ltxprogrammer.changed.entity.ChangedEntity;
import net.ltxprogrammer.changed.entity.EyeStyle;
import net.ltxprogrammer.changed.entity.beast.AbstractSnowLeopard;
import net.ltxprogrammer.changed.entity.variant.TransfurVariantInstance;
import net.ltxprogrammer.changed.process.ProcessTransfur;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractLuminarcticLeopard
extends AbstractSnowLeopard
implements CrawlFeature {
    public static final int GLOW_NONE = 0;
    public static final int GLOW_PULSE = 1;
    public static final int GLOW_ALWAYS = 2;
    private static final EntityDataAccessor<Integer> GLOW_STAGE = SynchedEntityData.m_135353_(AbstractLuminarcticLeopard.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> ACTIVATED_ABILITY = SynchedEntityData.m_135353_(AbstractLuminarcticLeopard.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public final ServerBossEvent bossBar = new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.WHITE, BossEvent.BossBarOverlay.NOTCHED_6);
    public final BossAbilitiesHandle bossAbilitiesHandle = new BossAbilitiesHandle(this);
    public float AbilitiesTicksCooldown = 20.0f;
    public int SuperAbilitiesTicksCooldown = 0;
    public int PassivesTicksCooldown = 0;
    public int DashingTicks = 0;
    public DodgeAbilityInstance dodgeAbilityInstance = null;
    private boolean isBoss = false;
    private boolean Aggro = false;
    private boolean attributesApplied = false;

    public AbstractLuminarcticLeopard(EntityType<? extends AbstractSnowLeopard> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
        this.setAttributes(this.m_21204_());
        this.dodgeAbilityInstance = (DodgeAbilityInstance)this.registerAbility(this::canDodge, new DodgeAbilityInstance((AbstractAbility)ChangedAddonAbilities.DODGE.get(), IAbstractChangedEntity.forEntity((ChangedEntity)this)));
    }

    public static <T extends AbstractLuminarcticLeopard> boolean canSpawnNear(EntityType<T> entityType, ServerLevelAccessor world, MobSpawnType reason, BlockPos pos, Random random) {
        if (world.m_46791_() == Difficulty.PEACEFUL) {
            return false;
        }
        if (world.m_45517_(LightLayer.BLOCK, pos) > 6) {
            return false;
        }
        BlockState blockBelow = world.m_8055_(pos.m_7495_());
        if (!blockBelow.m_60804_((BlockGetter)world, pos.m_7495_()) || !blockBelow.m_60783_((BlockGetter)world, pos.m_7495_(), Direction.UP)) {
            return false;
        }
        AABB checkArea = new AABB(pos).m_82400_(6.0);
        boolean nearLuminarCrystal = world.m_46847_(checkArea).anyMatch(state -> state.m_60713_((Block)ChangedAddonBlocks.LUMINAR_CRYSTAL_SMALL.get()) && (Boolean)state.m_61143_((Property)AbstractLuminarCrystal.CrystalSmall.HEARTED) != false);
        if (!nearLuminarCrystal) {
            return false;
        }
        int maxEntitiesNear = 3;
        int currentEntities = world.m_142425_(entityType, checkArea, entity -> true).size();
        return currentEntities < maxEntitiesNear;
    }

    public boolean canDodge(DodgeAbilityInstance abilityInstance) {
        return true;
    }

    public boolean isBoss() {
        return this.isBoss;
    }

    public void setBoss(boolean boss) {
        this.isBoss = boss;
    }

    public boolean isAggro() {
        return this.Aggro;
    }

    public void setAggro(boolean aggro) {
        this.Aggro = aggro;
    }

    protected int m_6552_(@NotNull Player player) {
        if (this.isBoss()) {
            return super.m_6552_(player) * 50;
        }
        return super.m_6552_(player);
    }

    protected boolean targetSelectorTest(LivingEntity livingEntity) {
        return this.isAggro() && !(livingEntity instanceof AbstractLuminarcticLeopard);
    }

    @NotNull
    protected SoundEvent m_7975_(@NotNull DamageSource pDamageSource) {
        return SoundEvents.f_11915_;
    }

    @NotNull
    protected SoundEvent m_5592_() {
        return SoundEvents.f_11910_;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(GLOW_STAGE, (Object)0);
        this.f_19804_.m_135372_(ACTIVATED_ABILITY, (Object)false);
    }

    public int getGlowStage() {
        return (Integer)this.f_19804_.m_135370_(GLOW_STAGE);
    }

    public void setGlowStage(int stage) {
        this.f_19804_.m_135381_(GLOW_STAGE, (Object)stage);
    }

    public boolean isActivatedAbility() {
        return (Boolean)this.f_19804_.m_135370_(ACTIVATED_ABILITY);
    }

    public void setActivatedAbility(boolean value) {
        this.f_19804_.m_135381_(ACTIVATED_ABILITY, (Object)value);
    }

    public void m_6710_(@Nullable LivingEntity entity) {
        super.m_6710_(entity);
    }

    public boolean m_7301_(@NotNull MobEffectInstance mobEffectInstance) {
        return super.m_7301_(mobEffectInstance);
    }

    public void variantTick(Level level) {
        super.variantTick(level);
        if (this.isBoss() && !this.attributesApplied) {
            this.handleBoss();
        } else if (!this.isBoss() && this.attributesApplied) {
            this.handleNonBoss();
        }
    }

    public void m_6075_() {
        super.m_6075_();
        if (this.isBoss() && !this.attributesApplied) {
            this.handleBoss();
        }
        if (this.getUnderlyingPlayer() == null) {
            if (!this.m_21525_()) {
                if (this.dodgeAbilityInstance != null && this.dodgeAbilityInstance.isDodgeActive()) {
                    this.dodgeAbilityInstance.setDodgeActivate(false);
                }
                if (this.isBoss()) {
                    if (this.AbilitiesTicksCooldown <= 0.0f) {
                        this.bossAbilitiesHandle.tick();
                        if (this.getUnderlyingPlayer() == null) {
                            this.setGlowStage(0);
                        }
                    } else {
                        this.AbilitiesTicksCooldown -= 1.0f;
                        if (this.getUnderlyingPlayer() == null) {
                            this.setGlowStage(1);
                        }
                    }
                    this.setActivatedAbility(this.m_5448_() != null);
                    if (this.SuperAbilitiesTicksCooldown > 0) {
                        --this.SuperAbilitiesTicksCooldown;
                    }
                    if (this.m_6084_()) {
                        if (this.PassivesTicksCooldown <= 10) {
                            this.bossAbilitiesHandle.Passives();
                        } else {
                            this.PassivesTicksCooldown -= 2;
                        }
                        if (this.isDashing()) {
                            --this.DashingTicks;
                            if (this.m_5448_() == null) {
                                this.DashingTicks = 0;
                            }
                            for (int theta = 0; theta < 360; theta += 15) {
                                double angleTheta = Math.toRadians(theta);
                                for (int phi = 0; phi <= 180; phi += 15) {
                                    double anglePhi = Math.toRadians(phi);
                                    double x = this.m_20185_() + Math.sin(anglePhi) * Math.cos(angleTheta) * 4.0;
                                    double y = this.m_20186_() + Math.cos(anglePhi) * 4.0;
                                    double z = this.m_20189_() + Math.sin(anglePhi) * Math.sin(angleTheta) * 4.0;
                                    Vec3 pos = new Vec3(x, y, z);
                                    ParticlesUtil.sendParticles(this.m_183503_(), (ParticleOptions)ParticleTypes.f_175827_, pos, 0.3f, 0.2f, 0.3f, 4, 0.0f);
                                }
                            }
                        }
                    }
                }
            }
            if (!this.f_19853_.f_46443_ && this.isBoss()) {
                this.bossBar.m_142711_(this.m_21223_() / this.m_21233_());
            }
        }
    }

    public void m_6457_(@NotNull ServerPlayer player) {
        super.m_6457_(player);
        if (this.isBoss()) {
            this.bossBar.m_6543_(player);
        }
    }

    public void m_6452_(@NotNull ServerPlayer player) {
        super.m_6452_(player);
        if (this.isBoss()) {
            this.bossBar.m_6539_(player);
        }
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("ActivatedAbility")) {
            this.setActivatedAbility(tag.m_128471_("ActivatedAbility"));
        }
        if (tag.m_128441_("AbilitiesTicksCooldown")) {
            this.AbilitiesTicksCooldown = tag.m_128457_("AbilitiesTicksCooldown");
        }
        if (tag.m_128441_("PassivesTicksCooldown")) {
            this.PassivesTicksCooldown = tag.m_128451_("PassivesTicksCooldown");
        }
        if (tag.m_128441_("SuperAbilitiesTicksCooldown")) {
            this.SuperAbilitiesTicksCooldown = tag.m_128451_("SuperAbilitiesTicksCooldown");
        }
        if (tag.m_128441_("DashingTicks")) {
            this.DashingTicks = tag.m_128451_("DashingTicks");
        }
        if (tag.m_128441_("GlowStage")) {
            this.setGlowStage(tag.m_128451_("GlowStage"));
        }
        if (tag.m_128441_("isBoss")) {
            this.isBoss = tag.m_128471_("isBoss");
        }
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("ActivatedAbility", this.isActivatedAbility());
        tag.m_128350_("AbilitiesTicksCooldown", this.AbilitiesTicksCooldown);
        tag.m_128405_("SuperAbilitiesTicksCooldown", this.SuperAbilitiesTicksCooldown);
        tag.m_128405_("PassivesTicksCooldown", this.PassivesTicksCooldown);
        tag.m_128405_("DashingTicks", this.DashingTicks);
        tag.m_128405_("GlowStage", this.getGlowStage());
        tag.m_128379_("isBoss", this.isBoss);
    }

    @Nullable
    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor p_21434_, @NotNull DifficultyInstance p_21435_, @NotNull MobSpawnType p_21436_, @Nullable SpawnGroupData p_21437_, @Nullable CompoundTag p_21438_) {
        if (p_21438_ != null && p_21438_.m_128441_("isBoss") && p_21438_.m_128471_("isBoss")) {
            if (!this.attributesApplied) {
                this.handleBoss();
            }
        } else if (this.isBoss() && !this.attributesApplied) {
            this.handleBoss();
        }
        return super.m_6518_(p_21434_, p_21435_, p_21436_, p_21437_, p_21438_);
    }

    public void handleBoss() {
        this.attributesApplied = true;
        Objects.requireNonNull(this.m_21051_(Attributes.f_22276_)).m_22100_(500.0);
        Objects.requireNonNull(this.m_21051_(Attributes.f_22281_)).m_22100_(17.5);
        Objects.requireNonNull(this.m_21051_(Attributes.f_22284_)).m_22100_(10.0);
        Objects.requireNonNull(this.m_21051_(Attributes.f_22285_)).m_22100_(2.5);
        this.m_21153_(500.0f);
        this.getBasicPlayerInfo().setEyeStyle(EyeStyle.TALL);
        IAbstractChangedEntity.forEitherSafe((Entity)this.maybeGetUnderlying()).map(IAbstractChangedEntity::getTransfurVariantInstance).ifPresent(TransfurVariantInstance::refreshAttributes);
    }

    public void handleNonBoss() {
        this.attributesApplied = false;
        this.setAttributes(this.m_21204_());
        IAbstractChangedEntity.forEitherSafe((Entity)this.maybeGetUnderlying()).map(IAbstractChangedEntity::getTransfurVariantInstance).ifPresent(TransfurVariantInstance::refreshAttributes);
    }

    public boolean isDashing() {
        return this.DashingTicks > 0;
    }

    private void setDodging(Entity entity) {
        if (entity != null) {
            this.m_7618_(EntityAnchorArgument.Anchor.FEET, entity.m_146892_());
        }
        this.m_21573_().m_26573_();
        if (this.dodgeAbilityInstance != null) {
            this.dodgeAbilityInstance.executeDodgeEffects((LivingEntity)this, (Entity)this.m_5448_());
            this.dodgeAbilityInstance.setDodgeActivate(true);
        }
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        Entity attacker;
        AbstractArrow abstractArrow;
        Entity attacker2;
        AbstractArrow abstractArrow2;
        Entity entity;
        this.AbilitiesTicksCooldown -= 0.05f * amount;
        Entity entity2 = source.m_7640_();
        if (entity2 instanceof ThrowableItemProjectile) {
            ThrowableItemProjectile throwableItemProjectile = (ThrowableItemProjectile)entity2;
            if (this.isBoss()) {
                Entity attacker3 = throwableItemProjectile.m_37282_() != null ? throwableItemProjectile.m_37282_() : source.m_7639_();
                this.setDodging(attacker3);
            }
        }
        if (source.m_19360_() && (entity = source.m_7640_()) instanceof AbstractArrow && (abstractArrow2 = (AbstractArrow)entity).m_36796_() <= 0 && this.isBoss()) {
            attacker2 = source.m_7640_() != null ? source.m_7640_() : source.m_7639_();
            this.setDodging(attacker2);
            return false;
        }
        if (source.m_19360_() && !this.isBoss()) {
            return super.m_6469_(source, amount);
        }
        if (source.m_19360_() && (attacker2 = source.m_7640_()) instanceof AbstractArrow && (abstractArrow = (AbstractArrow)attacker2).m_36796_() > 0 && this.isBoss()) {
            return super.m_6469_(source, amount);
        }
        if (this.isBoss() && (source.m_19384_() || source.m_19372_())) {
            if (source.m_19384_()) {
                return super.m_6469_(source, amount * 0.75f);
            }
            return super.m_6469_(source, amount * 0.25f);
        }
        Entity entity3 = attacker = source.m_7640_() != null ? source.m_7640_() : source.m_7639_();
        if (attacker == null && this.isBoss()) {
            if (source == ChangedAddonDamageSources.SOLVENT) {
                return super.m_6469_(source, amount * 1.25f);
            }
            if (source.m_19385_().contains("latex_solvent")) {
                return super.m_6469_(source, amount * 1.25f);
            }
            return super.m_6469_(source, amount * 0.25f);
        }
        if (attacker instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)attacker;
            if (this.isBoss()) {
                if (EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ChangedAddonEnchantments.SOLVENT.get()), (ItemStack)livingEntity.m_21205_()) >= 1) {
                    return super.m_6469_(source, amount * 1.25f);
                }
                if (source.m_19385_().contains("latex_solvent")) {
                    return super.m_6469_(source, amount * 1.25f);
                }
                float reducedAmount = amount / 6.0f;
                if (reducedAmount > 2.0f) {
                    if (reducedAmount < 4.0f) {
                        this.setDodging(attacker);
                    }
                    return super.m_6469_(source, reducedAmount);
                }
                this.setDodging(attacker);
                return false;
            }
        }
        return super.m_6469_(source, amount);
    }

    @Mod.EventBusSubscriber(modid="changed_addon")
    public static class WhenAttackAEntity {
        @SubscribeEvent
        public static void WhenAttack(LivingHurtEvent event) {
            AbstractLuminarcticLeopard lumi;
            EntityDamageSource entityDamageSource;
            LivingEntity target = event.getEntityLiving();
            Entity source = event.getSource().m_7639_();
            DamageSource damageSource = event.getSource();
            if (damageSource instanceof EntityDamageSource && (entityDamageSource = (EntityDamageSource)damageSource).m_19403_()) {
                return;
            }
            if (source instanceof AbstractLuminarcticLeopard && (lumi = (AbstractLuminarcticLeopard)source).m_21120_(InteractionHand.MAIN_HAND).m_41619_()) {
                ParticlesUtil.sendParticles(target.f_19853_, (ParticleOptions)ParticleTypes.f_175821_, target.m_146892_(), 0.3f, 0.5f, 0.3f, 4, 0.05f);
                target.m_146917_(target.m_146888_() + (int)((float)target.m_146891_() * 0.25f));
                target.m_5496_(SoundEvents.f_144205_, 2.0f, 1.0f);
            } else if (source instanceof Player) {
                Player player = (Player)source;
                TransfurVariantInstance instance = ProcessTransfur.getPlayerTransfurVariant((Player)player);
                if (player.m_21120_(InteractionHand.MAIN_HAND).m_41619_() && instance != null && instance.getParent().is(ChangedAddonTags.TransfurTypes.CAUSE_FREEZING)) {
                    ParticlesUtil.sendParticles(target.f_19853_, (ParticleOptions)ParticleTypes.f_175821_, target.m_146892_(), 0.3f, 0.5f, 0.3f, 4, 0.05f);
                    target.m_146917_(target.m_146888_() + (int)((float)target.m_146891_() * 0.25f));
                    target.m_5496_(SoundEvents.f_144205_, 2.0f, 1.0f);
                }
            }
        }

        @SubscribeEvent
        public static void onEntityDrop(LivingDropsEvent event) {
            AbstractLuminarcticLeopard leopard;
            LivingEntity entity = event.getEntityLiving();
            Level level = entity.f_19853_;
            if (entity instanceof AbstractLuminarcticLeopard && (leopard = (AbstractLuminarcticLeopard)entity).isBoss()) {
                ItemStack item = new ItemStack((ItemLike)ChangedAddonItems.LUMINAR_CRYSTAL_SHARD_HEARTED.get());
                ItemEntity drop = new ItemEntity(level, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), item);
                event.getDrops().add(drop);
            }
        }
    }
}

