/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.entity.goals.exp10;

import net.foxyas.changedaddon.entity.projectile.AbstractGenericParticleProjectile;
import net.foxyas.changedaddon.entity.projectile.WitherParticleProjectile;
import net.foxyas.changedaddon.init.ChangedAddonEntities;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ThrowWitherProjectileGoal
extends Goal {
    public final Mob holder;
    public int cooldown;
    protected final IntProvider cooldownProvider;
    protected final IntProvider maxUseTimesProvider;
    public int maxUseTimes;
    public int usedTimes;
    public int tick;
    public final float distance;

    public ThrowWitherProjectileGoal(Mob holder, IntProvider cooldownProvider, IntProvider maxUseTimesProvider) {
        this.holder = holder;
        this.cooldownProvider = cooldownProvider;
        this.maxUseTimesProvider = maxUseTimesProvider;
        this.distance = 25.0f;
    }

    public ThrowWitherProjectileGoal(Mob holder, IntProvider cooldownProvider, IntProvider maxUseTimesProvider, float distance) {
        this.holder = holder;
        this.cooldownProvider = cooldownProvider;
        this.maxUseTimesProvider = maxUseTimesProvider;
        this.distance = distance;
    }

    public boolean m_8036_() {
        if (this.holder.m_5448_() == null) {
            return false;
        }
        if (this.cooldown > 0) {
            --this.cooldown;
            return false;
        }
        return this.holder.m_20280_((Entity)this.holder.m_5448_()) >= (double)this.distance || this.holder.m_21187_().nextFloat() >= 0.9f;
    }

    public void m_8056_() {
        super.m_8056_();
        this.maxUseTimes = this.maxUseTimesProvider.m_142270_(this.holder.m_21187_());
    }

    public void m_8037_() {
        super.m_8037_();
        ++this.tick;
        LivingEntity target = this.holder.m_5448_();
        if (target == null) {
            return;
        }
        Level mobLevel = this.holder.m_183503_();
        if (this.usedTimes >= this.maxUseTimes) {
            return;
        }
        if (mobLevel instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)mobLevel;
            WitherParticleProjectile witherParticleProjectile = this.getWitherParticleProjectile(level, target);
            if (this.tick % 10 == 0) {
                this.holder.m_6674_(InteractionHand.MAIN_HAND);
                level.m_7967_((Entity)witherParticleProjectile);
                level.m_6269_(null, (Entity)this.holder, SoundEvents.f_11705_, SoundSource.HOSTILE, 1.0f, 1.0f);
                ++this.usedTimes;
            }
        }
    }

    public boolean m_6767_() {
        return false;
    }

    @NotNull
    private WitherParticleProjectile getWitherParticleProjectile(ServerLevel level, LivingEntity target) {
        this.holder.m_21563_().m_24964_(target.m_146892_());
        Vec3 motion = this.holder.m_20252_(1.0f);
        WitherParticleProjectile witherParticleProjectile = new WitherParticleProjectile((EntityType<? extends AbstractGenericParticleProjectile>)((EntityType)ChangedAddonEntities.WITHER_PARTICLE_PROJECTILE.get()), (Level)level);
        witherParticleProjectile.m_146884_(this.holder.m_146892_().m_82549_(motion));
        witherParticleProjectile.m_6686_(motion.f_82479_, motion.f_82480_, motion.f_82481_, 2.25f, 0.0f);
        witherParticleProjectile.m_5602_((Entity)this.holder);
        witherParticleProjectile.setCritArrow(this.holder.m_21187_().nextBoolean());
        witherParticleProjectile.setKnockback(2);
        witherParticleProjectile.setBaseDamage(5.0);
        return witherParticleProjectile;
    }

    public void m_8041_() {
        super.m_8041_();
        this.cooldown = this.cooldownProvider.m_142270_(this.holder.m_21187_());
        this.usedTimes = 0;
    }

    public boolean m_8045_() {
        boolean isDistance;
        if (this.holder.m_5448_() == null) {
            return false;
        }
        boolean bl = isDistance = this.holder.m_20280_((Entity)this.holder.m_5448_()) < (double)this.distance;
        if (isDistance || this.usedTimes >= this.maxUseTimes) {
            return false;
        }
        return this.cooldown <= 0;
    }
}

