/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.entity.goals.generic.attacks;

import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class BossComboAbilityGoal
extends Goal {
    private final Mob entity;
    private final Random random = new Random();
    private final int maxPhases;
    private final float minDistance;
    private final float maxDistance;
    private final float activationChance;
    private final Consumer<LivingEntity>[] phaseActions;
    private final Runnable onStart;
    private final Runnable onStop;
    private final int delay = 5;
    private LivingEntity target;
    private int phase = 0;
    private int ticks = 0;

    @SafeVarargs
    public BossComboAbilityGoal(Mob entity, int maxPhases, float minDistance, float maxDistance, float activationChance, Runnable onStart, Runnable onStop, Consumer<LivingEntity> ... phaseActions) {
        this.entity = entity;
        this.maxPhases = maxPhases;
        this.minDistance = minDistance;
        this.maxDistance = maxDistance;
        this.activationChance = activationChance;
        this.phaseActions = phaseActions;
        this.onStart = onStart;
        this.onStop = onStop;
    }

    public boolean m_8036_() {
        Player player;
        this.target = this.entity.m_5448_();
        LivingEntity livingEntity = this.target;
        if (livingEntity instanceof Player && ((player = (Player)livingEntity).m_7500_() || player.m_5833_())) {
            return false;
        }
        return this.target != null && this.target.m_20096_() && this.entity.m_20270_((Entity)this.target) >= this.minDistance && this.entity.m_20270_((Entity)this.target) <= this.maxDistance && this.random.nextFloat() <= this.activationChance;
    }

    public boolean m_8045_() {
        Player player;
        LivingEntity livingEntity = this.target;
        if (livingEntity instanceof Player && ((player = (Player)livingEntity).m_7500_() || player.m_5833_())) {
            return false;
        }
        return this.phase < this.maxPhases && this.target != null && this.target.m_6084_();
    }

    public void m_8056_() {
        super.m_8056_();
        this.phase = 0;
        this.ticks = 0;
        if (this.onStart != null) {
            this.onStart.run();
        }
        if (this.phaseActions.length > 0) {
            this.phaseActions[0].accept(this.target);
            ++this.phase;
        }
    }

    public void m_8037_() {
        super.m_8037_();
        ++this.ticks;
        if (this.ticks % 5 == 0 && this.phase < this.phaseActions.length) {
            this.phaseActions[this.phase].accept(this.target);
            ++this.phase;
        }
    }

    public void m_8041_() {
        super.m_8041_();
        if (this.onStop != null) {
            this.onStop.run();
        }
    }

    public static class DefaultCombos {
        private final LivingEntity attacker;
        private final LivingEntity target;
        private final float damage;
        private final SoundEvent[] impactSound;
        private final ParticleOptions[] impactParticle;

        public DefaultCombos(LivingEntity attacker, LivingEntity target, float damage, SoundEvent[] impactSound, ParticleOptions[] impactParticle) {
            this.attacker = attacker;
            this.target = target;
            this.damage = damage;
            this.impactSound = impactSound;
            this.impactParticle = impactParticle;
        }

        public void teleportToTarget() {
            if (this.target == null) {
                return;
            }
            this.attacker.m_6021_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
            LivingEntity livingEntity = this.attacker;
            if (livingEntity instanceof Mob) {
                Mob mob = (Mob)livingEntity;
                mob.m_21391_((Entity)this.target, 1.0f, 1.0f);
            }
            this.attacker.m_6674_(InteractionHand.MAIN_HAND);
            this.removeIframesFromTarget();
            this.target.m_6469_(DamageSource.m_19370_((LivingEntity)this.attacker), this.damage);
            this.spawnImpactEffect(this.target.m_20182_(), 0);
            this.spawnImpactParticleEffect(this.target.m_20182_(), 0);
        }

        public void removeIframesFromTarget() {
            this.target.f_19802_ = 0;
            this.target.f_20917_ = 1;
            this.target.f_20918_ = 1.0f;
            this.target.f_20916_ = 1;
        }

        public void teleportAndKnockback(float strength) {
            if (this.target == null) {
                return;
            }
            this.attacker.m_6021_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
            Vec3 knockDir = this.attacker.m_20154_().m_82490_((double)strength).m_82520_(0.0, 0.2, 0.0);
            this.target.m_20256_(knockDir);
            LivingEntity livingEntity = this.attacker;
            if (livingEntity instanceof Mob) {
                Mob mob = (Mob)livingEntity;
                mob.m_21391_((Entity)this.target, 1.0f, 1.0f);
            }
            this.attacker.m_6674_(InteractionHand.MAIN_HAND);
            this.removeIframesFromTarget();
            this.target.m_6469_(DamageSource.m_19370_((LivingEntity)this.attacker), this.damage / 2.0f);
            this.spawnImpactEffect(this.target.m_20182_(), 0);
            this.spawnImpactParticleEffect(this.target.m_20182_(), 0);
        }

        public void teleportAndKnockbackInAir(float strength) {
            if (this.target == null) {
                return;
            }
            this.attacker.m_6021_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
            Vec3 knockDir = this.attacker.m_20154_().m_82490_((double)strength).m_82520_(0.0, 0.2, 0.0);
            this.target.m_20256_(knockDir);
            LivingEntity livingEntity = this.attacker;
            if (livingEntity instanceof Mob) {
                Mob mob = (Mob)livingEntity;
                mob.m_21391_((Entity)this.target, 1.0f, 1.0f);
            }
            this.attacker.m_6674_(InteractionHand.MAIN_HAND);
            this.removeIframesFromTarget();
            this.target.m_6469_(DamageSource.m_19370_((LivingEntity)this.attacker), this.damage / 2.0f);
            this.applySlowFalling(this.target);
            this.spawnImpactEffect(this.target.m_20182_(), 0);
            this.spawnImpactParticleEffect(this.target.m_20182_(), 0);
        }

        public void uppercut() {
            if (this.target == null) {
                return;
            }
            this.attacker.m_6021_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
            this.target.m_20334_(0.0, 1.5, 0.0);
            LivingEntity livingEntity = this.attacker;
            if (livingEntity instanceof Mob) {
                Mob mob = (Mob)livingEntity;
                mob.m_21391_((Entity)this.target, 1.0f, 1.0f);
            }
            this.attacker.m_6674_(InteractionHand.MAIN_HAND);
            this.removeIframesFromTarget();
            this.target.m_6469_(DamageSource.m_19370_((LivingEntity)this.attacker), this.damage);
            this.applySlowFalling(this.target);
            this.spawnImpactEffect(this.target.m_20182_(), 1);
            this.spawnImpactParticleEffect(this.target.m_20182_(), 1);
        }

        public void slam() {
            if (this.target == null) {
                return;
            }
            this.attacker.m_6021_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
            this.target.m_20334_(0.0, -2.0, 0.0);
            LivingEntity livingEntity = this.attacker;
            if (livingEntity instanceof Mob) {
                Mob mob = (Mob)livingEntity;
                mob.m_21391_((Entity)this.target, 1.0f, 1.0f);
            }
            this.attacker.m_6674_(InteractionHand.MAIN_HAND);
            this.removeIframesFromTarget();
            this.target.m_6469_(DamageSource.m_19370_((LivingEntity)this.attacker), this.damage);
            this.spawnImpactEffect(this.target.m_20182_(), 2);
            this.spawnImpactParticleEffect(this.target.m_20182_(), 2);
            this.removeSlowFalling();
        }

        public void removeSlowFalling() {
            this.target.m_21195_(MobEffects.f_19591_);
            this.attacker.m_21195_(MobEffects.f_19591_);
        }

        public void applySlowFalling(LivingEntity entity) {
            MobEffectInstance slowFalling = new MobEffectInstance(MobEffects.f_19591_, 40, 0, false, false);
            entity.m_7292_(slowFalling);
            this.attacker.m_7292_(slowFalling);
        }

        public void spawnImpactEffect(Vec3 pos, int type) {
            Level level = this.attacker.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (type <= this.impactSound.length) {
                    this.attacker.m_5496_(this.impactSound[type], 2.0f, 1.0f);
                }
            }
        }

        public void spawnImpactParticleEffect(Vec3 pos, int type) {
            Level level = this.attacker.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (type <= this.impactParticle.length) {
                    serverLevel.m_8767_(this.impactParticle[type], pos.f_82479_, pos.f_82480_, pos.f_82481_, 3, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }
    }
}

