/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.entity.goals.generic.attacks;

import java.util.Random;
import net.foxyas.changedaddon.entity.bosses.VoidFoxEntity;
import net.foxyas.changedaddon.init.ChangedAddonTags;
import net.ltxprogrammer.changed.entity.ChangedEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public class SimpleComboAbilityGoal
extends Goal {
    private final Mob attacker;
    private final int maxPhases;
    private final Random random = new Random();
    private final float minRange;
    private final float maxRange;
    private final float damage;
    private final SoundEvent[] impactSound;
    private final ParticleOptions[] impactParticle;
    private LivingEntity target;
    private int phase = 0;
    private int ticks = 0;
    private int delay = 5;
    private boolean shouldEnd = false;

    public SimpleComboAbilityGoal(Mob attacker, int phases, float minRange, float maxRange, float damage, int delay, SoundEvent[] impactSounds, ParticleOptions[] impactParticle) {
        this.attacker = attacker;
        this.minRange = minRange;
        this.maxRange = maxRange;
        this.maxPhases = phases;
        this.damage = damage;
        this.delay = delay;
        this.impactSound = impactSounds;
        this.impactParticle = impactParticle;
    }

    public boolean isShouldEnd() {
        return this.shouldEnd;
    }

    public Mob getAttacker() {
        return this.attacker;
    }

    public LivingEntity getTarget() {
        return this.target;
    }

    public float getMinRange() {
        return this.minRange;
    }

    public float getMaxRange() {
        return this.maxRange;
    }

    public boolean m_8036_() {
        Player player;
        this.target = this.attacker.m_5448_();
        LivingEntity livingEntity = this.target;
        if (livingEntity instanceof Player && ((player = (Player)livingEntity).m_7500_() || player.m_5833_())) {
            return false;
        }
        return this.target != null && this.target.m_20096_() && this.attacker.m_20270_((Entity)this.target) >= this.minRange && this.attacker.m_20270_((Entity)this.target) <= this.maxRange && this.attacker.m_21187_().nextFloat() < 0.5f;
    }

    public boolean m_8045_() {
        Player player;
        LivingEntity livingEntity = this.target;
        if (livingEntity instanceof Player && ((player = (Player)livingEntity).m_7500_() || player.m_5833_())) {
            return false;
        }
        if (this.shouldEnd) {
            return false;
        }
        return this.phase <= this.maxPhases && this.target != null && this.target.m_6084_();
    }

    public void m_8056_() {
        this.phase = 0;
        this.ticks = 0;
        this.shouldEnd = false;
        this.teleportToTarget();
    }

    public void m_8037_() {
        ++this.ticks;
        if (this.ticks % this.delay == 0) {
            if (this.phase == 0) {
                if (this.attacker.m_21187_().nextFloat() >= 0.5f) {
                    this.uppercut();
                } else {
                    this.teleportAndKnockback(1.0f);
                }
            } else if (this.phase == this.maxPhases) {
                this.slam();
            } else if (!this.target.m_20096_()) {
                this.teleportAndKnockbackInAir(1.0f);
            } else if (this.attacker.m_21187_().nextFloat() >= 0.5f) {
                this.uppercut();
            } else {
                this.teleportAndKnockback(1.0f);
            }
            ++this.phase;
        }
    }

    public void m_8041_() {
        if (this.shouldEnd && this.phase < this.maxPhases) {
            this.slam();
        }
        if (!this.attacker.m_20096_()) {
            BlockPos pos = this.attacker.m_142538_();
            int groundY = this.attacker.f_19853_.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pos.m_123341_(), pos.m_123343_());
            Level world = this.attacker.f_19853_;
            if (world.m_6042_().m_63946_()) {
                int maxY;
                for (int y = maxY = world.m_141928_() - 1; y > 0; --y) {
                    BlockPos checkPos = new BlockPos(pos.m_123341_(), y, pos.m_123343_());
                    if (!world.m_46859_(checkPos) || !world.m_46859_(checkPos.m_7494_())) continue;
                    groundY = y;
                    break;
                }
            }
            this.attacker.m_6021_((double)pos.m_123341_() + 0.5, (double)groundY + 0.5, (double)pos.m_123343_() + 0.5);
            this.spawnImpactEffect(this.attacker.m_20182_(), 3);
            this.spawnImpactParticleEffect(this.target.m_20182_(), 2);
        }
        this.shouldEnd = false;
    }

    private void teleportToTarget() {
        if (this.target == null) {
            return;
        }
        this.attacker.m_6021_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
        this.attacker.m_6674_(InteractionHand.MAIN_HAND);
        this.attacker.m_21391_((Entity)this.target, 1.0f, 1.0f);
        this.removeIframesFromTarget();
        if (!this.target.m_21254_()) {
            this.target.m_6469_(DamageSource.m_19370_((LivingEntity)this.attacker), this.damage);
        } else {
            this.target.m_183503_().m_6269_(null, (Entity)this.target, SoundEvents.f_12346_, SoundSource.PLAYERS, 1.0f, 1.0f);
            this.shouldEnd = true;
        }
        this.spawnImpactEffect(this.target.m_20182_(), 0);
        this.spawnImpactParticleEffect(this.target.m_20182_(), 0);
    }

    private void removeIframesFromTarget() {
        this.target.f_19802_ = 0;
        this.target.f_20917_ = 1;
        this.target.f_20918_ = 1.0f;
        this.target.f_20916_ = 1;
    }

    private void teleportAndKnockback(float strength) {
        if (this.target == null) {
            return;
        }
        this.attacker.m_6021_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
        Vec3 knockDir = this.attacker.m_20154_().m_82490_((double)strength).m_82520_(0.0, 0.2, 0.0);
        this.target.m_20256_(knockDir);
        this.attacker.m_6674_(InteractionHand.MAIN_HAND);
        this.attacker.m_21391_((Entity)this.target, 1.0f, 1.0f);
        this.removeIframesFromTarget();
        if (!this.target.m_21254_()) {
            this.target.m_6469_(DamageSource.m_19370_((LivingEntity)this.attacker), this.damage / 2.0f);
        } else {
            this.target.m_183503_().m_6269_(null, (Entity)this.target, SoundEvents.f_12346_, SoundSource.PLAYERS, 1.0f, 1.0f);
            this.shouldEnd = true;
        }
        this.spawnImpactEffect(this.target.m_20182_(), 0);
        this.spawnImpactParticleEffect(this.target.m_20182_(), 0);
    }

    private void teleportAndKnockbackInAir(float strength) {
        if (this.target == null) {
            return;
        }
        this.attacker.m_6021_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
        Vec3 knockDir = this.attacker.m_20154_().m_82490_((double)strength).m_82520_(0.0, 0.2, 0.0);
        this.target.m_20256_(knockDir);
        this.attacker.m_6674_(InteractionHand.MAIN_HAND);
        this.attacker.m_21391_((Entity)this.target, 1.0f, 1.0f);
        this.removeIframesFromTarget();
        if (!this.target.m_21254_()) {
            this.target.m_6469_(DamageSource.m_19370_((LivingEntity)this.attacker), this.damage / 2.0f);
        } else {
            this.target.m_183503_().m_6269_(null, (Entity)this.target, SoundEvents.f_12346_, SoundSource.PLAYERS, 1.0f, 1.0f);
            this.shouldEnd = true;
        }
        this.applySlowFalling(this.target);
        this.spawnImpactEffect(this.target.m_20182_(), 0);
        this.spawnImpactParticleEffect(this.target.m_20182_(), 0);
    }

    private void uppercut() {
        if (this.target == null) {
            return;
        }
        this.attacker.m_6021_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
        this.target.m_20334_(0.0, 1.5, 0.0);
        this.attacker.m_6674_(InteractionHand.MAIN_HAND);
        this.attacker.m_21391_((Entity)this.target, 1.0f, 1.0f);
        this.removeIframesFromTarget();
        if (!this.target.m_21254_()) {
            this.target.m_6469_(DamageSource.m_19370_((LivingEntity)this.attacker), this.damage);
        } else {
            this.target.m_183503_().m_6269_(null, (Entity)this.target, SoundEvents.f_12346_, SoundSource.PLAYERS, 1.0f, 1.0f);
            this.shouldEnd = true;
        }
        this.applySlowFalling(this.target);
        this.spawnImpactEffect(this.target.m_20182_(), 1);
        this.spawnImpactParticleEffect(this.target.m_20182_(), 1);
    }

    private void slam() {
        if (this.target == null) {
            return;
        }
        this.attacker.m_6021_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
        this.target.m_20334_(0.0, -2.0, 0.0);
        this.attacker.m_6674_(InteractionHand.MAIN_HAND);
        this.attacker.m_21391_((Entity)this.target, 1.0f, 1.0f);
        this.removeIframesFromTarget();
        if (!this.target.m_21254_()) {
            this.target.m_6469_(DamageSource.m_19370_((LivingEntity)this.attacker), this.damage);
        } else {
            this.target.m_183503_().m_6269_(null, (Entity)this.target, SoundEvents.f_12346_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        this.spawnImpactEffect(this.target.m_20182_(), 2);
        this.spawnImpactParticleEffect(this.target.m_20182_(), 2);
        this.removeSlowFalling();
    }

    private void removeSlowFalling() {
        this.target.m_21195_(MobEffects.f_19591_);
        this.attacker.m_21195_(MobEffects.f_19591_);
    }

    private void applySlowFalling(LivingEntity entity) {
        MobEffectInstance slowFalling = new MobEffectInstance(MobEffects.f_19591_, 40, 0, false, false);
        entity.m_7292_(slowFalling);
        this.attacker.m_7292_(slowFalling);
    }

    private void spawnImpactEffect(Vec3 pos, int type) {
        Level level = this.attacker.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (type <= this.impactSound.length) {
                this.attacker.m_5496_(this.impactSound[type], 2.0f, 1.0f);
            }
        }
    }

    private void spawnImpactParticleEffect(Vec3 pos, int type) {
        Level level = this.attacker.f_19853_;
        if (level instanceof ServerLevel) {
            VoidFoxEntity voidFoxEntity;
            ChangedEntity changedEntity;
            Mob mob;
            ServerLevel serverLevel = (ServerLevel)level;
            if (type <= this.impactParticle.length) {
                serverLevel.m_8767_(this.impactParticle[type], pos.f_82479_, pos.f_82480_, pos.f_82481_, 3, 0.0, 0.0, 0.0, 0.0);
            }
            if (type != 1 && type != 2 && (mob = this.attacker) instanceof ChangedEntity && (changedEntity = (ChangedEntity)mob).getSelfVariant() != null && changedEntity.getSelfVariant().is(ChangedAddonTags.TransfurTypes.HAS_CLAWS) && changedEntity.m_21205_().m_41619_()) {
                this.doClawsAttackEffect((LivingEntity)changedEntity);
            }
            if (type != 1 && type != 2 && (mob = this.attacker) instanceof VoidFoxEntity && (voidFoxEntity = (VoidFoxEntity)mob).m_21205_().m_41619_()) {
                voidFoxEntity.doClawsAttackEffect();
            }
        }
    }

    public void doClawsAttackEffect(LivingEntity boss) {
        double d0 = (double)(-Mth.m_14031_((float)(boss.m_146908_() * ((float)Math.PI / 180)))) * 1.0;
        double d1 = (double)Mth.m_14089_((float)(boss.m_146908_() * ((float)Math.PI / 180))) * 1.0;
        Level level = boss.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123766_, boss.m_20185_() + d0, boss.m_20227_(0.5), boss.m_20189_() + d1, 0, d0, 0.0, d1, 0.0);
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123766_, boss.m_20185_() + d0, boss.m_20227_(0.6), boss.m_20189_() + d1, 0, d0, 0.0, d1, 0.0);
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123766_, boss.m_20185_() + d0, boss.m_20227_(0.7), boss.m_20189_() + d1, 0, d0, 0.0, d1, 0.0);
            boss.f_19853_.m_6263_(null, boss.m_20185_(), boss.m_20186_(), boss.m_20189_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 0.75f);
        }
    }
}

