/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.entity.goals.simple;

import java.util.EnumSet;
import net.foxyas.changedaddon.item.LaserPointer;
import net.ltxprogrammer.changed.entity.ChangedEntity;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class FollowAndLookAtLaser
extends Goal {
    private final Mob mob;
    private final double speedModifier;
    private LivingEntity laserPlayer;
    @Nullable
    private Vec3 laserTarget;

    public FollowAndLookAtLaser(Mob mob, double speedModifier) {
        this.mob = mob;
        this.speedModifier = speedModifier;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public void setLaserTarget(Vec3 laserTarget, LivingEntity laserPlayer) {
        this.laserPlayer = laserPlayer;
        this.laserTarget = laserTarget;
    }

    public void clearLaserTarget() {
        this.laserTarget = null;
        this.laserPlayer = null;
    }

    private boolean isPlayerUsingLaser() {
        if (this.laserPlayer == null) {
            return false;
        }
        ItemStack using = this.laserPlayer.m_21211_();
        return using.m_41720_() instanceof LaserPointer && this.laserPlayer.m_6117_();
    }

    public boolean m_8036_() {
        return this.laserTarget != null && this.isPlayerUsingLaser() && this.hasLineOfSight(this.laserTarget) && Math.sqrt(this.mob.m_20238_(this.laserTarget)) < 100.0;
    }

    public boolean m_8045_() {
        return this.laserTarget != null && this.isPlayerUsingLaser() && this.hasLineOfSight(this.laserTarget) && Math.sqrt(this.mob.m_20238_(this.laserTarget)) < 100.0;
    }

    private boolean hasLineOfSight(Vec3 target) {
        return this.mob.f_19853_.m_45547_(new ClipContext(this.mob.m_146892_(), target, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.mob)).m_6662_() == HitResult.Type.MISS;
    }

    public void m_8056_() {
        super.m_8056_();
        this.mob.m_5496_(SoundEvents.f_11785_, 1.0f, 1.0f);
    }

    public void m_8037_() {
        ChangedEntity ce;
        Mob mob;
        if (this.laserTarget == null || !this.isPlayerUsingLaser()) {
            return;
        }
        if (this.mob.m_5448_() != null || (mob = this.mob) instanceof ChangedEntity && (ce = (ChangedEntity)mob).m_5448_() != null) {
            return;
        }
        if (!this.mob.m_142582_((Entity)this.laserPlayer)) {
            return;
        }
        this.mob.m_21563_().m_24946_(this.laserTarget.f_82479_, this.laserTarget.f_82480_, this.laserTarget.f_82481_);
        if (this.mob.m_20238_(this.laserTarget) > 2.0) {
            this.mob.m_21573_().m_26519_(this.laserTarget.f_82479_, this.laserTarget.f_82480_, this.laserTarget.f_82481_, this.speedModifier);
        } else {
            this.mob.m_21573_().m_26573_();
        }
    }

    public void m_8041_() {
        this.mob.m_21573_().m_26573_();
        this.clearLaserTarget();
    }
}

