/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.entity.goals.void_fox;

import net.foxyas.changedaddon.entity.bosses.VoidFoxEntity;
import net.foxyas.changedaddon.entity.projectile.AbstractVoidFoxParticleProjectile;
import net.foxyas.changedaddon.entity.projectile.VoidFoxParticleProjectile;
import net.foxyas.changedaddon.init.ChangedAddonEntities;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class VoidFoxAntiFlyingAttack
extends Goal {
    private final Mob attacker;
    private final int delay;
    private final float minRange;
    private final float maxRange;
    private final float damage;
    private final EntityType<? extends AbstractVoidFoxParticleProjectile> projectileType = (EntityType)ChangedAddonEntities.PARTICLE_PROJECTILE.get();
    private LivingEntity target;
    private int ticks = 0;

    public VoidFoxAntiFlyingAttack(Mob attacker, float minRange, float maxRange, float damage, int delay) {
        this.attacker = attacker;
        this.minRange = minRange;
        this.maxRange = maxRange;
        this.damage = damage;
        this.delay = delay;
    }

    public Mob getAttacker() {
        return this.attacker;
    }

    public LivingEntity getTarget() {
        return this.target;
    }

    public float getMinRange() {
        return this.minRange;
    }

    public float getMaxRange() {
        return this.maxRange;
    }

    public boolean m_8036_() {
        this.target = this.attacker.m_5448_();
        LivingEntity livingEntity = this.target;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (player.m_7500_() || player.m_5833_()) {
                return false;
            }
            return player.m_150110_().f_35935_ && this.attacker.m_20270_((Entity)player) <= this.maxRange;
        }
        return this.target != null && !this.target.m_20096_() && this.attacker.m_20270_((Entity)this.target) >= this.minRange && this.attacker.m_20270_((Entity)this.target) <= this.maxRange;
    }

    public boolean m_8045_() {
        LivingEntity livingEntity = this.target;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (player.m_7500_() || player.m_5833_()) {
                return false;
            }
            return player.m_6084_() && !player.m_20096_();
        }
        return this.target != null && this.target.m_6084_() && !this.target.m_20096_();
    }

    public void m_8056_() {
        this.shootProjectile(this.target);
        this.attacker.m_183503_().m_6269_(null, (Entity)this.attacker, SoundEvents.f_11887_, SoundSource.HOSTILE, 2.0f, 1.0f);
        if (this.attacker.m_146892_().m_82554_(this.target.m_146892_()) <= 2.0) {
            this.teleportAndKnockbackInAir(1.0f);
        }
    }

    public boolean m_183429_() {
        return true;
    }

    protected int m_183277_(int delay) {
        return super.m_183277_(delay);
    }

    public boolean m_6767_() {
        return false;
    }

    public void m_8037_() {
        ++this.ticks;
        if (this.ticks % this.delay == 0) {
            Player player;
            LivingEntity livingEntity = this.target;
            if (livingEntity instanceof Player && (player = (Player)livingEntity).m_6084_() && !player.m_20096_() && player.m_150110_().f_35935_) {
                if (this.attacker.m_20270_((Entity)this.target) >= 2.0f) {
                    this.shootProjectile(this.target);
                    this.attacker.m_183503_().m_6269_(null, (Entity)this.attacker, SoundEvents.f_11887_, SoundSource.HOSTILE, 2.0f, 1.0f);
                } else if (this.attacker.m_20270_((Entity)this.target) <= 2.0f && this.attacker.m_20096_()) {
                    this.slam();
                }
            } else {
                Player player2;
                livingEntity = this.target;
                if (livingEntity instanceof Player && (player2 = (Player)livingEntity).m_6084_() && !player2.m_20096_() && player2.m_21255_()) {
                    if (this.attacker.m_146892_().m_82554_(this.target.m_146892_()) <= 2.0 && this.attacker.m_20096_()) {
                        this.slam();
                    } else {
                        this.shootProjectile(this.target);
                        this.attacker.m_183503_().m_6269_(null, (Entity)this.attacker, SoundEvents.f_11887_, SoundSource.HOSTILE, 2.0f, 1.0f);
                    }
                }
            }
            if (!this.target.m_20096_()) {
                if (this.attacker.m_146892_().m_82554_(this.target.m_146892_()) <= 2.0 && this.attacker.m_20096_()) {
                    this.slam();
                } else {
                    this.shootProjectile(this.target);
                    this.attacker.m_183503_().m_6269_(null, (Entity)this.attacker, SoundEvents.f_11887_, SoundSource.HOSTILE, 2.0f, 1.0f);
                }
            }
        } else {
            this.attacker.m_21573_().m_26573_();
            this.attacker.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
            Level level = this.attacker.m_183503_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123809_, this.attacker.m_20185_(), this.attacker.m_20188_(), this.attacker.m_20189_(), 4, 0.25, 0.5, 0.25, 0.5);
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123810_, this.attacker.m_20185_(), this.attacker.m_20188_(), this.attacker.m_20189_(), 4, 0.25, 0.5, 0.25, (double)0.05f);
            }
        }
    }

    public void m_8041_() {
        if (!this.attacker.m_20096_()) {
            BlockPos pos = this.attacker.m_142538_();
            int groundY = this.attacker.f_19853_.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pos.m_123341_(), pos.m_123343_());
            Level world = this.attacker.f_19853_;
            if (world.m_6042_().m_63946_()) {
                int maxY;
                for (int y = maxY = world.m_141928_() - 1; y > 0; --y) {
                    BlockPos checkPos = new BlockPos(pos.m_123341_(), y, pos.m_123343_());
                    if (!world.m_46859_(checkPos) || !world.m_46859_(checkPos.m_7494_())) continue;
                    groundY = y;
                    break;
                }
            }
            this.attacker.m_6021_((double)pos.m_123341_() + 0.5, (double)groundY + 0.5, (double)pos.m_123343_() + 0.5);
            this.spawnImpactEffect(this.attacker.m_20182_(), 3);
            this.spawnImpactParticleEffect(this.target.m_20182_(), 2);
        }
    }

    private void removeIframesFromTarget() {
        this.target.f_19802_ = 0;
        this.target.f_20917_ = 1;
        this.target.f_20918_ = 1.0f;
        this.target.f_20916_ = 1;
    }

    private void teleportAndKnockbackInAir(float strength) {
        if (this.target == null) {
            return;
        }
        this.attacker.m_6021_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
        Vec3 knockDir = this.attacker.m_20154_().m_82490_((double)strength).m_82520_(0.0, 0.2, 0.0);
        this.target.m_20256_(knockDir);
        this.attacker.m_6674_(InteractionHand.MAIN_HAND);
        this.removeIframesFromTarget();
        if (!this.target.m_21254_()) {
            this.target.m_6469_(DamageSource.m_19370_((LivingEntity)this.attacker), this.damage / 2.0f);
        } else {
            this.target.m_183503_().m_6269_(null, (Entity)this.target, SoundEvents.f_12346_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        this.applySlowFalling(this.target);
        this.spawnImpactEffect(this.target.m_20182_(), 0);
        this.spawnImpactParticleEffect(this.target.m_20182_(), 0);
    }

    private void slam() {
        if (this.target == null) {
            return;
        }
        LivingEntity livingEntity = this.target;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (player.m_150110_().f_35935_) {
                player.m_150110_().f_35935_ = false;
                player.m_6885_();
            }
        }
        this.attacker.m_6021_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
        this.target.m_20334_(0.0, -4.0, 0.0);
        this.attacker.m_6674_(InteractionHand.MAIN_HAND);
        this.removeIframesFromTarget();
        if (!this.target.m_21254_()) {
            this.target.m_6469_(DamageSource.m_19370_((LivingEntity)this.attacker), this.damage);
        } else {
            this.target.m_183503_().m_6269_(null, (Entity)this.target, SoundEvents.f_12346_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        this.spawnImpactEffect(this.target.m_20182_(), 2);
        this.spawnImpactParticleEffect(this.target.m_20182_(), 2);
        this.removeSlowFalling();
    }

    private void removeSlowFalling() {
        this.target.m_21195_(MobEffects.f_19591_);
        this.attacker.m_21195_(MobEffects.f_19591_);
    }

    private void applySlowFalling(LivingEntity entity) {
        MobEffectInstance slowFalling = new MobEffectInstance(MobEffects.f_19591_, 40, 0, false, false);
        entity.m_7292_(slowFalling);
        this.attacker.m_7292_(slowFalling);
    }

    private void spawnImpactEffect(Vec3 pos, int type) {
        Level level = this.attacker.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.attacker.m_5496_(SoundEvents.f_12313_, 2.0f, 1.0f);
        }
    }

    private void spawnImpactParticleEffect(Vec3 pos, int type) {
        Level level = this.attacker.f_19853_;
        if (level instanceof ServerLevel) {
            VoidFoxEntity voidFoxEntity;
            Mob mob;
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123747_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 3, 0.0, 0.0, 0.0, 0.0);
            if (type == 0 && (mob = this.attacker) instanceof VoidFoxEntity && (voidFoxEntity = (VoidFoxEntity)mob).m_21205_().m_41619_()) {
                voidFoxEntity.doClawsAttackEffect();
            }
        }
    }

    protected void shootProjectile(LivingEntity target) {
        Level level = this.attacker.f_19853_;
        switch (this.attacker.m_21187_().nextInt(3)) {
            case 0: {
                this.spawnProjectilesInCircle((LivingEntity)this.attacker, target, new Vec3(0.0, 0.5, 0.0), 2.0, 4, level);
                break;
            }
            case 1: {
                this.spawnProjectilesInXCircleTargetInPlayer((LivingEntity)this.attacker, target, new Vec3(0.0, 0.0, 0.0), 2.0, 8, level);
                break;
            }
            case 2: {
                this.spawnProjectilesInXCircleTargetInPlayerPos((LivingEntity)this.attacker, target, new Vec3(0.0, 0.0, 0.0), 2.0, 8, level);
            }
        }
    }

    public void spawnProjectilesInCircle(LivingEntity entity, LivingEntity target, Vec3 offset, double radius, int count, Level level) {
        Vec3 center = entity.m_146892_().m_82549_(offset);
        for (int i = 0; i < count; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)count;
            Vec3 dir = new Vec3(1.0, 0.0, 0.0).m_82535_((float)angle).m_82524_((float)Math.toRadians(-this.attacker.m_146908_())).m_82541_();
            Vec3 spawnPos = center.m_82549_(dir.m_82490_(radius));
            if (level.m_5776_()) continue;
            VoidFoxParticleProjectile projectile = this.getParticleProjectile(target, spawnPos);
            projectile.teleport = false;
            Vec3 direction = target.m_20299_(1.0f).m_82546_(this.attacker.m_20299_(0.5f)).m_82541_();
            projectile.m_6686_(direction.f_82479_, direction.f_82480_, direction.f_82481_, 1.5f, 0.0f);
            entity.f_19853_.m_7967_((Entity)projectile);
        }
        this.attacker.m_6674_(InteractionHand.MAIN_HAND);
    }

    public void spawnProjectilesInXCircleTargetInPlayer(LivingEntity entity, LivingEntity target, Vec3 offset, double radius, int count, Level level) {
        Vec3 center = target.m_146892_().m_82549_(offset);
        for (int i = 0; i < count; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)count;
            Vec3 dir = new Vec3(1.0, 0.0, 0.0).m_82524_((float)angle).m_82541_();
            Vec3 spawnPos = center.m_82549_(dir.m_82490_(radius));
            if (level.m_5776_()) continue;
            VoidFoxParticleProjectile projectile = this.getParticleProjectile(target, spawnPos);
            projectile.teleport = false;
            Vec3 direction = target.m_20299_(1.0f).m_82546_(this.attacker.m_20299_(0.5f)).m_82541_();
            projectile.m_6686_(direction.f_82479_, direction.f_82480_, direction.f_82481_, 1.5f, 0.0f);
            entity.f_19853_.m_7967_((Entity)projectile);
        }
        this.attacker.m_6674_(InteractionHand.MAIN_HAND);
    }

    @NotNull
    private VoidFoxParticleProjectile getParticleProjectile(LivingEntity target, Vec3 spawnPos) {
        VoidFoxParticleProjectile projectile = new VoidFoxParticleProjectile(this.projectileType, (LivingEntity)this.attacker, this.attacker.m_183503_(), target){

            @Override
            protected void m_5790_(@NotNull EntityHitResult result) {
                super.m_5790_(result);
                Entity entity = result.m_82443_();
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    if (player.m_150110_().f_35935_) {
                        player.m_5661_((Component)new TextComponent("Flying will not help you! so is better STOP!").m_130938_(style -> {
                            Style returnStyle = style.m_131140_(ChatFormatting.DARK_GRAY);
                            returnStyle = returnStyle.m_131155_(Boolean.valueOf(true));
                            return returnStyle;
                        }), true);
                    }
                }
            }
        };
        projectile.m_146884_(spawnPos);
        projectile.m_20242_(true);
        projectile.m_5602_((Entity)this.attacker);
        return projectile;
    }

    public void spawnProjectilesInXCircleTargetInPlayerPos(LivingEntity entity, LivingEntity target, Vec3 offset, double radius, int count, Level level) {
        Vec3 center = target.m_146892_().m_82549_(offset);
        for (int i = 0; i < count; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)count;
            Vec3 dir = new Vec3(1.0, 0.0, 0.0).m_82496_((float)angle).m_82541_();
            Vec3 spawnPos = center.m_82549_(dir.m_82490_(radius));
            if (level.m_5776_()) continue;
            VoidFoxParticleProjectile projectile = new VoidFoxParticleProjectile(this.projectileType, (LivingEntity)this.attacker, this.attacker.m_183503_(), null){

                @Override
                protected void m_5790_(@NotNull EntityHitResult result) {
                    super.m_5790_(result);
                    Entity entity = result.m_82443_();
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        if (player.m_150110_().f_35935_) {
                            player.m_5661_((Component)new TextComponent("Flying will not help you! so is better STOP!").m_130938_(style -> {
                                Style returnStyle = style.m_131140_(ChatFormatting.DARK_GRAY);
                                returnStyle = returnStyle.m_131155_(Boolean.valueOf(true));
                                return returnStyle;
                            }), true);
                        }
                    }
                }
            };
            projectile.setTargetPos(target.m_20182_());
            projectile.m_146884_(spawnPos);
            projectile.m_20242_(true);
            projectile.m_5602_((Entity)this.attacker);
            projectile.teleport = false;
            Vec3 direction = target.m_20299_(1.0f).m_82546_(this.attacker.m_20299_(0.5f)).m_82541_();
            projectile.m_6686_(direction.f_82479_, direction.f_82480_, direction.f_82481_, 1.5f, 0.0f);
            entity.f_19853_.m_7967_((Entity)projectile);
        }
        this.attacker.m_6674_(InteractionHand.MAIN_HAND);
    }
}

