/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.entity.mobs;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.foxyas.changedaddon.init.ChangedAddonEntities;
import net.foxyas.changedaddon.init.ChangedAddonItems;
import net.foxyas.changedaddon.world.inventory.FoxyasGuiMenu;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.EntityArmorInvWrapper;
import net.minecraftforge.items.wrapper.EntityHandsInvWrapper;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import org.jetbrains.annotations.NotNull;

public class FoxyasEntity
extends Monster {
    private final ItemStackHandler inventory = new ItemStackHandler(9);
    private final CombinedInvWrapper combined = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inventory, new EntityHandsInvWrapper((LivingEntity)this), new EntityArmorInvWrapper((LivingEntity)this)});

    public FoxyasEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<FoxyasEntity>)((EntityType)ChangedAddonEntities.FOXYAS.get()), world);
    }

    public FoxyasEntity(EntityType<FoxyasEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 10;
        this.m_21557_(false);
        this.m_21530_();
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.3);
        builder = builder.m_22268_(Attributes.f_22276_, 24.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 5.0);
        builder = builder.m_22268_(Attributes.f_22277_, 16.0);
        return builder;
    }

    @NotNull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.m_21573_().m_26575_().m_77355_(true);
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false){

            protected double m_6639_(@NotNull LivingEntity entity) {
                return this.f_25540_.m_20205_() * this.f_25540_.m_20205_() + entity.m_20205_();
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, ServerPlayer.class, 6.0f));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0){

            public boolean m_8036_() {
                return super.m_8036_() && !FoxyasEntity.this.m_20069_();
            }

            public boolean m_8045_() {
                return super.m_8045_() && !FoxyasEntity.this.m_20069_();
            }
        });
        this.f_21345_.m_25352_(7, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 40){

            public boolean m_8036_() {
                return super.m_8036_() && FoxyasEntity.this.m_20069_();
            }

            public boolean m_8045_() {
                return super.m_8045_() && FoxyasEntity.this.m_20069_();
            }
        });
        this.f_21346_.m_25352_(8, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(9, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(10, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(11, (Goal)new OpenDoorGoal((Mob)this, true));
        this.f_21345_.m_25352_(12, (Goal)new OpenDoorGoal((Mob)this, false));
    }

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    @NotNull
    public SoundEvent m_7975_(@NotNull DamageSource ds) {
        return SoundEvents.f_11915_;
    }

    @NotNull
    public SoundEvent m_5592_() {
        return SoundEvents.f_11910_;
    }

    public void m_6667_(@NotNull DamageSource source) {
        super.m_6667_(source);
        Entity entity = source.m_7639_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            Advancement _adv = player.f_8924_.m_129889_().m_136041_(new ResourceLocation("changed_addon:foxyas_advancement"));
            AdvancementProgress _ap = player.m_8960_().m_135996_(_adv);
            if (!_ap.m_8193_()) {
                for (String s : _ap.m_8219_()) {
                    player.m_8960_().m_135988_(_adv, s);
                }
            }
        }
    }

    public void doTrade() {
        ItemStack oranges = this.combined.getStackInSlot(0);
        if (oranges.m_41613_() < 2) {
            return;
        }
        ItemStack bottles = this.combined.getStackInSlot(1);
        if (bottles.m_41613_() < 1) {
            return;
        }
        ItemStack tmp = oranges.m_41777_();
        tmp.m_41764_(oranges.m_41613_() - 2);
        this.combined.setStackInSlot(0, tmp);
        tmp = bottles.m_41777_();
        tmp.m_41764_(bottles.m_41613_() - 1);
        this.combined.setStackInSlot(1, tmp);
        tmp = new ItemStack((ItemLike)ChangedAddonItems.ORANGE_JUICE.get());
        tmp = this.combined.insertItem(2, tmp, false);
        if (!tmp.m_41619_()) {
            Block.m_49840_((Level)this.f_19853_, (BlockPos)this.m_142538_(), (ItemStack)tmp);
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        if (this.m_6084_() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && side == null) {
            return LazyOptional.of(() -> this.combined).cast();
        }
        return super.getCapability(capability, side);
    }

    protected void m_5907_() {
        super.m_5907_();
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack itemstack = this.inventory.getStackInSlot(i);
            if (itemstack.m_41619_() || EnchantmentHelper.m_44924_((ItemStack)itemstack)) continue;
            this.m_19983_(itemstack);
        }
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128365_("InventoryCustom", (Tag)this.inventory.serializeNBT());
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        Tag inventoryCustom = compound.m_128423_("InventoryCustom");
        if (inventoryCustom instanceof CompoundTag) {
            CompoundTag inventoryTag = (CompoundTag)inventoryCustom;
            this.inventory.deserializeNBT(inventoryTag);
        }
    }

    @NotNull
    public InteractionResult m_6071_(Player sourceentity, @NotNull InteractionHand hand) {
        InteractionResult retval = InteractionResult.m_19078_((boolean)this.f_19853_.m_5776_());
        if (sourceentity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)sourceentity;
            NetworkHooks.openGui((ServerPlayer)serverPlayer, (MenuProvider)new MenuProvider(){

                @NotNull
                public Component m_5446_() {
                    return new TextComponent("Foxyas");
                }

                public AbstractContainerMenu m_7208_(int id, @NotNull Inventory inventory, @NotNull Player player) {
                    return new FoxyasGuiMenu(id, inventory, FoxyasEntity.this);
                }
            }, buf -> buf.m_130130_(this.m_142049_()));
        }
        super.m_6071_(sourceentity, hand);
        this.m_21573_().m_26519_(sourceentity.m_20185_(), sourceentity.m_20186_(), sourceentity.m_20189_(), 1.0);
        return retval;
    }

    public void m_6075_() {
        super.m_6075_();
        Vec3 _center = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
        List _entfound = this.f_19853_.m_6443_(Entity.class, new AABB(_center, _center).m_82400_(10.0), e -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.m_20238_(_center))).collect(Collectors.toList());
        for (Entity entityiterator : _entfound) {
            if (!entityiterator.getPersistentData().m_128471_("FoxyasGui_open")) continue;
            this.m_21573_().m_26519_(entityiterator.m_20185_(), entityiterator.m_20186_(), entityiterator.m_20189_(), 0.8);
            break;
        }
        if (this.m_20069_() && this.m_5842_() && !this.m_20096_()) {
            this.m_20124_(Pose.SWIMMING);
        } else if (this.m_20069_() && !this.m_5842_() && this.m_20096_()) {
            this.m_20124_(Pose.STANDING);
        } else if (!this.m_20069_() && !this.m_5842_() && this.m_20096_()) {
            this.m_20124_(Pose.STANDING);
        }
        if (this.m_20069_()) {
            float deltaZ;
            float deltaY;
            LivingEntity target = this.m_5448_();
            if (target == null) {
                return;
            }
            float deltaX = (float)(target.m_20185_() - this.m_20185_());
            float distance = (float)Math.sqrt(deltaX * deltaX + (deltaY = (float)(target.m_20186_() - this.m_20186_())) * deltaY + (deltaZ = (float)(target.m_20189_() - this.m_20189_())) * deltaZ);
            if (distance > 0.0f) {
                float speed = 0.04f;
                float motionX = deltaX / distance * speed;
                float motionY = deltaY / distance * speed;
                float motionZ = deltaZ / distance * speed;
                this.m_7618_(EntityAnchorArgument.Anchor.EYES, new Vec3(target.m_20185_(), target.m_20186_(), target.m_20189_()));
                this.m_20256_(this.m_20184_().m_82520_((double)motionX, (double)motionY, (double)motionZ));
            }
        }
    }
}

