/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.entity.projectile;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.foxyas.changedaddon.util.DynamicClipContext;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.IndirectEntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;

public abstract class ParriableProjectile
extends Projectile {
    private static final double ARROW_BASE_DAMAGE = 2.0;
    private static final EntityDataAccessor<Byte> ID_FLAGS = SynchedEntityData.m_135353_(ParriableProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Byte> PIERCE_LEVEL = SynchedEntityData.m_135353_(ParriableProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final int FLAG_CRIT = 1;
    private static final int FLAG_NO_PHYSICS = 2;
    private static final int FLAG_CROSSBOW = 4;
    private double baseDamage = 2.0;
    private int knockback;
    private SoundEvent soundEvent = this.getDefaultHitGroundSoundEvent();
    @Nullable
    private IntOpenHashSet piercingIgnoreEntityIds;
    @Nullable
    private List<Entity> piercedAndKilledEntities;

    protected ParriableProjectile(EntityType<? extends ParriableProjectile> entityType, Level level) {
        super(entityType, level);
    }

    protected ParriableProjectile(EntityType<? extends ParriableProjectile> entityType, double x, double y, double z, Level level) {
        this(entityType, level);
        this.m_6034_(x, y, z);
    }

    protected ParriableProjectile(EntityType<? extends ParriableProjectile> entityType, LivingEntity shooter, Level level) {
        this(entityType, shooter.m_20185_(), shooter.m_20188_() - (double)0.1f, shooter.m_20189_(), level);
        this.m_5602_((Entity)shooter);
    }

    public void setSoundEvent(SoundEvent pSoundEvent) {
        this.soundEvent = pSoundEvent;
    }

    public boolean m_6783_(double pDistance) {
        double d0 = this.m_142469_().m_82309_() * 10.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return pDistance < (d0 *= 64.0 * ParriableProjectile.m_20150_()) * d0;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(ID_FLAGS, (Object)0);
        this.f_19804_.m_135372_(PIERCE_LEVEL, (Object)0);
    }

    public void m_6453_(double pX, double pY, double pZ, float pYaw, float pPitch, int pPosRotationIncrements, boolean pTeleport) {
        this.m_6034_(pX, pY, pZ);
        this.m_19915_(pYaw, pPitch);
    }

    public void m_8119_() {
        VoxelShape voxelshape;
        BlockPos blockpos;
        BlockState blockstate;
        super.m_8119_();
        boolean flag = this.isNoPhysics();
        Vec3 vec3 = this.m_20184_();
        if (this.f_19860_ == 0.0f && this.f_19859_ == 0.0f) {
            double d0 = vec3.m_165924_();
            this.m_146922_((float)(Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_) * 57.2957763671875));
            this.m_146926_((float)(Mth.m_14136_((double)vec3.f_82480_, (double)d0) * 57.2957763671875));
            this.f_19859_ = this.m_146908_();
            this.f_19860_ = this.m_146909_();
        }
        if (!((blockstate = this.f_19853_.m_8055_(blockpos = this.m_142538_())).m_60795_() || this.ignoreBlock(blockstate) || flag || (voxelshape = blockstate.m_60812_((BlockGetter)this.f_19853_, blockpos)).m_83281_())) {
            Vec3 vec31 = this.m_20182_();
            for (AABB aabb : voxelshape.m_83299_()) {
                if (!aabb.m_82338_(blockpos).m_82390_(vec31)) continue;
                this.onHitBlock();
                return;
            }
        }
        if (this.m_20070_() || blockstate.m_60713_(Blocks.f_152499_)) {
            this.m_20095_();
        }
        Vec3 vec32 = this.m_20182_();
        Vec3 vec33 = vec32.m_82549_(vec3);
        BlockHitResult hitresult = this.f_19853_.m_45547_((ClipContext)new DynamicClipContext(vec32, vec33, (state, b, pos, context) -> {
            if (this.ignoreBlock(state)) {
                return Shapes.m_83040_();
            }
            return ClipContext.Block.COLLIDER.m_7544_(state, b, pos, context);
        }, arg_0 -> ((ClipContext.Fluid)ClipContext.Fluid.NONE).m_45731_(arg_0), CollisionContext.m_82750_((Entity)this)));
        if (hitresult.m_6662_() != HitResult.Type.MISS) {
            vec33 = hitresult.m_82450_();
        }
        while (!this.m_146910_()) {
            EntityHitResult entityhitresult = this.findHitEntity(vec32, vec33);
            if (entityhitresult != null) {
                hitresult = entityhitresult;
            }
            if (hitresult != null && hitresult.m_6662_() == HitResult.Type.ENTITY) {
                Entity entity = ((EntityHitResult)hitresult).m_82443_();
                Entity entity1 = this.m_37282_();
                if (entity instanceof Player) {
                    Player player1;
                    Player player = (Player)entity;
                    if (entity1 instanceof Player && !(player1 = (Player)entity1).m_7099_(player)) {
                        hitresult = null;
                        entityhitresult = null;
                    }
                }
            }
            if (hitresult != null && hitresult.m_6662_() != HitResult.Type.MISS && !flag && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
                this.m_6532_((HitResult)hitresult);
                this.f_19812_ = true;
            }
            if (entityhitresult == null || this.getPierceLevel() <= 0) break;
            hitresult = null;
        }
        vec3 = this.m_20184_();
        double d5 = vec3.f_82479_;
        double d6 = vec3.f_82480_;
        double d1 = vec3.f_82481_;
        if (this.isCritArrow()) {
            for (int i = 0; i < 4; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123797_, this.m_20185_() + d5 * (double)i / 4.0, this.m_20186_() + d6 * (double)i / 4.0, this.m_20189_() + d1 * (double)i / 4.0, -d5, -d6 + 0.2, -d1);
            }
        }
        double d7 = this.m_20185_() + d5;
        double d2 = this.m_20186_() + d6;
        double d3 = this.m_20189_() + d1;
        double d4 = vec3.m_165924_();
        if (flag) {
            this.m_146922_((float)(Mth.m_14136_((double)(-d5), (double)(-d1)) * 57.2957763671875));
        } else {
            this.m_146922_((float)(Mth.m_14136_((double)d5, (double)d1) * 57.2957763671875));
        }
        this.m_146926_((float)(Mth.m_14136_((double)d6, (double)d4) * 57.2957763671875));
        this.m_146926_(ParriableProjectile.m_37273_((float)this.f_19860_, (float)this.m_146909_()));
        this.m_146922_(ParriableProjectile.m_37273_((float)this.f_19859_, (float)this.m_146908_()));
        float f = 0.99f;
        if (this.m_20069_()) {
            for (int j = 0; j < 4; ++j) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123795_, d7 - d5 * 0.25, d2 - d6 * 0.25, d3 - d1 * 0.25, d5, d6, d1);
            }
            f = this.getWaterInertia();
        }
        this.m_20256_(vec3.m_82490_((double)f));
        if (!this.m_20068_() && !flag) {
            Vec3 vec34 = this.m_20184_();
            this.m_20334_(vec34.f_82479_, vec34.f_82480_ - (double)0.05f, vec34.f_82481_);
        }
        this.m_6034_(d7, d2, d3);
        this.m_20101_();
    }

    protected DamageSource damageSource() {
        Entity owner = this.m_37282_();
        return new IndirectEntityDamageSource("arrow", (Entity)this, (Entity)(owner != null ? owner : this)).m_19366_();
    }

    protected void m_5790_(@NotNull EntityHitResult pResult) {
        Entity entity1;
        super.m_5790_(pResult);
        Entity entity = pResult.m_82443_();
        float f = (float)this.m_20184_().m_82553_();
        int i = Mth.m_14165_((double)Mth.m_14008_((double)((double)f * this.baseDamage), (double)0.0, (double)2.147483647E9));
        if (this.getPierceLevel() > 0) {
            if (this.piercingIgnoreEntityIds == null) {
                this.piercingIgnoreEntityIds = new IntOpenHashSet(5);
            }
            if (this.piercedAndKilledEntities == null) {
                this.piercedAndKilledEntities = Lists.newArrayListWithCapacity((int)5);
            }
            if (this.piercingIgnoreEntityIds.size() >= this.getPierceLevel() + 1) {
                this.m_146870_();
                return;
            }
            this.piercingIgnoreEntityIds.add(entity.m_142049_());
        }
        if (this.isCritArrow()) {
            long j = this.f_19796_.nextInt(i / 2 + 2);
            i = (int)Math.min(j + (long)i, Integer.MAX_VALUE);
        }
        if ((entity1 = this.m_37282_()) instanceof LivingEntity) {
            LivingEntity livingOwner = (LivingEntity)entity1;
            livingOwner.m_21335_(entity);
        }
        boolean flag = entity.m_6095_() == EntityType.f_20566_;
        int k = entity.m_20094_();
        if (this.m_6060_() && !flag) {
            entity.m_20254_(5);
        }
        if (entity.m_6469_(this.damageSource(), (float)i)) {
            if (flag) {
                return;
            }
            if (entity instanceof LivingEntity) {
                Vec3 vec3;
                LivingEntity livingentity = (LivingEntity)entity;
                if (this.knockback > 0 && (vec3 = this.m_20184_().m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_((double)this.knockback * 0.6)).m_82556_() > 0.0) {
                    livingentity.m_5997_(vec3.f_82479_, 0.1, vec3.f_82481_);
                }
                if (!this.f_19853_.f_46443_ && entity1 instanceof LivingEntity) {
                    EnchantmentHelper.m_44823_((LivingEntity)livingentity, (Entity)entity1);
                    EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)entity1), (Entity)livingentity);
                }
                this.doPostHurtEffects(livingentity);
                if (livingentity != entity1 && livingentity instanceof Player && entity1 instanceof ServerPlayer && !this.m_20067_()) {
                    ((ServerPlayer)entity1).f_8906_.m_141995_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132159_, 0.0f));
                }
                if (!entity.m_6084_() && this.piercedAndKilledEntities != null) {
                    this.piercedAndKilledEntities.add((Entity)livingentity);
                }
                if (!this.f_19853_.f_46443_ && entity1 instanceof ServerPlayer) {
                    ServerPlayer serverplayer = (ServerPlayer)entity1;
                    if (this.piercedAndKilledEntities != null && this.shotFromCrossbow()) {
                        CriteriaTriggers.f_10556_.m_46871_(serverplayer, this.piercedAndKilledEntities);
                    } else if (!entity.m_6084_() && this.shotFromCrossbow()) {
                        CriteriaTriggers.f_10556_.m_46871_(serverplayer, Arrays.asList(entity));
                    }
                }
            }
            this.m_5496_(this.soundEvent, 1.0f, 1.2f / (this.f_19796_.nextFloat() * 0.2f + 0.9f));
            if (this.getPierceLevel() <= 0) {
                this.onDiscard();
                this.m_146870_();
            }
        } else {
            if (this.discardOnNoDmgImpact()) {
                this.onDiscard();
                this.m_146870_();
                return;
            }
            entity.m_7311_(k);
            this.m_20256_(this.m_20184_().m_82490_(-0.1));
            this.m_146922_(this.m_146908_() + 180.0f);
            this.f_19859_ += 180.0f;
            if (!this.f_19853_.f_46443_ && this.m_20184_().m_82556_() < 1.0E-7) {
                this.m_146870_();
            }
        }
    }

    protected abstract boolean ignoreBlock(@NotNull BlockState var1);

    public boolean discardOnNoDmgImpact() {
        return false;
    }

    public void onDiscard() {
    }

    protected void onHitBlock() {
        if (!this.m_20067_()) {
            this.m_5496_(this.getHitGroundSoundEvent(), 1.0f, 1.2f / (this.f_19796_.nextFloat() * 0.2f + 0.9f));
        }
        this.m_146870_();
    }

    protected void m_8060_(@NotNull BlockHitResult pResult) {
        this.onHitBlock();
    }

    protected SoundEvent getDefaultHitGroundSoundEvent() {
        return SoundEvents.f_11685_;
    }

    protected final SoundEvent getHitGroundSoundEvent() {
        return this.soundEvent;
    }

    protected void doPostHurtEffects(LivingEntity pTarget) {
    }

    @Nullable
    protected EntityHitResult findHitEntity(Vec3 pStartVec, Vec3 pEndVec) {
        return ProjectileUtil.m_37304_((Level)this.f_19853_, (Entity)this, (Vec3)pStartVec, (Vec3)pEndVec, (AABB)this.m_142469_().m_82369_(this.m_20184_()).m_82400_(1.0), this::m_5603_);
    }

    protected boolean m_5603_(@NotNull Entity target) {
        return super.m_5603_(target) && (this.piercingIgnoreEntityIds == null || !this.piercingIgnoreEntityIds.contains(target.m_142049_()));
    }

    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128347_("damage", this.baseDamage);
        pCompound.m_128379_("crit", this.isCritArrow());
        pCompound.m_128344_("PierceLevel", this.getPierceLevel());
        pCompound.m_128359_("SoundEvent", Registry.f_122821_.m_7981_((Object)this.soundEvent).toString());
        pCompound.m_128379_("ShotFromCrossbow", this.shotFromCrossbow());
    }

    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128425_("damage", 99)) {
            this.baseDamage = pCompound.m_128459_("damage");
        }
        this.setCritArrow(pCompound.m_128471_("crit"));
        this.setPierceLevel(pCompound.m_128445_("PierceLevel"));
        if (pCompound.m_128425_("SoundEvent", 8)) {
            this.soundEvent = Registry.f_122821_.m_6612_(new ResourceLocation(pCompound.m_128461_("SoundEvent"))).orElse(this.getDefaultHitGroundSoundEvent());
        }
        this.setShotFromCrossbow(pCompound.m_128471_("ShotFromCrossbow"));
    }

    protected abstract ItemStack getPickupItem();

    protected // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    public void setBaseDamage(double pBaseDamage) {
        this.baseDamage = pBaseDamage;
    }

    public double getBaseDamage() {
        return this.baseDamage;
    }

    public void setKnockback(int pKnockback) {
        this.knockback = pKnockback;
    }

    public int getKnockback() {
        return this.knockback;
    }

    public boolean m_6097_() {
        return false;
    }

    protected float m_6380_(Pose pPose, EntityDimensions pSize) {
        return 0.13f;
    }

    public void setCritArrow(boolean pCritArrow) {
        this.setFlag(1, pCritArrow);
    }

    public void setPierceLevel(byte pPierceLevel) {
        this.f_19804_.m_135381_(PIERCE_LEVEL, (Object)pPierceLevel);
    }

    private void setFlag(int pId, boolean pValue) {
        byte b0 = (Byte)this.f_19804_.m_135370_(ID_FLAGS);
        if (pValue) {
            this.f_19804_.m_135381_(ID_FLAGS, (Object)((byte)(b0 | pId)));
        } else {
            this.f_19804_.m_135381_(ID_FLAGS, (Object)((byte)(b0 & ~pId)));
        }
    }

    public boolean isCritArrow() {
        byte b0 = (Byte)this.f_19804_.m_135370_(ID_FLAGS);
        return (b0 & 1) != 0;
    }

    public boolean shotFromCrossbow() {
        byte b0 = (Byte)this.f_19804_.m_135370_(ID_FLAGS);
        return (b0 & 4) != 0;
    }

    public byte getPierceLevel() {
        return (Byte)this.f_19804_.m_135370_(PIERCE_LEVEL);
    }

    public void setEnchantmentEffectsFromEntity(LivingEntity pShooter, float pVelocity) {
        int i = EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44988_, (LivingEntity)pShooter);
        int j = EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44989_, (LivingEntity)pShooter);
        this.setBaseDamage((double)(pVelocity * 2.0f) + this.f_19796_.nextGaussian() * 0.25 + (double)((float)this.f_19853_.m_46791_().m_19028_() * 0.11f));
        if (i > 0) {
            this.setBaseDamage(this.getBaseDamage() + (double)i * 0.5 + 0.5);
        }
        if (j > 0) {
            this.setKnockback(j);
        }
        if (EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44990_, (LivingEntity)pShooter) > 0) {
            this.m_20254_(100);
        }
    }

    protected float getWaterInertia() {
        return 0.6f;
    }

    public void setNoPhysics(boolean pNoPhysics) {
        this.f_19794_ = pNoPhysics;
        this.setFlag(2, pNoPhysics);
    }

    public boolean isNoPhysics() {
        if (!this.f_19853_.f_46443_) {
            return this.f_19794_;
        }
        return ((Byte)this.f_19804_.m_135370_(ID_FLAGS) & 2) != 0;
    }

    public void setShotFromCrossbow(boolean pShotFromCrossbow) {
        this.setFlag(4, pShotFromCrossbow);
    }
}

