/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.entity.projectile;

import java.util.List;
import net.foxyas.changedaddon.entity.projectile.AbstractGenericParticleProjectile;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class WitherParticleProjectile
extends AbstractGenericParticleProjectile {
    public WitherParticleProjectile(EntityType<? extends AbstractGenericParticleProjectile> type, Level level) {
        super(type, level);
        this.particleOptions = ParticleTypes.f_123798_;
    }

    @Override
    @NotNull
    protected ItemStack getPickupItem() {
        return ItemStack.f_41583_;
    }

    @Override
    protected void spawnParticle() {
        super.spawnParticle();
    }

    @Override
    protected void m_8060_(@NotNull BlockHitResult pResult) {
        this.ApplyExplosionParticlesAndDamage();
        super.m_8060_(pResult);
    }

    @Override
    protected void m_5790_(@NotNull EntityHitResult pResult) {
        if (pResult.m_82443_().f_19864_) {
            this.ApplyExplosionParticlesAndDamage();
        }
        super.m_5790_(pResult);
    }

    @Override
    protected boolean ignoreBlock(@NotNull BlockState state) {
        return false;
    }

    @Override
    protected boolean m_5603_(@NotNull Entity target) {
        return super.m_5603_(target);
    }

    public void ApplyExplosionParticlesAndDamage() {
        Level level = this.m_183503_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        double radius = 1.0;
        double maxDistance = 6.0;
        double angleX = 15.0;
        double angleY = 15.0;
        for (double theta = 0.0; theta < 360.0; theta += angleX) {
            double angleTheta = Math.toRadians(theta);
            for (double phi = 0.0; phi <= 180.0; phi += angleY) {
                double anglePhi = Math.toRadians(phi);
                double dx = Math.sin(anglePhi) * Math.cos(angleTheta) * radius;
                double dy = Math.cos(anglePhi) * radius;
                double dz = Math.sin(anglePhi) * Math.sin(angleTheta) * radius;
                Vec3 dir = new Vec3(dx, dy, dz);
                Vec3 start = this.m_20182_();
                Vec3 end = start.m_82549_(dir.m_82490_(maxDistance));
                Vec3 motion = end.m_82546_(start).m_82541_();
                ClipContext ctx = new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this);
                BlockHitResult blockHit = serverLevel.m_45547_(ctx);
                Vec3 finalEnd = blockHit.m_6662_() != HitResult.Type.MISS ? blockHit.m_82450_() : end;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123744_, start.f_82479_, start.f_82480_, start.f_82481_, 0, motion.f_82479_, motion.f_82480_, motion.f_82481_, 1.0);
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123798_, start.f_82479_, start.f_82480_, start.f_82481_, 0, motion.f_82479_, motion.f_82480_, motion.f_82481_, 2.0);
                AABB aabb = new AABB(start, finalEnd).m_82400_(0.5);
                List entities = serverLevel.m_6443_(LivingEntity.class, aabb, e -> !e.m_7306_((Entity)this));
                for (LivingEntity target : entities) {
                    target.m_6469_(DamageSource.f_19319_, 8.0f);
                    target.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 100, 2));
                }
            }
        }
        serverLevel.m_6269_(null, (Entity)this, SoundEvents.f_11913_, SoundSource.AMBIENT, 1.0f, 1.0f);
    }
}

