/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.entity.simple;

import java.util.Set;
import net.foxyas.changedaddon.entity.defaults.AbstractCanTameSnepChangedEntity;
import net.foxyas.changedaddon.entity.interfaces.ChangedEntityExtension;
import net.foxyas.changedaddon.util.ColorUtil;
import net.ltxprogrammer.changed.entity.ChangedEntity;
import net.ltxprogrammer.changed.entity.TransfurCause;
import net.ltxprogrammer.changed.entity.beast.AbstractSnowLeopard;
import net.ltxprogrammer.changed.init.ChangedAttributes;
import net.ltxprogrammer.changed.util.Color3;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCheetahEntity
extends AbstractCanTameSnepChangedEntity {
    protected static final Set<ResourceLocation> SPAWN_BIOMES = Set.of(Biomes.f_48222_.m_135782_(), Biomes.f_186769_.m_135782_(), Biomes.f_48157_.m_135782_(), Biomes.f_48158_.m_135782_(), Biomes.f_186768_.m_135782_());

    public AbstractCheetahEntity(EntityType<? extends AbstractSnowLeopard> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
    }

    @Override
    protected boolean targetSelectorTest(LivingEntity livingEntity) {
        if (ChangedEntityExtension.of((ChangedEntity)this).isPacified()) {
            return false;
        }
        return super.targetSelectorTest(livingEntity);
    }

    protected void setAttributes(AttributeMap attributes) {
        super.setAttributes(attributes);
        attributes.m_22146_(Attributes.f_22279_).m_22100_((double)1.4f);
        attributes.m_22146_((Attribute)ForgeMod.SWIM_SPEED.get()).m_22100_(0.9);
        attributes.m_22146_(Attributes.f_22276_).m_22100_(20.0);
        attributes.m_22146_((Attribute)ChangedAttributes.TRANSFUR_DAMAGE.get()).m_22100_(2.5);
        attributes.m_22146_(Attributes.f_22281_).m_22100_(2.0);
    }

    @Override
    @NotNull
    protected InteractionResult m_6071_(Player player, @NotNull InteractionHand hand) {
        return super.m_6071_(player, hand);
    }

    public Color3 getTransfurColor(TransfurCause cause) {
        Color3 firstColor = Color3.getColor((String)"#d8b270");
        Color3 secondColor = Color3.getColor((String)"#634927");
        Color3 thirdColor = Color3.getColor((String)"#ecddc1");
        float progress = ColorUtil.getPlayerTransfurProgressSafe(this.getUnderlyingPlayer(), 1.0f);
        if ((progress = Mth.m_14036_((float)progress, (float)0.0f, (float)1.0f)) < 0.5f) {
            float t = progress / 0.5f;
            return ColorUtil.lerpTFColor(firstColor, secondColor, t);
        }
        float t = (progress - 0.5f) / 0.5f;
        return ColorUtil.lerpTFColor(secondColor, thirdColor, t);
    }

    @Nullable
    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor pLevel, @NotNull DifficultyInstance pDifficulty, @NotNull MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        SpawnGroupData returnValue = super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        if ((double)this.m_21187_().nextFloat() >= 0.75) {
            ChangedEntityExtension.of((ChangedEntity)this).setPacified(true);
        }
        return returnValue;
    }
}

