/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.entity.simple;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.foxyas.changedaddon.init.ChangedAddonEntities;
import net.foxyas.changedaddon.init.ChangedAddonItems;
import net.foxyas.changedaddon.init.ChangedAddonTags;
import net.foxyas.changedaddon.procedures.CreatureDietsHandleProcedure;
import net.foxyas.changedaddon.variants.ChangedAddonTransfurVariants;
import net.foxyas.changedaddon.variants.VariantExtraStats;
import net.ltxprogrammer.changed.ability.IAbstractChangedEntity;
import net.ltxprogrammer.changed.entity.Gender;
import net.ltxprogrammer.changed.entity.HairStyle;
import net.ltxprogrammer.changed.entity.TransfurCause;
import net.ltxprogrammer.changed.entity.TransfurMode;
import net.ltxprogrammer.changed.entity.beast.AbstractDarkLatexWolf;
import net.ltxprogrammer.changed.entity.variant.TransfurVariant;
import net.ltxprogrammer.changed.entity.variant.TransfurVariantInstance;
import net.ltxprogrammer.changed.init.ChangedAttributes;
import net.ltxprogrammer.changed.init.ChangedItems;
import net.ltxprogrammer.changed.process.ProcessTransfur;
import net.ltxprogrammer.changed.util.Color3;
import net.minecraft.network.protocol.Packet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import org.jetbrains.annotations.NotNull;

public class WolfyEntity
extends AbstractDarkLatexWolf
implements VariantExtraStats {
    public static final CreatureDietsHandleProcedure.DietType WOLFY_DIET = CreatureDietsHandleProcedure.DietType.create("WOLFY", ChangedAddonTags.TransfurTypes.WOLF_DIET, ChangedAddonTags.Items.WOLF_DIET, List.of((Item)ChangedAddonItems.FOXTA.get(), (Item)ChangedItems.ORANGE.get()));

    public WolfyEntity(PlayMessages.SpawnEntity ignoredPacket, Level world) {
        this((EntityType<WolfyEntity>)((EntityType)ChangedAddonEntities.WOLFY.get()), world);
    }

    public WolfyEntity(EntityType<WolfyEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 0;
        this.setAttributes(this.m_21204_());
        this.m_21557_(false);
        this.m_21530_();
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder.m_22268_((Attribute)ChangedAttributes.TRANSFUR_DAMAGE.get(), 0.0);
        builder = builder.m_22268_(Attributes.f_22279_, 0.3);
        builder = builder.m_22268_(Attributes.f_22276_, 14.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 2.0);
        builder = builder.m_22268_(Attributes.f_22277_, 16.0);
        return builder;
    }

    protected void setAttributes(AttributeMap attributes) {
        Objects.requireNonNull(attributes.m_22146_((Attribute)ChangedAttributes.TRANSFUR_DAMAGE.get())).m_22100_(1.0);
        attributes.m_22146_(Attributes.f_22276_).m_22100_(14.0);
        attributes.m_22146_(Attributes.f_22277_).m_22100_(25.0);
        attributes.m_22146_(Attributes.f_22279_).m_22100_((double)1.2f);
        attributes.m_22146_((Attribute)ForgeMod.SWIM_SPEED.get()).m_22100_(0.5);
        attributes.m_22146_(Attributes.f_22281_).m_22100_(2.0);
        attributes.m_22146_(Attributes.f_22284_).m_22100_(0.0);
        attributes.m_22146_(Attributes.f_22285_).m_22100_(0.0);
        attributes.m_22146_(Attributes.f_22278_).m_22100_(0.0);
    }

    public boolean tryAbsorbTarget(LivingEntity target, IAbstractChangedEntity source, float amount, @Nullable List<TransfurVariant<?>> possibleMobFusions) {
        return false;
    }

    @NotNull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public TransfurMode getTransfurMode() {
        return TransfurMode.NONE;
    }

    public HairStyle getDefaultHairStyle() {
        return (HairStyle)HairStyle.BALD.get();
    }

    @Nullable
    public List<HairStyle> getValidHairStyles() {
        return HairStyle.Collection.getAll();
    }

    public Color3 getHairColor(int layer) {
        return Color3.DARK;
    }

    public Gender getGender() {
        return Gender.MALE;
    }

    public boolean isMaskless() {
        return true;
    }

    protected void m_8099_() {
        super.m_8099_();
    }

    public Color3 getDripColor() {
        Color3 color = Color3.getColor((String)"#000000");
        color = this.f_19853_.f_46441_.nextInt(10) > 5 ? Color3.getColor((String)"#393939") : Color3.getColor((String)"#303030");
        return color;
    }

    public Color3 getTransfurColor(TransfurCause cause) {
        return Color3.getColor((String)"#303030");
    }

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public double m_6049_() {
        return super.m_6049_();
    }

    @Override
    public List<CreatureDietsHandleProcedure.DietType> getExtraDietTypes() {
        return List.of(WOLFY_DIET);
    }

    @NotNull
    public SoundEvent m_7975_(@NotNull DamageSource ds) {
        return SoundEvents.f_11915_;
    }

    @NotNull
    public SoundEvent m_5592_() {
        return SoundEvents.f_11910_;
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        if (source == DamageSource.f_19306_) {
            return false;
        }
        if (source.m_19372_()) {
            return false;
        }
        if (source.m_19384_()) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    @Mod.EventBusSubscriber
    public static class WolfyAttackedEvent {
        @SubscribeEvent
        public static void onEntityAttacked(LivingAttackEvent event) {
            EntityDamageSource _entityDamageSource;
            Entity entity = event.getEntity();
            if (!(entity instanceof Player)) {
                return;
            }
            Player player = (Player)entity;
            TransfurVariantInstance instance = ProcessTransfur.getPlayerTransfurVariant((Player)player);
            if (instance == null || !instance.is(ChangedAddonTransfurVariants.WOLFY)) {
                return;
            }
            DamageSource damagesource = event.getSource();
            if (damagesource instanceof EntityDamageSource && (_entityDamageSource = (EntityDamageSource)damagesource).m_19403_()) {
                event.setCanceled(true);
                return;
            }
            if (damagesource.m_19384_()) {
                event.setCanceled(true);
                return;
            }
            if (damagesource.m_19372_()) {
                event.setCanceled(true);
                return;
            }
            if (damagesource == DamageSource.f_19306_) {
                event.setCanceled(true);
            }
        }
    }
}

