/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.event;

import java.util.List;
import javax.annotation.Nullable;
import net.foxyas.changedaddon.client.renderer.layers.features.SonarOutlineLayer;
import net.foxyas.changedaddon.process.sounds.BossMusicHandler;
import net.foxyas.changedaddon.util.TransfurVariantUtils;
import net.foxyas.changedaddon.variants.ChangedAddonTransfurVariants;
import net.ltxprogrammer.changed.entity.variant.TransfurVariant;
import net.ltxprogrammer.changed.init.ChangedItems;
import net.ltxprogrammer.changed.init.ChangedRegistry;
import net.ltxprogrammer.changed.item.Syringe;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="changed_addon", value={Dist.CLIENT})
public class ClientEvent {
    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && Minecraft.m_91087_().f_91073_ != null) {
            BossMusicHandler.tick(Minecraft.m_91087_().f_91073_);
            SonarOutlineLayer.SonarClientState.tick();
        }
    }

    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        ClientEvent.showExtraTransfurInfo(event.getPlayer(), event.getItemStack(), event.getToolTip());
    }

    public static void showExtraTransfurInfo(@Nullable Player entity, ItemStack itemstack, List<Component> tooltip) {
        if (entity == null || itemstack == null || tooltip == null) {
            return;
        }
        if (!(itemstack.m_150930_((Item)ChangedItems.LATEX_SYRINGE.get()) || itemstack.m_150930_((Item)ChangedItems.LATEX_FLASK.get()) || itemstack.m_150930_((Item)ChangedItems.LATEX_TIPPED_ARROW.get()))) {
            return;
        }
        ResourceLocation loc = ResourceLocation.m_135820_((String)itemstack.m_41784_().m_128461_("form"));
        if (loc == null) {
            return;
        }
        TransfurVariant tf = (TransfurVariant)ChangedRegistry.TRANSFUR_VARIANT.get().getValue(loc);
        if (tf == null) {
            return;
        }
        if (entity.m_7500_()) {
            if (!Screen.m_96638_()) {
                String variantName = new TranslatableComponent(Syringe.getVariantDescriptionId((ItemStack)itemstack)).getString();
                tooltip.add((Component)new TranslatableComponent("item.changed_addon.latex_syringe.tooltip", new Object[]{variantName}));
            } else {
                int index = Math.min(tooltip.size(), 3);
                float extraHp = TransfurVariantUtils.GetExtraHp(tf, entity) / 2.0f;
                tooltip.add(index, (Component)new TranslatableComponent("text.changed_addon.additionalHealth").m_130946_("").m_7220_((Component)(extraHp == 0.0f ? new TextComponent("\u00a77None\u00a7r") : new TextComponent((extraHp > 0.0f ? "\u00a7a+" : "\u00a7c") + extraHp + "\u00a7r"))).m_7220_((Component)new TranslatableComponent("text.changed_addon.additionalHealth.Hearts")));
                tooltip.add(++index, (Component)new TranslatableComponent("text.changed_addon.miningStrength", new Object[]{TransfurVariantUtils.getMiningStrength(tf)}));
                float landSpeed = TransfurVariantUtils.GetLandSpeed(tf, entity);
                float landSpeedPct = landSpeed == 0.0f ? 0.0f : (landSpeed - 1.0f) * 100.0f;
                tooltip.add(++index, (Component)new TranslatableComponent("text.changed_addon.land_speed").m_130946_("").m_7220_((Component)(landSpeedPct == 0.0f ? new TextComponent("\u00a77None\u00a7r") : new TextComponent((landSpeedPct > 0.0f ? "\u00a7a+" : "\u00a7c") + (int)landSpeedPct + "%"))));
                float swimSpeed = TransfurVariantUtils.GetSwimSpeed(tf, entity);
                float swimSpeedPct = swimSpeed == 0.0f ? 0.0f : (swimSpeed - 1.0f) * 100.0f;
                tooltip.add(++index, (Component)new TranslatableComponent("text.changed_addon.swim_speed").m_130946_("").m_7220_((Component)(swimSpeedPct == 0.0f ? new TextComponent("\u00a77None\u00a7r") : new TextComponent((swimSpeedPct > 0.0f ? "\u00a7a+" : "\u00a7c") + (int)swimSpeedPct + "%"))));
                float jumpStrength = TransfurVariantUtils.GetJumpStrength(tf);
                float jumpStrengthPct = jumpStrength == 0.0f ? 0.0f : (jumpStrength - 1.0f) * 100.0f;
                tooltip.add(++index, (Component)new TranslatableComponent("text.changed_addon.jumpStrength").m_130946_("").m_7220_((Component)(jumpStrengthPct == 0.0f ? new TextComponent("\u00a77None\u00a7r") : new TextComponent((jumpStrengthPct > 0.0f ? "\u00a7a+" : "\u00a7c") + (int)jumpStrengthPct + "%"))));
                tooltip.add(++index, (Component)new TranslatableComponent("text.changed_addon.canGlide/Fly").m_130946_("").m_7220_((Component)(TransfurVariantUtils.CanGlideAndFly(tf) ? new TextComponent("\u00a7aTrue\u00a7r") : new TextComponent("\u00a7cFalse\u00a7r"))));
            }
            if (ChangedAddonTransfurVariants.isVariantOC(loc, entity.m_183503_())) {
                tooltip.add((Component)new TextComponent("\u00a78OC Transfur"));
            }
        }
        if (ChangedAddonTransfurVariants.isAnBossVariant(tf)) {
            tooltip.add((Component)new TextComponent("\u00a78Boss Version"));
        }
    }
}

