/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.init;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import net.foxyas.changedaddon.abilities.AdvancedHearingAbility;
import net.foxyas.changedaddon.abilities.CarryAbility;
import net.foxyas.changedaddon.abilities.ClawsAbility;
import net.foxyas.changedaddon.abilities.CustomInteraction;
import net.foxyas.changedaddon.abilities.DashAbility;
import net.foxyas.changedaddon.abilities.DazedPuddleAbility;
import net.foxyas.changedaddon.abilities.DissolveAbility;
import net.foxyas.changedaddon.abilities.DodgeAbility;
import net.foxyas.changedaddon.abilities.DodgeAbilityInstance;
import net.foxyas.changedaddon.abilities.LeapAbility;
import net.foxyas.changedaddon.abilities.LuminaraFireballAbility;
import net.foxyas.changedaddon.abilities.PassiveAbility;
import net.foxyas.changedaddon.abilities.PollenCarryAbility;
import net.foxyas.changedaddon.abilities.PsychicGrab;
import net.foxyas.changedaddon.abilities.PsychicHoldAbility;
import net.foxyas.changedaddon.abilities.PsychicPulseAbility;
import net.foxyas.changedaddon.abilities.ShockWaveAbility;
import net.foxyas.changedaddon.abilities.SoftenAbility;
import net.foxyas.changedaddon.abilities.SonarAbility;
import net.foxyas.changedaddon.abilities.TeleportAbility;
import net.foxyas.changedaddon.abilities.ThunderBoltAbility;
import net.foxyas.changedaddon.abilities.ThunderPathAbility;
import net.foxyas.changedaddon.abilities.ToggleClimbAbility;
import net.foxyas.changedaddon.abilities.TurnFeralSnepAbility;
import net.foxyas.changedaddon.abilities.UnfuseAbility;
import net.foxyas.changedaddon.abilities.WindControlAbility;
import net.foxyas.changedaddon.abilities.WindPassiveAbility;
import net.foxyas.changedaddon.abilities.WingFlapAbility;
import net.foxyas.changedaddon.abilities.WitherGrenadeAbility;
import net.foxyas.changedaddon.abilities.WitherWaveAbility;
import net.foxyas.changedaddon.init.ChangedAddonTags;
import net.ltxprogrammer.changed.ability.AbstractAbility;
import net.ltxprogrammer.changed.client.AbilityColors;
import net.ltxprogrammer.changed.client.ChangedClient;
import net.ltxprogrammer.changed.entity.variant.TransfurVariant;
import net.ltxprogrammer.changed.init.ChangedEntities;
import net.ltxprogrammer.changed.init.ChangedRegistry;
import net.ltxprogrammer.changed.init.ChangedTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="changed_addon", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ChangedAddonAbilities {
    public static final DeferredRegister<AbstractAbility<?>> REGISTRY = ChangedRegistry.ABILITY.createDeferred("changed_addon");
    public static final RegistryObject<DashAbility> DASH = REGISTRY.register("dash", DashAbility::new);
    public static final RegistryObject<LeapAbility> LEAP = REGISTRY.register("leap", LeapAbility::new);
    public static final RegistryObject<ThunderBoltAbility> THUNDERBOLT = REGISTRY.register("thunderbolt", ThunderBoltAbility::new);
    public static final RegistryObject<ThunderPathAbility> THUNDER_PATH = REGISTRY.register("thunder_path", ThunderPathAbility::new);
    public static final RegistryObject<PsychicPulseAbility> PSYCHIC_PULSE = REGISTRY.register("psychic_pulse", PsychicPulseAbility::new);
    public static final RegistryObject<PsychicHoldAbility> PSYCHIC_HOLD = REGISTRY.register("psychic_hold", PsychicHoldAbility::new);
    public static final RegistryObject<ShockWaveAbility> SHOCKWAVE = REGISTRY.register("shock_wave", ShockWaveAbility::new);
    public static final RegistryObject<DodgeAbility> DODGE = REGISTRY.register("dodge", DodgeAbility::new);
    public static final RegistryObject<DodgeAbility> TELEPORT_DODGE = REGISTRY.register("teleport_dodge", () -> new DodgeAbility(DodgeAbilityInstance.DodgeType.TELEPORT));
    public static final RegistryObject<CarryAbility> CARRY = REGISTRY.register("carry", CarryAbility::new);
    public static final RegistryObject<DissolveAbility> DISSOLVE = REGISTRY.register("warp", DissolveAbility::new);
    public static final RegistryObject<WitherWaveAbility> WITHER_WAVE = REGISTRY.register("wither_wave", WitherWaveAbility::new);
    public static final RegistryObject<DazedPuddleAbility> DAZED_PUDDLE = REGISTRY.register("dazed_puddle", DazedPuddleAbility::new);
    public static final RegistryObject<SoftenAbility> SOFTEN_ABILITY = REGISTRY.register("soften", SoftenAbility::new);
    public static final RegistryObject<CustomInteraction> CUSTOM_INTERACTION = REGISTRY.register("custom_interaction", CustomInteraction::new);
    public static final RegistryObject<TurnFeralSnepAbility> TURN_FERAL_SNEP = REGISTRY.register("turn_feral", TurnFeralSnepAbility::new);
    public static final RegistryObject<WingFlapAbility> WING_FLAP_ABILITY = REGISTRY.register("wing_flap", WingFlapAbility::new);
    public static final RegistryObject<ClawsAbility> CLAWS = REGISTRY.register("claws", ClawsAbility::new);
    public static final RegistryObject<PsychicGrab> PSYCHIC_GRAB = REGISTRY.register("psychic_grab", PsychicGrab::new);
    public static final RegistryObject<AdvancedHearingAbility> ADVANCED_HEARING = REGISTRY.register("advanced_hearing", AdvancedHearingAbility::new);
    public static final RegistryObject<TeleportAbility> TELEPORT = REGISTRY.register("teleport", TeleportAbility::new);
    public static final RegistryObject<UnfuseAbility> UNFUSE = REGISTRY.register("unfuse", UnfuseAbility::new);
    public static final RegistryObject<ToggleClimbAbility> TOGGLE_CLIMB = REGISTRY.register("toggle_climb", ToggleClimbAbility::new);
    public static final RegistryObject<PassiveAbility> APPLY_REGENERATION_PASSIVE = REGISTRY.register("passive_regeneration", () -> new PassiveAbility(entity -> PassiveAbility.ApplyMobEffect(entity, new MobEffectInstance(MobEffects.f_19605_, 60, 0, false, false, true))));
    public static final RegistryObject<WindControlAbility> WIND_CONTROL = REGISTRY.register("wind_control", WindControlAbility::new);
    public static final RegistryObject<WindPassiveAbility> WIND_PASSIVE = REGISTRY.register("wind_control_passive", WindPassiveAbility::new);
    public static final RegistryObject<WitherGrenadeAbility> WITHER_GRENADE = REGISTRY.register("wither_grenade", WitherGrenadeAbility::new);
    public static final RegistryObject<SonarAbility> SONAR = REGISTRY.register("sonar", SonarAbility::new);
    public static final RegistryObject<LuminaraFireballAbility> LUMINARA_FIREBALL = REGISTRY.register("luminara_fireball", LuminaraFireballAbility::new);
    public static final RegistryObject<PollenCarryAbility> POLLEN_CARRY = REGISTRY.register("pollen_carry", PollenCarryAbility::new);

    public static EntityType<?>[] getCanGlideEntitiesArray() {
        ArrayList canGlideEntities = new ArrayList();
        Collection transfurVariants = ChangedRegistry.TRANSFUR_VARIANT.get().getValues();
        transfurVariants.forEach(transfurVariant -> {
            if (transfurVariant.canGlide) {
                canGlideEntities.add(transfurVariant.getEntityType());
            }
        });
        return canGlideEntities.toArray(new EntityType[0]);
    }

    public static EntityType<?>[] getBeeEntities() {
        Stream<EntityType> beeEntities = ForgeRegistries.ENTITIES.getValues().stream().filter(entityType -> entityType.getRegistryName().toString().contains("latex_bee"));
        ArrayList<EntityType> canGlideEntities = new ArrayList<EntityType>(beeEntities.toList());
        return canGlideEntities.toArray(new EntityType[0]);
    }

    public static List<EntityType<?>> getAllEntityTypesThatCanGlide() {
        ArrayList canGlideEntities = new ArrayList();
        Collection transfurVariants = ChangedRegistry.TRANSFUR_VARIANT.get().getValues();
        transfurVariants.forEach(transfurVariant -> {
            if (transfurVariant.canGlide) {
                canGlideEntities.add(transfurVariant.getEntityType());
            }
        });
        return canGlideEntities;
    }

    public static void addUniversalAbilities(TransfurVariant.UniversalAbilitiesEvent event) {
        event.addAbility(event.isOfTag(ChangedTags.EntityTypes.LATEX).and(event.isNotOfTag(ChangedTags.EntityTypes.PARTIAL_LATEX)), SOFTEN_ABILITY);
        event.addAbility(event.isOfTag(ChangedAddonTags.EntityTypes.HAS_CLAWS), CLAWS);
        event.addAbility(event.isOfTag(ChangedAddonTags.EntityTypes.DRAGON_ENTITIES), WING_FLAP_ABILITY);
        event.addAbility(entityType -> entityType.equals(ChangedEntities.LATEX_BEE.get()) || entityType.m_204039_(ChangedAddonTags.EntityTypes.BEE_ENTITIES), POLLEN_CARRY);
    }

    @SubscribeEvent
    public static void registerAbilities(FMLConstructModEvent event) {
        REGISTRY.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    @SubscribeEvent
    public static void clientLoad(FMLClientSetupEvent event) {
        ((AbilityColors)ChangedClient.abilityColors.getOrThrow()).register(WingFlapAbility::getColor, new AbstractAbility[]{(AbstractAbility)WING_FLAP_ABILITY.get()});
        ((AbilityColors)ChangedClient.abilityColors.getOrThrow()).register(UnfuseAbility::getColor, new AbstractAbility[]{(AbstractAbility)UNFUSE.get()});
        ((AbilityColors)ChangedClient.abilityColors.getOrThrow()).register(ClawsAbility::getColor, new AbstractAbility[]{(AbstractAbility)CLAWS.get()});
        ((AbilityColors)ChangedClient.abilityColors.getOrThrow()).register(LuminaraFireballAbility::getColor, new AbstractAbility[]{(AbstractAbility)LUMINARA_FIREBALL.get()});
    }
}

