/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.init;

import com.mojang.serialization.Codec;
import java.awt.Color;
import java.util.function.Function;
import net.foxyas.changedaddon.client.particle.SolventParticleParticle;
import net.foxyas.changedaddon.effect.particles.LaserPointParticle;
import net.foxyas.changedaddon.effect.particles.ParticleProviderHolder;
import net.foxyas.changedaddon.effect.particles.ThunderSparkOption;
import net.foxyas.changedaddon.effect.particles.ThunderSparkParticle;
import net.ltxprogrammer.changed.util.Color3;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ChangedAddonParticleTypes {
    public static final DeferredRegister<ParticleType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, (String)"changed_addon");
    public static final RegistryObject<ParticleType<SimpleParticleType>> SOLVENT_PARTICLE = REGISTRY.register("solvent_particle", () -> new SimpleParticleType(true));
    public static final RegistryObject<ParticleType<ThunderSparkOption>> THUNDER_SPARK = ChangedAddonParticleTypes.register("thunder_spark", ThunderSparkOption.DESERIALIZER, ThunderSparkOption::codec);
    public static final RegistryObject<ParticleType<LaserPointParticle.Option>> LASER_POINT = ChangedAddonParticleTypes.register("laser_point", LaserPointParticle.Option.DESERIALIZER, LaserPointParticle.Option::codec);

    public static ThunderSparkOption thunderSpark(int lifeSpam) {
        return new ThunderSparkOption((ParticleType<ThunderSparkOption>)((ParticleType)THUNDER_SPARK.get()), lifeSpam);
    }

    public static LaserPointParticle.Option laserPoint(Entity entity, Color3 color, float alpha) {
        return new LaserPointParticle.Option(entity, color.toInt(), alpha);
    }

    public static LaserPointParticle.Option laserPoint(Entity entity, Color color) {
        return new LaserPointParticle.Option(entity, color.getRGB(), (float)color.getAlpha() / 255.0f);
    }

    private static <T extends ParticleOptions> RegistryObject<ParticleType<T>> register(String name, ParticleOptions.Deserializer<T> dec, final Function<ParticleType<T>, Codec<T>> fn) {
        return REGISTRY.register(name, () -> new ParticleType<T>(false, dec){

            @NotNull
            public Codec<T> m_7652_() {
                return (Codec)fn.apply(this);
            }
        });
    }

    @SubscribeEvent
    public static void registerParticles(ParticleFactoryRegisterEvent event) {
        ParticleEngine engine = Minecraft.m_91087_().f_91061_;
        for (RegistryObject particleTypeRegistryObject : REGISTRY.getEntries()) {
            Object object = particleTypeRegistryObject.get();
            if (!(object instanceof ParticleProviderHolder)) continue;
            ParticleProviderHolder particleProviderHolder = (ParticleProviderHolder)object;
            engine.m_107378_((ParticleType)particleTypeRegistryObject.get(), particleProviderHolder::getProvider);
        }
        engine.m_107378_((ParticleType)THUNDER_SPARK.get(), ThunderSparkParticle.Provider::new);
        engine.m_107378_((ParticleType)LASER_POINT.get(), LaserPointParticle.Provider::new);
        engine.m_107378_((ParticleType)SOLVENT_PARTICLE.get(), SolventParticleParticle::provider);
    }
}

