/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.item;

import java.awt.Color;
import java.util.List;
import javax.annotation.Nullable;
import net.foxyas.changedaddon.entity.goals.simple.FollowAndLookAtLaser;
import net.foxyas.changedaddon.init.ChangedAddonParticleTypes;
import net.foxyas.changedaddon.init.ChangedAddonTabs;
import net.foxyas.changedaddon.util.DynamicClipContext;
import net.foxyas.changedaddon.util.ParticlesUtil;
import net.foxyas.changedaddon.util.PlayerUtil;
import net.ltxprogrammer.changed.init.ChangedTags;
import net.ltxprogrammer.changed.item.SpecializedAnimations;
import net.ltxprogrammer.changed.util.Color3;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import org.jetbrains.annotations.NotNull;

public class LaserPointer
extends Item
implements SpecializedAnimations {
    public static final float MAX_LASER_REACH = 32.0f;
    public static final int FOLLOW_LASER_RADIUS = 16;
    public static final int FOLLOW_BB_SIZE = 32;
    public static final ClipContext.ShapeGetter IGNORE_TRANSLUCENT = (state, b, pos, context) -> {
        if (state.m_204336_(ChangedTags.Blocks.LASER_TRANSLUCENT)) {
            return Shapes.m_83040_();
        }
        return ClipContext.Block.COLLIDER.m_7544_(state, b, pos, context);
    };

    public LaserPointer() {
        super(new Item.Properties().m_41487_(1).m_41491_(ChangedAddonTabs.TAB_CHANGED_ADDON));
    }

    public static int getColor(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_("Color")) {
            return stack.m_41783_().m_128451_("Color");
        }
        return DefaultColors.RED.getRGB();
    }

    public static Color getAWTColor(ItemStack stack) {
        int color = LaserPointer.getColor(stack);
        return color == DefaultColors.RED.getRGB() ? DefaultColors.RED.color : new Color(color);
    }

    public static Color3 getColorAsColor3(ItemStack stack) {
        return Color3.fromInt((int)LaserPointer.getColor(stack));
    }

    public static String getHex(Color color) {
        return String.format("#%02X%02X%02X", color.getRed(), color.getGreen(), color.getBlue());
    }

    public static void setLaserColor(ItemStack stack, Color color) {
        LaserPointer.setLaserColor(stack, color.getRGB());
    }

    public static void setLaserColor(ItemStack stack, int color) {
        if (!(stack.m_41720_() instanceof LaserPointer)) {
            return;
        }
        stack.m_41784_().m_128405_("Color", color);
    }

    @NotNull
    public ItemStack m_7968_() {
        ItemStack stack = super.m_7968_();
        stack.m_41784_().m_128405_("Color", DefaultColors.RED.getRGB());
        return stack;
    }

    public int m_8105_(@NotNull ItemStack stack) {
        return 720000;
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack stack) {
        return UseAnim.NONE;
    }

    public void m_6787_(@NotNull CreativeModeTab tab, @NotNull NonNullList<ItemStack> items) {
        if (!this.m_41389_(tab)) {
            return;
        }
        for (DefaultColors color : DefaultColors.values()) {
            ItemStack stack = new ItemStack((ItemLike)this);
            stack.m_41784_().m_128405_("Color", color.getRGB());
            items.add((Object)stack);
        }
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        if (!flag.m_7050_()) {
            return;
        }
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_("Color")) {
            return;
        }
        Color color = new Color(tag.m_128451_("Color"));
        String hex = LaserPointer.getHex(color);
        tooltip.add((Component)new TranslatableComponent("item.changed_addon.laser_pointer.tooltip", new Object[]{hex}).m_130938_(e -> e.m_131148_(TextColor.m_131268_((String)hex))));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        player.m_6672_(hand);
        if (level.f_46443_) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        Vec3 eyePos = player.m_146892_();
        BlockHitResult result = level.m_45547_((ClipContext)new DynamicClipContext(eyePos, eyePos.m_82549_(player.m_20252_(1.0f).m_82490_(32.0)), IGNORE_TRANSLUCENT, arg_0 -> ((ClipContext.Fluid)ClipContext.Fluid.NONE).m_45731_(arg_0), CollisionContext.m_82750_((Entity)player)));
        EntityHitResult entityHitResult = PlayerUtil.getEntityHitLookingAt((Entity)player, result.m_6662_() != HitResult.Type.MISS ? (float)result.m_82448_((Entity)player) : 32.0f, false);
        if (entityHitResult != null) {
            Direction face = Direction.m_122366_((double)entityHitResult.m_82450_().f_82479_, (double)entityHitResult.m_82450_().f_82480_, (double)entityHitResult.m_82450_().f_82481_);
            Vec3 hitPos = this.applyOffset(entityHitResult.m_82450_(), face, -0.05f);
            this.spawnLaserParticle(level, player, stack, hitPos);
        } else if (result instanceof BlockHitResult) {
            BlockHitResult blockResult = result;
            if (level.m_8055_(blockResult.m_82425_()).m_60795_()) {
                this.spawnLaserParticle(level, player, stack, blockResult.m_82450_());
                return InteractionResultHolder.m_19098_((Object)stack);
            }
            Vec3 hitPos = this.applyOffset(result.m_82450_(), blockResult.m_82434_(), -0.05f);
            this.spawnLaserParticle(level, player, stack, hitPos);
        }
        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        super.onUsingTick(stack, player, count);
        Level level = player.f_19853_;
        if (player.f_19853_.f_46443_ || count % 20 != 0) {
            return;
        }
        Vec3 eyePos = player.m_146892_();
        BlockHitResult result = level.m_45547_((ClipContext)new DynamicClipContext(eyePos, eyePos.m_82549_(player.m_20252_(1.0f).m_82490_(32.0)), IGNORE_TRANSLUCENT, arg_0 -> ((ClipContext.Fluid)ClipContext.Fluid.NONE).m_45731_(arg_0), CollisionContext.m_82750_((Entity)player)));
        EntityHitResult entityHitResult = PlayerUtil.getEntityHitLookingAt((Entity)player, result.m_6662_() != HitResult.Type.MISS ? (float)result.m_82448_((Entity)player) : 32.0f, false);
        Vec3 hitPos = result.m_82450_();
        if (entityHitResult != null) {
            Direction face = Direction.m_122366_((double)entityHitResult.m_82450_().f_82479_, (double)entityHitResult.m_82450_().f_82480_, (double)entityHitResult.m_82450_().f_82481_);
            hitPos = this.applyOffset(entityHitResult.m_82450_(), face, -0.05f);
        } else if (result instanceof BlockHitResult) {
            BlockHitResult blockResult = result;
            if (level.m_8055_(blockResult.m_82425_()).m_60795_()) {
                return;
            }
            hitPos = this.applyOffset(result.m_82450_(), blockResult.m_82434_(), -0.05f);
        }
        List nearbyMobs = level.m_45976_(Mob.class, AABB.m_165882_((Vec3)hitPos, (double)32.0, (double)32.0, (double)32.0));
        block0: for (Mob mob : nearbyMobs) {
            for (WrappedGoal wrapped : mob.f_21345_.m_148105_()) {
                Goal goal = wrapped.m_26015_();
                if (!(goal instanceof FollowAndLookAtLaser)) continue;
                FollowAndLookAtLaser followGoal = (FollowAndLookAtLaser)goal;
                followGoal.setLaserTarget(hitPos, player);
                continue block0;
            }
        }
    }

    private Vec3 applyOffset(Vec3 hitPos, Direction face, float offset) {
        return hitPos.m_82492_((double)((float)face.m_122429_() * offset), (double)((float)face.m_122430_() * offset), (double)((float)face.m_122431_() * offset));
    }

    private void spawnLaserParticle(Level level, Player player, ItemStack stack, Vec3 pos) {
        ParticlesUtil.sendParticles(level, ChangedAddonParticleTypes.laserPoint((Entity)player, LaserPointer.getAWTColor(stack)), pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.0, 0.0, 0.0, 1, 0.0f);
    }

    @Nullable
    public SpecializedAnimations.AnimationHandler getAnimationHandler() {
        return ANIMATION_CACHE.computeIfAbsent(this, Animator::new);
    }

    public static enum DefaultColors {
        RED(Color.RED),
        GREEN(Color.GREEN),
        BLUE(Color.BLUE),
        YELLOW(Color.YELLOW),
        CYAN(Color.CYAN),
        MAGENTA(Color.MAGENTA),
        ORANGE(new Color(255, 165, 0)),
        PINK(new Color(255, 105, 180)),
        PURPLE(new Color(128, 0, 128)),
        WHITE(Color.WHITE),
        GRAY(Color.GRAY),
        LIGHT_GRAY(new Color(211, 211, 211)),
        LIME(new Color(50, 205, 50)),
        BROWN(new Color(139, 69, 19)),
        NAVY(new Color(0, 0, 128));

        public final Color color;

        private DefaultColors(Color color) {
            this.color = color;
        }

        public Color getColor() {
            return this.color;
        }

        public int getRGB() {
            return this.color.getRGB();
        }
    }

    public static class Animator
    extends SpecializedAnimations.AnimationHandler {
        public Animator(Item item) {
            super(item);
        }

        public void setupUsingAnimation(ItemStack itemStack, SpecializedAnimations.AnimationHandler.EntityStateContext entity, SpecializedAnimations.AnimationHandler.UpperModelContext model, HumanoidArm arm, float progress) {
            super.setupUsingAnimation(itemStack, entity, model, arm, progress);
            model.getArm((HumanoidArm)arm).f_104203_ = model.head.f_104203_ - 1.5707964f - (entity.livingEntity.m_6047_() ? 0.2617994f : 0.0f);
            model.getArm((HumanoidArm)arm).f_104204_ = model.head.f_104204_;
        }
    }
}

