/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import net.foxyas.changedaddon.init.ChangedAddonSoundEvents;
import net.foxyas.changedaddon.init.ChangedAddonTabs;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.NotNull;

public class TheDecimatorItem
extends Item {
    private static final UUID BASE_ATTACK_REACH_UUID = UUID.fromString("fa02d244-9771-415c-8789-fd03b5252c8c");

    public TheDecimatorItem() {
        super(new Item.Properties().m_41491_(ChangedAddonTabs.TAB_CHANGED_ADDON_COMBAT_OPTIONAL).m_41503_(1025));
    }

    private float AttackDamage() {
        return 13.0f;
    }

    private float AttackSpeed() {
        return -3.2f;
    }

    public float m_8102_(@NotNull ItemStack itemstack, @NotNull BlockState blockstate) {
        return 1.5f;
    }

    public boolean m_6813_(@NotNull ItemStack itemstack, @NotNull Level world, @NotNull BlockState blockstate, @NotNull BlockPos pos, @NotNull LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41622_(1, entity, i -> i.m_21166_(EquipmentSlot.MAINHAND));
            }
        }
        return true;
    }

    public boolean m_7579_(@NotNull ItemStack itemstack, @NotNull LivingEntity target, @NotNull LivingEntity attacker) {
        Player player = (Player)attacker;
        if (!player.m_150110_().f_35937_) {
            itemstack.m_41622_(1, (LivingEntity)player, p -> p.m_21166_(EquipmentSlot.MAINHAND));
        }
        return true;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return super.isBookEnchantable(stack, book);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment == Enchantments.f_44977_) {
            return false;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity target) {
        if ((double)player.m_36403_(0.0f) >= 0.9 && player.m_20096_()) {
            double radius = 1.25;
            AABB attackArea = target.m_142469_().m_82377_(radius, 0.25, radius);
            List nearbyEntities = player.f_19853_.m_45976_(LivingEntity.class, attackArea);
            for (LivingEntity entity : nearbyEntities) {
                if (entity == target || entity == player || player.m_7307_((Entity)entity) || entity instanceof ArmorStand && ((ArmorStand)entity).m_31677_() || !player.canHit((Entity)entity, 0.0)) continue;
                Vec3 knockbackVec = target.m_20182_().m_82546_(entity.m_20182_()).m_82541_();
                entity.m_147240_(0.8, knockbackVec.f_82479_, knockbackVec.f_82481_);
                entity.m_6469_(DamageSource.m_19370_((LivingEntity)player), 7.0f / (float)nearbyEntities.size());
            }
            if (ChangedAddonSoundEvents.HAMMER_SWING != null) {
                player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), ChangedAddonSoundEvents.HAMMER_SWING, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            double d0 = (double)(-Mth.m_14031_((float)(player.m_146908_() * ((float)Math.PI / 180)))) * 1.0;
            double d1 = (double)Mth.m_14089_((float)(player.m_146908_() * ((float)Math.PI / 180))) * 1.0;
            Level var7 = player.f_19853_;
            if (var7 instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)var7;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123766_, player.m_20185_() + d0, player.m_20227_(0.5), player.m_20189_() + d1, 0, d0, 0.0, d1, 0.0);
            }
        }
        return super.onLeftClickEntity(stack, player, target);
    }

    public int m_6473_() {
        return 15;
    }

    @NotNull
    public InteractionResult m_6225_(@NotNull UseOnContext context) {
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        if (!player.m_36335_().m_41519_(context.m_43722_().m_41720_())) {
            Level world = context.m_43725_();
            BlockPos pos = context.m_8083_();
            Direction face = context.m_43719_();
            AABB attackArea = new AABB(pos).m_82400_(3.0);
            List attackHitBox = world.m_45976_(LivingEntity.class, attackArea);
            for (LivingEntity livingEntity : attackHitBox) {
                if (livingEntity != player) {
                    livingEntity.m_6469_(DamageSource.m_19370_((LivingEntity)player), 6.5f);
                }
                Vec3 vecMath = livingEntity.m_20182_().m_82546_(Vec3.m_82512_((Vec3i)pos)).m_82541_();
                double distance = vecMath.m_82553_();
                Vec3 newVec = new Vec3(vecMath.m_7096_() / Math.max(0.75, distance), vecMath.m_7098_() / Math.max(0.75, distance), vecMath.m_7094_() / Math.max(0.75, distance));
                livingEntity.m_20256_(livingEntity.m_20184_().m_82549_(newVec));
            }
            AABB particleArea = this.getArea(face, pos);
            int radius = 2;
            int radiusY = 2;
            for (BlockPos p : BlockPos.m_121976_((int)((int)particleArea.f_82288_), (int)((int)particleArea.f_82289_), (int)((int)particleArea.f_82290_), (int)((int)particleArea.f_82291_), (int)((int)particleArea.f_82292_), (int)((int)particleArea.f_82293_))) {
                double dz;
                double dy;
                double dx = (double)(p.m_123341_() - pos.m_123341_()) / (double)radius;
                double distanceSq = dx * dx + (dy = (double)(p.m_123342_() - pos.m_123342_()) / (double)radiusY) * dy + (dz = (double)(p.m_123343_() - pos.m_123343_()) / (double)radius) * dz;
                if (!(distanceSq <= 1.0)) continue;
                world.m_46796_(2001, p, Block.m_49956_((BlockState)world.m_8055_(p)));
            }
            if (ChangedAddonSoundEvents.HAMMER_GUN_SHOT != null) {
                world.m_5594_(null, pos, ChangedAddonSoundEvents.HAMMER_GUN_SHOT, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            Vec3 center = Vec3.m_82512_((Vec3i)pos);
            world.m_7106_((ParticleOptions)ParticleTypes.f_123813_, center.f_82479_, center.f_82480_, center.f_82481_, 0.0, 0.0, 0.0);
            player.m_36335_().m_41524_(context.m_43722_().m_41720_(), 120);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @NotNull
    private AABB getArea(Direction face, BlockPos pos) {
        return switch (face) {
            case Direction.UP, Direction.DOWN -> new AABB((double)(pos.m_123341_() - 2), (double)pos.m_123342_(), (double)(pos.m_123343_() - 2), (double)(pos.m_123341_() + 2), (double)pos.m_123342_(), (double)(pos.m_123343_() + 2));
            case Direction.NORTH, Direction.SOUTH -> new AABB((double)(pos.m_123341_() - 2), (double)(pos.m_123342_() - 2), (double)pos.m_123343_(), (double)(pos.m_123341_() + 2), (double)(pos.m_123342_() + 2), (double)pos.m_123343_());
            case Direction.EAST, Direction.WEST -> new AABB((double)pos.m_123341_(), (double)(pos.m_123342_() - 2), (double)(pos.m_123343_() - 2), (double)pos.m_123341_(), (double)(pos.m_123342_() + 2), (double)(pos.m_123343_() + 2));
            default -> new AABB(pos);
        };
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot equipmentSlot, ItemStack stack) {
        if (equipmentSlot == EquipmentSlot.MAINHAND) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.putAll(super.getAttributeModifiers(equipmentSlot, stack));
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", (double)this.AttackDamage(), AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", (double)this.AttackSpeed(), AttributeModifier.Operation.ADDITION));
            builder.put((Object)((Attribute)ForgeMod.REACH_DISTANCE.get()), (Object)new AttributeModifier(BASE_ATTACK_REACH_UUID, "Tool modifier", 0.5, AttributeModifier.Operation.ADDITION));
            builder.put((Object)((Attribute)ForgeMod.ATTACK_RANGE.get()), (Object)new AttributeModifier(BASE_ATTACK_REACH_UUID, "Tool modifier", 0.5, AttributeModifier.Operation.ADDITION));
            return builder.build();
        }
        return super.getAttributeModifiers(equipmentSlot, stack);
    }

    @NotNull
    public Multimap<Attribute, AttributeModifier> m_7167_(@NotNull EquipmentSlot equipmentSlot) {
        return super.m_7167_(equipmentSlot);
    }
}

