/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.item;

import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.foxyas.changedaddon.configuration.ChangedAddonServerConfiguration;
import net.foxyas.changedaddon.init.ChangedAddonItems;
import net.foxyas.changedaddon.init.ChangedAddonSoundEvents;
import net.foxyas.changedaddon.init.ChangedAddonTabs;
import net.foxyas.changedaddon.item.tooltip.TransfurTotemTooltipComponent;
import net.foxyas.changedaddon.procedures.SummonDripParticlesProcedure;
import net.foxyas.changedaddon.util.PlayerUtil;
import net.ltxprogrammer.changed.entity.ChangedEntity;
import net.ltxprogrammer.changed.entity.variant.TransfurVariant;
import net.ltxprogrammer.changed.entity.variant.TransfurVariantInstance;
import net.ltxprogrammer.changed.init.ChangedRegistry;
import net.ltxprogrammer.changed.init.ChangedTransfurVariants;
import net.ltxprogrammer.changed.item.Syringe;
import net.ltxprogrammer.changed.process.ProcessTransfur;
import net.ltxprogrammer.changed.util.TagUtil;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

public class TransfurTotemItem
extends Item {
    public static final AttributeModifier TOTEM_BUFF_ATTACK = new AttributeModifier(UUID.fromString("17c5b5cf-bdae-4191-84d1-433db7cba751"), "transfur_stats", 4.0, AttributeModifier.Operation.ADDITION);
    public static final AttributeModifier TOTEM_BUFF_DEFENSE = new AttributeModifier(UUID.fromString("17c5b5cf-bdae-4191-84d1-433db7cba752"), "transfur_stats", 8.0, AttributeModifier.Operation.ADDITION);
    public static final AttributeModifier TOTEM_BUFF_ARMOR = new AttributeModifier(UUID.fromString("17c5b5cf-bdae-4191-84d1-433db7cba753"), "transfur_stats", 6.0, AttributeModifier.Operation.ADDITION);

    public TransfurTotemItem() {
        super(new Item.Properties().m_41491_(ChangedAddonTabs.TAB_CHANGED_ADDON).m_41487_(1).m_41486_().m_41497_(Rarity.RARE));
    }

    @NotNull
    public ItemStack m_7968_() {
        ItemStack defaultInstance = super.m_7968_();
        defaultInstance.m_41784_().m_128359_("form", "");
        return defaultInstance;
    }

    @NotNull
    public Optional<TooltipComponent> m_142422_(@NotNull ItemStack pStack) {
        if (Syringe.getVariant((ItemStack)pStack) == null) {
            return super.m_142422_(pStack);
        }
        return Optional.of(new TransfurTotemTooltipComponent(pStack));
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        return super.getAttributeModifiers(slot, stack);
    }

    private static void tryLinkForm(Level level, Player player, ItemStack itemstack) {
        ResourceLocation latexFormRes;
        TransfurVariantInstance tf = ProcessTransfur.getPlayerTransfurVariant((Player)player);
        ResourceLocation resourceLocation = latexFormRes = tf == null ? null : tf.getFormId();
        if (latexFormRes == null) {
            return;
        }
        String latexForm = latexFormRes.toString();
        if (((Boolean)ChangedAddonServerConfiguration.ACCEPT_ALL_VARIANTS.get()).booleanValue() || latexForm.startsWith("changed:form")) {
            TransfurTotemItem.linkForm(level, player, itemstack, tf, latexForm);
        } else if (latexForm.startsWith("changed_addon:form")) {
            TransfurTotemItem.cooldown(player, itemstack, 50);
            TransfurTotemItem.visualActivate(level, player, SoundEvents.f_12600_);
            player.m_5661_((Component)new TranslatableComponent("changed_addon.latex_totem.not_valid"), true);
        } else if (latexForm.startsWith("changed:special")) {
            TransfurTotemItem.linkForm(level, player, itemstack, tf, "changed:form_light_latex_wolf");
        }
    }

    private static void linkForm(Level level, Player player, ItemStack stack, TransfurVariantInstance<?> tf, String form) {
        stack.m_41784_().m_128359_("form", form);
        CompoundTag variantData = tf.save();
        variantData.m_128473_("previousAttributes");
        variantData.m_128473_("newAttributes");
        variantData.m_128473_("transfurProgressionO");
        variantData.m_128473_("transfurProgression");
        stack.m_41784_().m_128365_("TransfurVariantData", (Tag)variantData);
        TransfurTotemItem.activateVisuals(level, player, stack, null, 100, SoundEvents.f_11736_);
    }

    private static void cooldown(Player entity, ItemStack itemstack, int ticks) {
        if (!entity.m_150110_().f_35937_) {
            entity.m_36335_().m_41524_(itemstack.m_41720_(), ticks);
        }
    }

    private static void activateVisuals(Level level, Player entity, ItemStack itemstack, String advancement, int cooldown, SoundEvent soundEvent) {
        if (level.m_5776_()) {
            Minecraft.m_91087_().f_91063_.m_109113_(itemstack);
        }
        TransfurTotemItem.cooldown(entity, itemstack, cooldown);
        if (soundEvent != null) {
            TransfurTotemItem.visualActivate(level, entity, soundEvent);
        }
        if (advancement != null) {
            TransfurTotemItem.grantAdvancement((Entity)entity, advancement);
        }
    }

    private static void visualActivate(Level level, Player player, SoundEvent sound) {
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), sound, SoundSource.NEUTRAL, 1.0f, 1.0f);
    }

    private static void grantAdvancement(Entity entity, String id) {
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        Advancement adv = player.f_8924_.m_129889_().m_136041_(new ResourceLocation(id));
        if (adv == null) {
            return;
        }
        AdvancementProgress progress = player.m_8960_().m_135996_(adv);
        if (!progress.m_8193_()) {
            for (String criterion : progress.m_8219_()) {
                player.m_8960_().m_135988_(adv, criterion);
            }
        }
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack itemstack) {
        return UseAnim.BLOCK;
    }

    public boolean m_41470_() {
        return true;
    }

    public ItemStack getContainerItem(ItemStack itemstack) {
        return new ItemStack((ItemLike)this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_5812_(@NotNull ItemStack itemstack) {
        String form = itemstack.m_41784_().m_128461_("form");
        if (form.isEmpty()) {
            return false;
        }
        if (form.startsWith("changed:form")) {
            return true;
        }
        return form.startsWith("changed_addon:form") && (Boolean)ChangedAddonServerConfiguration.ACCEPT_ALL_VARIANTS.get() == true;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        boolean isValidUse;
        InteractionResultHolder ar = super.m_7203_(level, player, hand);
        ItemStack stack = (ItemStack)ar.m_19095_();
        if (!(level instanceof ServerLevel)) {
            return ar;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        boolean bl = isValidUse = player.m_21206_().m_150930_(stack.m_41720_()) && player.m_21205_().m_150930_(stack.m_41720_()) || player.m_21206_().m_150930_(stack.m_41720_()) && player.m_21205_().m_41619_() || player.m_21205_().m_150930_(stack.m_41720_());
        if (!isValidUse) {
            return ar;
        }
        String form = stack.m_41784_().m_128461_("form");
        boolean isTransfurred = ProcessTransfur.isPlayerTransfurred((Player)player);
        if (player.m_6144_()) {
            if (!form.isEmpty()) {
                stack.m_41784_().m_128359_("form", "");
                if (stack.m_41784_().m_128441_("TransfurVariantData")) {
                    stack.m_41784_().m_128473_("TransfurVariantData");
                }
                TransfurTotemItem.activateVisuals(level, player, stack, null, 50, SoundEvents.f_11738_);
                return ar;
            }
            if (isTransfurred) {
                TransfurTotemItem.tryLinkForm(level, player, stack);
            }
            return ar;
        }
        if (form.isEmpty()) {
            player.m_5661_((Component)new TextComponent("No form linked, please link one with \u00a7e<Shift+Click>"), true);
            return ar;
        }
        if (isTransfurred) {
            SummonDripParticlesProcedure.execute((Entity)player);
            PlayerUtil.UnTransfurPlayer(player);
            TransfurTotemItem.cooldown(player, stack, 100);
            TransfurTotemItem.visualActivate(level, player, ChangedAddonSoundEvents.UNTRANSFUR);
            TransfurTotemItem.grantAdvancement((Entity)player, "changed_addon:transfur_totem_advancement_1");
            return ar;
        }
        if (form.equals("changed_addon:form_puro_kind/female")) {
            form = "changed_addon:form_latex_puro_kind/female";
            stack.m_41784_().m_128359_("form", form);
        }
        if (stack.m_41784_().m_128441_("TransfurVariantData")) {
            CompoundTag data = stack.m_41784_().m_128469_("TransfurVariantData");
            PlayerUtil.TransfurPlayerAndLoadData(player, form, data, 0.85f);
        } else {
            PlayerUtil.TransfurPlayer(player, form, 0.85f);
        }
        TransfurTotemItem.activateVisuals(level, player, stack, "changed_addon:transfur_totem_advancement_1", 100, null);
        return ar;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public InteractionResult m_6880_(@NotNull ItemStack pStack, @NotNull Player player, @NotNull LivingEntity targetEntity, @NotNull InteractionHand pUsedHand) {
        if (pUsedHand != player.m_7655_()) {
            return InteractionResult.PASS;
        }
        Level level = player.f_19853_;
        ItemStack totem = player.m_21205_();
        if (!totem.m_150930_((Item)ChangedAddonItems.TRANSFUR_TOTEM.get()) || !totem.m_41784_().m_128461_("form").isEmpty()) {
            totem = player.m_21206_();
        }
        if (!totem.m_150930_((Item)ChangedAddonItems.TRANSFUR_TOTEM.get()) || !totem.m_41784_().m_128461_("form").isEmpty()) {
            return InteractionResult.PASS;
        }
        if (player.m_36335_().m_41519_((Item)ChangedAddonItems.TRANSFUR_TOTEM.get()) || !player.m_6144_()) {
            return InteractionResult.PASS;
        }
        if (targetEntity instanceof Player) {
            Player target = (Player)targetEntity;
            if (!ProcessTransfur.isPlayerTransfurred((Player)target)) {
                return InteractionResult.PASS;
            }
            String transfurId = ProcessTransfur.getPlayerTransfurVariant((Player)target).getFormId().toString();
            if (!((Boolean)ChangedAddonServerConfiguration.ACCEPT_ALL_VARIANTS.get()).booleanValue()) {
                if (transfurId.startsWith("changed:form")) {
                    TransfurTotemItem.cooldown(player, totem, 20);
                    if (level.m_5776_()) {
                        Minecraft.m_91087_().f_91063_.m_109113_(totem);
                    }
                    totem.m_41784_().m_128359_("form", transfurId);
                    level.m_6269_(null, (Entity)player, SoundEvents.f_11736_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    return InteractionResult.SUCCESS;
                }
                if (!transfurId.startsWith("changed_addon:form")) return InteractionResult.CONSUME;
                TransfurTotemItem.cooldown(player, totem, 50);
                if (level.m_5776_()) {
                    Minecraft.m_91087_().f_91063_.m_109113_(totem);
                }
                level.m_6269_(null, (Entity)player, SoundEvents.f_12600_, SoundSource.NEUTRAL, 1.0f, 0.0f);
                if (target.f_19853_.m_5776_()) return InteractionResult.SUCCESS;
                target.m_5661_((Component)new TextComponent(new TranslatableComponent("changed_addon.latex_totem.not_valid").getString()), true);
                return InteractionResult.SUCCESS;
            }
            TransfurTotemItem.cooldown(player, totem, 20);
            if (level.m_5776_()) {
                Minecraft.m_91087_().f_91063_.m_109113_(totem);
            }
            totem.m_41784_().m_128359_("form", transfurId);
            level.m_6269_(null, (Entity)player, SoundEvents.f_11736_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (!(targetEntity instanceof ChangedEntity)) return InteractionResult.CONSUME;
        ChangedEntity changedEntity = (ChangedEntity)targetEntity;
        String string = changedEntity.getSelfVariant() != null ? changedEntity.getSelfVariant().getFormId().toString() : "";
        TransfurTotemItem.cooldown(player, totem, 20);
        if (level.m_5776_()) {
            Minecraft.m_91087_().f_91063_.m_109113_(totem);
        }
        totem.m_41784_().m_128359_("form", string);
        level.m_6269_(null, (Entity)player, SoundEvents.f_11736_, SoundSource.NEUTRAL, 1.0f, 1.0f);
        return InteractionResult.SUCCESS;
    }

    private static void addModifier(LivingEntity entity, Attribute attribute, AttributeModifier modifier) {
        if (!Objects.requireNonNull(entity.m_21051_(attribute)).m_22109_(modifier)) {
            Objects.requireNonNull(entity.m_21051_(attribute)).m_22118_(modifier);
        }
    }

    private static void removeModifier(LivingEntity entity, Attribute attribute, AttributeModifier modifier) {
        if (Objects.requireNonNull(entity.m_21051_(attribute)).m_22109_(modifier)) {
            Objects.requireNonNull(entity.m_21051_(attribute)).m_22130_(modifier);
        }
    }

    public void m_6883_(@NotNull ItemStack itemstack, @NotNull Level level, @NotNull Entity entity, int slot, boolean selected) {
        super.m_6883_(itemstack, level, entity, slot, selected);
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (player instanceof ServerPlayer) {
            boolean holdingTotem;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            TransfurVariantInstance variant = ProcessTransfur.getPlayerTransfurVariant((Player)player);
            boolean isTransfurred = variant != null;
            boolean bl = holdingTotem = serverPlayer.m_21205_().m_41720_() == ChangedAddonItems.TRANSFUR_TOTEM.get() || serverPlayer.m_21206_().m_41720_() == ChangedAddonItems.TRANSFUR_TOTEM.get();
            if (isTransfurred && holdingTotem) {
                TransfurTotemItem.addModifier((LivingEntity)serverPlayer, Attributes.f_22281_, TOTEM_BUFF_ATTACK);
                TransfurTotemItem.addModifier((LivingEntity)serverPlayer, Attributes.f_22284_, TOTEM_BUFF_DEFENSE);
                TransfurTotemItem.addModifier((LivingEntity)serverPlayer, Attributes.f_22285_, TOTEM_BUFF_ARMOR);
            } else {
                TransfurTotemItem.removeModifier((LivingEntity)serverPlayer, Attributes.f_22281_, TOTEM_BUFF_ATTACK);
                TransfurTotemItem.removeModifier((LivingEntity)serverPlayer, Attributes.f_22284_, TOTEM_BUFF_DEFENSE);
                TransfurTotemItem.removeModifier((LivingEntity)serverPlayer, Attributes.f_22285_, TOTEM_BUFF_ARMOR);
            }
        }
        if (!player.m_21205_().m_150930_(itemstack.m_41720_()) && !player.m_21206_().m_150930_(itemstack.m_41720_())) {
            return;
        }
        if (player.m_36335_().m_41519_(itemstack.m_41720_()) || !ProcessTransfur.isPlayerTransfurred((Player)player) || !ProcessTransfur.getPlayerTransfurVariant((Player)player).is((TransfurVariant)ChangedTransfurVariants.LATEX_BENIGN_WOLF.get())) {
            return;
        }
        SummonDripParticlesProcedure.execute(entity);
        PlayerUtil.UnTransfurPlayer(player);
        level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12513_, SoundSource.NEUTRAL, 1.0f, 1.0f);
        player.m_36335_().m_41524_(itemstack.m_41720_(), 100);
        if (level.m_5776_()) {
            Minecraft.m_91087_().f_91063_.m_109113_(itemstack);
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer _player = (ServerPlayer)entity;
            player.m_5661_((Component)new TextComponent("The totem you were carrying has been activated"), true);
            Advancement _adv = _player.f_8924_.m_129889_().m_136041_(new ResourceLocation("changed_addon:transfur_totem_advancement_2"));
            AdvancementProgress _ap = _player.m_8960_().m_135996_(_adv);
            if (!_ap.m_8193_()) {
                for (String s : _ap.m_8219_()) {
                    _player.m_8960_().m_135988_(_adv, s);
                }
            }
        }
    }

    public static float itemPropertyFunc(Entity entity) {
        if (!(entity instanceof Player)) {
            return 0.0f;
        }
        Player player = (Player)entity;
        TransfurVariantInstance instance = ProcessTransfur.getPlayerTransfurVariant((Player)player);
        if (instance == null || !instance.is((Supplier)ChangedTransfurVariants.LATEX_BENIGN_WOLF)) {
            return 0.0f;
        }
        return 0.5f;
    }

    @Mod.EventBusSubscriber
    public static class TransfurTotemItemIsStruckByLighting {
        @SubscribeEvent
        public static void onLightning(EntityStruckByLightningEvent event) {
            Entity entity = event.getEntity();
            if (!(entity instanceof ItemEntity)) {
                return;
            }
            ItemEntity itemEntity = (ItemEntity)entity;
            if (itemEntity.m_32055_().m_150930_((Item)ChangedAddonItems.TRANSFUR_TOTEM.get())) {
                event.setCanceled(true);
            }
        }
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT})
    public static class ShowTransfurTotemItemTip {
        @SubscribeEvent
        public static void onItemTooltip(ItemTooltipEvent event) {
            ItemStack stack = event.getItemStack();
            List tooltip = event.getToolTip();
            if (stack.m_41720_() == ChangedAddonItems.TRANSFUR_TOTEM.get()) {
                CompoundTag itemTag = stack.m_41784_();
                if (itemTag.m_128461_("form").isEmpty()) {
                    tooltip.add(1, new TranslatableComponent("item.changed_addon.transfur_totem.no_form_linked"));
                } else {
                    TransfurVariant variant = (TransfurVariant)ChangedRegistry.TRANSFUR_VARIANT.get().getValue(TagUtil.getResourceLocation((CompoundTag)itemTag, (String)"form"));
                    if (variant == null) {
                        tooltip.add(1, new TranslatableComponent("item.changed_addon.transfur_totem.no_form_linked"));
                        return;
                    }
                    if (Screen.m_96638_() && !Screen.m_96639_() && !Screen.m_96637_()) {
                        tooltip.add(1, new TextComponent("\u00a76Form=" + itemTag.m_128461_("form")));
                    } else if (Screen.m_96639_() && Screen.m_96637_()) {
                        tooltip.add(1, new TranslatableComponent("item.changed_addon.transfur_totem.desc_1"));
                    } else {
                        String ID = Syringe.getVariantDescriptionId((ItemStack)stack);
                        tooltip.add(1, new TextComponent("\u00a76(" + new TranslatableComponent(ID).getString() + ")"));
                    }
                }
            }
        }
    }
}

