/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.item.clothes;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import net.foxyas.changedaddon.item.clothes.ClothingState;
import net.ltxprogrammer.changed.data.AccessorySlots;
import net.ltxprogrammer.changed.init.ChangedSounds;
import net.ltxprogrammer.changed.item.AccessoryItem;
import net.ltxprogrammer.changed.item.Clothing;
import net.ltxprogrammer.changed.item.ExtendedItemProperties;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.Wearable;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleClothingItem
extends Item
implements Wearable,
Clothing,
ExtendedItemProperties {
    public static String INTERACT_INSTRUCTIONS = "changed.instruction.clothing_state";
    public static BooleanProperty CLOSED = BooleanProperty.m_61465_((String)"closed");
    public StateDefinition<SimpleClothingItem, ClothingState> stateDefinition;
    public ClothingState defaultClothingState;

    public SimpleClothingItem(Item.Properties properties) {
        super(properties);
        StateDefinition.Builder builder = new StateDefinition.Builder((Object)this);
        this.createClothingStateDefinition((StateDefinition.Builder<SimpleClothingItem, ClothingState>)builder);
        this.stateDefinition = builder.m_61101_(SimpleClothingItem::defaultClothingState, ClothingState::new);
        this.registerDefaultState((ClothingState)this.stateDefinition.m_61090_());
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)AccessoryItem.DISPENSE_ITEM_BEHAVIOR);
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> builder, @NotNull TooltipFlag tooltipFlag) {
        super.m_7373_(stack, level, builder, tooltipFlag);
        if (tooltipFlag.m_7050_()) {
            builder.add((Component)new TextComponent(this.getClothingState(stack).toString()).m_130940_(ChatFormatting.DARK_GRAY));
        }
    }

    protected void addInteractInstructions(Consumer<Component> builder) {
        builder.accept((Component)new TranslatableComponent(INTERACT_INSTRUCTIONS, new Object[]{Minecraft.m_91087_().f_91066_.f_92095_.m_90863_()}).m_130940_(ChatFormatting.GRAY));
    }

    protected void createClothingStateDefinition(StateDefinition.Builder<SimpleClothingItem, ClothingState> builder) {
    }

    public ClothingState defaultClothingState() {
        return this.defaultClothingState;
    }

    public ClothingState getClothingState(ItemStack stack) {
        CompoundTag compoundTag = stack.m_41783_();
        if (compoundTag == null) {
            return this.defaultClothingState();
        }
        CompoundTag stateData = compoundTag.m_128469_("state");
        AtomicReference<ClothingState> evaluatedState = new AtomicReference<ClothingState>(this.defaultClothingState());
        stateData.m_128431_().forEach(propertyName -> {
            Property property = this.stateDefinition.m_61081_(propertyName);
            if (property != null) {
                property.m_6215_(stateData.m_128461_(propertyName)).ifPresent(value -> evaluatedState.set((ClothingState)((Object)((Object)((Object)((ClothingState)((Object)((Object)((Object)evaluatedState.get())))).m_61124_(property, (Comparable)value))))));
            }
        });
        return evaluatedState.getAcquire();
    }

    public void setClothingState(ItemStack stack, net.ltxprogrammer.changed.item.ClothingState state) {
        CompoundTag tag = new CompoundTag();
        state.m_61147_().forEach(property -> tag.m_128359_(property.m_61708_(), property.m_6940_(state.m_61143_(property))));
        stack.m_41784_().m_128365_("state", (Tag)tag);
    }

    protected final void registerDefaultState(ClothingState clothingState) {
        this.defaultClothingState = clothingState;
    }

    public boolean isDamageable(ItemStack stack) {
        return false;
    }

    public SoundEvent m_142602_() {
        return ChangedSounds.EQUIP3;
    }

    public SoundEvent getBreakSound(ItemStack itemStack) {
        return ChangedSounds.SLASH10;
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        ResourceLocation itemId = stack.m_41720_().getRegistryName();
        return String.format("%s:textures/models/%s.png", itemId.m_135827_(), itemId.m_135815_());
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        return AccessorySlots.getForEntity((LivingEntity)player).map(slots -> {
            ItemStack copy = stack.m_41777_();
            if (slots.quickMoveStack(stack)) {
                AccessorySlots.equipEventAndSound((LivingEntity)player, (ItemStack)copy);
                return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.f_46443_);
            }
            return InteractionResultHolder.m_19098_((Object)stack);
        }).orElse(InteractionResultHolder.m_19098_((Object)stack));
    }
}

