/*
 * Decompiled with CFR 0.152.
 */
package net.foxyas.changedaddon.network;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;

public record GeneratorGuiButtonMessage(int buttonId, int x, int y, int z) {
    public GeneratorGuiButtonMessage(FriendlyByteBuf buf) {
        this(buf.m_130242_(), buf.m_130242_(), buf.m_130242_(), buf.m_130242_());
    }

    public static void buffer(GeneratorGuiButtonMessage message, FriendlyByteBuf buf) {
        buf.m_130130_(message.buttonId);
        buf.m_130130_(message.x);
        buf.m_130130_(message.y);
        buf.m_130130_(message.z);
    }

    public static void handler(GeneratorGuiButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int x = message.x;
            int y = message.y;
            int z = message.z;
            GeneratorGuiButtonMessage.handleButtonAction((Player)entity, message.buttonId, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player player, int buttonID, int x, int y, int z) {
        if (player == null) {
            return;
        }
        Level level = player.f_19853_;
        if (!level.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            if (level.f_46443_) {
                return;
            }
            BlockPos pos = new BlockPos(x, y, z);
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity == null) {
                return;
            }
            BlockState state = level.m_8055_(pos);
            boolean enabled = blockEntity.getTileData().m_128471_("turn_on");
            if (enabled) {
                blockEntity.getTileData().m_128379_("turn_on", false);
                player.m_5661_((Component)new TextComponent("generator disabled"), true);
            } else {
                blockEntity.getTileData().m_128379_("turn_on", true);
                player.m_5661_((Component)new TextComponent("generator enabled"), true);
            }
            level.m_7260_(pos, state, state, 3);
        }
    }
}

